/*     */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ 
/*     */ public final class JDBCDynamicQLQueryMetaData
/*     */   implements JDBCQueryMetaData
/*     */ {
/*     */   private final Method method;
/*     */   private final boolean resultTypeMappingLocal;
/*     */   private final JDBCReadAheadMetaData readAhead;
/*     */   private final Class compiler;
/*     */   private final boolean lazyResultSetLoading;
/*     */ 
/*     */   public JDBCDynamicQLQueryMetaData(JDBCDynamicQLQueryMetaData defaults, JDBCReadAheadMetaData readAhead, Class qlCompiler, boolean lazyResultSetLoading)
/*     */     throws DeploymentException
/*     */   {
/*  64 */     this.method = defaults.getMethod();
/*  65 */     this.readAhead = readAhead;
/*  66 */     this.resultTypeMappingLocal = defaults.isResultTypeMappingLocal();
/*  67 */     this.compiler = qlCompiler;
/*  68 */     this.lazyResultSetLoading = lazyResultSetLoading;
/*     */   }
/*     */ 
/*     */   public JDBCDynamicQLQueryMetaData(boolean resultTypeMappingLocal, Method method, JDBCReadAheadMetaData readAhead, Class compiler, boolean lazyResultSetLoading)
/*     */     throws DeploymentException
/*     */   {
/*  84 */     this.method = method;
/*  85 */     this.readAhead = readAhead;
/*  86 */     this.resultTypeMappingLocal = resultTypeMappingLocal;
/*     */ 
/*  88 */     Class[] parameterTypes = method.getParameterTypes();
/*  89 */     if ((parameterTypes.length != 2) || (!parameterTypes[0].equals(String.class)) || (!parameterTypes[1].equals([Ljava.lang.Object.class)))
/*     */     {
/*  94 */       throw new DeploymentException("Dynamic-ql method must have two parameters of type String and Object[].");
/*     */     }
/*     */ 
/* 100 */     this.compiler = compiler;
/* 101 */     this.lazyResultSetLoading = lazyResultSetLoading;
/*     */   }
/*     */ 
/*     */   public Method getMethod()
/*     */   {
/* 107 */     return this.method;
/*     */   }
/*     */ 
/*     */   public boolean isResultTypeMappingLocal()
/*     */   {
/* 113 */     return this.resultTypeMappingLocal;
/*     */   }
/*     */ 
/*     */   public JDBCReadAheadMetaData getReadAhead()
/*     */   {
/* 123 */     return this.readAhead;
/*     */   }
/*     */ 
/*     */   public Class getQLCompilerClass()
/*     */   {
/* 128 */     return this.compiler;
/*     */   }
/*     */ 
/*     */   public boolean isLazyResultSetLoading()
/*     */   {
/* 133 */     return this.lazyResultSetLoading;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 147 */     if ((o instanceof JDBCDynamicQLQueryMetaData))
/*     */     {
/* 149 */       return ((JDBCDynamicQLQueryMetaData)o).method.equals(this.method);
/*     */     }
/* 151 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 162 */     return this.method.hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 177 */     return "[JDBCDynamicQLQueryMetaData : method=" + this.method + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCDynamicQLQueryMetaData
 * JD-Core Version:    0.6.0
 */