/*     */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public final class JDBCDeclaredQueryMetaData
/*     */   implements JDBCQueryMetaData
/*     */ {
/*     */   private final Method method;
/*     */   private final String additionalColumns;
/*     */   private final String from;
/*     */   private final String where;
/*     */   private final String order;
/*     */   private final String other;
/*     */   private final boolean distinct;
/*     */   private final String ejbName;
/*     */   private final String fieldName;
/*     */   private final String alias;
/*     */   private final JDBCReadAheadMetaData readAhead;
/*     */   private final boolean resultTypeMappingLocal;
/*     */   private final Class compiler;
/*     */   private final boolean lazyResultSetLoading;
/*     */ 
/*     */   public JDBCDeclaredQueryMetaData(JDBCDeclaredQueryMetaData defaults, JDBCReadAheadMetaData readAhead, Class compiler, boolean lazyResultSetLoading)
/*     */     throws DeploymentException
/*     */   {
/* 118 */     this.method = defaults.getMethod();
/* 119 */     this.readAhead = readAhead;
/*     */ 
/* 121 */     this.from = defaults.getFrom();
/* 122 */     this.where = defaults.getWhere();
/* 123 */     this.order = defaults.getOrder();
/* 124 */     this.other = defaults.getOther();
/*     */ 
/* 126 */     this.resultTypeMappingLocal = defaults.isResultTypeMappingLocal();
/*     */ 
/* 128 */     this.distinct = defaults.isSelectDistinct();
/* 129 */     this.ejbName = defaults.getEJBName();
/* 130 */     this.fieldName = defaults.getFieldName();
/* 131 */     this.alias = defaults.getAlias();
/* 132 */     this.additionalColumns = defaults.getAdditionalColumns();
/*     */ 
/* 134 */     this.compiler = compiler;
/* 135 */     this.lazyResultSetLoading = lazyResultSetLoading;
/*     */   }
/*     */ 
/*     */   public JDBCDeclaredQueryMetaData(boolean isResultTypeMappingLocal, Element queryElement, Method method, JDBCReadAheadMetaData readAhead, Class compiler, boolean lazyResultSetLoading)
/*     */     throws DeploymentException
/*     */   {
/* 156 */     this.compiler = compiler;
/* 157 */     this.lazyResultSetLoading = lazyResultSetLoading;
/*     */ 
/* 159 */     this.method = method;
/* 160 */     this.readAhead = readAhead;
/*     */ 
/* 162 */     this.from = nullIfEmpty(MetaData.getOptionalChildContent(queryElement, "from"));
/* 163 */     this.where = nullIfEmpty(MetaData.getOptionalChildContent(queryElement, "where"));
/* 164 */     this.order = nullIfEmpty(MetaData.getOptionalChildContent(queryElement, "order"));
/* 165 */     this.other = nullIfEmpty(MetaData.getOptionalChildContent(queryElement, "other"));
/*     */ 
/* 167 */     this.resultTypeMappingLocal = isResultTypeMappingLocal;
/*     */ 
/* 170 */     Element selectElement = MetaData.getOptionalChild(queryElement, "select");
/*     */ 
/* 173 */     if (selectElement != null)
/*     */     {
/* 176 */       this.distinct = (MetaData.getOptionalChild(selectElement, "distinct") != null);
/*     */ 
/* 179 */       if (method.getName().startsWith("ejbSelect"))
/*     */       {
/* 181 */         this.ejbName = MetaData.getUniqueChildContent(selectElement, "ejb-name");
/* 182 */         this.fieldName = nullIfEmpty(MetaData.getOptionalChildContent(selectElement, "field-name"));
/*     */       }
/*     */       else
/*     */       {
/* 187 */         if (MetaData.getOptionalChild(selectElement, "ejb-name") != null)
/*     */         {
/* 189 */           throw new DeploymentException("The ejb-name element of declared-sql select is only allowed for ejbSelect queries.");
/*     */         }
/*     */ 
/* 194 */         if (MetaData.getOptionalChild(selectElement, "field-name") != null)
/*     */         {
/* 196 */           throw new DeploymentException("The field-name element of declared-sql select is only allowed for ejbSelect queries.");
/*     */         }
/*     */ 
/* 201 */         this.ejbName = null;
/* 202 */         this.fieldName = null;
/*     */       }
/* 204 */       this.alias = nullIfEmpty(MetaData.getOptionalChildContent(selectElement, "alias"));
/* 205 */       this.additionalColumns = nullIfEmpty(MetaData.getOptionalChildContent(selectElement, "additional-columns"));
/*     */     }
/*     */     else
/*     */     {
/* 209 */       if (method.getName().startsWith("ejbSelect"))
/*     */       {
/* 211 */         throw new DeploymentException("The select element of declared-sql is required for ejbSelect queries.");
/*     */       }
/*     */ 
/* 216 */       this.distinct = false;
/* 217 */       this.ejbName = null;
/* 218 */       this.fieldName = null;
/* 219 */       this.alias = null;
/* 220 */       this.additionalColumns = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Method getMethod()
/*     */   {
/* 227 */     return this.method;
/*     */   }
/*     */ 
/*     */   public boolean isResultTypeMappingLocal()
/*     */   {
/* 233 */     return this.resultTypeMappingLocal;
/*     */   }
/*     */ 
/*     */   public JDBCReadAheadMetaData getReadAhead()
/*     */   {
/* 243 */     return this.readAhead;
/*     */   }
/*     */ 
/*     */   public Class getQLCompilerClass()
/*     */   {
/* 248 */     return this.compiler;
/*     */   }
/*     */ 
/*     */   public String getFrom()
/*     */   {
/* 258 */     return this.from;
/*     */   }
/*     */ 
/*     */   public String getWhere()
/*     */   {
/* 268 */     return this.where;
/*     */   }
/*     */ 
/*     */   public String getOrder()
/*     */   {
/* 278 */     return this.order;
/*     */   }
/*     */ 
/*     */   public String getOther()
/*     */   {
/* 290 */     return this.other;
/*     */   }
/*     */ 
/*     */   public boolean isSelectDistinct()
/*     */   {
/* 300 */     return this.distinct;
/*     */   }
/*     */ 
/*     */   public String getEJBName()
/*     */   {
/* 311 */     return this.ejbName;
/*     */   }
/*     */ 
/*     */   public String getFieldName()
/*     */   {
/* 322 */     return this.fieldName;
/*     */   }
/*     */ 
/*     */   public String getAlias()
/*     */   {
/* 333 */     return this.alias;
/*     */   }
/*     */ 
/*     */   public String getAdditionalColumns()
/*     */   {
/* 344 */     return this.additionalColumns;
/*     */   }
/*     */ 
/*     */   public boolean isLazyResultSetLoading()
/*     */   {
/* 349 */     return this.lazyResultSetLoading;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 363 */     if ((o instanceof JDBCDeclaredQueryMetaData))
/*     */     {
/* 365 */       return ((JDBCDeclaredQueryMetaData)o).method.equals(this.method);
/*     */     }
/* 367 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 378 */     return this.method.hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 393 */     return "[JDBCDeclaredQueryMetaData : method=" + this.method + "]";
/*     */   }
/*     */ 
/*     */   private static String nullIfEmpty(String s)
/*     */   {
/* 398 */     if ((s != null) && (s.trim().length() == 0))
/*     */     {
/* 400 */       s = null;
/*     */     }
/* 402 */     return s;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCDeclaredQueryMetaData
 * JD-Core Version:    0.6.0
 */