/*     */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*     */ 
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public final class JDBCCMPFieldPropertyMetaData
/*     */ {
/*     */   private final JDBCCMPFieldMetaData cmpField;
/*     */   private final String propertyName;
/*     */   private final String columnName;
/*     */   private final int jdbcType;
/*     */   private final String sqlType;
/*     */   private final boolean notNull;
/*     */ 
/*     */   public JDBCCMPFieldPropertyMetaData(JDBCCMPFieldMetaData cmpField, Element element)
/*     */     throws DeploymentException
/*     */   {
/*  79 */     this.cmpField = cmpField;
/*     */ 
/*  82 */     this.propertyName = MetaData.getUniqueChildContent(element, "property-name");
/*     */ 
/*  85 */     String columnStr = MetaData.getOptionalChildContent(element, "column-name");
/*     */ 
/*  87 */     if (columnStr != null)
/*  88 */       this.columnName = columnStr;
/*     */     else {
/*  90 */       this.columnName = null;
/*     */     }
/*     */ 
/*  94 */     String jdbcStr = MetaData.getOptionalChildContent(element, "jdbc-type");
/*  95 */     if (jdbcStr != null) {
/*  96 */       this.jdbcType = JDBCMappingMetaData.getJdbcTypeFromName(jdbcStr);
/*  97 */       this.sqlType = MetaData.getUniqueChildContent(element, "sql-type");
/*     */     } else {
/*  99 */       this.jdbcType = -2147483648;
/* 100 */       this.sqlType = null;
/*     */     }
/*     */ 
/* 104 */     this.notNull = (MetaData.getOptionalChild(element, "not-null") != null);
/*     */   }
/*     */ 
/*     */   public JDBCCMPFieldPropertyMetaData(JDBCCMPFieldMetaData cmpField, JDBCCMPFieldPropertyMetaData defaultValues)
/*     */   {
/* 120 */     this.cmpField = cmpField;
/*     */ 
/* 123 */     this.propertyName = defaultValues.propertyName;
/*     */ 
/* 126 */     this.columnName = defaultValues.columnName;
/*     */ 
/* 129 */     this.jdbcType = defaultValues.jdbcType;
/*     */ 
/* 132 */     this.sqlType = defaultValues.sqlType;
/*     */ 
/* 135 */     this.notNull = defaultValues.notNull;
/*     */   }
/*     */ 
/*     */   public String getPropertyName()
/*     */   {
/* 142 */     return this.propertyName;
/*     */   }
/*     */ 
/*     */   public String getColumnName()
/*     */   {
/* 150 */     return this.columnName;
/*     */   }
/*     */ 
/*     */   public int getJDBCType()
/*     */   {
/* 158 */     return this.jdbcType;
/*     */   }
/*     */ 
/*     */   public String getSQLType()
/*     */   {
/* 166 */     return this.sqlType;
/*     */   }
/*     */ 
/*     */   public boolean isNotNull()
/*     */   {
/* 174 */     return this.notNull;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 187 */     if ((o instanceof JDBCCMPFieldPropertyMetaData)) {
/* 188 */       JDBCCMPFieldPropertyMetaData cmpFieldProperty = (JDBCCMPFieldPropertyMetaData)o;
/*     */ 
/* 190 */       return (this.propertyName.equals(cmpFieldProperty.propertyName)) && (this.cmpField.equals(cmpFieldProperty.cmpField));
/*     */     }
/*     */ 
/* 193 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 203 */     int result = 17;
/* 204 */     result = 37 * result + this.cmpField.hashCode();
/* 205 */     result = 37 * result + this.propertyName.hashCode();
/* 206 */     return result;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 221 */     return "[JDBCCMPFieldPropertyMetaData : propertyName=" + this.propertyName + ", " + this.cmpField + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldPropertyMetaData
 * JD-Core Version:    0.6.0
 */