/*     */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ 
/*     */ public final class JDBCAutomaticQueryMetaData
/*     */   implements JDBCQueryMetaData
/*     */ {
/*     */   private final Method method;
/*     */   private final JDBCReadAheadMetaData readAhead;
/*     */   private final Class compiler;
/*     */   private final boolean lazyResultSetLoading;
/*     */ 
/*     */   public JDBCAutomaticQueryMetaData(Method method, JDBCReadAheadMetaData readAhead, Class qlCompiler, boolean lazyResultSetLoading)
/*     */   {
/*  61 */     this.method = method;
/*  62 */     this.readAhead = readAhead;
/*  63 */     this.compiler = qlCompiler;
/*  64 */     this.lazyResultSetLoading = lazyResultSetLoading;
/*     */   }
/*     */ 
/*     */   public Method getMethod()
/*     */   {
/*  69 */     return this.method;
/*     */   }
/*     */ 
/*     */   public boolean isResultTypeMappingLocal()
/*     */   {
/*  74 */     return false;
/*     */   }
/*     */ 
/*     */   public JDBCReadAheadMetaData getReadAhead()
/*     */   {
/*  84 */     return this.readAhead;
/*     */   }
/*     */ 
/*     */   public Class getQLCompilerClass()
/*     */   {
/*  89 */     return this.compiler;
/*     */   }
/*     */ 
/*     */   public boolean isLazyResultSetLoading()
/*     */   {
/*  94 */     return this.lazyResultSetLoading;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 107 */     if ((o instanceof JDBCAutomaticQueryMetaData))
/*     */     {
/* 109 */       return ((JDBCAutomaticQueryMetaData)o).method.equals(this.method);
/*     */     }
/* 111 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 122 */     return this.method.hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 136 */     return "[JDBCAutomaticQueryMetaData : method=" + this.method + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCAutomaticQueryMetaData
 * JD-Core Version:    0.6.0
 */