/*     */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
/*     */ import org.jboss.metadata.ApplicationMetaData;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.ConfigurationMetaData;
/*     */ import org.jboss.metadata.EntityMetaData;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.jboss.metadata.RelationMetaData;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public final class JDBCApplicationMetaData
/*     */ {
/*  53 */   private static final Class JDBC_PM = JDBCStoreManager.class;
/*     */   private final ClassLoader classLoader;
/*     */   private final ApplicationMetaData applicationMetaData;
/*     */   private final Map userTypeMappings;
/*  74 */   private final Map typeMappings = new HashMap();
/*     */ 
/*  79 */   private final Map entities = new HashMap();
/*     */ 
/*  84 */   private final Collection relationships = new HashSet();
/*     */ 
/*  89 */   private final Map entityRoles = new HashMap();
/*     */ 
/*  94 */   private final Map valueClasses = new HashMap();
/*     */ 
/*  99 */   private final Map entitiesByAbstractSchemaName = new HashMap();
/*     */ 
/* 104 */   private final Map entitiesByInterface = new HashMap();
/*     */ 
/* 109 */   private final Map entityCommands = new HashMap();
/*     */ 
/*     */   public JDBCApplicationMetaData(ApplicationMetaData applicationMetaData, ClassLoader classLoader)
/*     */     throws DeploymentException
/*     */   {
/* 127 */     this.classLoader = classLoader;
/* 128 */     this.applicationMetaData = applicationMetaData;
/*     */ 
/* 132 */     Iterator beans = applicationMetaData.getEnterpriseBeans();
/* 133 */     while (beans.hasNext())
/*     */     {
/* 135 */       BeanMetaData bean = (BeanMetaData)beans.next();
/*     */ 
/* 138 */       if (bean.isEntity())
/*     */       {
/* 140 */         EntityMetaData entity = (EntityMetaData)bean;
/*     */         Class pm;
/*     */         try
/*     */         {
/* 146 */           pm = classLoader.loadClass(entity.getContainerConfiguration().getPersistenceManager());
/*     */         }
/*     */         catch (ClassNotFoundException e)
/*     */         {
/* 150 */           throw new DeploymentException("Unable to load persistence manager", e);
/*     */         }
/* 152 */         if ((entity.isCMP()) && ((JDBC_PM.isAssignableFrom(pm)) || (pm.getName().equals("org.jboss.ejb.plugins.cmp.jdbc2.JDBCStoreManager2"))))
/*     */         {
/* 155 */           JDBCEntityMetaData jdbcEntity = new JDBCEntityMetaData(this, entity);
/*     */ 
/* 157 */           this.entities.put(entity.getEjbName(), jdbcEntity);
/*     */ 
/* 159 */           String schemaName = jdbcEntity.getAbstractSchemaName();
/* 160 */           if (schemaName != null)
/*     */           {
/* 162 */             this.entitiesByAbstractSchemaName.put(schemaName, jdbcEntity);
/*     */           }
/*     */ 
/* 165 */           Class remote = jdbcEntity.getRemoteClass();
/* 166 */           if (remote != null)
/*     */           {
/* 168 */             this.entitiesByInterface.put(remote, jdbcEntity);
/*     */           }
/*     */ 
/* 171 */           Class local = jdbcEntity.getLocalClass();
/* 172 */           if (local != null)
/*     */           {
/* 174 */             this.entitiesByInterface.put(local, jdbcEntity);
/*     */           }
/*     */ 
/* 178 */           this.entityRoles.put(entity.getEjbName(), new HashSet());
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 184 */     Iterator iterator = applicationMetaData.getRelationships();
/* 185 */     while (iterator.hasNext())
/*     */     {
/* 187 */       RelationMetaData relation = (RelationMetaData)iterator.next();
/*     */ 
/* 190 */       JDBCRelationMetaData jdbcRelation = new JDBCRelationMetaData(this, relation);
/*     */ 
/* 192 */       this.relationships.add(jdbcRelation);
/*     */ 
/* 195 */       JDBCRelationshipRoleMetaData left = jdbcRelation.getLeftRelationshipRole();
/*     */ 
/* 197 */       Collection leftEntityRoles = (Collection)this.entityRoles.get(left.getEntity().getName());
/*     */ 
/* 199 */       leftEntityRoles.add(left);
/*     */ 
/* 202 */       JDBCRelationshipRoleMetaData right = jdbcRelation.getRightRelationshipRole();
/*     */ 
/* 204 */       Collection rightEntityRoles = (Collection)this.entityRoles.get(right.getEntity().getName());
/*     */ 
/* 206 */       rightEntityRoles.add(right);
/*     */     }
/*     */ 
/* 209 */     this.userTypeMappings = Collections.EMPTY_MAP;
/*     */   }
/*     */ 
/*     */   public JDBCApplicationMetaData(Element element, JDBCApplicationMetaData defaultValues)
/*     */     throws DeploymentException
/*     */   {
/* 232 */     this.classLoader = defaultValues.classLoader;
/* 233 */     this.applicationMetaData = defaultValues.applicationMetaData;
/*     */ 
/* 235 */     Element userTypeMaps = MetaData.getOptionalChild(element, "user-type-mappings");
/* 236 */     if (userTypeMaps != null)
/*     */     {
/* 238 */       this.userTypeMappings = new HashMap();
/* 239 */       Iterator iter = MetaData.getChildrenByTagName(userTypeMaps, "user-type-mapping");
/* 240 */       while (iter.hasNext())
/*     */       {
/* 242 */         Element userTypeMappingEl = (Element)iter.next();
/* 243 */         JDBCUserTypeMappingMetaData userTypeMapping = new JDBCUserTypeMappingMetaData(userTypeMappingEl);
/* 244 */         this.userTypeMappings.put(userTypeMapping.getJavaType(), userTypeMapping);
/*     */       }
/*     */     }
/*     */     else {
/* 248 */       this.userTypeMappings = defaultValues.getUserTypeMappings();
/*     */     }
/*     */ 
/* 251 */     this.typeMappings.putAll(defaultValues.typeMappings);
/* 252 */     Element typeMaps = MetaData.getOptionalChild(element, "type-mappings");
/*     */     Iterator i;
/* 253 */     if (typeMaps != null)
/*     */     {
/* 255 */       for (i = MetaData.getChildrenByTagName(typeMaps, "type-mapping"); i.hasNext(); )
/*     */       {
/* 257 */         Element typeMappingElement = (Element)i.next();
/* 258 */         JDBCTypeMappingMetaData typeMapping = new JDBCTypeMappingMetaData(typeMappingElement);
/*     */ 
/* 260 */         this.typeMappings.put(typeMapping.getName(), typeMapping);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 265 */     this.valueClasses.putAll(defaultValues.valueClasses);
/* 266 */     Element valueClassesElement = MetaData.getOptionalChild(element, "dependent-value-classes");
/*     */ 
/* 268 */     if (valueClassesElement != null)
/*     */     {
/* 270 */       Iterator i = MetaData.getChildrenByTagName(valueClassesElement, "dependent-value-class");
/*     */ 
/* 272 */       while (i.hasNext())
/*     */       {
/* 275 */         Element valueClassElement = (Element)i.next();
/* 276 */         JDBCValueClassMetaData valueClass = new JDBCValueClassMetaData(valueClassElement, this.classLoader);
/*     */ 
/* 278 */         this.valueClasses.put(valueClass.getJavaType(), valueClass);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 283 */     this.entityCommands.putAll(defaultValues.entityCommands);
/* 284 */     Element entityCommandMaps = MetaData.getOptionalChild(element, "entity-commands");
/*     */ 
/* 286 */     if (entityCommandMaps != null)
/*     */     {
/* 288 */       Iterator i = MetaData.getChildrenByTagName(entityCommandMaps, "entity-command");
/*     */ 
/* 290 */       while (i.hasNext())
/*     */       {
/* 293 */         Element entityCommandElement = (Element)i.next();
/* 294 */         JDBCEntityCommandMetaData entityCommand = new JDBCEntityCommandMetaData(entityCommandElement);
/*     */ 
/* 296 */         this.entityCommands.put(entityCommand.getCommandName(), entityCommand);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 302 */     Element rWords = MetaData.getOptionalChild(element, "reserved-words");
/*     */     Iterator i;
/* 303 */     if (rWords != null)
/*     */     {
/* 305 */       for (i = MetaData.getChildrenByTagName(rWords, "word"); i.hasNext(); )
/*     */       {
/* 307 */         Element rWord = (Element)i.next();
/* 308 */         SQLUtil.addToRwords(MetaData.getElementContent(rWord));
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 314 */     this.entities.putAll(defaultValues.entities);
/* 315 */     this.entitiesByAbstractSchemaName.putAll(defaultValues.entitiesByAbstractSchemaName);
/*     */ 
/* 317 */     this.entitiesByInterface.putAll(defaultValues.entitiesByInterface);
/* 318 */     Element defaults = MetaData.getOptionalChild(element, "defaults");
/*     */     Iterator i;
/* 319 */     if (defaults != null)
/*     */     {
/* 321 */       ArrayList values = new ArrayList(this.entities.values());
/* 322 */       for (i = values.iterator(); i.hasNext(); )
/*     */       {
/* 324 */         JDBCEntityMetaData entityMetaData = (JDBCEntityMetaData)i.next();
/*     */ 
/* 327 */         entityMetaData = new JDBCEntityMetaData(this, defaults, entityMetaData);
/*     */ 
/* 331 */         this.entities.put(entityMetaData.getName(), entityMetaData);
/*     */ 
/* 333 */         String schemaName = entityMetaData.getAbstractSchemaName();
/* 334 */         if (schemaName != null)
/*     */         {
/* 336 */           this.entitiesByAbstractSchemaName.put(schemaName, entityMetaData);
/*     */         }
/*     */ 
/* 339 */         Class remote = entityMetaData.getRemoteClass();
/* 340 */         if (remote != null)
/*     */         {
/* 342 */           this.entitiesByInterface.put(remote, entityMetaData);
/*     */         }
/*     */ 
/* 345 */         Class local = entityMetaData.getLocalClass();
/* 346 */         if (local != null)
/*     */         {
/* 348 */           this.entitiesByInterface.put(local, entityMetaData);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 355 */     Element enterpriseBeans = MetaData.getOptionalChild(element, "enterprise-beans");
/*     */ 
/* 357 */     if (enterpriseBeans != null)
/*     */     {
/* 359 */       Iterator i = MetaData.getChildrenByTagName(enterpriseBeans, "entity");
/*     */ 
/* 361 */       while (i.hasNext())
/*     */       {
/* 364 */         Element beanElement = (Element)i.next();
/*     */ 
/* 367 */         String ejbName = MetaData.getUniqueChildContent(beanElement, "ejb-name");
/*     */ 
/* 369 */         JDBCEntityMetaData entityMetaData = getBeanByEjbName(ejbName);
/*     */ 
/* 371 */         if (entityMetaData == null)
/*     */         {
/* 373 */           throw new DeploymentException("Configuration found in jbosscmp-jdbc.xml for entity " + ejbName + " but bean " + "is not a jbosscmp-jdbc-managed cmp entity in " + "ejb-jar.xml");
/*     */         }
/*     */ 
/* 378 */         entityMetaData = new JDBCEntityMetaData(this, beanElement, entityMetaData);
/*     */ 
/* 380 */         this.entities.put(entityMetaData.getName(), entityMetaData);
/*     */ 
/* 382 */         String schemaName = entityMetaData.getAbstractSchemaName();
/* 383 */         if (schemaName != null)
/*     */         {
/* 385 */           this.entitiesByAbstractSchemaName.put(schemaName, entityMetaData);
/*     */         }
/*     */ 
/* 388 */         Class remote = entityMetaData.getRemoteClass();
/* 389 */         if (remote != null)
/*     */         {
/* 391 */           this.entitiesByInterface.put(remote, entityMetaData);
/*     */         }
/*     */ 
/* 394 */         Class local = entityMetaData.getLocalClass();
/* 395 */         if (local != null)
/*     */         {
/* 397 */           this.entitiesByInterface.put(local, entityMetaData);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 404 */     if (defaults == null)
/*     */     {
/* 407 */       this.relationships.addAll(defaultValues.relationships);
/* 408 */       this.entityRoles.putAll(defaultValues.entityRoles);
/*     */     }
/*     */     else
/*     */     {
/* 414 */       for (Iterator i = this.entities.values().iterator(); i.hasNext(); )
/*     */       {
/* 416 */         JDBCEntityMetaData entity = (JDBCEntityMetaData)i.next();
/* 417 */         this.entityRoles.put(entity.getName(), new HashSet());
/*     */       }
/*     */ 
/* 421 */       Iterator i = defaultValues.relationships.iterator();
/* 422 */       while (i.hasNext())
/*     */       {
/* 425 */         JDBCRelationMetaData relationMetaData = (JDBCRelationMetaData)i.next();
/*     */ 
/* 429 */         relationMetaData = new JDBCRelationMetaData(this, defaults, relationMetaData);
/*     */ 
/* 433 */         this.relationships.add(relationMetaData);
/*     */ 
/* 436 */         JDBCRelationshipRoleMetaData left = relationMetaData.getLeftRelationshipRole();
/*     */ 
/* 438 */         Collection leftEntityRoles = (Collection)this.entityRoles.get(left.getEntity().getName());
/*     */ 
/* 440 */         leftEntityRoles.add(left);
/*     */ 
/* 443 */         JDBCRelationshipRoleMetaData right = relationMetaData.getRightRelationshipRole();
/*     */ 
/* 445 */         Collection rightEntityRoles = (Collection)this.entityRoles.get(right.getEntity().getName());
/*     */ 
/* 447 */         rightEntityRoles.add(right);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 453 */     Element relationshipsElement = MetaData.getOptionalChild(element, "relationships");
/*     */     Map relationByName;
/*     */     Iterator i;
/* 455 */     if (relationshipsElement != null)
/*     */     {
/* 459 */       relationByName = new HashMap();
/* 460 */       for (Iterator i = this.relationships.iterator(); i.hasNext(); )
/*     */       {
/* 462 */         JDBCRelationMetaData relation = (JDBCRelationMetaData)i.next();
/* 463 */         if (relation.getRelationName() != null)
/*     */         {
/* 465 */           relationByName.put(relation.getRelationName(), relation);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 470 */       for (i = MetaData.getChildrenByTagName(relationshipsElement, "ejb-relation"); i.hasNext(); )
/*     */       {
/* 472 */         Element relationElement = (Element)i.next();
/*     */ 
/* 475 */         String relationName = MetaData.getUniqueChildContent(relationElement, "ejb-relation-name");
/* 476 */         JDBCRelationMetaData oldRelation = (JDBCRelationMetaData)relationByName.get(relationName);
/*     */ 
/* 478 */         if (oldRelation == null)
/*     */         {
/* 480 */           throw new DeploymentException("Configuration found in jbosscmp-jdbc.xml for relation " + relationName + " but relation is not a jbosscmp-jdbc-managed relation " + "in ejb-jar.xml");
/*     */         }
/*     */ 
/* 486 */         JDBCRelationMetaData newRelation = new JDBCRelationMetaData(this, relationElement, oldRelation);
/*     */ 
/* 490 */         this.relationships.remove(oldRelation);
/* 491 */         this.relationships.add(newRelation);
/*     */ 
/* 494 */         JDBCRelationshipRoleMetaData newLeft = newRelation.getLeftRelationshipRole();
/*     */ 
/* 496 */         Collection leftEntityRoles = (Collection)this.entityRoles.get(newLeft.getEntity().getName());
/*     */ 
/* 498 */         leftEntityRoles.remove(oldRelation.getLeftRelationshipRole());
/* 499 */         leftEntityRoles.add(newLeft);
/*     */ 
/* 502 */         JDBCRelationshipRoleMetaData newRight = newRelation.getRightRelationshipRole();
/*     */ 
/* 504 */         Collection rightEntityRoles = (Collection)this.entityRoles.get(newRight.getEntity().getName());
/*     */ 
/* 506 */         rightEntityRoles.remove(oldRelation.getRightRelationshipRole());
/* 507 */         rightEntityRoles.add(newRight);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public JDBCTypeMappingMetaData getTypeMappingByName(String name)
/*     */   {
/* 520 */     return (JDBCTypeMappingMetaData)this.typeMappings.get(name);
/*     */   }
/*     */ 
/*     */   public Collection getRolesForEntity(String entityName)
/*     */   {
/* 531 */     Collection roles = (Collection)this.entityRoles.get(entityName);
/* 532 */     return Collections.unmodifiableCollection(roles);
/*     */   }
/*     */ 
/*     */   public Collection getValueClasses()
/*     */   {
/* 541 */     return Collections.unmodifiableCollection(this.valueClasses.values());
/*     */   }
/*     */ 
/*     */   public ClassLoader getClassLoader()
/*     */   {
/* 551 */     return this.classLoader;
/*     */   }
/*     */ 
/*     */   public JDBCEntityMetaData getBeanByEjbName(String name)
/*     */   {
/* 561 */     return (JDBCEntityMetaData)this.entities.get(name);
/*     */   }
/*     */ 
/*     */   public JDBCEntityCommandMetaData getEntityCommandByName(String name)
/*     */   {
/* 571 */     return (JDBCEntityCommandMetaData)this.entityCommands.get(name);
/*     */   }
/*     */ 
/*     */   public Map getUserTypeMappings()
/*     */   {
/* 576 */     return Collections.unmodifiableMap(this.userTypeMappings);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCApplicationMetaData
 * JD-Core Version:    0.6.0
 */