/*    */ package org.jboss.ejb.plugins.cmp.jdbc.keygen;
/*    */ 
/*    */ import java.sql.PreparedStatement;
/*    */ import java.sql.ResultSet;
/*    */ import java.sql.SQLException;
/*    */ import javax.ejb.EJBException;
/*    */ import org.jboss.deployment.DeploymentException;
/*    */ import org.jboss.ejb.EntityEnterpriseContext;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCIdentityColumnCreateCommand;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
/*    */ 
/*    */ public class JDBCSQLServerCreateCommand extends JDBCIdentityColumnCreateCommand
/*    */ {
/*    */   protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand)
/*    */     throws DeploymentException
/*    */   {
/* 48 */     super.initEntityCommand(entityCommand);
/* 49 */     this.pkSQL = entityCommand.getAttribute("pk-sql");
/* 50 */     if (this.pkSQL == null)
/*    */     {
/* 52 */       this.pkSQL = "SELECT SCOPE_IDENTITY()";
/*    */     }
/*    */   }
/*    */ 
/*    */   protected void initInsertSQL()
/*    */   {
/* 58 */     super.initInsertSQL();
/* 59 */     this.insertSQL = (this.insertSQL + "; " + this.pkSQL);
/*    */   }
/*    */ 
/*    */   protected int executeInsert(int index, PreparedStatement ps, EntityEnterpriseContext ctx) throws SQLException
/*    */   {
/* 64 */     ps.execute();
/* 65 */     ResultSet rs = null;
/*    */     try
/*    */     {
/* 68 */       int rows = ps.getUpdateCount();
/* 69 */       if (rows != 1)
/*    */       {
/* 71 */         throw new EJBException("Expected updateCount of 1, got " + rows);
/*    */       }
/* 73 */       if (!ps.getMoreResults())
/*    */       {
/* 75 */         throw new EJBException("Expected ResultSet but got an updateCount. Is NOCOUNT set for all triggers?");
/*    */       }
/*    */ 
/* 78 */       rs = ps.getResultSet();
/* 79 */       if (!rs.next())
/*    */       {
/* 81 */         throw new EJBException("ResultSet was empty");
/*    */       }
/* 83 */       this.pkField.loadInstanceResults(rs, 1, ctx);
/* 84 */       i = rows;
/*    */     }
/*    */     catch (RuntimeException e)
/*    */     {
/*    */       int i;
/* 88 */       throw e;
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 93 */       throw new EJBException("Error extracting generated keys", e);
/*    */     }
/*    */     finally
/*    */     {
/* 97 */       JDBCUtil.safeClose(rs);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.keygen.JDBCSQLServerCreateCommand
 * JD-Core Version:    0.6.0
 */