/*    */ package org.jboss.ejb.plugins.cmp.jdbc.keygen;
/*    */ 
/*    */ import java.sql.Connection;
/*    */ import java.sql.ResultSet;
/*    */ import java.sql.SQLException;
/*    */ import java.sql.Statement;
/*    */ import javax.ejb.CreateException;
/*    */ import javax.sql.DataSource;
/*    */ import org.jboss.deployment.DeploymentException;
/*    */ import org.jboss.ejb.EntityEnterpriseContext;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCInsertPKCreateCommand;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class JDBCPkSqlCreateCommand extends JDBCInsertPKCreateCommand
/*    */ {
/*    */   protected String pkSQL;
/*    */   protected JDBCCMPFieldBridge pkField;
/*    */ 
/*    */   public void init(JDBCStoreManager manager)
/*    */     throws DeploymentException
/*    */   {
/* 54 */     super.init(manager);
/* 55 */     this.pkField = getGeneratedPKField();
/*    */   }
/*    */ 
/*    */   protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) throws DeploymentException
/*    */   {
/* 60 */     super.initEntityCommand(entityCommand);
/*    */ 
/* 62 */     this.pkSQL = entityCommand.getAttribute("pk-sql");
/* 63 */     if (this.pkSQL == null)
/*    */     {
/* 65 */       throw new DeploymentException("pk-sql attribute must be set for entity " + this.entity.getEntityName());
/*    */     }
/* 67 */     if (this.debug)
/*    */     {
/* 69 */       this.log.debug("Generate PK sql is: " + this.pkSQL);
/*    */     }
/*    */   }
/*    */ 
/*    */   protected void generateFields(EntityEnterpriseContext ctx) throws CreateException
/*    */   {
/* 75 */     super.generateFields(ctx);
/*    */ 
/* 77 */     Connection con = null;
/* 78 */     Statement s = null;
/* 79 */     ResultSet rs = null;
/*    */     try
/*    */     {
/* 82 */       if (this.debug)
/*    */       {
/* 84 */         this.log.debug("Executing SQL: " + this.pkSQL);
/*    */       }
/*    */ 
/* 87 */       DataSource dataSource = this.entity.getDataSource();
/* 88 */       con = dataSource.getConnection();
/* 89 */       s = con.createStatement();
/*    */ 
/* 91 */       rs = s.executeQuery(this.pkSQL);
/* 92 */       if (!rs.next())
/*    */       {
/* 94 */         throw new CreateException("Error fetching next primary key value: result set contains no rows");
/*    */       }
/* 96 */       this.pkField.loadInstanceResults(rs, 1, ctx);
/*    */     }
/*    */     catch (SQLException e)
/*    */     {
/* 100 */       this.log.error("Error fetching the next primary key value", e);
/* 101 */       throw new CreateException("Error fetching the next primary key value:" + e);
/*    */     }
/*    */     finally
/*    */     {
/* 105 */       JDBCUtil.safeClose(rs);
/* 106 */       JDBCUtil.safeClose(s);
/* 107 */       JDBCUtil.safeClose(con);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.keygen.JDBCPkSqlCreateCommand
 * JD-Core Version:    0.6.0
 */