/*     */ package org.jboss.ejb.plugins.cmp.jdbc.keygen;
/*     */ 
/*     */ import java.sql.CallableStatement;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.SQLException;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCIdentityColumnCreateCommand;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class JDBCOracleCreateCommand extends JDBCIdentityColumnCreateCommand
/*     */ {
/*     */   private String sequence;
/*     */   private int jdbcType;
/*     */ 
/*     */   public void init(JDBCStoreManager manager)
/*     */     throws DeploymentException
/*     */   {
/*  51 */     super.init(manager);
/*     */   }
/*     */ 
/*     */   protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) throws DeploymentException
/*     */   {
/*  56 */     super.initEntityCommand(entityCommand);
/*  57 */     this.sequence = entityCommand.getAttribute("sequence");
/*  58 */     if (this.sequence == null)
/*  59 */       throw new DeploymentException("Sequence must be specified");
/*     */   }
/*     */ 
/*     */   protected void initInsertSQL()
/*     */   {
/*  65 */     this.jdbcType = this.pkField.getJDBCType().getJDBCTypes()[0];
/*     */ 
/*  67 */     StringBuffer sql = new StringBuffer();
/*  68 */     sql.append("{call INSERT INTO ").append(this.entity.getQualifiedTableName());
/*  69 */     sql.append(" (");
/*  70 */     SQLUtil.getColumnNamesClause(this.pkField, sql).append(", ");
/*     */ 
/*  73 */     SQLUtil.getColumnNamesClause(this.insertFields, sql);
/*     */ 
/*  75 */     sql.append(")");
/*  76 */     sql.append(" VALUES (");
/*  77 */     sql.append(this.sequence + ".NEXTVAL, ");
/*  78 */     SQLUtil.getValuesClause(this.insertFields, sql);
/*  79 */     sql.append(")");
/*  80 */     sql.append(" RETURNING ");
/*  81 */     SQLUtil.getColumnNamesClause(this.pkField, sql).append(" INTO ? }");
/*     */ 
/*  83 */     this.insertSQL = sql.toString();
/*  84 */     if (this.debug)
/*  85 */       this.log.debug("Insert Entity SQL: " + this.insertSQL);
/*     */   }
/*     */ 
/*     */   protected PreparedStatement prepareStatement(Connection c, String sql, EntityEnterpriseContext ctx)
/*     */     throws SQLException
/*     */   {
/*  91 */     return c.prepareCall(sql);
/*     */   }
/*     */ 
/*     */   protected int executeInsert(int paramIndex, PreparedStatement ps, EntityEnterpriseContext ctx) throws SQLException
/*     */   {
/*  96 */     CallableStatement cs = (CallableStatement)ps;
/*  97 */     cs.registerOutParameter(paramIndex, this.jdbcType);
/*  98 */     cs.execute();
/*  99 */     Object pk = JDBCUtil.getParameter(this.log, cs, paramIndex, this.jdbcType, this.pkField.getFieldType());
/* 100 */     this.pkField.setInstanceValue(ctx, pk);
/* 101 */     return 1;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.keygen.JDBCOracleCreateCommand
 * JD-Core Version:    0.6.0
 */