/*     */ package org.jboss.ejb.plugins.cmp.jdbc.keygen;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Statement;
/*     */ import javax.ejb.EJBException;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCIdentityColumnCreateCommand;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class JDBCMySQLCreateCommand extends JDBCIdentityColumnCreateCommand
/*     */ {
/*  51 */   private static final Logger log = Logger.getLogger(JDBCMySQLCreateCommand.class);
/*     */   private String className;
/*     */   private String methodName;
/*     */   private Method method;
/*     */   private Method getUnderlyingStatement;
/*     */ 
/*     */   public void init(JDBCStoreManager manager)
/*     */     throws DeploymentException
/*     */   {
/*  59 */     super.init(manager);
/*  60 */     ClassLoader loader = GetTCLAction.getContextClassLoader();
/*     */     try
/*     */     {
/*  63 */       Class psClass = loader.loadClass(this.className);
/*  64 */       this.method = psClass.getMethod(this.methodName, null);
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/*  68 */       throw new DeploymentException("Could not load driver class: " + this.className, e);
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*  72 */       throw new DeploymentException("Driver does not have method: " + this.methodName + "()");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  77 */       Class wrapperClass = loader.loadClass("org.jboss.resource.adapter.jdbc.StatementAccess");
/*  78 */       this.getUnderlyingStatement = wrapperClass.getMethod("getUnderlyingStatement", null);
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/*  82 */       throw new DeploymentException("Could not load org.jboss.resource.adapter.jdbc.StatementAccess", e);
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*  86 */       throw new DeploymentException("StatementAccess.getUnderlyingStatement not found", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) throws DeploymentException
/*     */   {
/*  92 */     super.initEntityCommand(entityCommand);
/*  93 */     this.className = entityCommand.getAttribute("class-name");
/*  94 */     if (this.className == null)
/*     */     {
/*  96 */       this.className = "com.mysql.jdbc.PreparedStatement";
/*     */     }
/*  98 */     this.methodName = entityCommand.getAttribute("method");
/*  99 */     if (this.methodName == null)
/*     */     {
/* 101 */       this.methodName = "getGeneratedKeys";
/*     */     }
/*     */   }
/*     */ 
/*     */   protected int executeInsert(int paramIndex, PreparedStatement ps, EntityEnterpriseContext ctx) throws SQLException
/*     */   {
/* 107 */     int rows = ps.executeUpdate();
/*     */ 
/* 110 */     Statement stmt = ps;
/*     */     do
/*     */     {
/*     */       try
/*     */       {
/* 115 */         Object[] args = new Object[0];
/* 116 */         stmt = (Statement)this.getUnderlyingStatement.invoke(stmt, args);
/*     */       }
/*     */       catch (IllegalAccessException e)
/*     */       {
/* 120 */         SQLException ex = new SQLException("Failed to invoke getUnderlyingStatement");
/* 121 */         ex.initCause(e);
/* 122 */         throw ex;
/*     */       }
/*     */       catch (InvocationTargetException e)
/*     */       {
/* 126 */         SQLException ex = new SQLException("Failed to invoke getUnderlyingStatement");
/* 127 */         ex.initCause(e);
/* 128 */         throw ex;
/*     */       }
/*     */     }
/* 130 */     while ((stmt != null) && (!this.method.getDeclaringClass().isInstance(stmt)));
/*     */ 
/* 132 */     ResultSet rs = null;
/*     */     try
/*     */     {
/* 135 */       rs = (ResultSet)this.method.invoke(stmt, null);
/* 136 */       if (!rs.next())
/*     */       {
/* 138 */         throw new EJBException("getGeneratedKeys returned an empty ResultSet");
/*     */       }
/* 140 */       this.pkField.loadInstanceResults(rs, 1, ctx);
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/* 144 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 149 */       throw new EJBException("Error extracting generated keys", e);
/*     */     }
/*     */     finally
/*     */     {
/* 153 */       JDBCUtil.safeClose(rs);
/*     */     }
/* 155 */     return rows;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.keygen.JDBCMySQLCreateCommand
 * JD-Core Version:    0.6.0
 */