/*    */ package org.jboss.ejb.plugins.cmp.jdbc.keygen;
/*    */ 
/*    */ import javax.ejb.CreateException;
/*    */ import javax.naming.InitialContext;
/*    */ import javax.naming.NamingException;
/*    */ import org.jboss.deployment.DeploymentException;
/*    */ import org.jboss.ejb.EntityEnterpriseContext;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCInsertPKCreateCommand;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
/*    */ import org.jboss.ejb.plugins.keygenerator.KeyGenerator;
/*    */ import org.jboss.ejb.plugins.keygenerator.KeyGeneratorFactory;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class JDBCKeyGeneratorCreateCommand extends JDBCInsertPKCreateCommand
/*    */ {
/*    */   protected KeyGenerator keyGenerator;
/*    */   protected JDBCCMPFieldBridge pkField;
/*    */ 
/*    */   public void init(JDBCStoreManager manager)
/*    */     throws DeploymentException
/*    */   {
/* 53 */     super.init(manager);
/* 54 */     this.pkField = getGeneratedPKField();
/*    */   }
/*    */ 
/*    */   protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) throws DeploymentException
/*    */   {
/* 59 */     super.initEntityCommand(entityCommand);
/*    */ 
/* 61 */     String factoryName = entityCommand.getAttribute("key-generator-factory");
/* 62 */     if (factoryName == null)
/*    */     {
/* 64 */       throw new DeploymentException("key-generator-factory attribute must be set for entity " + this.entity.getEntityName());
/*    */     }
/*    */ 
/*    */     try
/*    */     {
/* 69 */       KeyGeneratorFactory keyGeneratorFactory = (KeyGeneratorFactory)new InitialContext().lookup(factoryName);
/* 70 */       this.keyGenerator = keyGeneratorFactory.getKeyGenerator();
/*    */     }
/*    */     catch (NamingException e)
/*    */     {
/* 74 */       throw new DeploymentException("Error: can't find key generator factory: " + factoryName, e);
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 78 */       throw new DeploymentException("Error: can't create key generator instance; key generator factory: " + factoryName, e);
/*    */     }
/*    */   }
/*    */ 
/*    */   protected void generateFields(EntityEnterpriseContext ctx) throws CreateException
/*    */   {
/* 84 */     super.generateFields(ctx);
/*    */ 
/* 86 */     Object pk = this.keyGenerator.generateKey();
/* 87 */     this.log.debug("Generated new pk: " + pk);
/* 88 */     this.pkField.setInstanceValue(ctx, pk);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.keygen.JDBCKeyGeneratorCreateCommand
 * JD-Core Version:    0.6.0
 */