/*     */ package org.jboss.ejb.plugins.cmp.jdbc.keygen;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Statement;
/*     */ import javax.ejb.EJBException;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCIdentityColumnCreateCommand;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
/*     */ 
/*     */ public class JDBCInformixCreateCommand extends JDBCIdentityColumnCreateCommand
/*     */ {
/*     */   private static final String NAME = "class-name";
/*     */   private static final String DEFAULT_CLASS = "com.informix.jdbc.IfxStatement";
/*     */   private static final String METHOD = "method";
/*     */   private static final String DEFAULT_METHOD = "getSerial";
/*     */   private String className;
/*     */   private String methodName;
/*     */   private Method method;
/*     */   private Method getUnderlyingStatement;
/*     */ 
/*     */   public void init(JDBCStoreManager manager)
/*     */     throws DeploymentException
/*     */   {
/*  61 */     super.init(manager);
/*  62 */     ClassLoader loader = GetTCLAction.getContextClassLoader();
/*     */     try
/*     */     {
/*  65 */       Class psClass = loader.loadClass(this.className);
/*  66 */       this.method = psClass.getMethod(this.methodName, null);
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/*  70 */       throw new DeploymentException("Could not load driver class: " + this.className, e);
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*  74 */       throw new DeploymentException("Driver does not have method: " + this.methodName + "()");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  79 */       Class wrapperClass = loader.loadClass("org.jboss.resource.adapter.jdbc.StatementAccess");
/*  80 */       this.getUnderlyingStatement = wrapperClass.getMethod("getUnderlyingStatement", null);
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/*  84 */       throw new DeploymentException("Could not load org.jboss.resource.adapter.jdbc.StatementAccess", e);
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*  88 */       throw new DeploymentException("StatementAccess.getUnderlyingStatement not found", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) throws DeploymentException
/*     */   {
/*  94 */     super.initEntityCommand(entityCommand);
/*  95 */     this.className = entityCommand.getAttribute("class-name");
/*  96 */     if (this.className == null)
/*     */     {
/*  98 */       this.className = "com.informix.jdbc.IfxStatement";
/*     */     }
/* 100 */     this.methodName = entityCommand.getAttribute("method");
/* 101 */     if (this.methodName == null)
/*     */     {
/* 103 */       this.methodName = "getSerial";
/*     */     }
/*     */   }
/*     */ 
/*     */   protected int executeInsert(int paramIndex, PreparedStatement ps, EntityEnterpriseContext ctx) throws SQLException
/*     */   {
/* 109 */     int rows = ps.executeUpdate();
/*     */ 
/* 112 */     Statement stmt = ps;
/*     */     do
/*     */     {
/*     */       try
/*     */       {
/* 117 */         Object[] args = new Object[0];
/* 118 */         stmt = (Statement)this.getUnderlyingStatement.invoke(stmt, args);
/*     */       }
/*     */       catch (IllegalAccessException e)
/*     */       {
/* 122 */         SQLException ex = new SQLException("Failed to invoke getUnderlyingStatement");
/* 123 */         ex.initCause(e);
/* 124 */         throw ex;
/*     */       }
/*     */       catch (InvocationTargetException e)
/*     */       {
/* 128 */         SQLException ex = new SQLException("Failed to invoke getUnderlyingStatement");
/* 129 */         ex.initCause(e);
/* 130 */         throw ex;
/*     */       }
/*     */     }
/* 132 */     while ((stmt != null) && (!this.method.getDeclaringClass().isInstance(stmt)));
/*     */     try
/*     */     {
/* 136 */       Number pk = (Number)this.method.invoke(stmt, null);
/* 137 */       this.pkField.setInstanceValue(ctx, pk);
/* 138 */       return rows;
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/* 142 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/* 147 */     throw new EJBException("Error extracting generated keys", e);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.keygen.JDBCInformixCreateCommand
 * JD-Core Version:    0.6.0
 */