/*     */ package org.jboss.ejb.plugins.cmp.jdbc.bridge;
/*     */ 
/*     */ import java.lang.reflect.UndeclaredThrowableException;
/*     */ import java.security.AccessController;
/*     */ import java.security.Principal;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import java.util.Map;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.jacc.PolicyContext;
/*     */ import javax.security.jacc.PolicyContextException;
/*     */ import org.jboss.security.RunAs;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SecurityContextFactory;
/*     */ import org.jboss.security.SecurityContextUtil;
/*     */ import org.jboss.security.plugins.SecurityContextAssociation;
/*     */ 
/*     */ class SecurityActions
/*     */ {
/*     */   static ClassLoader getContextClassLoader()
/*     */   {
/* 198 */     return SecurityActions.TCLAction.UTIL.getContextClassLoader();
/*     */   }
/*     */ 
/*     */   static void setContextClassLoader(ClassLoader loader)
/*     */   {
/* 203 */     SecurityActions.TCLAction.UTIL.setContextClassLoader(loader);
/*     */   }
/*     */ 
/*     */   static RunAs peekRunAsIdentity()
/*     */   {
/* 210 */     if (System.getSecurityManager() == null)
/*     */     {
/* 212 */       return RunAsIdentityActions.NON_PRIVILEGED.peek();
/*     */     }
/*     */ 
/* 216 */     return RunAsIdentityActions.PRIVILEGED.peek();
/*     */   }
/*     */ 
/*     */   static void pushRunAsIdentity(RunAs principal)
/*     */   {
/* 222 */     if (System.getSecurityManager() == null)
/*     */     {
/* 224 */       RunAsIdentityActions.NON_PRIVILEGED.push(principal);
/*     */     }
/*     */     else
/*     */     {
/* 228 */       RunAsIdentityActions.PRIVILEGED.push(principal);
/*     */     }
/*     */   }
/*     */ 
/*     */   static RunAs popRunAsIdentity()
/*     */   {
/* 234 */     if (System.getSecurityManager() == null)
/*     */     {
/* 236 */       return RunAsIdentityActions.NON_PRIVILEGED.pop();
/*     */     }
/*     */ 
/* 240 */     return RunAsIdentityActions.PRIVILEGED.pop();
/*     */   }
/*     */ 
/*     */   static Subject getContextSubject()
/*     */     throws PolicyContextException
/*     */   {
/* 248 */     if (System.getSecurityManager() == null)
/*     */     {
/* 250 */       return PolicyContextActions.NON_PRIVILEGED.getContextSubject();
/*     */     }
/*     */ 
/* 254 */     return PolicyContextActions.PRIVILEGED.getContextSubject();
/*     */   }
/*     */ 
/*     */   static void createAndSetSecurityContext(Principal p, Object cred, String domain)
/*     */     throws PrivilegedActionException
/*     */   {
/* 380 */     AccessController.doPrivileged(new PrivilegedExceptionAction(p, cred, domain)
/*     */     {
/*     */       public Object run() throws Exception
/*     */       {
/* 384 */         SecurityContext sc = SecurityContextFactory.createSecurityContext(this.val$p, this.val$cred, null, this.val$domain);
/* 385 */         SecurityContextAssociation.setSecurityContext(sc);
/* 386 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static void createAndSetSecurityContext(Principal p, Object cred, String domain, Subject subject) throws PrivilegedActionException {
/* 393 */     AccessController.doPrivileged(new PrivilegedExceptionAction(domain, p, cred, subject)
/*     */     {
/*     */       public Object run() throws Exception
/*     */       {
/* 397 */         SecurityContext sc = SecurityContextFactory.createSecurityContext(this.val$domain);
/* 398 */         sc.getUtil().createSubjectInfo(this.val$p, this.val$cred, this.val$subject);
/* 399 */         SecurityContextAssociation.setSecurityContext(sc);
/* 400 */         return null;
/*     */       } } );
/*     */   }
/*     */ 
/*     */   static void clearSecurityContext() {
/* 406 */     AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/* 410 */         SecurityContextAssociation.setSecurityContext(null);
/* 411 */         return null;
/*     */       } } );
/*     */   }
/*     */ 
/*     */   static SecurityContext getSecurityContext() {
/* 417 */     return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run() {
/* 420 */         return SecurityContextAssociation.getSecurityContext();
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static Exception getContextException() {
/* 427 */     return (Exception)AccessController.doPrivileged(new PrivilegedAction() {
/*     */       static final String EX_KEY = "org.jboss.security.exception";
/*     */ 
/*     */       public Object run() {
/* 432 */         SecurityContext sc = SecurityActions.getSecurityContext();
/* 433 */         return sc.getData().get("org.jboss.security.exception");
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static void pushSubjectContext(Principal p, Object cred, Subject s) {
/* 440 */     AccessController.doPrivileged(new PrivilegedAction(p, cred, s)
/*     */     {
/*     */       public Object run()
/*     */       {
/* 444 */         SecurityContext sc = SecurityActions.getSecurityContext();
/* 445 */         if (sc == null)
/* 446 */           throw new IllegalStateException("Security Context is null");
/* 447 */         sc.getUtil().createSubjectInfo(this.val$p, this.val$cred, this.val$s);
/* 448 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static void popSubjectContext() {
/* 455 */     AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/* 459 */         SecurityContext sc = SecurityActions.getSecurityContext();
/* 460 */         if (sc == null)
/* 461 */           throw new IllegalStateException("Security Context is null");
/* 462 */         Principal p = sc.getUtil().getUserPrincipal();
/* 463 */         Object cred = sc.getUtil().getCredential();
/* 464 */         sc.getUtil().createSubjectInfo(p, cred, null);
/* 465 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static void pushCallerRunAsIdentity(RunAs ra) {
/* 472 */     AccessController.doPrivileged(new PrivilegedAction(ra)
/*     */     {
/*     */       public Object run() {
/* 475 */         SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/* 476 */         if (sc == null)
/* 477 */           throw new IllegalStateException("Security Context is null");
/* 478 */         sc.setIncomingRunAs(this.val$ra);
/* 479 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static void popCallerRunAsIdentity() {
/* 486 */     AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run() {
/* 489 */         SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/* 490 */         if (sc == null)
/* 491 */           throw new IllegalStateException("Security Context is null");
/* 492 */         sc.setIncomingRunAs(null);
/* 493 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static abstract interface TCLAction
/*     */   {
/* 288 */     public static final TCLAction NON_PRIVILEGED = new TCLAction()
/*     */     {
/*     */       public ClassLoader getContextClassLoader()
/*     */       {
/* 292 */         return Thread.currentThread().getContextClassLoader();
/*     */       }
/*     */ 
/*     */       public ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 297 */         return thread.getContextClassLoader();
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(ClassLoader cl)
/*     */       {
/* 302 */         Thread.currentThread().setContextClassLoader(cl);
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 307 */         thread.setContextClassLoader(cl);
/*     */       }
/* 288 */     };
/*     */ 
/* 311 */     public static final TCLAction PRIVILEGED = new TCLAction()
/*     */     {
/* 313 */       private final PrivilegedAction getTCLPrivilegedAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/* 317 */           return Thread.currentThread().getContextClassLoader();
/*     */         }
/* 313 */       };
/*     */ 
/*     */       public ClassLoader getContextClassLoader()
/*     */       {
/* 323 */         return (ClassLoader)AccessController.doPrivileged(this.getTCLPrivilegedAction);
/*     */       }
/*     */ 
/*     */       public ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 328 */         return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(thread)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 332 */             return this.val$thread.getContextClassLoader();
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(ClassLoader cl) {
/* 339 */         AccessController.doPrivileged(new PrivilegedAction(cl)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 344 */             Thread.currentThread().setContextClassLoader(this.val$cl);
/* 345 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 353 */         AccessController.doPrivileged(new PrivilegedAction(thread, cl)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 358 */             this.val$thread.setContextClassLoader(this.val$cl);
/* 359 */             return null;
/*     */           }
/*     */         });
/*     */       }
/* 311 */     };
/*     */ 
/*     */     public abstract ClassLoader getContextClassLoader();
/*     */ 
/*     */     public abstract ClassLoader getContextClassLoader(Thread paramThread);
/*     */ 
/*     */     public abstract void setContextClassLoader(ClassLoader paramClassLoader);
/*     */ 
/*     */     public abstract void setContextClassLoader(Thread paramThread, ClassLoader paramClassLoader);
/*     */ 
/*     */     public static class UTIL
/*     */     {
/*     */       static SecurityActions.TCLAction getTCLAction()
/*     */       {
/* 264 */         return System.getSecurityManager() == null ? SecurityActions.TCLAction.NON_PRIVILEGED : SecurityActions.TCLAction.PRIVILEGED;
/*     */       }
/*     */ 
/*     */       static ClassLoader getContextClassLoader()
/*     */       {
/* 269 */         return getTCLAction().getContextClassLoader();
/*     */       }
/*     */ 
/*     */       static ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 274 */         return getTCLAction().getContextClassLoader(thread);
/*     */       }
/*     */ 
/*     */       static void setContextClassLoader(ClassLoader cl)
/*     */       {
/* 279 */         getTCLAction().setContextClassLoader(cl);
/*     */       }
/*     */ 
/*     */       static void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 284 */         getTCLAction().setContextClassLoader(thread, cl);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static abstract interface PolicyContextActions
/*     */   {
/*     */     public static final String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
/* 156 */     public static final PolicyContextActions PRIVILEGED = new PolicyContextActions()
/*     */     {
/* 158 */       private final PrivilegedExceptionAction exAction = new PrivilegedExceptionAction()
/*     */       {
/*     */         public Object run() throws Exception
/*     */         {
/* 162 */           return (Subject)PolicyContext.getContext("javax.security.auth.Subject.container");
/*     */         }
/* 158 */       };
/*     */ 
/*     */       public Subject getContextSubject()
/*     */         throws PolicyContextException
/*     */       {
/*     */         Exception ex;
/*     */         try
/*     */         {
/* 170 */           return (Subject)AccessController.doPrivileged(this.exAction);
/*     */         }
/*     */         catch (PrivilegedActionException e)
/*     */         {
/* 174 */           ex = e.getException();
/* 175 */           if ((ex instanceof PolicyContextException))
/* 176 */             throw ((PolicyContextException)ex);
/*     */         }
/* 178 */         throw new UndeclaredThrowableException(ex);
/*     */       }
/* 156 */     };
/*     */ 
/* 183 */     public static final PolicyContextActions NON_PRIVILEGED = new PolicyContextActions()
/*     */     {
/*     */       public Subject getContextSubject()
/*     */         throws PolicyContextException
/*     */       {
/* 188 */         return (Subject)PolicyContext.getContext("javax.security.auth.Subject.container");
/*     */       }
/* 183 */     };
/*     */ 
/*     */     public abstract Subject getContextSubject()
/*     */       throws PolicyContextException;
/*     */   }
/*     */ 
/*     */   static abstract interface RunAsIdentityActions
/*     */   {
/*  52 */     public static final RunAsIdentityActions PRIVILEGED = new RunAsIdentityActions()
/*     */     {
/*  54 */       private final PrivilegedAction peekAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/*  59 */           SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/*  60 */           if (sc == null)
/*  61 */             throw new IllegalStateException("Security Context is null");
/*  62 */           return sc.getOutgoingRunAs();
/*     */         }
/*  54 */       };
/*     */ 
/*  66 */       private final PrivilegedAction popAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/*  71 */           SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/*  72 */           if (sc == null)
/*  73 */             throw new IllegalStateException("Security Context is null");
/*  74 */           RunAs ra = sc.getOutgoingRunAs();
/*  75 */           sc.setOutgoingRunAs(null);
/*  76 */           return ra;
/*     */         }
/*  66 */       };
/*     */ 
/*     */       public RunAs peek()
/*     */       {
/*  82 */         return (RunAs)AccessController.doPrivileged(this.peekAction);
/*     */       }
/*     */ 
/*     */       public void push(RunAs id)
/*     */       {
/*  87 */         AccessController.doPrivileged(new PrivilegedAction(id)
/*     */         {
/*     */           public Object run()
/*     */           {
/*  93 */             SecurityContext sa = SecurityContextAssociation.getSecurityContext();
/*  94 */             if (sa == null)
/*  95 */               throw new IllegalStateException("Security Context is null to push runas");
/*  96 */             sa.setOutgoingRunAs(this.val$id);
/*  97 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public RunAs pop()
/*     */       {
/* 105 */         return (RunAs)AccessController.doPrivileged(this.popAction);
/*     */       }
/*  52 */     };
/*     */ 
/* 109 */     public static final RunAsIdentityActions NON_PRIVILEGED = new RunAsIdentityActions()
/*     */     {
/*     */       public RunAs peek()
/*     */       {
/* 114 */         SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/* 115 */         if (sc == null)
/* 116 */           throw new IllegalStateException("Security Context is null");
/* 117 */         return sc.getOutgoingRunAs();
/*     */       }
/*     */ 
/*     */       public void push(RunAs id)
/*     */       {
/* 123 */         SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/* 124 */         if (sc == null)
/* 125 */           throw new IllegalStateException("Security Context is null to push runas");
/* 126 */         sc.setOutgoingRunAs(id);
/*     */       }
/*     */ 
/*     */       public RunAs pop()
/*     */       {
/* 133 */         SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/* 134 */         if (sc == null)
/* 135 */           throw new IllegalStateException("Security Context is null");
/* 136 */         RunAs ra = null;
/* 137 */         ra = sc.getOutgoingRunAs();
/* 138 */         sc.setOutgoingRunAs(null);
/* 139 */         return ra;
/*     */       }
/* 109 */     };
/*     */ 
/*     */     public abstract RunAs peek();
/*     */ 
/*     */     public abstract void push(RunAs paramRunAs);
/*     */ 
/*     */     public abstract RunAs pop();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.bridge.SecurityActions
 * JD-Core Version:    0.6.0
 */