/*     */ package org.jboss.ejb.plugins.cmp.jdbc.bridge;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Collection;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.FinderException;
/*     */ import javax.ejb.ObjectNotFoundException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.GenericEntityObjectFactory;
/*     */ import org.jboss.ejb.plugins.cmp.bridge.SelectorBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCQueryCommand;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCQueryManager;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.ConfigurationMetaData;
/*     */ 
/*     */ public class JDBCSelectorBridge
/*     */   implements SelectorBridge
/*     */ {
/*     */   private final JDBCQueryMetaData queryMetaData;
/*     */   private final JDBCStoreManager manager;
/*     */   private TransactionManager tm;
/*     */   private boolean syncBeforeSelect;
/*     */ 
/*     */   public JDBCSelectorBridge(JDBCStoreManager manager, JDBCQueryMetaData queryMetaData)
/*     */   {
/*  63 */     this.queryMetaData = queryMetaData;
/*  64 */     this.manager = manager;
/*     */ 
/*  66 */     EntityContainer container = manager.getContainer();
/*  67 */     this.tm = container.getTransactionManager();
/*  68 */     this.syncBeforeSelect = (!container.getBeanMetaData().getContainerConfiguration().getSyncOnCommitOnly());
/*     */   }
/*     */ 
/*     */   public Object invoke(EntityEnterpriseContext ctx, Method method, Object[] args)
/*     */     throws Exception
/*     */   {
/*  76 */     Transaction tx = ctx != null ? ctx.getTransaction() : this.tm.getTransaction();
/*     */ 
/*  78 */     if (this.syncBeforeSelect)
/*     */     {
/*  80 */       EntityContainer.synchronizeEntitiesWithinTransaction(tx);
/*     */     }
/*     */ 
/*  83 */     return execute(args);
/*     */   }
/*     */ 
/*     */   public String getSelectorName()
/*     */   {
/*  90 */     return this.queryMetaData.getMethod().getName();
/*     */   }
/*     */ 
/*     */   public Method getMethod()
/*     */   {
/*  95 */     return this.queryMetaData.getMethod();
/*     */   }
/*     */ 
/*     */   private Class getReturnType()
/*     */   {
/* 100 */     return this.queryMetaData.getMethod().getReturnType();
/*     */   }
/*     */ 
/*     */   public Object execute(Object[] args) throws FinderException {
/* 106 */     Method method = getMethod();
/*     */     Collection retVal;
/*     */     try {
/* 109 */       JDBCQueryCommand query = this.manager.getQueryManager().getQueryCommand(method);
/* 110 */       EntityContainer selectedContainer = query.getSelectManager().getContainer();
/*     */       GenericEntityObjectFactory factory;
/*     */       GenericEntityObjectFactory factory;
/* 112 */       if ((this.queryMetaData.isResultTypeMappingLocal()) && (selectedContainer.getLocalHomeClass() != null))
/*     */       {
/* 114 */         factory = selectedContainer.getLocalProxyFactory();
/*     */       }
/*     */       else
/*     */       {
/* 118 */         factory = selectedContainer.getProxyFactory();
/*     */       }
/*     */ 
/* 121 */       retVal = query.execute(method, args, null, factory);
/*     */     }
/*     */     catch (FinderException e)
/*     */     {
/* 125 */       throw e;
/*     */     }
/*     */     catch (EJBException e)
/*     */     {
/* 129 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 133 */       throw new EJBException("Error in " + getSelectorName(), e);
/*     */     }
/*     */ 
/* 136 */     if (!Collection.class.isAssignableFrom(getReturnType()))
/*     */     {
/* 139 */       if (retVal.size() == 0)
/*     */       {
/* 141 */         throw new ObjectNotFoundException();
/*     */       }
/* 143 */       if (retVal.size() > 1)
/*     */       {
/* 145 */         throw new FinderException(getSelectorName() + " returned " + retVal.size() + " objects");
/*     */       }
/*     */ 
/* 149 */       Object o = retVal.iterator().next();
/* 150 */       if ((o == null) && (method.getReturnType().isPrimitive()))
/*     */       {
/* 152 */         throw new FinderException("Cannot return null as a value of primitive type " + method.getReturnType().getName());
/*     */       }
/*     */ 
/* 157 */       return o;
/*     */     }
/*     */ 
/* 162 */     if (Set.class.isAssignableFrom(getReturnType()))
/*     */     {
/* 164 */       return new HashSet(retVal);
/*     */     }
/*     */ 
/* 168 */     return retVal;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCSelectorBridge
 * JD-Core Version:    0.6.0
 */