/*    */ package org.jboss.ejb.plugins.cmp.jdbc.bridge;
/*    */ 
/*    */ import javax.naming.InitialContext;
/*    */ import javax.naming.NamingException;
/*    */ import org.jboss.deployment.DeploymentException;
/*    */ import org.jboss.ejb.EntityEnterpriseContext;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
/*    */ import org.jboss.ejb.plugins.keygenerator.KeyGenerator;
/*    */ import org.jboss.ejb.plugins.keygenerator.KeyGeneratorFactory;
/*    */ 
/*    */ public class JDBCKeyGenVersionFieldBridge extends JDBCCMP2xVersionFieldBridge
/*    */ {
/*    */   private final KeyGenerator keyGenerator;
/*    */ 
/*    */   public JDBCKeyGenVersionFieldBridge(JDBCStoreManager manager, JDBCCMPFieldMetaData metadata, String keygenFactoryName)
/*    */     throws DeploymentException
/*    */   {
/* 47 */     super(manager, metadata);
/* 48 */     this.keyGenerator = initKeyGenerator(keygenFactoryName);
/*    */   }
/*    */ 
/*    */   public JDBCKeyGenVersionFieldBridge(JDBCCMP2xFieldBridge cmpField, String keygenFactoryName)
/*    */     throws DeploymentException
/*    */   {
/* 54 */     super(cmpField);
/* 55 */     this.keyGenerator = initKeyGenerator(keygenFactoryName);
/*    */   }
/*    */ 
/*    */   private KeyGenerator initKeyGenerator(String keygenFactoryName) throws DeploymentException
/*    */   {
/*    */     try
/*    */     {
/* 62 */       InitialContext ctx = new InitialContext();
/* 63 */       KeyGeneratorFactory keygenFactory = (KeyGeneratorFactory)ctx.lookup(keygenFactoryName);
/* 64 */       return keygenFactory.getKeyGenerator();
/*    */     }
/*    */     catch (NamingException e)
/*    */     {
/* 68 */       throw new DeploymentException("Could not lookup key generator factory: " + keygenFactoryName, e);
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/*    */     }
/* 73 */     throw new DeploymentException("Could not create KeyGenerator instance.", e);
/*    */   }
/*    */ 
/*    */   public void setFirstVersion(EntityEnterpriseContext ctx)
/*    */   {
/* 79 */     Object version = this.keyGenerator.generateKey();
/* 80 */     setInstanceValue(ctx, version);
/*    */   }
/*    */ 
/*    */   public Object updateVersion(EntityEnterpriseContext ctx)
/*    */   {
/* 85 */     Object next = this.keyGenerator.generateKey();
/* 86 */     setInstanceValue(ctx, next);
/* 87 */     return next;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCKeyGenVersionFieldBridge
 * JD-Core Version:    0.6.0
 */