/*     */ package org.jboss.ejb.plugins.cmp.jdbc.bridge;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import javax.ejb.EJBException;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.CMPFieldStateFactory;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCContext;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCType;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
/*     */ 
/*     */ public class JDBCCMP2xFieldBridge extends JDBCAbstractCMPFieldBridge
/*     */ {
/*     */   private final String columnName;
/*     */   private final JDBCCMP2xFieldBridge cmpFieldIAmMappedTo;
/*     */   private ChainLink cmrChainLink;
/*     */ 
/*     */   public JDBCCMP2xFieldBridge(JDBCStoreManager manager, JDBCCMPFieldMetaData metadata)
/*     */     throws DeploymentException
/*     */   {
/*  70 */     super(manager, metadata);
/*  71 */     this.cmpFieldIAmMappedTo = null;
/*  72 */     this.columnName = metadata.getColumnName();
/*     */   }
/*     */ 
/*     */   public JDBCCMP2xFieldBridge(JDBCStoreManager manager, JDBCCMPFieldMetaData metadata, CMPFieldStateFactory stateFactory, boolean checkDirtyAfterGet)
/*     */     throws DeploymentException
/*     */   {
/*  81 */     this(manager, metadata);
/*  82 */     this.stateFactory = stateFactory;
/*  83 */     this.checkDirtyAfterGet = checkDirtyAfterGet;
/*     */   }
/*     */ 
/*     */   public JDBCCMP2xFieldBridge(JDBCCMP2xFieldBridge cmpField, CMPFieldStateFactory stateFactory, boolean checkDirtyAfterGet)
/*     */     throws DeploymentException
/*     */   {
/*  91 */     this((JDBCStoreManager)cmpField.getManager(), cmpField.getFieldName(), cmpField.getFieldType(), cmpField.getJDBCType(), cmpField.isReadOnly(), cmpField.getReadTimeOut(), cmpField.getPrimaryKeyClass(), cmpField.getPrimaryKeyField(), cmpField, null, cmpField.getColumnName());
/*     */ 
/* 104 */     this.stateFactory = stateFactory;
/* 105 */     this.checkDirtyAfterGet = checkDirtyAfterGet;
/*     */   }
/*     */ 
/*     */   public JDBCCMP2xFieldBridge(JDBCStoreManager manager, JDBCCMPFieldMetaData metadata, JDBCType jdbcType)
/*     */     throws DeploymentException
/*     */   {
/* 116 */     super(manager, metadata, jdbcType);
/* 117 */     this.cmpFieldIAmMappedTo = null;
/* 118 */     this.columnName = metadata.getColumnName();
/*     */   }
/*     */ 
/*     */   public JDBCCMP2xFieldBridge(JDBCStoreManager manager, String fieldName, Class fieldType, JDBCType jdbcType, boolean readOnly, long readTimeOut, Class primaryKeyClass, Field primaryKeyField, JDBCCMP2xFieldBridge cmpFieldIAmMappedTo, JDBCCMRFieldBridge myCMRField, String columnName)
/*     */     throws DeploymentException
/*     */   {
/* 138 */     super(manager, fieldName, fieldType, jdbcType, readOnly, readTimeOut, primaryKeyClass, primaryKeyField, cmpFieldIAmMappedTo.getFieldIndex(), cmpFieldIAmMappedTo.getTableIndex(), cmpFieldIAmMappedTo.checkDirtyAfterGet, cmpFieldIAmMappedTo.stateFactory);
/*     */ 
/* 152 */     this.cmpFieldIAmMappedTo = cmpFieldIAmMappedTo;
/* 153 */     if (myCMRField != null)
/*     */     {
/* 155 */       this.cmrChainLink = new CMRChainLink(myCMRField);
/* 156 */       cmpFieldIAmMappedTo.addCMRChainLink(this.cmrChainLink);
/*     */     }
/* 158 */     this.columnName = columnName;
/*     */   }
/*     */ 
/*     */   public JDBCCMP2xFieldBridge getCmpFieldIAmMappedTo()
/*     */   {
/* 165 */     return this.cmpFieldIAmMappedTo;
/*     */   }
/*     */ 
/*     */   public ChainLink getCmrChainLink()
/*     */   {
/* 170 */     return this.cmrChainLink;
/*     */   }
/*     */ 
/*     */   public boolean isFKFieldMappedToCMPField()
/*     */   {
/* 175 */     return (this.cmpFieldIAmMappedTo != null) && (this.cmrChainLink != null);
/*     */   }
/*     */ 
/*     */   public String getColumnName()
/*     */   {
/* 180 */     return this.columnName;
/*     */   }
/*     */ 
/*     */   public Object getInstanceValue(EntityEnterpriseContext ctx)
/*     */   {
/* 187 */     FieldState fieldState = getLoadedState(ctx);
/* 188 */     return fieldState.getValue();
/*     */   }
/*     */ 
/*     */   public void setInstanceValue(EntityEnterpriseContext ctx, Object value)
/*     */   {
/* 193 */     FieldState fieldState = getFieldState(ctx);
/*     */ 
/* 196 */     if ((this.cmpFieldIAmMappedTo != null) && (this.cmpFieldIAmMappedTo.isPrimaryKeyMember()))
/*     */     {
/* 200 */       if (value != null)
/*     */       {
/* 202 */         if ((fieldState.isLoaded()) && (fieldState.isValueChanged(value)))
/*     */         {
/* 204 */           throw new IllegalStateException("New value [" + value + "] of a foreign key field " + getFieldName() + " changed the value of a primary key field " + this.cmpFieldIAmMappedTo.getFieldName() + "[" + fieldState.value + "]");
/*     */         }
/*     */ 
/* 214 */         fieldState.setValue(value);
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 220 */       if ((this.cmrChainLink != null) && (JDBCEntityBridge.isEjbCreateDone(ctx)) && (fieldState.isLoaded()) && (fieldState.isValueChanged(value)))
/*     */       {
/* 225 */         this.cmrChainLink.execute(ctx, fieldState, value);
/*     */       }
/*     */ 
/* 228 */       fieldState.setValue(value);
/*     */     }
/*     */ 
/* 232 */     fieldState.setLoaded();
/*     */   }
/*     */ 
/*     */   public void lockInstanceValue(EntityEnterpriseContext ctx)
/*     */   {
/* 237 */     getFieldState(ctx).lockValue();
/*     */   }
/*     */ 
/*     */   public boolean isLoaded(EntityEnterpriseContext ctx)
/*     */   {
/* 242 */     return getFieldState(ctx).isLoaded();
/*     */   }
/*     */ 
/*     */   public boolean isDirty(EntityEnterpriseContext ctx)
/*     */   {
/* 250 */     return (!this.primaryKeyMember) && (!this.readOnly) && (getFieldState(ctx).isDirty());
/*     */   }
/*     */ 
/*     */   public void setClean(EntityEnterpriseContext ctx)
/*     */   {
/* 261 */     FieldState fieldState = getFieldState(ctx);
/* 262 */     fieldState.setClean();
/*     */ 
/* 265 */     if ((this.readOnly) && (this.readTimeOut != -1L))
/* 266 */       FieldState.access$102(fieldState, System.currentTimeMillis());
/*     */   }
/*     */ 
/*     */   public void resetPersistenceContext(EntityEnterpriseContext ctx)
/*     */   {
/* 271 */     if (isReadTimedOut(ctx))
/*     */     {
/* 273 */       JDBCContext jdbcCtx = (JDBCContext)ctx.getPersistenceContext();
/* 274 */       FieldState fieldState = (FieldState)jdbcCtx.getFieldState(this.jdbcContextIndex);
/* 275 */       if (fieldState != null)
/* 276 */         fieldState.reset();
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isReadTimedOut(EntityEnterpriseContext ctx)
/*     */   {
/* 283 */     if (!this.readOnly) {
/* 284 */       return true;
/*     */     }
/*     */ 
/* 287 */     if (this.readTimeOut == -1L) {
/* 288 */       return false;
/*     */     }
/* 290 */     long readInterval = System.currentTimeMillis() - getFieldState(ctx).lastRead;
/* 291 */     return readInterval >= this.readTimeOut;
/*     */   }
/*     */ 
/*     */   public Object getLockedValue(EntityEnterpriseContext ctx)
/*     */   {
/* 296 */     return getLoadedState(ctx).getLockedValue();
/*     */   }
/*     */ 
/*     */   public void updateState(EntityEnterpriseContext ctx, Object value)
/*     */   {
/* 301 */     getFieldState(ctx).updateState(value);
/*     */   }
/*     */ 
/*     */   protected void setDirtyAfterGet(EntityEnterpriseContext ctx)
/*     */   {
/* 306 */     getFieldState(ctx).setCheckDirty();
/*     */   }
/*     */ 
/*     */   private FieldState getLoadedState(EntityEnterpriseContext ctx)
/*     */   {
/* 313 */     FieldState fieldState = getFieldState(ctx);
/* 314 */     if (!fieldState.isLoaded())
/*     */     {
/* 316 */       this.manager.loadField(this, ctx);
/* 317 */       if (!fieldState.isLoaded())
/* 318 */         throw new EJBException("Could not load field value: " + getFieldName());
/*     */     }
/* 320 */     return fieldState;
/*     */   }
/*     */ 
/*     */   private void addCMRChainLink(ChainLink nextCMRChainLink)
/*     */   {
/* 325 */     if (this.cmrChainLink == null)
/*     */     {
/* 327 */       this.cmrChainLink = new DummyChainLink(null);
/*     */     }
/* 329 */     this.cmrChainLink.setNextLink(nextCMRChainLink);
/*     */   }
/*     */ 
/*     */   private FieldState getFieldState(EntityEnterpriseContext ctx)
/*     */   {
/* 334 */     JDBCContext jdbcCtx = (JDBCContext)ctx.getPersistenceContext();
/* 335 */     FieldState fieldState = (FieldState)jdbcCtx.getFieldState(this.jdbcContextIndex);
/* 336 */     if (fieldState == null)
/*     */     {
/* 338 */       fieldState = new FieldState(jdbcCtx);
/* 339 */       jdbcCtx.setFieldState(this.jdbcContextIndex, fieldState);
/*     */     }
/* 341 */     return fieldState;
/*     */   }
/*     */ 
/*     */   private static class DummyChainLink extends JDBCCMP2xFieldBridge.ChainLink
/*     */   {
/*     */     public void doExecute(JDBCCMP2xFieldBridge.ChainLink originator, EntityEnterpriseContext ctx, JDBCCMP2xFieldBridge.FieldState fieldState, Object newValue)
/*     */     {
/* 618 */       if (originator != getNextLink())
/*     */       {
/* 620 */         getNextLink().doExecute(originator, ctx, fieldState, newValue);
/*     */       }
/*     */ 
/* 623 */       fieldState.setValue(newValue);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class CMRChainLink extends JDBCCMP2xFieldBridge.ChainLink
/*     */   {
/*     */     private final JDBCCMRFieldBridge cmrField;
/*     */ 
/*     */     public CMRChainLink(JDBCCMRFieldBridge cmrField)
/*     */     {
/* 520 */       this.cmrField = cmrField;
/*     */     }
/*     */ 
/*     */     public void doExecute(JDBCCMP2xFieldBridge.ChainLink originator, EntityEnterpriseContext ctx, JDBCCMP2xFieldBridge.FieldState fieldState, Object newValue)
/*     */     {
/* 542 */       Object oldRelatedId = this.cmrField.getRelatedIdFromContext(ctx);
/*     */ 
/* 545 */       if (originator != getNextLink())
/*     */       {
/* 547 */         getNextLink().doExecute(originator, ctx, fieldState, newValue);
/*     */       }
/*     */ 
/* 551 */       fieldState.setValue(newValue);
/*     */ 
/* 554 */       Object newRelatedId = this.cmrField.getRelatedIdFromContext(ctx);
/*     */ 
/* 557 */       if (oldRelatedId != null) {
/* 558 */         destroyRelations(oldRelatedId, ctx);
/*     */       }
/*     */ 
/* 561 */       if (newRelatedId != null)
/* 562 */         createRelations(newRelatedId, ctx);
/*     */     }
/*     */ 
/*     */     private void createRelations(Object newRelatedId, EntityEnterpriseContext ctx)
/*     */     {
/*     */       try
/*     */       {
/* 569 */         if (this.cmrField.isForeignKeyValid(newRelatedId))
/*     */         {
/* 571 */           this.cmrField.createRelationLinks(ctx, newRelatedId, false);
/*     */         }
/*     */         else
/*     */         {
/* 576 */           this.cmrField.setForeignKey(ctx, newRelatedId);
/*     */ 
/* 578 */           if (ctx.getId() != null)
/*     */           {
/* 580 */             JDBCCMRFieldBridge relatedCMRField = (JDBCCMRFieldBridge)this.cmrField.getRelatedCMRField();
/* 581 */             relatedCMRField.addRelatedPKWaitingForMyPK(newRelatedId, ctx.getId());
/*     */           }
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/*     */     }
/*     */ 
/*     */     private void destroyRelations(Object oldRelatedId, EntityEnterpriseContext ctx)
/*     */     {
/* 593 */       JDBCCMRFieldBridge relatedCMRField = (JDBCCMRFieldBridge)this.cmrField.getRelatedCMRField();
/* 594 */       relatedCMRField.removeRelatedPKWaitingForMyPK(oldRelatedId, ctx.getId());
/*     */       try
/*     */       {
/* 597 */         if (this.cmrField.isForeignKeyValid(oldRelatedId))
/*     */         {
/* 599 */           this.cmrField.destroyRelationLinks(ctx, oldRelatedId, true, false);
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static abstract class ChainLink
/*     */   {
/*     */     private ChainLink nextLink;
/*     */ 
/*     */     public ChainLink()
/*     */     {
/* 483 */       this.nextLink = this;
/*     */     }
/*     */ 
/*     */     public void setNextLink(ChainLink nextLink)
/*     */     {
/* 488 */       nextLink.nextLink = this.nextLink;
/* 489 */       this.nextLink = nextLink;
/*     */     }
/*     */ 
/*     */     public ChainLink getNextLink()
/*     */     {
/* 494 */       return this.nextLink;
/*     */     }
/*     */ 
/*     */     public void execute(EntityEnterpriseContext ctx, JDBCCMP2xFieldBridge.FieldState fieldState, Object newValue)
/*     */     {
/* 501 */       this.nextLink.doExecute(this, ctx, fieldState, newValue);
/*     */     }
/*     */ 
/*     */     protected abstract void doExecute(ChainLink paramChainLink, EntityEnterpriseContext paramEntityEnterpriseContext, JDBCCMP2xFieldBridge.FieldState paramFieldState, Object paramObject);
/*     */   }
/*     */ 
/*     */   private class FieldState
/*     */   {
/*     */     private JDBCEntityBridge.EntityState entityState;
/*     */     private Object value;
/*     */     private Object state;
/*     */     private Object lockedValue;
/* 357 */     private long lastRead = -1L;
/*     */ 
/*     */     public FieldState(JDBCContext jdbcCtx)
/*     */     {
/* 361 */       this.entityState = jdbcCtx.getEntityState();
/*     */     }
/*     */ 
/*     */     public Object getValue()
/*     */     {
/* 372 */       return this.value;
/*     */     }
/*     */ 
/*     */     public void setValue(Object newValue)
/*     */     {
/* 381 */       this.value = newValue;
/* 382 */       setCheckDirty();
/*     */     }
/*     */ 
/*     */     private void setCheckDirty()
/*     */     {
/* 387 */       this.entityState.setCheckDirty(JDBCCMP2xFieldBridge.this.tableIndex);
/*     */     }
/*     */ 
/*     */     public boolean isLoaded()
/*     */     {
/* 395 */       return this.entityState.isLoaded(JDBCCMP2xFieldBridge.this.tableIndex);
/*     */     }
/*     */ 
/*     */     public void setLoaded()
/*     */     {
/* 403 */       this.entityState.setLoaded(JDBCCMP2xFieldBridge.this.tableIndex);
/*     */     }
/*     */ 
/*     */     public boolean isDirty()
/*     */     {
/* 411 */       return (isLoaded()) && (!JDBCCMP2xFieldBridge.this.stateFactory.isStateValid(this.state, this.value));
/*     */     }
/*     */ 
/*     */     public boolean isValueChanged(Object newValue)
/*     */     {
/* 422 */       return newValue != null;
/*     */     }
/*     */ 
/*     */     public void setClean()
/*     */     {
/* 430 */       this.entityState.setClean(JDBCCMP2xFieldBridge.this.tableIndex);
/* 431 */       updateState(this.value);
/*     */     }
/*     */ 
/*     */     private void updateState(Object value)
/*     */     {
/* 443 */       this.state = JDBCCMP2xFieldBridge.this.stateFactory.getFieldState(value);
/* 444 */       this.lockedValue = value;
/*     */     }
/*     */ 
/*     */     public void reset()
/*     */     {
/* 452 */       this.value = null;
/* 453 */       this.state = null;
/* 454 */       this.lastRead = -1L;
/* 455 */       this.entityState.resetFlags(JDBCCMP2xFieldBridge.this.tableIndex);
/*     */     }
/*     */ 
/*     */     public void lockValue()
/*     */     {
/* 460 */       if (this.entityState.lockValue(JDBCCMP2xFieldBridge.this.tableIndex))
/*     */       {
/* 463 */         this.lockedValue = this.value;
/*     */       }
/*     */     }
/*     */ 
/*     */     public Object getLockedValue()
/*     */     {
/* 469 */       return this.lockedValue;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMP2xFieldBridge
 * JD-Core Version:    0.6.0
 */