/*     */ package org.jboss.ejb.plugins.cmp.jdbc.bridge;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import javax.ejb.EJBException;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.CMPFieldStateFactory;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCContext;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class JDBCCMP1xFieldBridge extends JDBCAbstractCMPFieldBridge
/*     */ {
/*     */   private Field field;
/*     */ 
/*     */   public JDBCCMP1xFieldBridge(JDBCStoreManager manager, JDBCCMPFieldMetaData metadata)
/*     */     throws DeploymentException
/*     */   {
/*  61 */     super(manager, metadata);
/*     */     try
/*     */     {
/*  65 */       this.field = manager.getMetaData().getEntityClass().getField(getFieldName());
/*     */     }
/*     */     catch (NoSuchFieldException e)
/*     */     {
/*  70 */       throw new DeploymentException("No field named '" + getFieldName() + "' found in entity class.");
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getInstanceValue(EntityEnterpriseContext ctx)
/*     */   {
/*  77 */     FieldState fieldState = getFieldState(ctx);
/*  78 */     if (!fieldState.isLoaded())
/*     */     {
/*  80 */       throw new EJBException("CMP 1.1 field not loaded: " + getFieldName());
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  85 */       return this.field.get(ctx.getInstance());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*  90 */     throw new EJBException("Internal error getting instance field " + getFieldName(), e);
/*     */   }
/*     */ 
/*     */   public void setInstanceValue(EntityEnterpriseContext ctx, Object value)
/*     */   {
/*     */     try
/*     */     {
/*  99 */       this.field.set(ctx.getInstance(), value);
/* 100 */       FieldState fieldState = getFieldState(ctx);
/* 101 */       fieldState.setLoaded();
/* 102 */       fieldState.setCheckDirty();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 107 */       throw new EJBException("Internal error setting instance field " + getFieldName(), e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getLockedValue(EntityEnterpriseContext ctx)
/*     */   {
/* 114 */     throw new UnsupportedOperationException("Optimistic locking is not supported in CMP1.1.");
/*     */   }
/*     */ 
/*     */   public void lockInstanceValue(EntityEnterpriseContext ctx)
/*     */   {
/*     */   }
/*     */ 
/*     */   public boolean isLoaded(EntityEnterpriseContext ctx)
/*     */   {
/* 124 */     return getFieldState(ctx).isLoaded();
/*     */   }
/*     */ 
/*     */   public boolean isDirty(EntityEnterpriseContext ctx)
/*     */   {
/* 133 */     if ((isReadOnly()) || (isPrimaryKeyMember()))
/*     */     {
/* 135 */       return false;
/*     */     }
/*     */ 
/* 139 */     return (isLoaded(ctx)) && (!this.stateFactory.isStateValid(getInstanceValue(ctx), getFieldState(ctx).originalValue));
/*     */   }
/*     */ 
/*     */   public void setClean(EntityEnterpriseContext ctx)
/*     */   {
/* 149 */     FieldState fieldState = getFieldState(ctx);
/* 150 */     FieldState.access$002(fieldState, getInstanceValue(ctx));
/*     */ 
/* 153 */     if (isReadOnly())
/*     */     {
/* 155 */       FieldState.access$102(fieldState, System.currentTimeMillis());
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isReadTimedOut(EntityEnterpriseContext ctx)
/*     */   {
/* 162 */     if (!isReadOnly())
/*     */     {
/* 164 */       return true;
/*     */     }
/*     */ 
/* 168 */     if (getReadTimeOut() == -1L)
/*     */     {
/* 170 */       return false;
/*     */     }
/*     */ 
/* 173 */     long readInterval = System.currentTimeMillis() - getFieldState(ctx).lastRead;
/*     */ 
/* 175 */     return readInterval >= getReadTimeOut();
/*     */   }
/*     */ 
/*     */   public void resetPersistenceContext(EntityEnterpriseContext ctx)
/*     */   {
/* 180 */     if (isReadTimedOut(ctx))
/*     */     {
/* 182 */       JDBCContext jdbcCtx = (JDBCContext)ctx.getPersistenceContext();
/* 183 */       FieldState fieldState = (FieldState)jdbcCtx.getFieldState(this.jdbcContextIndex);
/* 184 */       if (fieldState != null)
/* 185 */         fieldState.reset();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void setDirtyAfterGet(EntityEnterpriseContext ctx)
/*     */   {
/* 191 */     getFieldState(ctx).setCheckDirty();
/*     */   }
/*     */ 
/*     */   private FieldState getFieldState(EntityEnterpriseContext ctx)
/*     */   {
/* 196 */     JDBCContext jdbcCtx = (JDBCContext)ctx.getPersistenceContext();
/* 197 */     FieldState fieldState = (FieldState)jdbcCtx.getFieldState(this.jdbcContextIndex);
/* 198 */     if (fieldState == null)
/*     */     {
/* 200 */       fieldState = new FieldState(jdbcCtx);
/* 201 */       jdbcCtx.setFieldState(this.jdbcContextIndex, fieldState);
/*     */     }
/* 203 */     return fieldState;
/*     */   }
/*     */   private class FieldState {
/*     */     private Object originalValue;
/* 209 */     private long lastRead = -1L;
/*     */     private JDBCEntityBridge.EntityState entityState;
/*     */ 
/*     */     public FieldState(JDBCContext jdbcContext) {
/* 214 */       this.entityState = jdbcContext.getEntityState();
/*     */     }
/*     */ 
/*     */     public boolean isLoaded()
/*     */     {
/* 219 */       return this.entityState.isLoaded(JDBCCMP1xFieldBridge.this.tableIndex);
/*     */     }
/*     */ 
/*     */     public void setLoaded()
/*     */     {
/* 224 */       this.entityState.setLoaded(JDBCCMP1xFieldBridge.this.tableIndex);
/*     */     }
/*     */ 
/*     */     public void setCheckDirty()
/*     */     {
/* 229 */       this.entityState.setCheckDirty(JDBCCMP1xFieldBridge.this.tableIndex);
/*     */     }
/*     */ 
/*     */     public void reset()
/*     */     {
/* 234 */       this.originalValue = null;
/* 235 */       this.lastRead = -1L;
/* 236 */       this.entityState.resetFlags(JDBCCMP1xFieldBridge.this.tableIndex);
/* 237 */       JDBCCMP1xFieldBridge.this.log.debug("reset field state");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMP1xFieldBridge
 * JD-Core Version:    0.6.0
 */