/*     */ package org.jboss.ejb.plugins.cmp.jdbc.bridge;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import javax.ejb.EJBException;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.CMPFieldStateFactory;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCEntityPersistenceStore;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCParameterSetter;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCResultSetReader;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCType;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCTypeFactory;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.LockingStrategy;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class JDBCAbstractCMPFieldBridge
/*     */   implements JDBCCMPFieldBridge
/*     */ {
/*     */   protected final Logger log;
/*     */   protected final JDBCStoreManager manager;
/*     */   private final JDBCType jdbcType;
/*     */   protected final String fieldName;
/*     */   private final Class fieldType;
/*     */   protected final boolean readOnly;
/*     */   protected final long readTimeOut;
/*     */   protected final boolean primaryKeyMember;
/*     */   private final Class primaryKeyClass;
/*     */   private final Field primaryKeyField;
/*     */   protected final int jdbcContextIndex;
/*     */   protected final int tableIndex;
/*     */   protected CMPFieldStateFactory stateFactory;
/*     */   protected boolean checkDirtyAfterGet;
/*  89 */   protected byte defaultFlags = 0;
/*     */ 
/*  91 */   private LockingStrategy lockingStrategy = LockingStrategy.NONE;
/*     */ 
/*     */   public JDBCAbstractCMPFieldBridge(JDBCStoreManager manager, JDBCCMPFieldMetaData metadata)
/*     */     throws DeploymentException
/*     */   {
/*  97 */     this(manager, metadata, manager.getJDBCTypeFactory().getJDBCType(metadata));
/*     */   }
/*     */ 
/*     */   public JDBCAbstractCMPFieldBridge(JDBCStoreManager manager, JDBCCMPFieldMetaData metadata, JDBCType jdbcType)
/*     */     throws DeploymentException
/*     */   {
/* 105 */     this.manager = manager;
/* 106 */     this.fieldName = metadata.getFieldName();
/* 107 */     this.fieldType = metadata.getFieldType();
/* 108 */     this.jdbcType = jdbcType;
/* 109 */     this.readOnly = metadata.isReadOnly();
/* 110 */     this.readTimeOut = metadata.getReadTimeOut();
/* 111 */     this.primaryKeyMember = metadata.isPrimaryKeyMember();
/* 112 */     this.primaryKeyClass = metadata.getEntity().getPrimaryKeyClass();
/* 113 */     this.primaryKeyField = metadata.getPrimaryKeyField();
/*     */ 
/* 115 */     JDBCEntityBridge entityBridge = (JDBCEntityBridge)manager.getEntityBridge();
/* 116 */     this.jdbcContextIndex = entityBridge.getNextJDBCContextIndex();
/*     */ 
/* 118 */     if (!metadata.isRelationTableField())
/* 119 */       this.tableIndex = entityBridge.addTableField(this);
/*     */     else {
/* 121 */       this.tableIndex = -1;
/*     */     }
/* 123 */     JDBCTypeFactory typeFactory = manager.getJDBCTypeFactory();
/* 124 */     this.stateFactory = JDBCTypeFactory.getCMPFieldStateFactory(typeFactory, metadata.getStateFactory(), this.fieldType);
/*     */ 
/* 127 */     this.checkDirtyAfterGet = JDBCTypeFactory.checkDirtyAfterGet(typeFactory, metadata.getCheckDirtyAfterGet(), this.fieldType);
/*     */ 
/* 131 */     this.log = createLogger(manager, this.fieldName);
/*     */   }
/*     */ 
/*     */   public JDBCAbstractCMPFieldBridge(JDBCStoreManager manager, String fieldName, Class fieldType, JDBCType jdbcType, boolean readOnly, long readTimeOut, Class primaryKeyClass, Field primaryKeyField, int jdbcContextIndex, int tableIndex, boolean checkDirtyAfterGet, CMPFieldStateFactory stateFactory)
/*     */   {
/* 147 */     this.manager = manager;
/* 148 */     this.fieldName = fieldName;
/* 149 */     this.fieldType = fieldType;
/* 150 */     this.jdbcType = jdbcType;
/* 151 */     this.readOnly = readOnly;
/* 152 */     this.readTimeOut = readTimeOut;
/* 153 */     this.primaryKeyMember = false;
/* 154 */     this.primaryKeyClass = primaryKeyClass;
/* 155 */     this.primaryKeyField = primaryKeyField;
/* 156 */     this.jdbcContextIndex = jdbcContextIndex;
/* 157 */     this.tableIndex = tableIndex;
/* 158 */     this.stateFactory = stateFactory;
/* 159 */     this.checkDirtyAfterGet = checkDirtyAfterGet;
/* 160 */     this.log = createLogger(manager, fieldName);
/*     */   }
/*     */ 
/*     */   public byte getDefaultFlags()
/*     */   {
/* 165 */     return this.defaultFlags;
/*     */   }
/*     */ 
/*     */   public void addDefaultFlag(byte flag)
/*     */   {
/* 171 */     this.defaultFlags = (byte)(this.defaultFlags | flag);
/*     */   }
/*     */ 
/*     */   public JDBCEntityPersistenceStore getManager()
/*     */   {
/* 176 */     return this.manager;
/*     */   }
/*     */ 
/*     */   public String getFieldName()
/*     */   {
/* 181 */     return this.fieldName;
/*     */   }
/*     */ 
/*     */   public JDBCType getJDBCType()
/*     */   {
/* 186 */     return this.jdbcType;
/*     */   }
/*     */ 
/*     */   public Class getFieldType()
/*     */   {
/* 191 */     return this.fieldType;
/*     */   }
/*     */ 
/*     */   public boolean isPrimaryKeyMember()
/*     */   {
/* 196 */     return this.primaryKeyMember;
/*     */   }
/*     */ 
/*     */   public Field getPrimaryKeyField()
/*     */   {
/* 201 */     return this.primaryKeyField;
/*     */   }
/*     */ 
/*     */   public boolean isReadOnly()
/*     */   {
/* 206 */     return this.readOnly;
/*     */   }
/*     */ 
/*     */   public long getReadTimeOut()
/*     */   {
/* 211 */     return this.readTimeOut;
/*     */   }
/*     */ 
/*     */   public Object getValue(EntityEnterpriseContext ctx)
/*     */   {
/* 216 */     Object value = getInstanceValue(ctx);
/* 217 */     if (ctx.isValid())
/*     */     {
/* 219 */       this.lockingStrategy.accessed(this, ctx);
/* 220 */       if (this.checkDirtyAfterGet)
/*     */       {
/* 222 */         setDirtyAfterGet(ctx);
/*     */       }
/*     */     }
/* 225 */     return value;
/*     */   }
/*     */ 
/*     */   public void setValue(EntityEnterpriseContext ctx, Object value)
/*     */   {
/* 230 */     if (isReadOnly())
/*     */     {
/* 232 */       throw new EJBException("Field is read-only: fieldName=" + this.fieldName);
/*     */     }
/* 234 */     if ((this.primaryKeyMember) && (JDBCEntityBridge.isEjbCreateDone(ctx)))
/*     */     {
/* 236 */       throw new IllegalStateException("A CMP field that is a member of the primary key can only be set in ejbCreate [EJB 2.0 Spec. 10.3.5].");
/*     */     }
/*     */ 
/* 241 */     if (ctx.isValid())
/*     */     {
/* 243 */       if (!isLoaded(ctx))
/*     */       {
/* 246 */         this.manager.loadField(this, ctx);
/*     */       }
/* 248 */       this.lockingStrategy.changed(this, ctx);
/*     */     }
/* 250 */     setInstanceValue(ctx, value);
/*     */   }
/*     */ 
/*     */   public Object getPrimaryKeyValue(Object primaryKey)
/*     */     throws IllegalArgumentException
/*     */   {
/*     */     try
/*     */     {
/* 258 */       if (this.primaryKeyField != null)
/*     */       {
/* 260 */         if (primaryKey == null)
/*     */         {
/* 262 */           return null;
/*     */         }
/*     */ 
/* 266 */         return this.primaryKeyField.get(primaryKey);
/*     */       }
/*     */ 
/* 271 */       return primaryKey;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*     */ 
/* 277 */     throw new EJBException("Internal error getting primary key field member " + getFieldName(), e);
/*     */   }
/*     */ 
/*     */   public Object setPrimaryKeyValue(Object primaryKey, Object value)
/*     */     throws IllegalArgumentException
/*     */   {
/*     */     try
/*     */     {
/* 287 */       if (this.primaryKeyField != null)
/*     */       {
/* 291 */         if ((value == null) && (primaryKey == null))
/*     */         {
/* 293 */           return null;
/*     */         }
/*     */ 
/* 297 */         if (primaryKey == null)
/*     */         {
/* 299 */           primaryKey = this.primaryKeyClass.newInstance();
/*     */         }
/*     */ 
/* 303 */         this.primaryKeyField.set(primaryKey, value);
/* 304 */         return primaryKey;
/*     */       }
/*     */ 
/* 309 */       return value;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*     */ 
/* 315 */     throw new EJBException("Internal error setting instance field " + getFieldName(), e);
/*     */   }
/*     */ 
/*     */   public abstract void resetPersistenceContext(EntityEnterpriseContext paramEntityEnterpriseContext);
/*     */ 
/*     */   public void initInstance(EntityEnterpriseContext ctx)
/*     */   {
/* 327 */     if (!this.readOnly)
/*     */     {
/*     */       Object value;
/*     */       Object value;
/* 330 */       if (this.fieldType == Boolean.TYPE) {
/* 331 */         value = Boolean.FALSE;
/*     */       }
/*     */       else
/*     */       {
/*     */         Object value;
/* 332 */         if (this.fieldType == Byte.TYPE) {
/* 333 */           value = new Byte(0);
/*     */         }
/*     */         else
/*     */         {
/*     */           Object value;
/* 334 */           if (this.fieldType == Integer.TYPE) {
/* 335 */             value = new Integer(0);
/*     */           }
/*     */           else
/*     */           {
/*     */             Object value;
/* 336 */             if (this.fieldType == Long.TYPE) {
/* 337 */               value = new Long(0L);
/*     */             }
/*     */             else
/*     */             {
/*     */               Object value;
/* 338 */               if (this.fieldType == Short.TYPE) {
/* 339 */                 value = new Short(0);
/*     */               }
/*     */               else
/*     */               {
/*     */                 Object value;
/* 340 */                 if (this.fieldType == Character.TYPE) {
/* 341 */                   value = new Character('\000');
/*     */                 }
/*     */                 else
/*     */                 {
/*     */                   Object value;
/* 342 */                   if (this.fieldType == Double.TYPE) {
/* 343 */                     value = new Double(0.0D);
/*     */                   }
/*     */                   else
/*     */                   {
/*     */                     Object value;
/* 344 */                     if (this.fieldType == Float.TYPE)
/* 345 */                       value = new Float(0.0F);
/*     */                     else
/* 347 */                       value = null; 
/*     */                   }
/*     */                 }
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/* 348 */       setInstanceValue(ctx, value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int setInstanceParameters(PreparedStatement ps, int parameterIndex, EntityEnterpriseContext ctx)
/*     */   {
/* 354 */     Object instanceValue = getInstanceValue(ctx);
/* 355 */     return setArgumentParameters(ps, parameterIndex, instanceValue);
/*     */   }
/*     */ 
/*     */   public int setPrimaryKeyParameters(PreparedStatement ps, int parameterIndex, Object primaryKey)
/*     */     throws IllegalArgumentException
/*     */   {
/* 361 */     Object primaryKeyValue = getPrimaryKeyValue(primaryKey);
/* 362 */     return setArgumentParameters(ps, parameterIndex, primaryKeyValue);
/*     */   }
/*     */ 
/*     */   public int setArgumentParameters(PreparedStatement ps, int parameterIndex, Object arg)
/*     */   {
/*     */     try
/*     */     {
/* 369 */       int[] jdbcTypes = this.jdbcType.getJDBCTypes();
/* 370 */       for (int i = 0; i < jdbcTypes.length; i++)
/*     */       {
/* 372 */         Object columnValue = this.jdbcType.getColumnValue(i, arg);
/* 373 */         this.jdbcType.getParameterSetter()[i].set(ps, parameterIndex++, jdbcTypes[i], columnValue, this.log);
/*     */       }
/*     */ 
/* 376 */       return parameterIndex;
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/*     */     }
/* 381 */     throw new EJBException("Internal error setting parameters for field " + getFieldName(), e);
/*     */   }
/*     */ 
/*     */   public int loadInstanceResults(ResultSet rs, int parameterIndex, EntityEnterpriseContext ctx)
/*     */   {
/*     */     try
/*     */     {
/* 390 */       Object[] argumentRef = new Object[1];
/*     */ 
/* 393 */       parameterIndex = loadArgumentResults(rs, parameterIndex, argumentRef);
/*     */ 
/* 396 */       setInstanceValue(ctx, argumentRef[0]);
/*     */ 
/* 398 */       this.lockingStrategy.loaded(this, ctx);
/*     */ 
/* 400 */       return parameterIndex;
/*     */     }
/*     */     catch (EJBException e)
/*     */     {
/* 405 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/* 410 */     throw new EJBException("Internal error getting results for field " + getFieldName(), e);
/*     */   }
/*     */ 
/*     */   public int loadPrimaryKeyResults(ResultSet rs, int parameterIndex, Object[] pkRef)
/*     */     throws IllegalArgumentException
/*     */   {
/* 418 */     Object[] argumentRef = new Object[1];
/*     */ 
/* 420 */     parameterIndex = loadArgumentResults(rs, parameterIndex, argumentRef, true);
/*     */ 
/* 423 */     pkRef[0] = (argumentRef[0] == null ? null : setPrimaryKeyValue(pkRef[0], argumentRef[0]));
/*     */ 
/* 426 */     return parameterIndex;
/*     */   }
/*     */ 
/*     */   public int loadArgumentResults(ResultSet rs, int parameterIndex, Object[] argumentRef)
/*     */     throws IllegalArgumentException
/*     */   {
/* 432 */     return loadArgumentResults(rs, parameterIndex, argumentRef, false);
/*     */   }
/*     */ 
/*     */   public boolean isRelationTableField()
/*     */   {
/* 437 */     return this.tableIndex < 0;
/*     */   }
/*     */ 
/*     */   public final int getFieldIndex()
/*     */   {
/* 442 */     return this.jdbcContextIndex;
/*     */   }
/*     */ 
/*     */   public Class getPrimaryKeyClass()
/*     */   {
/* 447 */     return this.primaryKeyClass;
/*     */   }
/*     */ 
/*     */   public int getTableIndex()
/*     */   {
/* 453 */     return this.tableIndex;
/*     */   }
/*     */ 
/*     */   public void setLockingStrategy(LockingStrategy lockingStrategy)
/*     */   {
/* 458 */     this.lockingStrategy = lockingStrategy;
/*     */   }
/*     */ 
/*     */   protected abstract void setDirtyAfterGet(EntityEnterpriseContext paramEntityEnterpriseContext);
/*     */ 
/*     */   public boolean isCMPField() {
/* 465 */     return true;
/*     */   }
/*     */ 
/*     */   private int loadArgumentResults(ResultSet rs, int parameterIndex, Object[] argumentRef, boolean nullColumnNullifiesResult)
/*     */     throws IllegalArgumentException
/*     */   {
/*     */     try
/*     */     {
/* 475 */       argumentRef[0] = null;
/*     */ 
/* 478 */       Class[] javaTypes = this.jdbcType.getJavaTypes();
/* 479 */       JDBCResultSetReader[] rsReaders = this.jdbcType.getResultSetReaders();
/* 480 */       for (int i = 0; i < javaTypes.length; i++)
/*     */       {
/* 482 */         Object columnValue = rsReaders[i].get(rs, parameterIndex++, javaTypes[i], this.log);
/* 483 */         if ((nullColumnNullifiesResult) && (columnValue == null))
/*     */         {
/* 485 */           argumentRef[0] = null;
/* 486 */           parameterIndex += javaTypes.length - i - 1;
/* 487 */           break;
/*     */         }
/* 489 */         argumentRef[0] = this.jdbcType.setColumnValue(i, argumentRef[0], columnValue);
/*     */       }
/*     */ 
/* 493 */       return parameterIndex;
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/*     */     }
/* 498 */     throw new EJBException("Internal error getting results for field member " + getFieldName(), e);
/*     */   }
/*     */ 
/*     */   private Logger createLogger(JDBCStoreManager manager, String fieldName)
/*     */   {
/* 505 */     return Logger.getLogger(getClass().getName() + "." + manager.getMetaData().getName() + "#" + fieldName);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractCMPFieldBridge
 * JD-Core Version:    0.6.0
 */