/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ 
/*     */ abstract interface TCLAction
/*     */ {
/*  61 */   public static final TCLAction NON_PRIVILEGED = new TCLAction()
/*     */   {
/*     */     public ClassLoader getContextClassLoader()
/*     */     {
/*  65 */       return Thread.currentThread().getContextClassLoader();
/*     */     }
/*     */ 
/*     */     public ClassLoader getContextClassLoader(Thread thread)
/*     */     {
/*  70 */       return thread.getContextClassLoader();
/*     */     }
/*     */ 
/*     */     public void setContextClassLoader(ClassLoader cl)
/*     */     {
/*  75 */       Thread.currentThread().setContextClassLoader(cl);
/*     */     }
/*     */ 
/*     */     public void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */     {
/*  80 */       thread.setContextClassLoader(cl);
/*     */     }
/*  61 */   };
/*     */ 
/*  84 */   public static final TCLAction PRIVILEGED = new TCLAction()
/*     */   {
/*  86 */     private final PrivilegedAction getTCLPrivilegedAction = new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/*  90 */         return Thread.currentThread().getContextClassLoader();
/*     */       }
/*  86 */     };
/*     */ 
/*     */     public ClassLoader getContextClassLoader()
/*     */     {
/*  96 */       return (ClassLoader)AccessController.doPrivileged(this.getTCLPrivilegedAction);
/*     */     }
/*     */ 
/*     */     public ClassLoader getContextClassLoader(Thread thread)
/*     */     {
/* 101 */       return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(thread)
/*     */       {
/*     */         public Object run()
/*     */         {
/* 105 */           return this.val$thread.getContextClassLoader();
/*     */         }
/*     */       });
/*     */     }
/*     */ 
/*     */     public void setContextClassLoader(ClassLoader cl) {
/* 112 */       AccessController.doPrivileged(new PrivilegedAction(cl)
/*     */       {
/*     */         public Object run()
/*     */         {
/* 117 */           Thread.currentThread().setContextClassLoader(this.val$cl);
/* 118 */           return null;
/*     */         }
/*     */       });
/*     */     }
/*     */ 
/*     */     public void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */     {
/* 126 */       AccessController.doPrivileged(new PrivilegedAction(thread, cl)
/*     */       {
/*     */         public Object run()
/*     */         {
/* 131 */           this.val$thread.setContextClassLoader(this.val$cl);
/* 132 */           return null;
/*     */         }
/*     */       });
/*     */     }
/*  84 */   };
/*     */ 
/*     */   public abstract ClassLoader getContextClassLoader();
/*     */ 
/*     */   public abstract ClassLoader getContextClassLoader(Thread paramThread);
/*     */ 
/*     */   public abstract void setContextClassLoader(ClassLoader paramClassLoader);
/*     */ 
/*     */   public abstract void setContextClassLoader(Thread paramThread, ClassLoader paramClassLoader);
/*     */ 
/*     */   public static class UTIL
/*     */   {
/*     */     static TCLAction getTCLAction()
/*     */     {
/*  37 */       return System.getSecurityManager() == null ? TCLAction.NON_PRIVILEGED : TCLAction.PRIVILEGED;
/*     */     }
/*     */ 
/*     */     static ClassLoader getContextClassLoader()
/*     */     {
/*  42 */       return getTCLAction().getContextClassLoader();
/*     */     }
/*     */ 
/*     */     static ClassLoader getContextClassLoader(Thread thread)
/*     */     {
/*  47 */       return getTCLAction().getContextClassLoader(thread);
/*     */     }
/*     */ 
/*     */     static void setContextClassLoader(ClassLoader cl)
/*     */     {
/*  52 */       getTCLAction().setContextClassLoader(cl);
/*     */     }
/*     */ 
/*     */     static void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */     {
/*  57 */       getTCLAction().setContextClassLoader(thread, cl);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.TCLAction
 * JD-Core Version:    0.6.0
 */