/*    */ package org.jboss.ejb.plugins.cmp.jdbc;
/*    */ 
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMRFieldBridge;
/*    */ 
/*    */ public final class RelationPair
/*    */ {
/*    */   private final JDBCCMRFieldBridge leftCMRField;
/*    */   private final JDBCCMRFieldBridge rightCMRField;
/*    */   private final Object leftId;
/*    */   private final Object rightId;
/*    */ 
/*    */   public RelationPair(JDBCCMRFieldBridge leftCMRField, Object leftId, JDBCCMRFieldBridge rightCMRField, Object rightId)
/*    */   {
/* 43 */     this.leftCMRField = leftCMRField;
/* 44 */     this.leftId = leftId;
/*    */ 
/* 46 */     this.rightCMRField = rightCMRField;
/* 47 */     this.rightId = rightId;
/*    */   }
/*    */ 
/*    */   public Object getLeftId() {
/* 51 */     return this.leftId;
/*    */   }
/*    */ 
/*    */   public Object getRightId() {
/* 55 */     return this.rightId;
/*    */   }
/*    */ 
/*    */   public boolean equals(Object obj) {
/* 59 */     if ((obj instanceof RelationPair)) {
/* 60 */       RelationPair pair = (RelationPair)obj;
/*    */ 
/* 63 */       if ((this.leftCMRField == pair.leftCMRField) && (this.rightCMRField == pair.rightCMRField) && (this.leftId.equals(pair.leftId)) && (this.rightId.equals(pair.rightId)))
/*    */       {
/* 67 */         return true;
/*    */       }
/*    */ 
/* 71 */       if ((this.leftCMRField == pair.rightCMRField) && (this.rightCMRField == pair.leftCMRField) && (this.leftId.equals(pair.rightId)) && (this.rightId.equals(pair.leftId)))
/*    */       {
/* 75 */         return true;
/*    */       }
/*    */     }
/* 78 */     return false;
/*    */   }
/*    */ 
/*    */   public int hashCode() {
/* 82 */     return this.leftId.hashCode() ^ this.rightId.hashCode();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.RelationPair
 * JD-Core Version:    0.6.0
 */