/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.io.Reader;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.math.BigDecimal;
/*     */ import java.math.BigInteger;
/*     */ import java.rmi.MarshalledObject;
/*     */ import java.rmi.RemoteException;
/*     */ import java.sql.CallableStatement;
/*     */ import java.sql.Connection;
/*     */ import java.sql.Ref;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Statement;
/*     */ import java.sql.Time;
/*     */ import java.sql.Timestamp;
/*     */ import java.sql.Types;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.Handle;
/*     */ import org.jboss.invocation.MarshalledValue;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public final class JDBCUtil
/*     */ {
/*  69 */   private static final Logger log = Logger.getLogger(JDBCUtil.class.getName());
/*     */   private static final Map jdbcTypeNames;
/*     */   private static final Map csTypes;
/*     */   private static final String SQL_ERROR = "SQL error";
/*     */   private static final String GET_TIMESTAMP = "getTimestamp";
/*     */   private static final String GET_DATE = "getDate";
/*     */   private static final String GET_TIME = "getTime";
/*     */   private static final String GET_BIGDECIMAL = "getBigDecimal";
/*     */   private static final String GET_REF = "getRef";
/*     */   private static final String GET_STRING = "getString";
/*     */   private static final String GET_BOOLEAN = "getBoolean";
/*     */   private static final String GET_BYTE = "getByte";
/*     */   private static final String GET_SHORT = "getShort";
/*     */   private static final String GET_INT = "getInt";
/*     */   private static final String GET_LONG = "getLong";
/*     */   private static final String GET_FLOAT = "getFloat";
/*     */   private static final String GET_DOUBLE = "getDouble";
/*     */   private static final String GET_BYTES = "getBytes";
/*     */ 
/*     */   public static void safeClose(Connection con)
/*     */   {
/*  73 */     if (con != null)
/*     */     {
/*     */       try
/*     */       {
/*  77 */         con.close();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*  81 */         log.error("SQL error", e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void safeClose(ResultSet rs)
/*     */   {
/*  88 */     if (rs != null)
/*     */     {
/*     */       try
/*     */       {
/*  92 */         rs.close();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*  96 */         log.error("SQL error", e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void safeClose(Statement statement)
/*     */   {
/* 103 */     if (statement != null)
/*     */     {
/*     */       try
/*     */       {
/* 107 */         statement.close();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 111 */         log.error("SQL error", e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void safeClose(InputStream in)
/*     */   {
/* 118 */     if (in != null)
/*     */     {
/*     */       try
/*     */       {
/* 122 */         in.close();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 126 */         log.error("SQL error", e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void safeClose(OutputStream out)
/*     */   {
/* 133 */     if (out != null)
/*     */     {
/*     */       try
/*     */       {
/* 137 */         out.close();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 141 */         log.error("SQL error", e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void safeClose(Reader reader)
/*     */   {
/* 148 */     if (reader != null)
/*     */     {
/*     */       try
/*     */       {
/* 152 */         reader.close();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 156 */         log.error("SQL error", e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static Object coerceToSQLType(int jdbcType, Object value)
/*     */   {
/* 171 */     if (value.getClass() == java.util.Date.class)
/*     */     {
/* 173 */       if (jdbcType == 91)
/*     */       {
/* 175 */         return new java.sql.Date(((java.util.Date)value).getTime());
/*     */       }
/* 177 */       if (jdbcType == 92)
/*     */       {
/* 179 */         return new Time(((java.util.Date)value).getTime());
/*     */       }
/* 181 */       if (jdbcType == 93)
/*     */       {
/* 183 */         return new Timestamp(((java.util.Date)value).getTime());
/*     */       }
/*     */     }
/* 186 */     else if ((value.getClass() == Character.class) && (jdbcType == 12))
/*     */     {
/* 188 */       value = value.toString();
/*     */     }
/* 190 */     return value;
/*     */   }
/*     */ 
/*     */   public static byte[] convertObjectToByteArray(Object value)
/*     */     throws SQLException
/*     */   {
/* 203 */     if ((value instanceof byte[]))
/*     */     {
/* 205 */       return (byte[])(byte[])value;
/*     */     }
/*     */ 
/* 208 */     ByteArrayOutputStream baos = null;
/* 209 */     ObjectOutputStream oos = null;
/*     */     try
/*     */     {
/* 213 */       if ((value instanceof EJBObject))
/*     */       {
/* 215 */         value = ((EJBObject)value).getHandle();
/*     */       }
/*     */ 
/* 219 */       value = new MarshalledValue(value);
/*     */ 
/* 222 */       baos = new ByteArrayOutputStream();
/* 223 */       oos = new ObjectOutputStream(baos);
/* 224 */       oos.writeObject(value);
/* 225 */       arrayOfByte = baos.toByteArray();
/*     */     }
/*     */     catch (RemoteException e)
/*     */     {
/*     */       byte[] arrayOfByte;
/* 229 */       throw new SQLException("Cannot get Handle of EJBObject: " + e);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 233 */       throw new SQLException("Can't serialize binary object: " + e);
/*     */     }
/*     */     finally
/*     */     {
/* 237 */       safeClose(oos);
/* 238 */       safeClose(baos);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static Object convertToObject(byte[] input)
/*     */     throws SQLException
/*     */   {
/* 251 */     ByteArrayInputStream bais = new ByteArrayInputStream(input);
/*     */     try
/*     */     {
/* 254 */       localObject1 = convertToObject(bais);
/*     */     }
/*     */     finally
/*     */     {
/*     */       Object localObject1;
/* 258 */       safeClose(bais);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static Object convertToObject(InputStream input)
/*     */     throws SQLException
/*     */   {
/* 272 */     Object value = null;
/* 273 */     if (input != null)
/*     */     {
/* 275 */       ObjectInputStream ois = null;
/*     */       try
/*     */       {
/* 279 */         ois = new ObjectInputStream(input);
/* 280 */         value = ois.readObject();
/*     */ 
/* 283 */         if ((value instanceof MarshalledValue))
/*     */         {
/* 285 */           value = ((MarshalledValue)value).get();
/*     */         }
/* 287 */         else if ((value instanceof MarshalledObject))
/*     */         {
/* 289 */           value = ((MarshalledObject)value).get();
/*     */         }
/*     */ 
/* 293 */         if ((value instanceof Handle))
/*     */         {
/* 295 */           value = ((Handle)value).getEJBObject();
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (RemoteException e)
/*     */       {
/* 301 */         throw new SQLException("Unable to load EJBObject back from Handle: " + e);
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 305 */         throw new SQLException("Unable to load to deserialize result: " + e);
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/* 309 */         throw new SQLException("Unable to load to deserialize result: " + e);
/*     */       }
/*     */       finally
/*     */       {
/* 314 */         safeClose(ois);
/*     */       }
/*     */     }
/* 317 */     return value;
/*     */   }
/*     */ 
/*     */   public static String getLongString(ResultSet rs, int index)
/*     */     throws SQLException
/*     */   {
/* 333 */     Reader textData = rs.getCharacterStream(index);
/*     */     String value;
/* 334 */     if (textData != null)
/*     */     {
/*     */       try
/*     */       {
/* 340 */         StringBuffer textBuffer = new StringBuffer();
/* 341 */         char[] tmpBuffer = new char[1000];
/*     */         int charsRead;
/* 343 */         while ((charsRead = textData.read(tmpBuffer)) != -1)
/* 344 */           textBuffer.append(tmpBuffer, 0, charsRead);
/* 345 */         value = textBuffer.toString();
/*     */       }
/*     */       catch (IOException ioException)
/*     */       {
/*     */         String value;
/* 349 */         throw new SQLException(ioException.getMessage());
/*     */       }
/*     */       finally
/*     */       {
/* 353 */         safeClose(textData);
/*     */       }
/*     */     }
/*     */     else
/* 357 */       value = null;
/* 358 */     return value;
/*     */   }
/*     */ 
/*     */   public static byte[] getByteArray(InputStream input)
/*     */     throws SQLException
/*     */   {
/* 374 */     ByteArrayOutputStream baos = new ByteArrayOutputStream();
/*     */     try
/*     */     {
/* 379 */       byte[] tmpBuffer = new byte[1000];
/*     */       int bytesRead;
/* 381 */       while ((bytesRead = input.read(tmpBuffer)) != -1)
/* 382 */         baos.write(tmpBuffer, 0, bytesRead);
/* 383 */       arrayOfByte1 = baos.toByteArray();
/*     */     }
/*     */     catch (IOException ioException)
/*     */     {
/*     */       byte[] arrayOfByte1;
/* 387 */       throw new SQLException(ioException.getMessage());
/*     */     }
/*     */     finally
/*     */     {
/* 391 */       safeClose(baos);
/* 392 */       safeClose(input);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static JDBCResultSetReader getResultSetReader(int jdbcType, Class destination)
/*     */   {
/*     */     JDBCResultSetReader reader;
/* 401 */     switch (jdbcType)
/*     */     {
/*     */     case 2005:
/* 404 */       reader = JDBCResultSetReader.CLOB_READER;
/* 405 */       break;
/*     */     case -1:
/* 407 */       reader = JDBCResultSetReader.LONGVARCHAR_READER;
/* 408 */       break;
/*     */     case -2:
/* 410 */       reader = JDBCResultSetReader.BINARY_READER;
/* 411 */       break;
/*     */     case -3:
/* 413 */       reader = JDBCResultSetReader.VARBINARY_READER;
/* 414 */       break;
/*     */     case 2004:
/* 416 */       reader = JDBCResultSetReader.BLOB_READER;
/* 417 */       break;
/*     */     case -4:
/* 419 */       reader = JDBCResultSetReader.LONGVARBINARY_READER;
/* 420 */       break;
/*     */     case 2000:
/* 422 */       reader = JDBCResultSetReader.JAVA_OBJECT_READER;
/* 423 */       break;
/*     */     case 2002:
/* 425 */       reader = JDBCResultSetReader.STRUCT_READER;
/* 426 */       break;
/*     */     case 2003:
/* 428 */       reader = JDBCResultSetReader.ARRAY_READER;
/* 429 */       break;
/*     */     case 1111:
/* 431 */       reader = JDBCResultSetReader.OTHER_READER;
/* 432 */       break;
/*     */     default:
/* 435 */       reader = getResultReaderByType(destination);
/*     */     }
/*     */ 
/* 438 */     return reader;
/*     */   }
/*     */ 
/*     */   public static JDBCResultSetReader getResultReaderByType(Class destination)
/*     */   {
/*     */     JDBCResultSetReader reader;
/*     */     JDBCResultSetReader reader;
/* 444 */     if (destination == java.util.Date.class)
/*     */     {
/* 446 */       reader = JDBCResultSetReader.JAVA_UTIL_DATE_READER;
/*     */     }
/*     */     else
/*     */     {
/*     */       JDBCResultSetReader reader;
/* 448 */       if (destination == java.sql.Date.class)
/*     */       {
/* 450 */         reader = JDBCResultSetReader.JAVA_SQL_DATE_READER;
/*     */       }
/*     */       else
/*     */       {
/*     */         JDBCResultSetReader reader;
/* 452 */         if (destination == Time.class)
/*     */         {
/* 454 */           reader = JDBCResultSetReader.JAVA_SQL_TIME_READER;
/*     */         }
/*     */         else
/*     */         {
/*     */           JDBCResultSetReader reader;
/* 456 */           if (destination == Timestamp.class)
/*     */           {
/* 458 */             reader = JDBCResultSetReader.JAVA_SQL_TIMESTAMP_READER;
/*     */           }
/*     */           else
/*     */           {
/*     */             JDBCResultSetReader reader;
/* 460 */             if (destination == BigDecimal.class)
/*     */             {
/* 462 */               reader = JDBCResultSetReader.BIGDECIMAL_READER;
/*     */             }
/*     */             else
/*     */             {
/*     */               JDBCResultSetReader reader;
/* 464 */               if (destination == Ref.class)
/*     */               {
/* 466 */                 reader = JDBCResultSetReader.REF_READER;
/*     */               }
/*     */               else
/*     */               {
/*     */                 JDBCResultSetReader reader;
/* 468 */                 if (destination == String.class)
/*     */                 {
/* 470 */                   reader = JDBCResultSetReader.STRING_READER;
/*     */                 }
/*     */                 else
/*     */                 {
/*     */                   JDBCResultSetReader reader;
/* 472 */                   if ((destination == Boolean.class) || (destination == Boolean.TYPE))
/*     */                   {
/* 474 */                     reader = JDBCResultSetReader.BOOLEAN_READER;
/*     */                   }
/*     */                   else
/*     */                   {
/*     */                     JDBCResultSetReader reader;
/* 476 */                     if ((destination == Byte.class) || (destination == Byte.TYPE))
/*     */                     {
/* 478 */                       reader = JDBCResultSetReader.BYTE_READER;
/*     */                     }
/*     */                     else
/*     */                     {
/*     */                       JDBCResultSetReader reader;
/* 480 */                       if ((destination == Character.class) || (destination == Character.TYPE))
/*     */                       {
/* 482 */                         reader = JDBCResultSetReader.CHARACTER_READER;
/*     */                       }
/*     */                       else
/*     */                       {
/*     */                         JDBCResultSetReader reader;
/* 484 */                         if ((destination == Short.class) || (destination == Short.TYPE))
/*     */                         {
/* 486 */                           reader = JDBCResultSetReader.SHORT_READER;
/*     */                         }
/*     */                         else
/*     */                         {
/*     */                           JDBCResultSetReader reader;
/* 488 */                           if ((destination == Integer.class) || (destination == Integer.TYPE))
/*     */                           {
/* 490 */                             reader = JDBCResultSetReader.INT_READER;
/*     */                           }
/*     */                           else
/*     */                           {
/*     */                             JDBCResultSetReader reader;
/* 492 */                             if ((destination == Long.class) || (destination == Long.TYPE))
/*     */                             {
/* 494 */                               reader = JDBCResultSetReader.LONG_READER;
/*     */                             }
/*     */                             else
/*     */                             {
/*     */                               JDBCResultSetReader reader;
/* 496 */                               if ((destination == Float.class) || (destination == Float.TYPE))
/*     */                               {
/* 498 */                                 reader = JDBCResultSetReader.FLOAT_READER;
/*     */                               }
/*     */                               else
/*     */                               {
/*     */                                 JDBCResultSetReader reader;
/* 500 */                                 if ((destination == Double.class) || (destination == Double.TYPE))
/*     */                                 {
/* 502 */                                   reader = JDBCResultSetReader.DOUBLE_READER;
/*     */                                 }
/*     */                                 else
/*     */                                 {
/* 506 */                                   reader = JDBCResultSetReader.OBJECT_READER;
/*     */                                 }
/*     */                               }
/*     */                             }
/*     */                           }
/*     */                         }
/*     */                       }
/*     */                     }
/*     */                   }
/*     */                 }
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 508 */     return reader;
/*     */   }
/*     */ 
/*     */   public static JDBCParameterSetter getParameterSetter(int jdbcType, Class javaType)
/*     */   {
/*     */     JDBCParameterSetter ps;
/* 515 */     switch (jdbcType)
/*     */     {
/*     */     case -1:
/*     */     case 2005:
/* 519 */       ps = JDBCParameterSetter.CLOB;
/* 520 */       break;
/*     */     case -3:
/*     */     case -2:
/* 524 */       ps = JDBCParameterSetter.BINARY;
/* 525 */       break;
/*     */     case -4:
/*     */     case 2004:
/* 529 */       ps = JDBCParameterSetter.BLOB;
/* 530 */       break;
/*     */     case 2:
/*     */     case 3:
/* 534 */       ps = JDBCParameterSetter.NUMERIC;
/* 535 */       break;
/*     */     case 1111:
/*     */     case 2000:
/*     */     case 2002:
/*     */     default:
/* 542 */       ps = JDBCParameterSetter.OBJECT;
/*     */     }
/*     */ 
/* 546 */     return ps;
/*     */   }
/*     */ 
/*     */   public static String getJDBCTypeName(int jdbcType)
/*     */   {
/* 567 */     return (String)jdbcTypeNames.get(new Integer(jdbcType));
/*     */   }
/*     */ 
/*     */   public static Object getParameter(Logger log, CallableStatement cs, int index, int jdbcType, Class destination)
/*     */     throws SQLException
/*     */   {
/* 707 */     Object value = null;
/* 708 */     switch (jdbcType)
/*     */     {
/*     */     case -4:
/*     */     case -1:
/*     */     case 2004:
/*     */     case 2005:
/* 717 */       throw new UnsupportedOperationException();
/*     */     case -3:
/*     */     case -2:
/* 725 */       byte[] bytes = cs.getBytes(index);
/* 726 */       if (!cs.wasNull())
/*     */       {
/* 728 */         if (destination == [B.class)
/* 729 */           value = bytes;
/*     */         else
/* 731 */           value = convertToObject(bytes);
/*     */       }
/* 733 */       if (log.isTraceEnabled())
/*     */       {
/* 735 */         log.trace("Get result: index=" + index + ", javaType=" + destination.getName() + ", Binary, value=" + value);
/*     */       }
/*     */ 
/* 740 */       break;
/*     */     case 1111:
/*     */     case 2000:
/*     */     case 2002:
/*     */     case 2003:
/* 751 */       value = cs.getObject(index);
/* 752 */       if (!log.isTraceEnabled())
/*     */         break;
/* 754 */       log.trace("Get result: index=" + index + ", javaType=" + destination.getName() + ", Object, value=" + value); break;
/*     */     default:
/* 765 */       Method method = (Method)csTypes.get(destination.getName());
/* 766 */       if (method != null)
/*     */       {
/*     */         try
/*     */         {
/* 770 */           value = method.invoke(cs, new Object[] { new Integer(index) });
/* 771 */           if (cs.wasNull())
/*     */           {
/* 773 */             value = null;
/*     */           }
/*     */ 
/* 776 */           if (log.isTraceEnabled())
/*     */           {
/* 778 */             log.trace("Get result: index=" + index + ", javaType=" + destination.getName() + ", Simple, value=" + value);
/*     */           }
/*     */ 
/*     */         }
/*     */         catch (IllegalAccessException e)
/*     */         {
/*     */         }
/*     */         catch (InvocationTargetException e)
/*     */         {
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 794 */         value = cs.getObject(index);
/* 795 */         if (!log.isTraceEnabled())
/*     */           break;
/* 797 */         log.trace("Get result: index=" + index + ", javaType=" + destination.getName() + ", Object, value=" + value);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 803 */     return coerceToJavaType(value, destination);
/*     */   }
/*     */ 
/*     */   private static Object coerceToJavaType(Object value, Class destination)
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 815 */       if (value == null)
/*     */       {
/* 817 */         return null;
/*     */       }
/*     */ 
/* 824 */       if (((value instanceof MarshalledObject)) && (!destination.equals(MarshalledObject.class)))
/*     */       {
/* 826 */         value = ((MarshalledObject)value).get();
/*     */       }
/*     */ 
/* 833 */       if ((value instanceof Handle))
/*     */       {
/* 835 */         value = ((Handle)value).getEJBObject();
/*     */       }
/*     */ 
/* 843 */       if (destination.isPrimitive())
/*     */       {
/* 845 */         if (value == null)
/* 846 */           throw new IllegalStateException("Loaded NULL value for a field of a primitive type.");
/* 847 */         if (((destination.equals(Byte.TYPE)) && ((value instanceof Byte))) || ((destination.equals(Short.TYPE)) && ((value instanceof Short))) || ((destination.equals(Character.TYPE)) && ((value instanceof Character))) || ((destination.equals(Boolean.TYPE)) && ((value instanceof Boolean))) || ((destination.equals(Integer.TYPE)) && ((value instanceof Integer))) || ((destination.equals(Long.TYPE)) && ((value instanceof Long))) || ((destination.equals(Float.TYPE)) && ((value instanceof Float))) || ((destination.equals(Double.TYPE)) && ((value instanceof Double))))
/*     */         {
/* 857 */           return value;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 865 */       if ((destination == java.util.Date.class) && ((value instanceof java.util.Date)))
/*     */       {
/* 868 */         if ((value instanceof Timestamp))
/*     */         {
/* 870 */           Timestamp ts = (Timestamp)value;
/*     */ 
/* 875 */           long temp = ts.getTime();
/* 876 */           if (temp % 1000L == 0L)
/* 877 */             temp += ts.getNanos() / 1000000;
/* 878 */           return new java.util.Date(temp);
/*     */         }
/*     */ 
/* 882 */         return new java.util.Date(((java.util.Date)value).getTime());
/*     */       }
/*     */ 
/* 890 */       if ((destination == Time.class) && ((value instanceof Time)))
/*     */       {
/* 892 */         return new Time(((Time)value).getTime());
/*     */       }
/*     */ 
/* 899 */       if ((destination == java.sql.Date.class) && ((value instanceof java.sql.Date)))
/*     */       {
/* 901 */         return new java.sql.Date(((java.sql.Date)value).getTime());
/*     */       }
/*     */ 
/* 908 */       if ((destination == Timestamp.class) && ((value instanceof Timestamp)))
/*     */       {
/* 912 */         Timestamp orignal = (Timestamp)value;
/* 913 */         Timestamp copy = new Timestamp(orignal.getTime());
/* 914 */         copy.setNanos(orignal.getNanos());
/* 915 */         return copy;
/*     */       }
/*     */ 
/* 922 */       if (((value instanceof String)) && ((destination == Character.class) || (destination == Character.TYPE)))
/*     */       {
/* 924 */         return new Character(((String)value).charAt(0));
/*     */       }
/*     */ 
/* 928 */       if (destination.isAssignableFrom(value.getClass()))
/*     */       {
/* 930 */         return value;
/*     */       }
/*     */ 
/* 933 */       if ((destination == BigInteger.class) && (value.getClass() == BigDecimal.class))
/*     */       {
/* 935 */         return ((BigDecimal)value).toBigInteger();
/*     */       }
/*     */ 
/* 939 */       throw new SQLException("Got a " + value.getClass().getName() + "[cl=" + System.identityHashCode(value.getClass().getClassLoader()) + ", value=" + value + "] while looking for a " + destination.getName() + "[cl=" + System.identityHashCode(destination) + "]");
/*     */     }
/*     */     catch (RemoteException e)
/*     */     {
/* 947 */       throw new SQLException("Unable to load EJBObject back from Handle: " + e);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 952 */       throw new SQLException("Unable to load to deserialize result: " + e);
/*     */     }
/*     */     catch (ClassNotFoundException e) {
/*     */     }
/* 956 */     throw new SQLException("Unable to load to deserialize result: " + e);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 588 */     Class[] arg = { Integer.TYPE };
/*     */ 
/* 593 */     csTypes = new HashMap();
/*     */     try
/*     */     {
/* 597 */       csTypes.put(java.util.Date.class.getName(), CallableStatement.class.getMethod("getTimestamp", arg));
/*     */ 
/* 600 */       csTypes.put(java.sql.Date.class.getName(), CallableStatement.class.getMethod("getDate", arg));
/*     */ 
/* 603 */       csTypes.put(Time.class.getName(), CallableStatement.class.getMethod("getTime", arg));
/*     */ 
/* 606 */       csTypes.put(Timestamp.class.getName(), CallableStatement.class.getMethod("getTimestamp", arg));
/*     */ 
/* 609 */       csTypes.put(BigDecimal.class.getName(), CallableStatement.class.getMethod("getBigDecimal", arg));
/*     */ 
/* 612 */       csTypes.put(Ref.class.getName(), CallableStatement.class.getMethod("getRef", arg));
/*     */ 
/* 615 */       csTypes.put(String.class.getName(), CallableStatement.class.getMethod("getString", arg));
/*     */ 
/* 618 */       csTypes.put(Boolean.class.getName(), CallableStatement.class.getMethod("getBoolean", arg));
/*     */ 
/* 621 */       csTypes.put(Boolean.TYPE.getName(), CallableStatement.class.getMethod("getBoolean", arg));
/*     */ 
/* 624 */       csTypes.put(Byte.class.getName(), CallableStatement.class.getMethod("getByte", arg));
/*     */ 
/* 627 */       csTypes.put(Byte.TYPE.getName(), CallableStatement.class.getMethod("getByte", arg));
/*     */ 
/* 630 */       csTypes.put(Character.class.getName(), CallableStatement.class.getMethod("getString", arg));
/*     */ 
/* 633 */       csTypes.put(Character.TYPE.getName(), CallableStatement.class.getMethod("getString", arg));
/*     */ 
/* 636 */       csTypes.put(Short.class.getName(), CallableStatement.class.getMethod("getShort", arg));
/*     */ 
/* 639 */       csTypes.put(Short.TYPE.getName(), CallableStatement.class.getMethod("getShort", arg));
/*     */ 
/* 642 */       csTypes.put(Integer.class.getName(), CallableStatement.class.getMethod("getInt", arg));
/*     */ 
/* 645 */       csTypes.put(Integer.TYPE.getName(), CallableStatement.class.getMethod("getInt", arg));
/*     */ 
/* 648 */       csTypes.put(Long.class.getName(), CallableStatement.class.getMethod("getLong", arg));
/*     */ 
/* 651 */       csTypes.put(Long.TYPE.getName(), CallableStatement.class.getMethod("getLong", arg));
/*     */ 
/* 654 */       csTypes.put(Float.class.getName(), CallableStatement.class.getMethod("getFloat", arg));
/*     */ 
/* 657 */       csTypes.put(Float.TYPE.getName(), CallableStatement.class.getMethod("getFloat", arg));
/*     */ 
/* 660 */       csTypes.put(Double.class.getName(), CallableStatement.class.getMethod("getDouble", arg));
/*     */ 
/* 663 */       csTypes.put(Double.TYPE.getName(), CallableStatement.class.getMethod("getDouble", arg));
/*     */ 
/* 666 */       csTypes.put("[B", CallableStatement.class.getMethod("getBytes", arg));
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/* 672 */       log.error("SQL error", e);
/*     */     }
/*     */ 
/* 677 */     jdbcTypeNames = new HashMap();
/* 678 */     Field[] fields = Types.class.getFields();
/* 679 */     for (int i = 0; i < fields.length; i++)
/*     */     {
/*     */       try
/*     */       {
/* 683 */         jdbcTypeNames.put(fields[i].get(null), fields[i].getName());
/*     */       }
/*     */       catch (IllegalAccessException e)
/*     */       {
/* 688 */         log.error("SQL error", e);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil
 * JD-Core Version:    0.6.0
 */