/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ public final class JDBCTypeSimple
/*     */   implements JDBCType
/*     */ {
/*     */   private final String[] columnNames;
/*     */   private final Class[] javaTypes;
/*     */   private final int[] jdbcTypes;
/*     */   private final String[] sqlTypes;
/*     */   private final boolean[] notNull;
/*     */   private final boolean[] autoIncrement;
/*     */   private final JDBCResultSetReader[] resultSetReader;
/*     */   private final JDBCParameterSetter[] paramSetter;
/*     */   private final Mapper mapper;
/*     */ 
/*     */   public JDBCTypeSimple(String columnName, Class javaType, int jdbcType, String sqlType, boolean notNull, boolean autoIncrement, Mapper mapper, JDBCParameterSetter paramSetter, JDBCResultSetReader resultReader)
/*     */   {
/*  59 */     this.columnNames = new String[] { columnName };
/*  60 */     this.javaTypes = new Class[] { javaType };
/*  61 */     this.jdbcTypes = new int[] { jdbcType };
/*  62 */     this.sqlTypes = new String[] { sqlType };
/*  63 */     this.notNull = new boolean[] { notNull };
/*  64 */     this.autoIncrement = new boolean[] { autoIncrement };
/*  65 */     this.mapper = mapper;
/*  66 */     this.resultSetReader = new JDBCResultSetReader[] { resultReader };
/*  67 */     this.paramSetter = new JDBCParameterSetter[] { paramSetter };
/*     */   }
/*     */ 
/*     */   public final String[] getColumnNames()
/*     */   {
/*  72 */     return this.columnNames;
/*     */   }
/*     */ 
/*     */   public final Class[] getJavaTypes()
/*     */   {
/*  77 */     return this.javaTypes;
/*     */   }
/*     */ 
/*     */   public final int[] getJDBCTypes()
/*     */   {
/*  82 */     return this.jdbcTypes;
/*     */   }
/*     */ 
/*     */   public final String[] getSQLTypes()
/*     */   {
/*  87 */     return this.sqlTypes;
/*     */   }
/*     */ 
/*     */   public final boolean[] getNotNull()
/*     */   {
/*  92 */     return this.notNull;
/*     */   }
/*     */ 
/*     */   public final boolean[] getAutoIncrement()
/*     */   {
/*  97 */     return this.autoIncrement;
/*     */   }
/*     */ 
/*     */   public final Object getColumnValue(int index, Object value)
/*     */   {
/* 102 */     if (index != 0)
/*     */     {
/* 104 */       throw new IndexOutOfBoundsException("JDBCSimpleType does not support an index>0.");
/*     */     }
/* 106 */     return this.mapper == null ? value : this.mapper.toColumnValue(value);
/*     */   }
/*     */ 
/*     */   public final Object setColumnValue(int index, Object value, Object columnValue)
/*     */   {
/* 111 */     if (index != 0)
/*     */     {
/* 113 */       throw new IndexOutOfBoundsException("JDBCSimpleType does not support an index>0.");
/*     */     }
/* 115 */     return this.mapper == null ? columnValue : this.mapper.toFieldValue(columnValue);
/*     */   }
/*     */ 
/*     */   public boolean hasMapper()
/*     */   {
/* 120 */     return this.mapper != null;
/*     */   }
/*     */ 
/*     */   public boolean isSearchable()
/*     */   {
/* 125 */     int jdbcType = this.jdbcTypes[0];
/* 126 */     return (jdbcType != -2) && (jdbcType != 2004) && (jdbcType != 2005) && (jdbcType != -4) && (jdbcType != -1) && (jdbcType != -3);
/*     */   }
/*     */ 
/*     */   public final JDBCResultSetReader[] getResultSetReaders()
/*     */   {
/* 136 */     return this.resultSetReader;
/*     */   }
/*     */ 
/*     */   public JDBCParameterSetter[] getParameterSetter()
/*     */   {
/* 141 */     return this.paramSetter;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCTypeSimple
 * JD-Core Version:    0.6.0
 */