/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ 
/*     */ public final class JDBCTypeComplexProperty
/*     */ {
/*     */   private final String propertyName;
/*     */   private final String columnName;
/*     */   private final Class javaType;
/*     */   private final int jdbcType;
/*     */   private final String sqlType;
/*     */   private final boolean notNull;
/*     */   private final JDBCResultSetReader resulSetReader;
/*     */   private final JDBCParameterSetter paramSetter;
/*     */   private final Method[] getters;
/*     */   private final Method[] setters;
/*     */ 
/*     */   public JDBCTypeComplexProperty(String propertyName, String columnName, Class javaType, int jdbcType, String sqlType, boolean notNull, Method[] getters, Method[] setters)
/*     */   {
/*  65 */     this.propertyName = propertyName;
/*  66 */     this.columnName = columnName;
/*  67 */     this.javaType = javaType;
/*  68 */     this.jdbcType = jdbcType;
/*  69 */     this.sqlType = sqlType;
/*  70 */     this.notNull = notNull;
/*  71 */     this.getters = getters;
/*  72 */     this.setters = setters;
/*  73 */     this.resulSetReader = JDBCUtil.getResultSetReader(jdbcType, javaType);
/*  74 */     this.paramSetter = JDBCUtil.getParameterSetter(jdbcType, javaType);
/*     */   }
/*     */ 
/*     */   public JDBCTypeComplexProperty(JDBCTypeComplexProperty defaultProperty, String columnName, int jdbcType, String sqlType, boolean notNull)
/*     */   {
/*  85 */     this.propertyName = defaultProperty.propertyName;
/*  86 */     this.columnName = columnName;
/*  87 */     this.javaType = defaultProperty.javaType;
/*  88 */     this.jdbcType = jdbcType;
/*  89 */     this.sqlType = sqlType;
/*  90 */     this.notNull = notNull;
/*  91 */     this.getters = defaultProperty.getters;
/*  92 */     this.setters = defaultProperty.setters;
/*  93 */     this.resulSetReader = JDBCUtil.getResultSetReader(jdbcType, this.javaType);
/*  94 */     this.paramSetter = JDBCUtil.getParameterSetter(jdbcType, this.javaType);
/*     */   }
/*     */ 
/*     */   public String getPropertyName()
/*     */   {
/*  99 */     return this.propertyName;
/*     */   }
/*     */ 
/*     */   public String getColumnName()
/*     */   {
/* 104 */     return this.columnName;
/*     */   }
/*     */ 
/*     */   public Class getJavaType()
/*     */   {
/* 109 */     return this.javaType;
/*     */   }
/*     */ 
/*     */   public int getJDBCType()
/*     */   {
/* 114 */     return this.jdbcType;
/*     */   }
/*     */ 
/*     */   public String getSQLType()
/*     */   {
/* 119 */     return this.sqlType;
/*     */   }
/*     */ 
/*     */   public boolean isNotNull()
/*     */   {
/* 124 */     return this.notNull;
/*     */   }
/*     */ 
/*     */   public JDBCResultSetReader getResulSetReader()
/*     */   {
/* 129 */     return this.resulSetReader;
/*     */   }
/*     */ 
/*     */   public JDBCParameterSetter getParameterSetter()
/*     */   {
/* 134 */     return this.paramSetter;
/*     */   }
/*     */ 
/*     */   public Object getColumnValue(Object value) throws Exception
/*     */   {
/* 139 */     Object[] noArgs = new Object[0];
/*     */ 
/* 141 */     for (int i = 0; i < this.getters.length; i++)
/*     */     {
/* 143 */       if (value == null)
/*     */       {
/* 145 */         return null;
/*     */       }
/* 147 */       value = this.getters[i].invoke(value, noArgs);
/*     */     }
/* 149 */     return value;
/*     */   }
/*     */ 
/*     */   public Object setColumnValue(Object value, Object columnValue)
/*     */     throws Exception
/*     */   {
/* 158 */     Object[] noArgs = new Object[0];
/* 159 */     Object[] singleArg = new Object[1];
/*     */ 
/* 162 */     Object returnValue = value;
/*     */ 
/* 165 */     for (int i = 0; i < this.getters.length - 1; i++)
/*     */     {
/* 168 */       Object next = this.getters[i].invoke(value, noArgs);
/*     */ 
/* 171 */       if (next == null)
/*     */       {
/* 174 */         next = this.getters[i].getReturnType().newInstance();
/*     */ 
/* 177 */         singleArg[0] = next;
/*     */ 
/* 179 */         this.setters[i].invoke(value, singleArg);
/*     */       }
/*     */ 
/* 183 */       value = next;
/*     */     }
/*     */ 
/* 187 */     singleArg[0] = columnValue;
/* 188 */     this.setters[(this.setters.length - 1)].invoke(value, singleArg);
/*     */ 
/* 191 */     return returnValue;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCTypeComplexProperty
 * JD-Core Version:    0.6.0
 */