/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.ejb.CreateException;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.FinderException;
/*     */ import javax.ejb.RemoveException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EjbModule;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.GenericEntityObjectFactory;
/*     */ import org.jboss.ejb.plugins.cmp.ejbql.Catalog;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMRFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMRFieldBridge.RelationDataManager;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCApplicationMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCXmlFileLoader;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.ApplicationMetaData;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.tm.TransactionLocal;
/*     */ 
/*     */ public final class JDBCStoreManager
/*     */   implements JDBCEntityPersistenceStore
/*     */ {
/*  82 */   private static final Object TX_DATA_KEY = "TX_DATA_KEY";
/*     */   private static final String CATALOG = "CATALOG";
/*     */   private static final String CREATED_MANAGERS = "CREATED_JDBCStoreManagers";
/*     */   private static final String CMP_JDBC = "CMP-JDBC";
/*     */   private EjbModule ejbModule;
/*     */   private EntityContainer container;
/*     */   private Logger log;
/*     */   private JDBCEntityMetaData metaData;
/*     */   private JDBCEntityBridge entityBridge;
/*     */   private JDBCTypeFactory typeFactory;
/*     */   private JDBCQueryManager queryManager;
/*     */   private JDBCCommandFactory commandFactory;
/*     */   private ReadAheadCache readAheadCache;
/*     */   private JDBCInitCommand initCommand;
/*     */   private JDBCStartCommand startCommand;
/*     */   private JDBCStopCommand stopCommand;
/*     */   private JDBCDestroyCommand destroyCommand;
/*     */   private JDBCCreateBeanClassInstanceCommand createBeanClassInstanceCommand;
/*     */   private JDBCInitEntityCommand initEntityCommand;
/*     */   private JDBCFindEntityCommand findEntityCommand;
/*     */   private JDBCFindEntitiesCommand findEntitiesCommand;
/*     */   private JDBCCreateCommand createEntityCommand;
/*     */   private JDBCPostCreateEntityCommand postCreateEntityCommand;
/*     */   private JDBCRemoveEntityCommand removeEntityCommand;
/*     */   private JDBCLoadEntityCommand loadEntityCommand;
/*     */   private JDBCIsModifiedCommand isModifiedCommand;
/*     */   private JDBCStoreEntityCommand storeEntityCommand;
/*     */   private JDBCActivateEntityCommand activateEntityCommand;
/*     */   private JDBCPassivateEntityCommand passivateEntityCommand;
/*     */   private JDBCLoadRelationCommand loadRelationCommand;
/*     */   private JDBCDeleteRelationsCommand deleteRelationsCommand;
/*     */   private JDBCInsertRelationsCommand insertRelationsCommand;
/*     */   private TransactionManager tm;
/*     */   private TransactionLocal txDataMap;
/*     */   private TransactionLocal cascadeDeleteSet;
/*     */ 
/*     */   public JDBCStoreManager()
/*     */   {
/* 133 */     this.cascadeDeleteSet = new TransactionLocal()
/*     */     {
/*     */       protected Object initialValue()
/*     */       {
/* 137 */         return new JDBCStoreManager.CascadeDeleteRegistry(JDBCStoreManager.this, null);
/*     */       }
/*     */     };
/*     */   }
/*     */ 
/*     */   public EntityContainer getContainer()
/*     */   {
/* 147 */     return this.container;
/*     */   }
/*     */ 
/*     */   public void setContainer(Container container)
/*     */   {
/* 158 */     this.container = ((EntityContainer)container);
/* 159 */     if (container != null)
/*     */     {
/* 161 */       this.ejbModule = container.getEjbModule();
/* 162 */       this.log = Logger.getLogger(getClass().getName() + "." + container.getBeanMetaData().getEjbName());
/*     */     }
/*     */     else
/*     */     {
/* 169 */       this.ejbModule = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public JDBCAbstractEntityBridge getEntityBridge()
/*     */   {
/* 175 */     return this.entityBridge;
/*     */   }
/*     */ 
/*     */   public JDBCTypeFactory getJDBCTypeFactory()
/*     */   {
/* 180 */     return this.typeFactory;
/*     */   }
/*     */ 
/*     */   public JDBCEntityMetaData getMetaData()
/*     */   {
/* 185 */     return this.metaData;
/*     */   }
/*     */ 
/*     */   public JDBCQueryManager getQueryManager()
/*     */   {
/* 190 */     return this.queryManager;
/*     */   }
/*     */ 
/*     */   public JDBCCommandFactory getCommandFactory()
/*     */   {
/* 195 */     return this.commandFactory;
/*     */   }
/*     */ 
/*     */   public ReadAheadCache getReadAheadCache()
/*     */   {
/* 200 */     return this.readAheadCache;
/*     */   }
/*     */ 
/*     */   public Map getApplicationDataMap()
/*     */   {
/* 208 */     return this.ejbModule.getModuleDataMap();
/*     */   }
/*     */ 
/*     */   public Object getApplicationData(Object key)
/*     */   {
/* 213 */     return this.ejbModule.getModuleData(key);
/*     */   }
/*     */ 
/*     */   public void putApplicationData(Object key, Object value)
/*     */   {
/* 218 */     this.ejbModule.putModuleData(key, value);
/*     */   }
/*     */ 
/*     */   private Map getApplicationTxDataMap()
/*     */   {
/*     */     try
/*     */     {
/* 225 */       Transaction tx = this.tm.getTransaction();
/* 226 */       if (tx == null)
/*     */       {
/* 228 */         return null;
/*     */       }
/*     */ 
/* 232 */       Map txMap = (Map)this.txDataMap.get(tx);
/*     */ 
/* 235 */       if (txMap == null)
/*     */       {
/* 237 */         int status = tx.getStatus();
/* 238 */         if ((status == 0) || (status == 7))
/*     */         {
/* 241 */           txMap = new HashMap();
/* 242 */           this.txDataMap.set(tx, txMap);
/*     */         }
/*     */       }
/* 245 */       return txMap;
/*     */     }
/*     */     catch (EJBException e)
/*     */     {
/* 249 */       throw e;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 253 */     throw new EJBException("Error getting application tx data map.", e);
/*     */   }
/*     */ 
/*     */   public void scheduleCascadeDelete(List pks)
/*     */   {
/* 262 */     CascadeDeleteRegistry registry = (CascadeDeleteRegistry)this.cascadeDeleteSet.get();
/* 263 */     registry.scheduleAll(pks);
/*     */   }
/*     */ 
/*     */   public boolean unscheduledCascadeDelete(Object pk)
/*     */   {
/* 273 */     CascadeDeleteRegistry registry = (CascadeDeleteRegistry)this.cascadeDeleteSet.get();
/* 274 */     return registry.unschedule(pk);
/*     */   }
/*     */ 
/*     */   public Object getApplicationTxData(Object key)
/*     */   {
/* 279 */     Map map = getApplicationTxDataMap();
/* 280 */     if (map != null)
/*     */     {
/* 282 */       return map.get(key);
/*     */     }
/* 284 */     return null;
/*     */   }
/*     */ 
/*     */   public void putApplicationTxData(Object key, Object value)
/*     */   {
/* 289 */     Map map = getApplicationTxDataMap();
/* 290 */     if (map != null)
/*     */     {
/* 292 */       map.put(key, value);
/*     */     }
/*     */   }
/*     */ 
/*     */   private Map getEntityTxDataMap()
/*     */   {
/* 298 */     Map entityTxDataMap = (Map)getApplicationTxData(this);
/* 299 */     if (entityTxDataMap == null)
/*     */     {
/* 301 */       entityTxDataMap = new HashMap();
/* 302 */       putApplicationTxData(this, entityTxDataMap);
/*     */     }
/* 304 */     return entityTxDataMap;
/*     */   }
/*     */ 
/*     */   public Object getEntityTxData(Object key)
/*     */   {
/* 309 */     return getEntityTxDataMap().get(key);
/*     */   }
/*     */ 
/*     */   public void putEntityTxData(Object key, Object value)
/*     */   {
/* 314 */     getEntityTxDataMap().put(key, value);
/*     */   }
/*     */ 
/*     */   public void removeEntityTxData(Object key)
/*     */   {
/* 319 */     getEntityTxDataMap().remove(key);
/*     */   }
/*     */ 
/*     */   public Catalog getCatalog()
/*     */   {
/* 324 */     return (Catalog)getApplicationData("CATALOG");
/*     */   }
/*     */ 
/*     */   private void initApplicationDataMap()
/*     */   {
/* 329 */     Map moduleData = this.ejbModule.getModuleDataMap();
/* 330 */     synchronized (moduleData)
/*     */     {
/* 332 */       this.txDataMap = ((TransactionLocal)moduleData.get(TX_DATA_KEY));
/* 333 */       if (this.txDataMap == null)
/*     */       {
/* 335 */         this.txDataMap = new TransactionLocal();
/* 336 */         moduleData.put(TX_DATA_KEY, this.txDataMap);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/* 350 */     HashMap managersMap = (HashMap)getApplicationData("CREATED_JDBCStoreManagers");
/* 351 */     if (managersMap == null)
/*     */     {
/* 353 */       managersMap = new HashMap();
/* 354 */       putApplicationData("CREATED_JDBCStoreManagers", managersMap);
/*     */     }
/* 356 */     managersMap.put(this.container.getBeanMetaData().getEjbName(), this);
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 368 */     initStoreManager();
/*     */ 
/* 373 */     Catalog catalog = getCatalog();
/* 374 */     HashMap managersMap = (HashMap)getApplicationData("CREATED_JDBCStoreManagers");
/* 375 */     if ((catalog.getEntityCount() == managersMap.size()) && (catalog.getEJBNames().equals(managersMap.keySet())))
/*     */     {
/* 379 */       ArrayList managers = new ArrayList(managersMap.values());
/*     */ 
/* 384 */       for (int i = 0; i < managers.size(); i++)
/*     */       {
/* 386 */         JDBCStoreManager manager = (JDBCStoreManager)managers.get(i);
/* 387 */         manager.resolveRelationships();
/*     */       }
/*     */ 
/* 393 */       for (int i = 0; i < managers.size(); i++)
/*     */       {
/* 395 */         JDBCStoreManager manager = (JDBCStoreManager)managers.get(i);
/* 396 */         manager.startStoreManager();
/*     */       }
/*     */ 
/* 400 */       for (int i = 0; i < managers.size(); i++)
/*     */       {
/* 402 */         JDBCStoreManager manager = (JDBCStoreManager)managers.get(i);
/* 403 */         manager.startCommand.addForeignKeyConstraints();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void initStoreManager()
/*     */     throws Exception
/*     */   {
/* 414 */     if (this.log.isDebugEnabled()) {
/* 415 */       this.log.debug("Initializing CMP plugin for " + this.container.getBeanMetaData().getEjbName());
/*     */     }
/*     */ 
/* 418 */     this.tm = this.container.getTransactionManager();
/*     */ 
/* 421 */     initApplicationDataMap();
/*     */ 
/* 424 */     this.metaData = loadJDBCEntityMetaData();
/*     */ 
/* 427 */     this.typeFactory = new JDBCTypeFactory(this.metaData.getTypeMapping(), this.metaData.getJDBCApplication().getValueClasses(), this.metaData.getJDBCApplication().getUserTypeMappings());
/*     */ 
/* 434 */     this.entityBridge = new JDBCEntityBridge(this.metaData, this);
/* 435 */     this.entityBridge.init();
/*     */ 
/* 438 */     Catalog catalog = getCatalog();
/* 439 */     if (catalog == null)
/*     */     {
/* 441 */       catalog = new Catalog();
/* 442 */       putApplicationData("CATALOG", catalog);
/*     */     }
/* 444 */     catalog.addEntity(this.entityBridge);
/*     */ 
/* 447 */     this.readAheadCache = new ReadAheadCache(this);
/* 448 */     this.readAheadCache.create();
/*     */ 
/* 451 */     this.commandFactory = new JDBCCommandFactory(this);
/*     */ 
/* 454 */     this.initCommand = this.commandFactory.createInitCommand();
/* 455 */     this.initCommand.execute();
/*     */   }
/*     */ 
/*     */   private void resolveRelationships() throws Exception
/*     */   {
/* 460 */     this.entityBridge.resolveRelationships();
/*     */   }
/*     */ 
/*     */   private void startStoreManager()
/*     */     throws Exception
/*     */   {
/* 469 */     this.entityBridge.start();
/*     */ 
/* 472 */     this.startCommand = this.commandFactory.createStartCommand();
/* 473 */     this.stopCommand = this.commandFactory.createStopCommand();
/* 474 */     this.destroyCommand = this.commandFactory.createDestroyCommand();
/*     */ 
/* 477 */     this.initEntityCommand = this.commandFactory.createInitEntityCommand();
/* 478 */     this.createBeanClassInstanceCommand = this.commandFactory.createCreateBeanClassInstanceCommand();
/* 479 */     this.findEntityCommand = this.commandFactory.createFindEntityCommand();
/* 480 */     this.findEntitiesCommand = this.commandFactory.createFindEntitiesCommand();
/* 481 */     this.createEntityCommand = this.commandFactory.createCreateEntityCommand();
/* 482 */     this.postCreateEntityCommand = this.commandFactory.createPostCreateEntityCommand();
/* 483 */     this.removeEntityCommand = this.commandFactory.createRemoveEntityCommand();
/* 484 */     this.loadEntityCommand = this.commandFactory.createLoadEntityCommand();
/* 485 */     this.isModifiedCommand = this.commandFactory.createIsModifiedCommand();
/* 486 */     this.storeEntityCommand = this.commandFactory.createStoreEntityCommand();
/* 487 */     this.activateEntityCommand = this.commandFactory.createActivateEntityCommand();
/* 488 */     this.passivateEntityCommand = this.commandFactory.createPassivateEntityCommand();
/*     */ 
/* 491 */     this.loadRelationCommand = this.commandFactory.createLoadRelationCommand();
/* 492 */     this.deleteRelationsCommand = this.commandFactory.createDeleteRelationsCommand();
/* 493 */     this.insertRelationsCommand = this.commandFactory.createInsertRelationsCommand();
/*     */ 
/* 496 */     this.queryManager = new JDBCQueryManager(this);
/*     */ 
/* 499 */     this.startCommand.execute();
/*     */ 
/* 505 */     this.queryManager.start();
/*     */ 
/* 507 */     this.readAheadCache.start();
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 513 */     if (this.stopCommand != null)
/*     */     {
/* 515 */       Map managersMap = (HashMap)getApplicationData("CREATED_JDBCStoreManagers");
/* 516 */       while (!managersMap.isEmpty())
/*     */       {
/* 518 */         int stoppedInIteration = 0;
/* 519 */         for (Iterator i = managersMap.values().iterator(); i.hasNext(); )
/*     */         {
/* 521 */           JDBCStoreManager manager = (JDBCStoreManager)i.next();
/* 522 */           if ((manager.stopCommand == null) || (manager.stopCommand.execute()))
/*     */           {
/* 524 */             i.remove();
/* 525 */             stoppedInIteration++;
/*     */           }
/*     */         }
/*     */ 
/* 529 */         if (stoppedInIteration == 0)
/*     */         {
/*     */           break;
/*     */         }
/*     */       }
/*     */     }
/* 535 */     this.readAheadCache.stop();
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/* 541 */     if (this.destroyCommand != null)
/*     */     {
/* 543 */       this.destroyCommand.execute();
/*     */     }
/*     */ 
/* 546 */     if (this.readAheadCache != null)
/*     */     {
/* 548 */       this.readAheadCache.destroy();
/*     */     }
/*     */ 
/* 551 */     this.readAheadCache = null;
/* 552 */     if (this.queryManager != null)
/*     */     {
/* 554 */       this.queryManager.clear();
/*     */     }
/* 556 */     this.queryManager = null;
/*     */ 
/* 558 */     if (this.createBeanClassInstanceCommand != null)
/*     */     {
/* 560 */       this.createBeanClassInstanceCommand.destroy();
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object createBeanClassInstance()
/*     */     throws Exception
/*     */   {
/* 574 */     if (this.createBeanClassInstanceCommand == null)
/* 575 */       throw new IllegalStateException("createBeanClassInstanceCommand == null");
/* 576 */     return this.createBeanClassInstanceCommand.execute();
/*     */   }
/*     */ 
/*     */   public void initEntity(EntityEnterpriseContext ctx)
/*     */   {
/* 581 */     this.initEntityCommand.execute(ctx);
/*     */   }
/*     */ 
/*     */   public Object createEntity(Method createMethod, Object[] args, EntityEnterpriseContext ctx)
/*     */     throws CreateException
/*     */   {
/* 587 */     Object pk = this.createEntityCommand.execute(createMethod, args, ctx);
/* 588 */     if (pk == null)
/* 589 */       throw new CreateException("Primary key for created instance is null.");
/* 590 */     return pk;
/*     */   }
/*     */ 
/*     */   public Object postCreateEntity(Method createMethod, Object[] args, EntityEnterpriseContext ctx)
/*     */   {
/* 595 */     return this.postCreateEntityCommand.execute(createMethod, args, ctx);
/*     */   }
/*     */ 
/*     */   public Object findEntity(Method finderMethod, Object[] args, EntityEnterpriseContext ctx, GenericEntityObjectFactory factory)
/*     */     throws FinderException
/*     */   {
/* 604 */     return this.findEntityCommand.execute(finderMethod, args, ctx, factory);
/*     */   }
/*     */ 
/*     */   public Collection findEntities(Method finderMethod, Object[] args, EntityEnterpriseContext ctx, GenericEntityObjectFactory factory)
/*     */     throws FinderException
/*     */   {
/* 613 */     return this.findEntitiesCommand.execute(finderMethod, args, ctx, factory);
/*     */   }
/*     */ 
/*     */   public void activateEntity(EntityEnterpriseContext ctx)
/*     */   {
/* 618 */     this.activateEntityCommand.execute(ctx);
/*     */   }
/*     */ 
/*     */   public void loadEntity(EntityEnterpriseContext ctx)
/*     */   {
/* 628 */     loadEntity(ctx, true);
/*     */   }
/*     */ 
/*     */   public boolean loadEntity(EntityEnterpriseContext ctx, boolean failIfNotFound)
/*     */   {
/* 634 */     if (!ctx.isValid())
/*     */     {
/* 636 */       if (this.log.isTraceEnabled())
/*     */       {
/* 638 */         this.log.trace("RESET PERSISTENCE CONTEXT: id=" + ctx.getId());
/*     */       }
/* 640 */       this.entityBridge.resetPersistenceContext(ctx);
/*     */     }
/*     */ 
/* 644 */     JDBCEntityBridge.setCreated(ctx);
/*     */ 
/* 646 */     return this.loadEntityCommand.execute(ctx, failIfNotFound);
/*     */   }
/*     */ 
/*     */   public void loadField(JDBCCMPFieldBridge field, EntityEnterpriseContext ctx)
/*     */   {
/* 651 */     this.loadEntityCommand.execute(field, ctx);
/*     */   }
/*     */ 
/*     */   public boolean isStoreRequired(EntityEnterpriseContext ctx)
/*     */   {
/* 656 */     return this.isModifiedCommand.execute(ctx);
/*     */   }
/*     */ 
/*     */   public boolean isModified(EntityEnterpriseContext ctx)
/*     */   {
/* 661 */     return this.entityBridge.isModified(ctx);
/*     */   }
/*     */ 
/*     */   public void storeEntity(EntityEnterpriseContext ctx)
/*     */   {
/* 666 */     this.storeEntityCommand.execute(ctx);
/* 667 */     synchronizeRelationData();
/*     */   }
/*     */ 
/*     */   private void synchronizeRelationData()
/*     */   {
/* 672 */     JDBCCMRFieldBridge[] cmrFields = (JDBCCMRFieldBridge[])(JDBCCMRFieldBridge[])this.entityBridge.getCMRFields();
/* 673 */     for (int i = 0; i < cmrFields.length; i++)
/*     */     {
/* 675 */       JDBCCMRFieldBridge.RelationDataManager relationManager = cmrFields[i].getRelationDataManager();
/* 676 */       if (!relationManager.isDirty())
/*     */         continue;
/* 678 */       RelationData relationData = relationManager.getRelationData();
/*     */ 
/* 680 */       deleteRelations(relationData);
/* 681 */       insertRelations(relationData);
/*     */ 
/* 683 */       relationData.addedRelations.clear();
/* 684 */       relationData.removedRelations.clear();
/* 685 */       relationData.notRelatedPairs.clear();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void passivateEntity(EntityEnterpriseContext ctx)
/*     */   {
/* 692 */     this.passivateEntityCommand.execute(ctx);
/*     */   }
/*     */ 
/*     */   public void removeEntity(EntityEnterpriseContext ctx) throws RemoveException, RemoteException
/*     */   {
/* 697 */     this.removeEntityCommand.execute(ctx);
/*     */   }
/*     */ 
/*     */   public Collection loadRelation(JDBCCMRFieldBridge cmrField, Object pk)
/*     */   {
/* 705 */     return this.loadRelationCommand.execute(cmrField, pk);
/*     */   }
/*     */ 
/*     */   private void deleteRelations(RelationData relationData)
/*     */   {
/* 710 */     this.deleteRelationsCommand.execute(relationData);
/*     */   }
/*     */ 
/*     */   private void insertRelations(RelationData relationData)
/*     */   {
/* 715 */     this.insertRelationsCommand.execute(relationData);
/*     */   }
/*     */ 
/*     */   private JDBCEntityMetaData loadJDBCEntityMetaData()
/*     */     throws DeploymentException
/*     */   {
/* 721 */     ApplicationMetaData amd = this.container.getBeanMetaData().getApplicationMetaData();
/*     */ 
/* 724 */     JDBCApplicationMetaData jamd = (JDBCApplicationMetaData)amd.getPluginData("CMP-JDBC");
/*     */ 
/* 726 */     if (jamd == null)
/*     */     {
/* 730 */       JDBCXmlFileLoader jfl = new JDBCXmlFileLoader(this.container, this.log);
/*     */ 
/* 732 */       jamd = jfl.load();
/* 733 */       amd.addPluginData("CMP-JDBC", jamd);
/*     */     }
/*     */ 
/* 737 */     String ejbName = this.container.getBeanMetaData().getEjbName();
/* 738 */     JDBCEntityMetaData metadata = jamd.getBeanByEjbName(ejbName);
/* 739 */     if (metadata == null)
/*     */     {
/* 741 */       throw new DeploymentException("No metadata found for bean " + ejbName);
/*     */     }
/* 743 */     return metadata;
/*     */   }
/*     */ 
/*     */   private final class CascadeDeleteRegistry {
/*     */     private Set scheduled;
/*     */ 
/*     */     private CascadeDeleteRegistry() {
/*     */     }
/*     */ 
/*     */     public void scheduleAll(List pks) {
/* 754 */       if (this.scheduled == null)
/*     */       {
/* 756 */         this.scheduled = new HashSet();
/*     */       }
/* 758 */       this.scheduled.addAll(pks);
/*     */     }
/*     */ 
/*     */     public boolean unschedule(Object pk)
/*     */     {
/* 763 */       return this.scheduled.remove(pk);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager
 * JD-Core Version:    0.6.0
 */