/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.sql.DataSource;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge.FieldIterator;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public final class JDBCStoreEntityCommand
/*     */ {
/*     */   private final JDBCEntityBridge entity;
/*     */   private final JDBCFieldBridge[] primaryKeyFields;
/*     */   private final Logger log;
/*     */ 
/*     */   public JDBCStoreEntityCommand(JDBCStoreManager manager)
/*     */   {
/*  56 */     this.entity = ((JDBCEntityBridge)manager.getEntityBridge());
/*  57 */     this.primaryKeyFields = this.entity.getPrimaryKeyFields();
/*     */ 
/*  60 */     this.log = Logger.getLogger(getClass().getName() + "." + manager.getMetaData().getName());
/*     */   }
/*     */ 
/*     */   public void execute(EntityEnterpriseContext ctx)
/*     */   {
/*  70 */     JDBCEntityBridge.FieldIterator dirtyIterator = this.entity.getDirtyIterator(ctx);
/*  71 */     if ((!dirtyIterator.hasNext()) || (this.entity.isBeingRemoved(ctx)) || (this.entity.isScheduledForBatchCascadeDelete(ctx)))
/*     */     {
/*  73 */       if (this.log.isTraceEnabled())
/*     */       {
/*  75 */         this.log.trace("Store command NOT executed. Entity is not dirty , is being removed or scheduled for *batch* cascade delete: pk=" + ctx.getId());
/*     */       }
/*     */ 
/*  78 */       return;
/*     */     }
/*     */ 
/*  82 */     StringBuffer sql = new StringBuffer(200);
/*  83 */     sql.append("UPDATE ").append(this.entity.getQualifiedTableName()).append(" SET ");
/*     */ 
/*  86 */     SQLUtil.getSetClause(dirtyIterator, sql).append(" WHERE ");
/*     */ 
/*  88 */     SQLUtil.getWhereClause(this.primaryKeyFields, sql);
/*     */ 
/*  90 */     boolean hasLockedFields = this.entity.hasLockedFields(ctx);
/*  91 */     JDBCEntityBridge.FieldIterator lockedIterator = null;
/*  92 */     if (hasLockedFields)
/*     */     {
/*  94 */       lockedIterator = this.entity.getLockedIterator(ctx);
/*  95 */       while (lockedIterator.hasNext())
/*     */       {
/*  97 */         sql.append(" AND ");
/*  98 */         JDBCCMPFieldBridge field = lockedIterator.next();
/*  99 */         if (field.getLockedValue(ctx) == null)
/*     */         {
/* 101 */           SQLUtil.getIsNullClause(false, field, "", sql);
/* 102 */           lockedIterator.remove();
/*     */         }
/*     */         else
/*     */         {
/* 106 */           SQLUtil.getWhereClause(field, sql);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 111 */     Connection con = null;
/* 112 */     PreparedStatement ps = null;
/* 113 */     int rowsAffected = 0;
/*     */     try
/*     */     {
/* 117 */       if (this.log.isDebugEnabled())
/*     */       {
/* 119 */         this.log.debug("Executing SQL: " + sql);
/*     */       }
/*     */ 
/* 123 */       con = this.entity.getDataSource().getConnection();
/* 124 */       ps = con.prepareStatement(sql.toString());
/*     */ 
/* 127 */       int index = 1;
/* 128 */       dirtyIterator.reset();
/* 129 */       while (dirtyIterator.hasNext())
/*     */       {
/* 131 */         index = dirtyIterator.next().setInstanceParameters(ps, index, ctx);
/*     */       }
/*     */ 
/* 135 */       index = this.entity.setPrimaryKeyParameters(ps, index, ctx.getId());
/*     */ 
/* 138 */       if (hasLockedFields)
/*     */       {
/* 140 */         lockedIterator.reset();
/* 141 */         while (lockedIterator.hasNext())
/*     */         {
/* 143 */           JDBCCMPFieldBridge field = lockedIterator.next();
/* 144 */           Object value = field.getLockedValue(ctx);
/* 145 */           index = field.setArgumentParameters(ps, index, value);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 150 */       rowsAffected = ps.executeUpdate();
/*     */     }
/*     */     catch (EJBException e)
/*     */     {
/* 154 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 158 */       throw new EJBException("Store failed", e);
/*     */     }
/*     */     finally
/*     */     {
/* 162 */       JDBCUtil.safeClose(ps);
/* 163 */       JDBCUtil.safeClose(con);
/*     */     }
/*     */ 
/* 167 */     if (rowsAffected != 1)
/*     */     {
/* 169 */       throw new EJBException("Update failed. Expected one affected row: rowsAffected=" + rowsAffected + ", id=" + ctx.getId());
/*     */     }
/*     */ 
/* 174 */     dirtyIterator.reset();
/* 175 */     while (dirtyIterator.hasNext())
/*     */     {
/* 177 */       dirtyIterator.next().setClean(ctx);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreEntityCommand
 * JD-Core Version:    0.6.0
 */