/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.math.BigDecimal;
/*     */ import java.math.BigInteger;
/*     */ import java.rmi.MarshalledObject;
/*     */ import java.rmi.RemoteException;
/*     */ import java.sql.Blob;
/*     */ import java.sql.Clob;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Time;
/*     */ import java.sql.Timestamp;
/*     */ import java.util.Arrays;
/*     */ import javax.ejb.Handle;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract interface JDBCResultSetReader
/*     */ {
/*  58 */   public static final JDBCResultSetReader CLOB_READER = new AbstractResultSetReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination) throws SQLException
/*     */     {
/*  62 */       Clob clob = rs.getClob(index);
/*     */       String content;
/*     */       String content;
/*  65 */       if (clob == null)
/*     */       {
/*  67 */         content = null;
/*     */       }
/*     */       else
/*     */       {
/*  71 */         Reader reader = clob.getCharacterStream();
/*  72 */         if (reader != null)
/*     */         {
/*  74 */           int intLength = (int)clob.length();
/*     */           try
/*     */           {
/*     */             String content;
/*  79 */             if (intLength <= 8192)
/*     */             {
/*  81 */               char[] chars = new char[intLength];
/*  82 */               reader.read(chars);
/*  83 */               content = String.valueOf(chars);
/*     */             }
/*     */             else
/*     */             {
/*  87 */               StringBuffer buf = new StringBuffer(intLength);
/*  88 */               char[] chars = new char[8192];
/*  89 */               int i = reader.read(chars);
/*  90 */               while (i > 0)
/*     */               {
/*  92 */                 buf.append(chars, 0, i);
/*  93 */                 i = reader.read(chars);
/*     */               }
/*  95 */               content = buf.toString();
/*     */             }
/*     */           }
/*     */           catch (IOException e)
/*     */           {
/*     */             String content;
/* 100 */             throw new SQLException("Failed to read CLOB character stream: " + e.getMessage());
/*     */           }
/*     */           finally
/*     */           {
/* 104 */             JDBCUtil.safeClose(reader);
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 109 */           content = null;
/*     */         }
/*     */       }
/*     */ 
/* 113 */       return content;
/*     */     }
/*  58 */   };
/*     */ 
/* 117 */   public static final JDBCResultSetReader LONGVARCHAR_READER = new AbstractResultSetReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination) throws SQLException
/*     */     {
/* 121 */       return JDBCUtil.getLongString(rs, index);
/*     */     }
/* 117 */   };
/*     */ 
/* 125 */   public static final JDBCResultSetReader BINARY_READER = new AbstractResultSetReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination) throws SQLException
/*     */     {
/* 129 */       Object value = null;
/* 130 */       byte[] bytes = rs.getBytes(index);
/* 131 */       if (!rs.wasNull())
/*     */       {
/* 133 */         if (destination == [B.class)
/* 134 */           value = bytes;
/*     */         else
/* 136 */           value = JDBCUtil.convertToObject(bytes);
/*     */       }
/* 138 */       return value;
/*     */     }
/* 125 */   };
/*     */ 
/* 142 */   public static final JDBCResultSetReader VARBINARY_READER = new AbstractResultSetReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination) throws SQLException
/*     */     {
/* 146 */       Object value = null;
/* 147 */       byte[] bytes = rs.getBytes(index);
/* 148 */       if (!rs.wasNull())
/*     */       {
/* 150 */         if (destination == [B.class)
/* 151 */           value = bytes;
/*     */         else
/* 153 */           value = JDBCUtil.convertToObject(bytes);
/*     */       }
/* 155 */       return value;
/*     */     }
/* 142 */   };
/*     */ 
/* 159 */   public static final JDBCResultSetReader BLOB_READER = new AbstractResultSetReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination) throws SQLException
/*     */     {
/* 163 */       Blob blob = rs.getBlob(index);
/*     */       Object value;
/*     */       Object value;
/* 166 */       if (blob == null)
/*     */       {
/* 168 */         value = null;
/*     */       }
/*     */       else
/*     */       {
/* 172 */         InputStream binaryData = blob.getBinaryStream();
/*     */         Object value;
/* 173 */         if (binaryData != null)
/*     */         {
/*     */           Object value;
/* 175 */           if (destination == [B.class)
/* 176 */             value = JDBCUtil.getByteArray(binaryData);
/*     */           else
/* 178 */             value = JDBCUtil.convertToObject(binaryData);
/*     */         }
/*     */         else
/*     */         {
/* 182 */           value = null;
/*     */         }
/*     */       }
/*     */ 
/* 186 */       return value;
/*     */     }
/* 159 */   };
/*     */ 
/* 190 */   public static final JDBCResultSetReader LONGVARBINARY_READER = new AbstractResultSetReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination) throws SQLException
/*     */     {
/* 194 */       Object value = null;
/* 195 */       InputStream binaryData = rs.getBinaryStream(index);
/* 196 */       if ((binaryData != null) && (!rs.wasNull()))
/*     */       {
/* 198 */         if (destination == [B.class)
/* 199 */           value = JDBCUtil.getByteArray(binaryData);
/*     */         else
/* 201 */           value = JDBCUtil.convertToObject(binaryData);
/*     */       }
/* 203 */       return value;
/*     */     }
/* 190 */   };
/*     */ 
/* 207 */   public static final JDBCResultSetReader JAVA_OBJECT_READER = new AbstractResultSetReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination) throws SQLException
/*     */     {
/* 211 */       return rs.getObject(index);
/*     */     }
/* 207 */   };
/*     */ 
/* 215 */   public static final JDBCResultSetReader STRUCT_READER = new AbstractResultSetReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination) throws SQLException
/*     */     {
/* 219 */       return rs.getObject(index);
/*     */     }
/* 215 */   };
/*     */ 
/* 223 */   public static final JDBCResultSetReader ARRAY_READER = new AbstractResultSetReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination) throws SQLException
/*     */     {
/* 227 */       return rs.getObject(index);
/*     */     }
/* 223 */   };
/*     */ 
/* 231 */   public static final JDBCResultSetReader OTHER_READER = new AbstractResultSetReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination) throws SQLException
/*     */     {
/* 235 */       return rs.getObject(index);
/*     */     }
/* 231 */   };
/*     */ 
/* 239 */   public static final JDBCResultSetReader JAVA_UTIL_DATE_READER = new AbstractResultSetReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination) throws SQLException
/*     */     {
/* 243 */       return rs.getTimestamp(index);
/*     */     }
/*     */ 
/*     */     protected Object coerceToJavaType(Object value, Class destination)
/*     */     {
/*     */       java.util.Date result;
/*     */       java.util.Date result;
/* 251 */       if ((value instanceof Timestamp))
/*     */       {
/* 253 */         Timestamp ts = (Timestamp)value;
/*     */ 
/* 257 */         long temp = ts.getTime();
/* 258 */         if (temp % 1000L == 0L)
/* 259 */           temp += ts.getNanos() / 1000000;
/* 260 */         result = new java.util.Date(temp);
/*     */       }
/*     */       else
/*     */       {
/* 264 */         result = new java.util.Date(((java.util.Date)value).getTime());
/*     */       }
/* 266 */       return result;
/*     */     }
/* 239 */   };
/*     */ 
/* 270 */   public static final JDBCResultSetReader JAVA_SQL_DATE_READER = new AbstractResultSetReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination) throws SQLException
/*     */     {
/* 274 */       return rs.getDate(index);
/*     */     }
/*     */ 
/*     */     protected Object coerceToJavaType(Object value, Class destination)
/*     */     {
/* 280 */       return new java.sql.Date(((java.sql.Date)value).getTime());
/*     */     }
/* 270 */   };
/*     */ 
/* 284 */   public static final JDBCResultSetReader JAVA_SQL_TIME_READER = new AbstractResultSetReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination) throws SQLException
/*     */     {
/* 288 */       return rs.getTime(index);
/*     */     }
/*     */ 
/*     */     protected Object coerceToJavaType(Object value, Class destination)
/*     */     {
/* 294 */       return new Time(((Time)value).getTime());
/*     */     }
/* 284 */   };
/*     */ 
/* 298 */   public static final JDBCResultSetReader JAVA_SQL_TIMESTAMP_READER = new AbstractResultSetReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination) throws SQLException
/*     */     {
/* 302 */       return rs.getTimestamp(index);
/*     */     }
/*     */ 
/*     */     protected Object coerceToJavaType(Object value, Class destination)
/*     */     {
/* 308 */       Timestamp orignal = (Timestamp)value;
/* 309 */       Timestamp copy = new Timestamp(orignal.getTime());
/* 310 */       copy.setNanos(orignal.getNanos());
/* 311 */       return copy;
/*     */     }
/* 298 */   };
/*     */ 
/* 315 */   public static final JDBCResultSetReader BIGDECIMAL_READER = new AbstractResultSetReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination)
/*     */       throws SQLException
/*     */     {
/* 320 */       return rs.getBigDecimal(index);
/*     */     }
/* 315 */   };
/*     */ 
/* 324 */   public static final JDBCResultSetReader REF_READER = new AbstractResultSetReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination)
/*     */       throws SQLException
/*     */     {
/* 329 */       return rs.getRef(index);
/*     */     }
/* 324 */   };
/*     */ 
/* 333 */   public static final JDBCResultSetReader BYTE_ARRAY_READER = new AbstractResultSetReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination)
/*     */       throws SQLException
/*     */     {
/* 338 */       return rs.getBytes(index);
/*     */     }
/* 333 */   };
/*     */ 
/* 342 */   public static final JDBCResultSetReader OBJECT_READER = new AbstractResultSetReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination) throws SQLException
/*     */     {
/* 346 */       return rs.getObject(index);
/*     */     }
/* 342 */   };
/*     */ 
/* 350 */   public static final JDBCResultSetReader STRING_READER = new JDBCResultSetReader()
/*     */   {
/*     */     public Object get(ResultSet rs, int index, Class destination, Logger log) throws SQLException
/*     */     {
/* 354 */       String result = rs.getString(index);
/*     */ 
/* 356 */       if (log.isTraceEnabled())
/*     */       {
/* 358 */         log.trace("result: i=" + index + ", type=" + destination.getName() + ", value=" + result);
/*     */       }
/*     */ 
/* 361 */       return result;
/*     */     }
/* 350 */   };
/*     */ 
/* 396 */   public static final JDBCResultSetReader BOOLEAN_READER = new AbstractPrimitiveReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination)
/*     */       throws SQLException
/*     */     {
/* 401 */       return rs.getBoolean(index) ? Boolean.TRUE : Boolean.FALSE;
/*     */     }
/* 396 */   };
/*     */ 
/* 405 */   public static final JDBCResultSetReader BYTE_READER = new AbstractPrimitiveReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination)
/*     */       throws SQLException
/*     */     {
/* 410 */       return new Byte(rs.getByte(index));
/*     */     }
/* 405 */   };
/*     */ 
/* 414 */   public static final JDBCResultSetReader CHARACTER_READER = new AbstractPrimitiveReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination)
/*     */       throws SQLException
/*     */     {
/* 419 */       return rs.getString(index);
/*     */     }
/*     */ 
/*     */     protected Object coerceToJavaType(Object value, Class destination)
/*     */     {
/* 428 */       if (((value instanceof String)) && ((destination == Character.class) || (destination == Character.TYPE)))
/*     */       {
/* 430 */         return new Character(((String)value).charAt(0));
/*     */       }
/*     */ 
/* 434 */       return value;
/*     */     }
/* 414 */   };
/*     */ 
/* 439 */   public static final JDBCResultSetReader SHORT_READER = new AbstractPrimitiveReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination)
/*     */       throws SQLException
/*     */     {
/* 444 */       return new Short(rs.getShort(index));
/*     */     }
/* 439 */   };
/*     */ 
/* 448 */   public static final JDBCResultSetReader INT_READER = new AbstractPrimitiveReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination)
/*     */       throws SQLException
/*     */     {
/* 453 */       return new Integer(rs.getInt(index));
/*     */     }
/* 448 */   };
/*     */ 
/* 457 */   public static final JDBCResultSetReader LONG_READER = new AbstractPrimitiveReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination)
/*     */       throws SQLException
/*     */     {
/* 462 */       return new Long(rs.getLong(index));
/*     */     }
/* 457 */   };
/*     */ 
/* 466 */   public static final JDBCResultSetReader FLOAT_READER = new AbstractPrimitiveReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination)
/*     */       throws SQLException
/*     */     {
/* 471 */       return new Float(rs.getFloat(index));
/*     */     }
/* 466 */   };
/*     */ 
/* 475 */   public static final JDBCResultSetReader DOUBLE_READER = new AbstractPrimitiveReader()
/*     */   {
/*     */     protected Object readResult(ResultSet rs, int index, Class destination)
/*     */       throws SQLException
/*     */     {
/* 480 */       return new Double(rs.getDouble(index));
/*     */     }
/* 475 */   };
/*     */ 
/*     */   public abstract Object get(ResultSet paramResultSet, int paramInt, Class paramClass, Logger paramLogger)
/*     */     throws SQLException;
/*     */ 
/*     */   public static abstract class AbstractResultSetReader
/*     */     implements JDBCResultSetReader
/*     */   {
/*     */     public Object get(ResultSet rs, int index, Class destination, Logger log)
/*     */       throws SQLException
/*     */     {
/* 488 */       Object result = readResult(rs, index, destination);
/* 489 */       if (result != null) {
/* 490 */         result = coerceToJavaType(result, destination);
/*     */       }
/* 492 */       if (log.isTraceEnabled())
/*     */       {
/* 494 */         log.trace("result: i=" + index + ", type=" + destination.getName() + ", value=" + result);
/*     */       }
/*     */ 
/* 497 */       return result;
/*     */     }
/*     */ 
/*     */     protected abstract Object readResult(ResultSet paramResultSet, int paramInt, Class paramClass)
/*     */       throws SQLException;
/*     */ 
/*     */     protected Object coerceToJavaType(Object value, Class destination)
/*     */       throws SQLException
/*     */     {
/*     */       try
/*     */       {
/* 512 */         if (((value instanceof MarshalledObject)) && (!destination.equals(MarshalledObject.class)))
/*     */         {
/* 514 */           value = ((MarshalledObject)value).get();
/*     */         }
/*     */ 
/* 521 */         if ((value instanceof Handle))
/*     */         {
/* 523 */           value = ((Handle)value).getEJBObject();
/*     */         }
/*     */ 
/* 527 */         if (destination.isAssignableFrom(value.getClass()))
/*     */         {
/* 529 */           return value;
/*     */         }
/*     */ 
/* 532 */         if ((destination == BigInteger.class) && (value.getClass() == BigDecimal.class))
/*     */         {
/* 534 */           return ((BigDecimal)value).toBigInteger();
/*     */         }
/*     */ 
/* 538 */         String className = null;
/* 539 */         Object interfaces = null;
/* 540 */         ClassLoader cl = null;
/* 541 */         if (value != null)
/*     */         {
/* 543 */           Class valueClass = value.getClass();
/* 544 */           className = valueClass.getName();
/* 545 */           interfaces = Arrays.asList(valueClass.getInterfaces());
/* 546 */           cl = valueClass.getClassLoader();
/*     */         }
/* 548 */         throw new SQLException("Got a " + className + "[cl=" + cl + " + interfaces=" + interfaces + ", value=" + value + "] while looking for a " + destination.getName() + "[cl=" + destination.getClassLoader() + "]");
/*     */       }
/*     */       catch (RemoteException e)
/*     */       {
/* 554 */         throw new SQLException("Unable to load EJBObject back from Handle: " + e);
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 558 */         throw new SQLException("Unable to load to deserialize result: " + e);
/*     */       }
/*     */       catch (ClassNotFoundException e) {
/*     */       }
/* 562 */       throw new SQLException("Unable to load to deserialize result: " + e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static abstract class AbstractPrimitiveReader extends JDBCResultSetReader.AbstractResultSetReader
/*     */   {
/*     */     public Object get(ResultSet rs, int index, Class destination, Logger log)
/*     */       throws SQLException
/*     */     {
/* 373 */       Object result = readResult(rs, index, destination);
/* 374 */       if (rs.wasNull())
/* 375 */         result = null;
/*     */       else {
/* 377 */         result = coerceToJavaType(result, destination);
/*     */       }
/* 379 */       if (log.isTraceEnabled())
/*     */       {
/* 381 */         log.trace("result: i=" + index + ", type=" + destination.getName() + ", value=" + result);
/*     */       }
/*     */ 
/* 384 */       return result;
/*     */     }
/*     */ 
/*     */     protected Object coerceToJavaType(Object value, Class destination)
/*     */       throws SQLException
/*     */     {
/* 392 */       return value;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCResultSetReader
 * JD-Core Version:    0.6.0
 */