/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.rmi.RemoteException;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.util.Map;
/*     */ import javax.ejb.RemoveException;
/*     */ import javax.sql.DataSource;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMRFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.ConfigurationMetaData;
/*     */ 
/*     */ public final class JDBCRemoveEntityCommand
/*     */ {
/*     */   private final JDBCStoreManager manager;
/*     */   private final JDBCEntityBridge entity;
/*     */   private final Logger log;
/*     */   private final String removeEntitySQL;
/*     */   private final boolean syncOnCommitOnly;
/*     */   private boolean batchCascadeDelete;
/*     */ 
/*     */   public JDBCRemoveEntityCommand(JDBCStoreManager manager)
/*     */     throws DeploymentException
/*     */   {
/*  62 */     this.manager = manager;
/*  63 */     this.entity = ((JDBCEntityBridge)manager.getEntityBridge());
/*     */ 
/*  66 */     this.log = Logger.getLogger(getClass().getName() + "." + manager.getMetaData().getName());
/*     */ 
/*  71 */     StringBuffer sql = new StringBuffer();
/*  72 */     sql.append("DELETE FROM ").append(this.entity.getQualifiedTableName()).append(" WHERE ");
/*     */ 
/*  75 */     SQLUtil.getWhereClause(this.entity.getPrimaryKeyFields(), sql);
/*     */ 
/*  77 */     this.removeEntitySQL = sql.toString();
/*  78 */     if (this.log.isDebugEnabled()) {
/*  79 */       this.log.debug("Remove SQL: " + this.removeEntitySQL);
/*     */     }
/*  81 */     ConfigurationMetaData containerConfig = manager.getContainer().getBeanMetaData().getContainerConfiguration();
/*     */ 
/*  83 */     this.syncOnCommitOnly = containerConfig.getSyncOnCommitOnly();
/*     */ 
/*  85 */     JDBCCMRFieldBridge[] cmrFields = (JDBCCMRFieldBridge[])(JDBCCMRFieldBridge[])this.entity.getCMRFields();
/*  86 */     for (int i = 0; i < cmrFields.length; i++)
/*     */     {
/*  88 */       if (!cmrFields[i].isBatchCascadeDelete())
/*     */         continue;
/*  90 */       this.batchCascadeDelete = true;
/*  91 */       break;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void execute(EntityEnterpriseContext ctx)
/*     */     throws RemoveException, RemoteException
/*     */   {
/*  99 */     if (this.entity.isRemoved(ctx))
/*     */     {
/* 101 */       throw new IllegalStateException("Instance was already removed: id=" + ctx.getId());
/*     */     }
/*     */ 
/* 104 */     this.entity.setIsBeingRemoved(ctx);
/*     */ 
/* 107 */     Object[] oldRelationsRef = new Object[1];
/* 108 */     boolean needsSync = this.entity.removeFromRelations(ctx, oldRelationsRef);
/*     */ 
/* 112 */     if ((!this.syncOnCommitOnly) && (needsSync))
/*     */     {
/* 114 */       EntityContainer.synchronizeEntitiesWithinTransaction(ctx.getTransaction());
/*     */     }
/*     */ 
/* 117 */     if (!this.batchCascadeDelete)
/*     */     {
/* 119 */       if (!this.entity.isScheduledForBatchCascadeDelete(ctx))
/*     */       {
/* 121 */         executeDeleteSQL(ctx);
/*     */       }
/* 125 */       else if (this.log.isTraceEnabled()) {
/* 126 */         this.log.trace("Instance is scheduled for cascade delete. id=" + ctx.getId());
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 131 */     if (oldRelationsRef[0] != null)
/*     */     {
/* 133 */       Map oldRelations = (Map)oldRelationsRef[0];
/* 134 */       this.entity.cascadeDelete(ctx, oldRelations);
/*     */     }
/*     */ 
/* 137 */     if (this.batchCascadeDelete)
/*     */     {
/* 139 */       if (!this.entity.isScheduledForBatchCascadeDelete(ctx))
/*     */       {
/* 141 */         executeDeleteSQL(ctx);
/*     */       }
/* 145 */       else if (this.log.isTraceEnabled()) {
/* 146 */         this.log.debug("Instance is scheduled for cascade delete. id=" + ctx.getId());
/*     */       }
/*     */     }
/*     */ 
/* 150 */     this.entity.setRemoved(ctx);
/* 151 */     this.manager.getReadAheadCache().removeCachedData(ctx.getId());
/*     */   }
/*     */ 
/*     */   private void executeDeleteSQL(EntityEnterpriseContext ctx) throws RemoveException
/*     */   {
/* 156 */     Object key = ctx.getId();
/* 157 */     Connection con = null;
/* 158 */     PreparedStatement ps = null;
/* 159 */     int rowsAffected = 0;
/*     */     try
/*     */     {
/* 162 */       if (this.log.isDebugEnabled()) {
/* 163 */         this.log.debug("Executing SQL: " + this.removeEntitySQL);
/*     */       }
/*     */ 
/* 166 */       con = this.entity.getDataSource().getConnection();
/* 167 */       ps = con.prepareStatement(this.removeEntitySQL);
/*     */ 
/* 170 */       this.entity.setPrimaryKeyParameters(ps, 1, key);
/*     */ 
/* 173 */       rowsAffected = ps.executeUpdate();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 177 */       this.log.error("Could not remove " + key, e);
/* 178 */       throw new RemoveException("Could not remove " + key + ": " + e.getMessage());
/*     */     }
/*     */     finally
/*     */     {
/* 182 */       JDBCUtil.safeClose(ps);
/* 183 */       JDBCUtil.safeClose(con);
/*     */     }
/*     */ 
/* 187 */     if (rowsAffected == 0)
/*     */     {
/* 189 */       this.log.error("Could not remove entity " + key);
/* 190 */       throw new RemoveException("Could not remove entity");
/*     */     }
/*     */ 
/* 193 */     if (this.log.isTraceEnabled())
/* 194 */       this.log.trace("Remove: Rows affected = " + rowsAffected);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCRemoveEntityCommand
 * JD-Core Version:    0.6.0
 */