/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import javax.ejb.EJBException;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.Interceptor;
/*     */ import org.jboss.ejb.plugins.AbstractInterceptor;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.CMRInvocation;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.CMRMessage;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMRFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ 
/*     */ public final class JDBCRelationInterceptor extends AbstractInterceptor
/*     */ {
/*     */   private EntityContainer container;
/*     */   private Logger log;
/*     */ 
/*     */   public void setContainer(Container container)
/*     */   {
/*  67 */     this.container = ((EntityContainer)container);
/*  68 */     if (container != null)
/*     */     {
/*  70 */       this.log = Logger.getLogger(getClass().getName() + "." + container.getBeanMetaData().getEjbName());
/*     */     }
/*     */   }
/*     */ 
/*     */   public Container getContainer()
/*     */   {
/*  79 */     return this.container;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation mi)
/*     */     throws Exception
/*     */   {
/*  86 */     if (!(mi instanceof CMRInvocation)) {
/*  87 */       return getNext().invoke(mi);
/*     */     }
/*  89 */     CMRMessage relationshipMessage = ((CMRInvocation)mi).getCmrMessage();
/*  90 */     if (relationshipMessage == null)
/*     */     {
/*  93 */       return getNext().invoke(mi);
/*     */     }
/*     */ 
/*  97 */     EntityEnterpriseContext ctx = (EntityEnterpriseContext)mi.getEnterpriseContext();
/*  98 */     JDBCCMRFieldBridge cmrField = (JDBCCMRFieldBridge)mi.getArguments()[0];
/*     */ 
/* 100 */     if (CMRMessage.GET_RELATED_ID == relationshipMessage)
/*     */     {
/* 103 */       if (this.log.isTraceEnabled())
/*     */       {
/* 105 */         this.log.trace("Getting related id: field=" + cmrField.getFieldName() + " id=" + ctx.getId());
/*     */       }
/* 107 */       return cmrField.getRelatedId(ctx);
/*     */     }
/*     */ 
/* 110 */     if (CMRMessage.ADD_RELATION == relationshipMessage)
/*     */     {
/* 113 */       Object relatedId = mi.getArguments()[1];
/* 114 */       if (this.log.isTraceEnabled())
/*     */       {
/* 116 */         this.log.trace("Add relation: field=" + cmrField.getFieldName() + " id=" + ctx.getId() + " relatedId=" + relatedId);
/*     */       }
/*     */ 
/* 121 */       cmrField.addRelation(ctx, relatedId);
/*     */ 
/* 123 */       return null;
/*     */     }
/*     */ 
/* 126 */     if (CMRMessage.REMOVE_RELATION == relationshipMessage)
/*     */     {
/* 129 */       Object relatedId = mi.getArguments()[1];
/* 130 */       if (this.log.isTraceEnabled())
/*     */       {
/* 132 */         this.log.trace("Remove relation: field=" + cmrField.getFieldName() + " id=" + ctx.getId() + " relatedId=" + relatedId);
/*     */       }
/*     */ 
/* 137 */       cmrField.removeRelation(ctx, relatedId);
/*     */ 
/* 139 */       return null;
/*     */     }
/* 141 */     if (CMRMessage.SCHEDULE_FOR_CASCADE_DELETE == relationshipMessage)
/*     */     {
/* 143 */       JDBCEntityBridge entity = (JDBCEntityBridge)cmrField.getEntity();
/* 144 */       entity.scheduleForCascadeDelete(ctx);
/* 145 */       return null;
/*     */     }
/* 147 */     if (CMRMessage.SCHEDULE_FOR_BATCH_CASCADE_DELETE == relationshipMessage)
/*     */     {
/* 149 */       JDBCEntityBridge entity = (JDBCEntityBridge)cmrField.getEntity();
/* 150 */       entity.scheduleForBatchCascadeDelete(ctx);
/* 151 */       return null;
/*     */     }
/*     */ 
/* 156 */     throw new EJBException("Unknown cmp2.0-relationship-message=" + relationshipMessage);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCRelationInterceptor
 * JD-Core Version:    0.6.0
 */