/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import javax.ejb.FinderException;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.plugins.cmp.ejbql.Catalog;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCAutomaticQueryMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCDeclaredQueryMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCDynamicQLQueryMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCJBossQLQueryMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQlQueryMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public final class JDBCQueryManager
/*     */ {
/*     */   private static final String FIND_BY_PK = "findByPrimaryKey";
/*     */   private static final String EJB_FIND = "ejbFind";
/*     */   private static final String FIND_ALL = "findAll";
/*     */   private static final String FIND_BY = "findBy";
/*  64 */   private final Map knownQueries = new HashMap();
/*     */   private final JDBCStoreManager manager;
/*     */ 
/*     */   public JDBCQueryManager(JDBCStoreManager manager)
/*     */   {
/*  69 */     this.manager = manager;
/*     */   }
/*     */ 
/*     */   public static final Class getQLCompiler(Element query, JDBCEntityMetaData entity)
/*     */     throws DeploymentException
/*     */   {
/*  75 */     String compiler = MetaData.getOptionalChildContent(query, "ql-compiler");
/*     */     Class impl;
/*     */     Class impl;
/*  78 */     if ((compiler == null) || (compiler.trim().length() == 0))
/*     */     {
/*  80 */       impl = entity.getQLCompiler();
/*     */     }
/*     */     else
/*     */     {
/*     */       try
/*     */       {
/*  86 */         impl = TCLAction.UTIL.getContextClassLoader().loadClass(compiler);
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/*  90 */         throw new DeploymentException("Failed to load compiler implementation: " + compiler);
/*     */       }
/*     */     }
/*  93 */     return impl;
/*     */   }
/*     */ 
/*     */   public static final QLCompiler getInstance(Class impl, Catalog catalog)
/*     */     throws DeploymentException
/*     */   {
/*  99 */     if (impl == null)
/*     */     {
/* 101 */       throw new DeploymentException("ql-compiler is not specified.");
/*     */     }
/*     */     Constructor constructor;
/*     */     try
/*     */     {
/* 107 */       constructor = impl.getConstructor(new Class[] { Catalog.class });
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/* 111 */       throw new DeploymentException("Compiler class does not have a constructor which takes " + Catalog.class.getName());
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 116 */       return (QLCompiler)constructor.newInstance(new Object[] { catalog });
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 120 */     throw new DeploymentException("Failed to create an instance of " + impl.getName() + ": " + e.getMessage(), e);
/*     */   }
/*     */ 
/*     */   public JDBCQueryCommand getQueryCommand(Method queryMethod)
/*     */     throws FinderException
/*     */   {
/* 127 */     JDBCQueryCommand queryCommand = (JDBCQueryCommand)this.knownQueries.get(queryMethod);
/*     */ 
/* 129 */     if (queryCommand == null)
/*     */     {
/* 131 */       throw new FinderException("Unknown query: " + queryMethod);
/*     */     }
/* 133 */     return queryCommand;
/*     */   }
/*     */ 
/*     */   public void start() throws DeploymentException
/*     */   {
/* 138 */     Logger log = Logger.getLogger(getClass().getName() + "." + this.manager.getMetaData().getName());
/*     */ 
/* 143 */     JDBCCommandFactory factory = this.manager.getCommandFactory();
/*     */ 
/* 145 */     Class homeClass = this.manager.getContainer().getHomeClass();
/* 146 */     Class localHomeClass = this.manager.getContainer().getLocalHomeClass();
/*     */ 
/* 151 */     JDBCEntityBridge entity = (JDBCEntityBridge)this.manager.getEntityBridge();
/* 152 */     if (homeClass != null)
/*     */     {
/*     */       try
/*     */       {
/* 157 */         Method method = homeClass.getMethod("findByPrimaryKey", new Class[] { entity.getPrimaryKeyClass() });
/*     */ 
/* 159 */         JDBCQueryMetaData findByPKMD = this.manager.getMetaData().getQueryMetaDataForMethod(method);
/* 160 */         JDBCReadAheadMetaData readAhead = findByPKMD == null ? entity.getMetaData().getReadAhead() : findByPKMD.getReadAhead();
/*     */ 
/* 164 */         JDBCQueryMetaData q = new JDBCAutomaticQueryMetaData(method, readAhead, entity.getMetaData().getQLCompiler(), false);
/*     */ 
/* 170 */         this.knownQueries.put(method, factory.createFindByPrimaryKeyQuery(q));
/*     */ 
/* 172 */         if (log.isDebugEnabled())
/* 173 */           log.debug("Added findByPrimaryKey query command for home interface");
/*     */       }
/*     */       catch (NoSuchMethodException e) {
/* 176 */         throw new DeploymentException("Home interface does not have a findByPrimaryKey method");
/*     */       }
/*     */     }
/*     */ 
/* 180 */     if (localHomeClass != null)
/*     */     {
/*     */       Method method;
/*     */       try
/*     */       {
/* 187 */         method = localHomeClass.getMethod("findByPrimaryKey", new Class[] { entity.getPrimaryKeyClass() });
/*     */       }
/*     */       catch (NoSuchMethodException e) {
/* 190 */         throw new DeploymentException("Local home interface does not have the method findByPrimaryKey(" + entity.getPrimaryKeyClass().getName() + ")");
/*     */       }
/*     */ 
/* 196 */       JDBCQueryMetaData findByPKMD = this.manager.getMetaData().getQueryMetaDataForMethod(method);
/* 197 */       JDBCReadAheadMetaData readAhead = findByPKMD == null ? entity.getMetaData().getReadAhead() : findByPKMD.getReadAhead();
/*     */ 
/* 199 */       JDBCQueryMetaData q = new JDBCAutomaticQueryMetaData(method, readAhead, entity.getMetaData().getQLCompiler(), false);
/* 200 */       this.knownQueries.put(method, factory.createFindByPrimaryKeyQuery(q));
/*     */ 
/* 202 */       if (log.isDebugEnabled()) {
/* 203 */         log.debug("Added findByPrimaryKey query command for local home interface");
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 209 */     Class ejbClass = this.manager.getMetaData().getEntityClass();
/*     */ 
/* 211 */     Method[] customMethods = ejbClass.getMethods();
/* 212 */     for (int i = 0; i < customMethods.length; i++)
/*     */     {
/* 214 */       Method m = customMethods[i];
/* 215 */       String methodName = m.getName();
/* 216 */       if (!methodName.startsWith("ejbFind"))
/*     */         continue;
/* 218 */       String interfaceName = 'f' + methodName.substring(4);
/*     */ 
/* 220 */       if (homeClass != null)
/*     */       {
/*     */         try
/*     */         {
/* 225 */           Method interfaceMethod = homeClass.getMethod(interfaceName, m.getParameterTypes());
/*     */ 
/* 230 */           this.knownQueries.put(interfaceMethod, new JDBCCustomFinderQuery(this.manager, m));
/*     */ 
/* 232 */           if (log.isDebugEnabled()) {
/* 233 */             log.debug("Added custom finder " + methodName + " on home interface");
/*     */           }
/*     */         }
/*     */         catch (NoSuchMethodException e)
/*     */         {
/*     */         }
/*     */       }
/* 240 */       if (localHomeClass == null) {
/*     */         continue;
/*     */       }
/*     */       try
/*     */       {
/* 245 */         Method interfaceMethod = localHomeClass.getMethod(interfaceName, m.getParameterTypes());
/*     */ 
/* 250 */         this.knownQueries.put(interfaceMethod, new JDBCCustomFinderQuery(this.manager, m));
/*     */ 
/* 252 */         if (log.isDebugEnabled()) {
/* 253 */           log.debug("Added custom finder " + methodName + " on local home interface");
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (NoSuchMethodException e)
/*     */       {
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 265 */     Iterator definedFinders = this.manager.getMetaData().getQueries().iterator();
/* 266 */     while (definedFinders.hasNext())
/*     */     {
/* 268 */       JDBCQueryMetaData q = (JDBCQueryMetaData)definedFinders.next();
/*     */ 
/* 270 */       if (!this.knownQueries.containsKey(q.getMethod()))
/*     */       {
/* 272 */         if ((q instanceof JDBCJBossQLQueryMetaData))
/*     */         {
/* 274 */           this.knownQueries.put(q.getMethod(), factory.createJBossQLQuery(q));
/*     */         }
/* 276 */         else if ((q instanceof JDBCDynamicQLQueryMetaData))
/*     */         {
/* 278 */           this.knownQueries.put(q.getMethod(), factory.createDynamicQLQuery(q));
/*     */         }
/* 280 */         else if ((q instanceof JDBCDeclaredQueryMetaData))
/*     */         {
/* 282 */           this.knownQueries.put(q.getMethod(), factory.createDeclaredSQLQuery(q));
/*     */         }
/* 284 */         else if ((q instanceof JDBCQlQueryMetaData))
/*     */         {
/* 286 */           this.knownQueries.put(q.getMethod(), factory.createEJBQLQuery(q));
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 294 */     if (homeClass != null)
/*     */     {
/* 296 */       addAutomaticFinders(this.manager, homeClass.getMethods(), log);
/*     */     }
/*     */ 
/* 299 */     if (localHomeClass != null)
/*     */     {
/* 301 */       addAutomaticFinders(this.manager, localHomeClass.getMethods(), log);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 307 */     this.knownQueries.clear();
/*     */   }
/*     */ 
/*     */   private void addAutomaticFinders(JDBCStoreManager manager, Method[] homeMethods, Logger log)
/*     */     throws DeploymentException
/*     */   {
/* 316 */     JDBCCommandFactory factory = manager.getCommandFactory();
/* 317 */     JDBCEntityBridge entity = (JDBCEntityBridge)manager.getEntityBridge();
/* 318 */     for (int i = 0; i < homeMethods.length; i++)
/*     */     {
/* 320 */       Method method = homeMethods[i];
/*     */ 
/* 322 */       if (this.knownQueries.containsKey(method))
/*     */         continue;
/* 324 */       String name = method.getName();
/* 325 */       if (name.equals("findAll"))
/*     */       {
/* 327 */         JDBCQueryMetaData q = new JDBCAutomaticQueryMetaData(method, entity.getMetaData().getReadAhead(), entity.getMetaData().getQLCompiler(), false);
/*     */ 
/* 332 */         this.knownQueries.put(method, factory.createFindAllQuery(q));
/*     */       } else {
/* 334 */         if ((!name.startsWith("findBy")) || (name.equals("findByPrimaryKey")))
/*     */           continue;
/*     */         try
/*     */         {
/* 338 */           JDBCQueryMetaData q = new JDBCAutomaticQueryMetaData(method, entity.getMetaData().getReadAhead(), entity.getMetaData().getQLCompiler(), false);
/*     */ 
/* 342 */           this.knownQueries.put(method, factory.createFindByQuery(q));
/*     */         }
/*     */         catch (IllegalArgumentException e) {
/* 345 */           log.debug("Could not create the finder " + name + ", because no matching CMP field was found.");
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCQueryManager
 * JD-Core Version:    0.6.0
 */