/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMRFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
/*     */ 
/*     */ public final class JDBCPostCreateEntityCommand
/*     */ {
/*     */   private final JDBCEntityBridge entity;
/*     */   private final JDBCCMRFieldBridge[] cmrWithFKMappedToCMP;
/*     */ 
/*     */   public JDBCPostCreateEntityCommand(JDBCStoreManager manager)
/*     */   {
/*  50 */     this.entity = ((JDBCEntityBridge)manager.getEntityBridge());
/*  51 */     JDBCFieldBridge[] cmrFields = this.entity.getCMRFields();
/*  52 */     List fkToCMPList = new ArrayList(4);
/*  53 */     for (int i = 0; i < cmrFields.length; i++)
/*     */     {
/*  55 */       JDBCCMRFieldBridge cmrField = (JDBCCMRFieldBridge)cmrFields[i];
/*  56 */       JDBCCMRFieldBridge relatedCMRField = (JDBCCMRFieldBridge)cmrField.getRelatedCMRField();
/*  57 */       if ((!cmrField.hasFKFieldsMappedToCMPFields()) && (!relatedCMRField.hasFKFieldsMappedToCMPFields())) {
/*     */         continue;
/*     */       }
/*  60 */       fkToCMPList.add(cmrField);
/*     */     }
/*     */ 
/*  63 */     if (fkToCMPList.isEmpty())
/*  64 */       this.cmrWithFKMappedToCMP = null;
/*     */     else
/*  66 */       this.cmrWithFKMappedToCMP = ((JDBCCMRFieldBridge[])(JDBCCMRFieldBridge[])fkToCMPList.toArray(new JDBCCMRFieldBridge[fkToCMPList.size()]));
/*     */   }
/*     */ 
/*     */   public Object execute(Method m, Object[] args, EntityEnterpriseContext ctx)
/*     */   {
/*  73 */     if (this.cmrWithFKMappedToCMP == null) {
/*  74 */       return null;
/*     */     }
/*  76 */     for (int i = 0; i < this.cmrWithFKMappedToCMP.length; i++)
/*     */     {
/*  78 */       JDBCCMRFieldBridge cmrField = this.cmrWithFKMappedToCMP[i];
/*  79 */       JDBCCMRFieldBridge relatedCMRField = (JDBCCMRFieldBridge)cmrField.getRelatedCMRField();
/*  80 */       if (cmrField.hasFKFieldsMappedToCMPFields())
/*     */       {
/*  82 */         Object relatedId = cmrField.getRelatedIdFromContext(ctx);
/*  83 */         if (relatedId != null)
/*     */         {
/*     */           try
/*     */           {
/*  87 */             if (cmrField.isForeignKeyValid(relatedId))
/*     */             {
/*  89 */               cmrField.createRelationLinks(ctx, relatedId);
/*     */             }
/*     */             else
/*     */             {
/*  93 */               relatedCMRField.addRelatedPKWaitingForMyPK(relatedId, ctx.getId());
/*     */             }
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/*     */           }
/*     */         }
/*     */       }
/*     */       else {
/* 102 */         if (!relatedCMRField.hasFKFieldsMappedToCMPFields())
/*     */           continue;
/* 104 */         cmrField.addRelatedPKsWaitedForMe(ctx);
/*     */       }
/*     */     }
/* 107 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCPostCreateEntityCommand
 * JD-Core Version:    0.6.0
 */