/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.sql.DataSource;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractCMRFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMRFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCFunctionMappingMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public final class JDBCLoadRelationCommand
/*     */ {
/*     */   private final JDBCStoreManager manager;
/*     */   private final JDBCEntityBridge entity;
/*     */   private final Logger log;
/*     */ 
/*     */   public JDBCLoadRelationCommand(JDBCStoreManager manager)
/*     */   {
/*  60 */     this.manager = manager;
/*  61 */     this.entity = ((JDBCEntityBridge)manager.getEntityBridge());
/*     */ 
/*  64 */     this.log = Logger.getLogger(getClass().getName() + "." + manager.getMetaData().getName());
/*     */   }
/*     */ 
/*     */   public Collection execute(JDBCCMRFieldBridge cmrField, Object pk)
/*     */   {
/*  72 */     JDBCCMRFieldBridge relatedCMRField = (JDBCCMRFieldBridge)cmrField.getRelatedCMRField();
/*     */ 
/*  75 */     ReadAheadCache readAheadCache = this.manager.getReadAheadCache();
/*  76 */     ReadAheadCache relatedReadAheadCache = cmrField.getRelatedManager().getReadAheadCache();
/*     */ 
/*  79 */     ReadAheadCache.EntityReadAheadInfo info = readAheadCache.getEntityReadAheadInfo(pk);
/*  80 */     List loadKeys = info.getLoadKeys();
/*     */ 
/*  82 */     Connection con = null;
/*  83 */     PreparedStatement ps = null;
/*  84 */     ResultSet rs = null;
/*     */     try
/*     */     {
/*  88 */       boolean[] preloadMask = getPreloadMask(cmrField);
/*  89 */       String sql = getSQL(cmrField, preloadMask, loadKeys.size());
/*     */ 
/*  92 */       if (this.log.isDebugEnabled()) {
/*  93 */         this.log.debug("load relation SQL: " + sql);
/*     */       }
/*     */ 
/*  96 */       con = cmrField.getDataSource().getConnection();
/*  97 */       ps = con.prepareStatement(sql.toString());
/*     */ 
/* 100 */       if (this.entity.getFetchSize() > 0)
/*     */       {
/* 102 */         ps.setFetchSize(this.entity.getFetchSize());
/*     */       }
/*     */ 
/* 106 */       JDBCCMPFieldBridge[] myKeyFields = getMyKeyFields(cmrField);
/* 107 */       JDBCCMPFieldBridge[] relatedKeyFields = getRelatedKeyFields(cmrField);
/*     */ 
/* 110 */       int paramIndex = 1;
/* 111 */       for (int i = 0; i < loadKeys.size(); i++)
/*     */       {
/* 113 */         Object key = loadKeys.get(i);
/* 114 */         for (int j = 0; j < myKeyFields.length; j++) {
/* 115 */           paramIndex = myKeyFields[j].setPrimaryKeyParameters(ps, paramIndex, key);
/*     */         }
/*     */       }
/*     */ 
/* 119 */       rs = ps.executeQuery();
/*     */ 
/* 122 */       Map resultsMap = new HashMap(loadKeys.size());
/* 123 */       for (int i = 0; i < loadKeys.size(); i++)
/*     */       {
/* 125 */         resultsMap.put(loadKeys.get(i), new ArrayList());
/*     */       }
/*     */ 
/* 129 */       Object[] ref = new Object[1];
/* 130 */       while (rs.next())
/*     */       {
/* 133 */         int index = 1;
/*     */ 
/* 136 */         ref[0] = null;
/*     */ 
/* 139 */         Object loadedPk = pk;
/* 140 */         if (loadKeys.size() > 1)
/*     */         {
/* 143 */           for (int i = 0; i < myKeyFields.length; i++)
/*     */           {
/* 145 */             index = myKeyFields[i].loadPrimaryKeyResults(rs, index, ref);
/* 146 */             if (ref[0] == null)
/*     */             {
/*     */               break;
/*     */             }
/*     */           }
/* 151 */           loadedPk = ref[0];
/*     */         }
/*     */ 
/* 155 */         ref[0] = null;
/* 156 */         for (int i = 0; i < relatedKeyFields.length; i++)
/*     */         {
/* 158 */           index = relatedKeyFields[i].loadPrimaryKeyResults(rs, index, ref);
/* 159 */           if (ref[0] == null)
/*     */           {
/*     */             break;
/*     */           }
/*     */         }
/* 164 */         Object loadedFk = ref[0];
/*     */ 
/* 166 */         if (loadedFk != null)
/*     */         {
/* 169 */           List results = (List)resultsMap.get(loadedPk);
/* 170 */           results.add(loadedFk);
/*     */ 
/* 174 */           if (relatedCMRField.isSingleValued())
/*     */           {
/* 176 */             relatedReadAheadCache.addPreloadData(loadedFk, relatedCMRField, Collections.singletonList(loadedPk));
/*     */           }
/*     */ 
/* 183 */           if (preloadMask != null)
/*     */           {
/* 185 */             JDBCFieldBridge[] relatedFields = cmrField.getRelatedJDBCEntity().getTableFields();
/* 186 */             for (int i = 0; i < relatedFields.length; i++)
/*     */             {
/* 188 */               if (preloadMask[i] == 0)
/*     */                 continue;
/* 190 */               JDBCFieldBridge field = relatedFields[i];
/* 191 */               ref[0] = null;
/*     */ 
/* 194 */               index = field.loadArgumentResults(rs, index, ref);
/* 195 */               relatedReadAheadCache.addPreloadData(loadedFk, field, ref[0]);
/*     */             }
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 203 */       JDBCReadAheadMetaData readAhead = relatedCMRField.getReadAhead();
/* 204 */       for (iter = resultsMap.keySet().iterator(); iter.hasNext(); )
/*     */       {
/* 206 */         Object key = iter.next();
/*     */ 
/* 209 */         List results = (List)resultsMap.get(key);
/*     */ 
/* 212 */         relatedReadAheadCache.addFinderResults(results, readAhead);
/*     */ 
/* 216 */         if (!key.equals(pk))
/*     */         {
/* 218 */           readAheadCache.addPreloadData(key, cmrField, results);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 223 */       iter = (List)resultsMap.get(pk);
/*     */     }
/*     */     catch (EJBException e)
/*     */     {
/*     */       Iterator iter;
/* 227 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 231 */       throw new EJBException("Load relation failed", e);
/*     */     }
/*     */     finally
/*     */     {
/* 235 */       JDBCUtil.safeClose(rs);
/* 236 */       JDBCUtil.safeClose(ps);
/* 237 */       JDBCUtil.safeClose(con);
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getSQL(JDBCCMRFieldBridge cmrField, boolean[] preloadMask, int keyCount) throws DeploymentException
/*     */   {
/* 243 */     JDBCCMPFieldBridge[] myKeyFields = getMyKeyFields(cmrField);
/* 244 */     JDBCCMPFieldBridge[] relatedKeyFields = getRelatedKeyFields(cmrField);
/* 245 */     String relationTable = getQualifiedRelationTable(cmrField);
/* 246 */     JDBCEntityBridge relatedEntity = cmrField.getRelatedJDBCEntity();
/* 247 */     String relatedTable = relatedEntity.getQualifiedTableName();
/*     */ 
/* 250 */     boolean join = ((preloadMask != null) || (cmrField.allFkFieldsMappedToPkFields())) && (relatedKeyFields != relatedEntity.getPrimaryKeyFields());
/*     */     String relatedTableAlias;
/*     */     String relationTableAlias;
/*     */     String relatedTableAlias;
/* 256 */     if (join)
/*     */     {
/* 258 */       String relationTableAlias = getRelationTable(cmrField);
/* 259 */       relatedTableAlias = relatedTable.equals(relationTable) ? getRelationTable(cmrField) + '_' + cmrField.getFieldName() : relatedEntity.getTableName();
/*     */     }
/*     */     else
/*     */     {
/* 265 */       relationTableAlias = "";
/* 266 */       relatedTableAlias = "";
/*     */     }
/*     */ 
/* 269 */     JDBCFunctionMappingMetaData selectTemplate = getSelectTemplate(cmrField);
/* 270 */     return selectTemplate == null ? getPlainSQL(keyCount, myKeyFields, relationTableAlias, relatedKeyFields, preloadMask, cmrField, relatedTableAlias, relationTable, join, relatedTable) : getSQLByTemplate(keyCount, myKeyFields, relationTableAlias, relatedKeyFields, preloadMask, cmrField, relatedTableAlias, relationTable, join, relatedTable, selectTemplate);
/*     */   }
/*     */ 
/*     */   private JDBCCMPFieldBridge[] getMyKeyFields(JDBCCMRFieldBridge cmrField)
/*     */   {
/* 299 */     if (cmrField.getRelationMetaData().isTableMappingStyle())
/*     */     {
/* 302 */       return (JDBCCMPFieldBridge[])(JDBCCMPFieldBridge[])cmrField.getTableKeyFields();
/*     */     }
/* 304 */     if (cmrField.getRelatedCMRField().hasForeignKey())
/*     */     {
/* 307 */       return (JDBCCMPFieldBridge[])(JDBCCMPFieldBridge[])cmrField.getRelatedCMRField().getForeignKeyFields();
/*     */     }
/*     */ 
/* 312 */     return (JDBCCMPFieldBridge[])(JDBCCMPFieldBridge[])this.entity.getPrimaryKeyFields();
/*     */   }
/*     */ 
/*     */   private static JDBCCMPFieldBridge[] getRelatedKeyFields(JDBCCMRFieldBridge cmrField)
/*     */   {
/* 318 */     if (cmrField.getRelationMetaData().isTableMappingStyle())
/*     */     {
/* 321 */       return (JDBCCMPFieldBridge[])(JDBCCMPFieldBridge[])cmrField.getRelatedCMRField().getTableKeyFields();
/*     */     }
/* 323 */     if (cmrField.getRelatedCMRField().hasForeignKey())
/*     */     {
/* 326 */       return (JDBCCMPFieldBridge[])(JDBCCMPFieldBridge[])cmrField.getRelatedJDBCEntity().getPrimaryKeyFields();
/*     */     }
/*     */ 
/* 331 */     return (JDBCCMPFieldBridge[])(JDBCCMPFieldBridge[])cmrField.getForeignKeyFields();
/*     */   }
/*     */ 
/*     */   private static boolean[] getPreloadMask(JDBCCMRFieldBridge cmrField)
/*     */   {
/* 337 */     boolean[] preloadMask = null;
/* 338 */     if (cmrField.getReadAhead().isOnFind())
/*     */     {
/* 340 */       JDBCEntityBridge relatedEntity = cmrField.getRelatedJDBCEntity();
/* 341 */       String eagerLoadGroup = cmrField.getReadAhead().getEagerLoadGroup();
/* 342 */       preloadMask = relatedEntity.getLoadGroupMask(eagerLoadGroup);
/*     */     }
/* 344 */     return preloadMask;
/*     */   }
/*     */ 
/*     */   private String getQualifiedRelationTable(JDBCCMRFieldBridge cmrField)
/*     */   {
/* 349 */     if (cmrField.getRelationMetaData().isTableMappingStyle())
/*     */     {
/* 352 */       return cmrField.getQualifiedTableName();
/*     */     }
/* 354 */     if (cmrField.getRelatedCMRField().hasForeignKey())
/*     */     {
/* 357 */       return cmrField.getRelatedJDBCEntity().getQualifiedTableName();
/*     */     }
/*     */ 
/* 362 */     return this.entity.getQualifiedTableName();
/*     */   }
/*     */ 
/*     */   private String getRelationTable(JDBCCMRFieldBridge cmrField)
/*     */   {
/* 368 */     if (cmrField.getRelationMetaData().isTableMappingStyle())
/*     */     {
/* 371 */       return cmrField.getTableName();
/*     */     }
/* 373 */     if (cmrField.getRelatedCMRField().hasForeignKey())
/*     */     {
/* 376 */       return cmrField.getRelatedJDBCEntity().getTableName();
/*     */     }
/*     */ 
/* 381 */     return this.entity.getTableName();
/*     */   }
/*     */ 
/*     */   private JDBCFunctionMappingMetaData getSelectTemplate(JDBCCMRFieldBridge cmrField)
/*     */     throws DeploymentException
/*     */   {
/* 388 */     JDBCFunctionMappingMetaData selectTemplate = null;
/* 389 */     if (cmrField.getRelationMetaData().isTableMappingStyle())
/*     */     {
/* 392 */       if (cmrField.getRelationMetaData().hasRowLocking())
/*     */       {
/* 394 */         selectTemplate = cmrField.getRelationMetaData().getTypeMapping().getRowLockingTemplate();
/*     */ 
/* 396 */         if (selectTemplate == null)
/*     */         {
/* 398 */           throw new IllegalStateException("row-locking is not allowed for this type of datastore");
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/* 403 */     else if (cmrField.getRelatedCMRField().hasForeignKey())
/*     */     {
/* 406 */       if (cmrField.getRelatedJDBCEntity().getMetaData().hasRowLocking())
/*     */       {
/* 408 */         selectTemplate = cmrField.getRelatedJDBCEntity().getMetaData().getTypeMapping().getRowLockingTemplate();
/*     */ 
/* 410 */         if (selectTemplate == null)
/*     */         {
/* 412 */           throw new IllegalStateException("row-locking is not allowed for this type of datastore");
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/* 420 */     else if (this.entity.getMetaData().hasRowLocking())
/*     */     {
/* 422 */       selectTemplate = this.entity.getMetaData().getTypeMapping().getRowLockingTemplate();
/* 423 */       if (selectTemplate == null)
/*     */       {
/* 425 */         throw new IllegalStateException("row-locking is not allowed for this type of datastore");
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 430 */     return selectTemplate;
/*     */   }
/*     */ 
/*     */   private static String getPlainSQL(int keyCount, JDBCCMPFieldBridge[] myKeyFields, String relationTableAlias, JDBCCMPFieldBridge[] relatedKeyFields, boolean[] preloadMask, JDBCCMRFieldBridge cmrField, String relatedTableAlias, String relationTable, boolean join, String relatedTable)
/*     */   {
/* 447 */     StringBuffer sql = new StringBuffer(400);
/* 448 */     sql.append("SELECT ");
/*     */ 
/* 450 */     if (keyCount > 1)
/*     */     {
/* 452 */       SQLUtil.getColumnNamesClause(myKeyFields, relationTableAlias, sql).append(", ");
/*     */     }
/*     */ 
/* 455 */     SQLUtil.getColumnNamesClause(relatedKeyFields, relationTableAlias, sql);
/*     */ 
/* 457 */     if (preloadMask != null)
/*     */     {
/* 459 */       SQLUtil.appendColumnNamesClause(cmrField.getRelatedJDBCEntity().getTableFields(), preloadMask, relatedTableAlias, sql);
/*     */     }
/*     */ 
/* 469 */     sql.append(" FROM ").append(relationTable);
/* 470 */     if (join)
/*     */     {
/* 472 */       sql.append(' ').append(relationTableAlias).append(", ").append(relatedTable).append(' ').append(relatedTableAlias);
/*     */     }
/*     */ 
/* 483 */     sql.append(" WHERE ");
/*     */ 
/* 485 */     if (join)
/*     */     {
/* 488 */       sql.append('(');
/* 489 */       SQLUtil.getJoinClause(relatedKeyFields, relationTableAlias, cmrField.getRelatedJDBCEntity().getPrimaryKeyFields(), relatedTableAlias, sql).append(')').append(" AND ").append('(');
/*     */     }
/*     */ 
/* 501 */     String pkWhere = SQLUtil.getWhereClause(myKeyFields, relationTableAlias, new StringBuffer(50)).toString();
/* 502 */     for (int i = 0; i < keyCount; i++)
/*     */     {
/* 504 */       if (i > 0)
/* 505 */         sql.append(" OR ");
/* 506 */       sql.append('(').append(pkWhere).append(')');
/*     */     }
/*     */ 
/* 509 */     if (join) {
/* 510 */       sql.append(')');
/*     */     }
/* 512 */     return sql.toString();
/*     */   }
/*     */ 
/*     */   private static String getSQLByTemplate(int keyCount, JDBCCMPFieldBridge[] myKeyFields, String relationTableAlias, JDBCCMPFieldBridge[] relatedKeyFields, boolean[] preloadMask, JDBCCMRFieldBridge cmrField, String relatedTableAlias, String relationTable, boolean join, String relatedTable, JDBCFunctionMappingMetaData selectTemplate)
/*     */   {
/* 530 */     StringBuffer columnNamesClause = new StringBuffer(100);
/* 531 */     if (keyCount > 1)
/*     */     {
/* 533 */       SQLUtil.getColumnNamesClause(myKeyFields, relationTableAlias, columnNamesClause).append(", ");
/*     */     }
/*     */ 
/* 536 */     SQLUtil.getColumnNamesClause(relatedKeyFields, relationTableAlias, columnNamesClause);
/* 537 */     if (preloadMask != null)
/*     */     {
/* 539 */       SQLUtil.appendColumnNamesClause(cmrField.getRelatedJDBCEntity().getTableFields(), preloadMask, relatedTableAlias, columnNamesClause);
/*     */     }
/*     */ 
/* 549 */     StringBuffer fromClause = new StringBuffer(100);
/* 550 */     fromClause.append(relationTable);
/* 551 */     if (join)
/*     */     {
/* 553 */       fromClause.append(' ').append(relationTableAlias).append(", ").append(relatedTable).append(' ').append(relatedTableAlias);
/*     */     }
/*     */ 
/* 564 */     StringBuffer whereClause = new StringBuffer(150);
/*     */ 
/* 566 */     if (join)
/*     */     {
/* 569 */       whereClause.append('(');
/* 570 */       SQLUtil.getJoinClause(relatedKeyFields, relationTableAlias, cmrField.getRelatedJDBCEntity().getPrimaryKeyFields(), relatedTableAlias, whereClause).append(')').append(" AND ").append('(');
/*     */     }
/*     */ 
/* 582 */     String pkWhere = SQLUtil.getWhereClause(myKeyFields, relationTableAlias, new StringBuffer(50)).toString();
/* 583 */     for (int i = 0; i < keyCount; i++)
/*     */     {
/* 585 */       if (i > 0)
/*     */       {
/* 587 */         whereClause.append(" OR ");
/*     */       }
/* 589 */       whereClause.append('(').append(pkWhere).append(')');
/*     */     }
/*     */ 
/* 592 */     if (join)
/*     */     {
/* 594 */       whereClause.append(')');
/*     */     }
/*     */ 
/* 600 */     String[] args = { columnNamesClause.toString(), fromClause.toString(), whereClause.toString(), null };
/*     */ 
/* 606 */     return selectTemplate.getFunctionSql(args, new StringBuffer(500)).toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCLoadRelationCommand
 * JD-Core Version:    0.6.0
 */