/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.util.List;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.NoSuchEntityException;
/*     */ import javax.sql.DataSource;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge.FieldIterator;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCFunctionMappingMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public final class JDBCLoadEntityCommand
/*     */ {
/*     */   private final JDBCStoreManager manager;
/*     */   private final JDBCEntityBridge entity;
/*     */   private final Logger log;
/*     */   private final JDBCFunctionMappingMetaData rowLockingTemplate;
/*     */ 
/*     */   public JDBCLoadEntityCommand(JDBCStoreManager manager)
/*     */     throws DeploymentException
/*     */   {
/*  65 */     this.manager = manager;
/*  66 */     this.entity = ((JDBCEntityBridge)manager.getEntityBridge());
/*  67 */     boolean rowLocking = this.entity.getMetaData().hasRowLocking();
/*  68 */     this.rowLockingTemplate = (rowLocking ? this.entity.getMetaData().getTypeMapping().getRowLockingTemplate() : null);
/*     */ 
/*  71 */     this.log = Logger.getLogger(getClass().getName() + "." + manager.getMetaData().getName());
/*     */   }
/*     */ 
/*     */   public boolean execute(EntityEnterpriseContext ctx, boolean failIfNotFound)
/*     */   {
/*  88 */     return execute(null, ctx, failIfNotFound);
/*     */   }
/*     */ 
/*     */   public void execute(JDBCCMPFieldBridge requiredField, EntityEnterpriseContext ctx)
/*     */   {
/*  98 */     execute(requiredField, ctx, true);
/*     */   }
/*     */ 
/*     */   private boolean execute(JDBCCMPFieldBridge requiredField, EntityEnterpriseContext ctx, boolean failIfNotFound)
/*     */   {
/* 118 */     Object id = ctx.getId();
/*     */ 
/* 120 */     this.entity.injectPrimaryKeyIntoInstance(ctx, id);
/*     */ 
/* 123 */     ReadAheadCache readAheadCache = this.manager.getReadAheadCache();
/*     */ 
/* 126 */     if (readAheadCache.load(ctx))
/*     */     {
/* 128 */       if ((requiredField == null) || ((requiredField != null) && (requiredField.isLoaded(ctx))))
/*     */       {
/* 130 */         return true;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 135 */     ReadAheadCache.EntityReadAheadInfo info = readAheadCache.getEntityReadAheadInfo(id);
/*     */ 
/* 138 */     JDBCEntityBridge.FieldIterator loadIter = this.entity.getLoadIterator(requiredField, info.getReadAhead(), ctx);
/* 139 */     if (!loadIter.hasNext()) {
/* 140 */       return true;
/*     */     }
/*     */ 
/* 143 */     List loadKeys = info.getLoadKeys();
/*     */ 
/* 146 */     String sql = this.rowLockingTemplate != null ? getRawLockingSQL(loadIter, loadKeys.size()) : getSQL(loadIter, loadKeys.size());
/*     */ 
/* 148 */     Connection con = null;
/* 149 */     PreparedStatement ps = null;
/* 150 */     ResultSet rs = null;
/*     */     try
/*     */     {
/* 154 */       if (this.log.isDebugEnabled())
/*     */       {
/* 156 */         this.log.debug("Executing SQL: " + sql);
/*     */       }
/*     */ 
/* 160 */       con = this.entity.getDataSource().getConnection();
/* 161 */       ps = con.prepareStatement(sql);
/*     */ 
/* 164 */       if (this.entity.getFetchSize() > 0)
/*     */       {
/* 166 */         ps.setFetchSize(this.entity.getFetchSize());
/*     */       }
/*     */ 
/* 170 */       int paramIndex = 1;
/* 171 */       for (int i = 0; i < loadKeys.size(); i++)
/*     */       {
/* 173 */         paramIndex = this.entity.setPrimaryKeyParameters(ps, paramIndex, loadKeys.get(i));
/*     */       }
/*     */ 
/* 177 */       rs = ps.executeQuery();
/*     */ 
/* 180 */       boolean mainEntityLoaded = false;
/* 181 */       Object[] ref = new Object[1];
/* 182 */       while (rs.next())
/*     */       {
/* 185 */         index = 1;
/*     */ 
/* 188 */         ref[0] = null;
/*     */ 
/* 191 */         Object pk = null;
/* 192 */         if (loadKeys.size() > 1)
/*     */         {
/* 195 */           index = this.entity.loadPrimaryKeyResults(rs, index, ref);
/* 196 */           pk = ref[0];
/*     */         }
/*     */ 
/* 200 */         if ((loadKeys.size() == 1) || (pk.equals(id)))
/*     */         {
/* 203 */           loadIter.reset();
/* 204 */           while (loadIter.hasNext())
/*     */           {
/* 206 */             JDBCCMPFieldBridge field = loadIter.next();
/* 207 */             index = field.loadInstanceResults(rs, index, ctx);
/* 208 */             field.setClean(ctx);
/*     */           }
/* 210 */           mainEntityLoaded = true;
/*     */         }
/*     */         else
/*     */         {
/* 215 */           loadIter.reset();
/* 216 */           while (loadIter.hasNext())
/*     */           {
/* 218 */             JDBCCMPFieldBridge field = loadIter.next();
/*     */ 
/* 220 */             ref[0] = null;
/*     */ 
/* 223 */             index = field.loadArgumentResults(rs, index, ref);
/*     */ 
/* 226 */             readAheadCache.addPreloadData(pk, field, ref[0]);
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 232 */       loadIter.removeAll();
/*     */ 
/* 235 */       if (!mainEntityLoaded)
/*     */       {
/* 237 */         if (failIfNotFound) {
/* 238 */           throw new NoSuchEntityException("Entity not found: primaryKey=" + ctx.getId());
/*     */         }
/* 240 */         index = 0; jsr 42;
/*     */       }
/*     */ 
/* 243 */       index = 1;
/*     */     }
/*     */     catch (EJBException e)
/*     */     {
/*     */       int index;
/* 247 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 251 */       throw new EJBException("Load failed", e);
/*     */     }
/*     */     finally
/*     */     {
/* 255 */       JDBCUtil.safeClose(rs);
/* 256 */       JDBCUtil.safeClose(ps);
/* 257 */       JDBCUtil.safeClose(con);
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getSQL(JDBCEntityBridge.FieldIterator loadIter, int keyCount)
/*     */   {
/* 263 */     StringBuffer sql = new StringBuffer(250);
/* 264 */     sql.append("SELECT ");
/*     */ 
/* 268 */     JDBCFieldBridge[] primaryKeyFields = this.entity.getPrimaryKeyFields();
/* 269 */     if (keyCount > 1)
/*     */     {
/* 271 */       SQLUtil.getColumnNamesClause(primaryKeyFields, sql);
/* 272 */       sql.append(", ");
/*     */     }
/* 274 */     SQLUtil.getColumnNamesClause(loadIter, sql);
/* 275 */     sql.append(" FROM ").append(this.entity.getQualifiedTableName()).append(" WHERE ");
/*     */ 
/* 281 */     String pkWhere = SQLUtil.getWhereClause(primaryKeyFields, new StringBuffer(50)).toString();
/* 282 */     sql.append('(').append(pkWhere).append(')');
/* 283 */     for (int i = 1; i < keyCount; i++)
/*     */     {
/* 285 */       sql.append(" OR ").append('(').append(pkWhere).append(')');
/*     */     }
/*     */ 
/* 288 */     return sql.toString();
/*     */   }
/*     */ 
/*     */   private String getRawLockingSQL(JDBCEntityBridge.FieldIterator loadIter, int keyCount)
/*     */   {
/* 295 */     StringBuffer columnNamesClause = new StringBuffer(250);
/*     */ 
/* 299 */     if (keyCount > 1)
/*     */     {
/* 301 */       SQLUtil.getColumnNamesClause(this.entity.getPrimaryKeyFields(), columnNamesClause);
/* 302 */       columnNamesClause.append(", ");
/*     */     }
/*     */ 
/* 305 */     SQLUtil.getColumnNamesClause(loadIter, columnNamesClause);
/*     */ 
/* 309 */     String tableName = this.entity.getQualifiedTableName();
/*     */ 
/* 313 */     String whereClause = SQLUtil.getWhereClause(this.entity.getPrimaryKeyFields(), new StringBuffer(50)).toString();
/*     */ 
/* 315 */     if (keyCount > 0)
/*     */     {
/* 317 */       StringBuffer sb = new StringBuffer((whereClause.length() + 6) * keyCount + 4);
/* 318 */       for (int i = 0; i < keyCount; i++)
/*     */       {
/* 320 */         if (i > 0)
/* 321 */           sb.append(" OR ");
/* 322 */         sb.append('(').append(whereClause).append(')');
/*     */       }
/* 324 */       whereClause = sb.toString();
/*     */     }
/*     */ 
/* 327 */     String[] args = { columnNamesClause.toString(), tableName, whereClause, null };
/*     */ 
/* 333 */     return this.rowLockingTemplate.getFunctionSql(args, new StringBuffer(300)).toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCLoadEntityCommand
 * JD-Core Version:    0.6.0
 */