/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.sql.DataSource;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMRFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public final class JDBCInsertRelationsCommand
/*     */ {
/*     */   private final Logger log;
/*     */ 
/*     */   public JDBCInsertRelationsCommand(JDBCStoreManager manager)
/*     */   {
/*  45 */     this.log = Logger.getLogger(getClass().getName() + "." + manager.getMetaData().getName());
/*     */   }
/*     */ 
/*     */   public void execute(RelationData relationData)
/*     */   {
/*  52 */     if (relationData.addedRelations.size() == 0) {
/*  53 */       return;
/*     */     }
/*     */ 
/*  56 */     Connection con = null;
/*  57 */     PreparedStatement ps = null;
/*     */ 
/*  59 */     JDBCCMRFieldBridge cmrField = relationData.getLeftCMRField();
/*     */     try
/*     */     {
/*  62 */       String sql = getSQL(relationData);
/*  63 */       boolean debug = this.log.isDebugEnabled();
/*  64 */       if (debug) {
/*  65 */         this.log.debug("Executing SQL: " + sql);
/*     */       }
/*     */ 
/*  68 */       DataSource dataSource = cmrField.getDataSource();
/*  69 */       con = dataSource.getConnection();
/*     */ 
/*  72 */       ps = con.prepareStatement(sql);
/*     */ 
/*  74 */       Iterator pairs = relationData.addedRelations.iterator();
/*     */       int rowsAffected;
/*  75 */       while (pairs.hasNext()) {
/*  76 */         RelationPair pair = (RelationPair)pairs.next();
/*     */ 
/*  79 */         setParameters(ps, relationData, pair);
/*     */ 
/*  81 */         rowsAffected = ps.executeUpdate();
/*     */       }
/*     */     } catch (Exception e) {
/*  84 */       throw new EJBException("Could insert relations into " + cmrField.getQualifiedTableName(), e);
/*     */     }
/*     */     finally {
/*  87 */       JDBCUtil.safeClose(ps);
/*  88 */       JDBCUtil.safeClose(con);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected static String getSQL(RelationData relationData) {
/*  93 */     JDBCCMRFieldBridge left = relationData.getLeftCMRField();
/*  94 */     JDBCCMRFieldBridge right = relationData.getRightCMRField();
/*     */ 
/*  96 */     StringBuffer sql = new StringBuffer(200);
/*  97 */     sql.append("INSERT INTO ").append(left.getQualifiedTableName());
/*     */ 
/*  99 */     sql.append('(');
/* 100 */     SQLUtil.getColumnNamesClause(left.getTableKeyFields(), sql);
/* 101 */     sql.append(", ");
/* 102 */     SQLUtil.getColumnNamesClause(right.getTableKeyFields(), sql);
/* 103 */     sql.append(')');
/*     */ 
/* 105 */     sql.append(" VALUES ").append('(');
/* 106 */     SQLUtil.getValuesClause(left.getTableKeyFields(), sql);
/* 107 */     sql.append(", ");
/* 108 */     SQLUtil.getValuesClause(right.getTableKeyFields(), sql);
/* 109 */     sql.append(')');
/* 110 */     return sql.toString();
/*     */   }
/*     */ 
/*     */   protected static void setParameters(PreparedStatement ps, RelationData relationData, RelationPair pair)
/*     */   {
/* 117 */     int index = 1;
/*     */ 
/* 120 */     Object leftId = pair.getLeftId();
/* 121 */     JDBCCMPFieldBridge[] leftFields = (JDBCCMPFieldBridge[])(JDBCCMPFieldBridge[])relationData.getLeftCMRField().getTableKeyFields();
/* 122 */     for (int i = 0; i < leftFields.length; i++) {
/* 123 */       index = leftFields[i].setPrimaryKeyParameters(ps, index, leftId);
/*     */     }
/*     */ 
/* 126 */     Object rightId = pair.getRightId();
/* 127 */     JDBCCMPFieldBridge[] rightFields = (JDBCCMPFieldBridge[])(JDBCCMPFieldBridge[])relationData.getRightCMRField().getTableKeyFields();
/* 128 */     for (int i = 0; i < rightFields.length; i++)
/* 129 */       index = rightFields[i].setPrimaryKeyParameters(ps, index, rightId);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCInsertRelationsCommand
 * JD-Core Version:    0.6.0
 */