/*    */ package org.jboss.ejb.plugins.cmp.jdbc;
/*    */ 
/*    */ import java.lang.reflect.Method;
/*    */ import java.util.Collection;
/*    */ import java.util.Iterator;
/*    */ import javax.ejb.FinderException;
/*    */ import javax.ejb.ObjectNotFoundException;
/*    */ import org.jboss.ejb.EntityEnterpriseContext;
/*    */ import org.jboss.ejb.GenericEntityObjectFactory;
/*    */ 
/*    */ public final class JDBCFindEntityCommand
/*    */ {
/*    */   private static final String NO_SUCH_ENTITY = "No such entity!";
/*    */   private final JDBCStoreManager manager;
/*    */ 
/*    */   public JDBCFindEntityCommand(JDBCStoreManager manager)
/*    */   {
/* 52 */     this.manager = manager;
/*    */   }
/*    */ 
/*    */   public Object execute(Method finderMethod, Object[] args, EntityEnterpriseContext ctx, GenericEntityObjectFactory factory)
/*    */     throws FinderException
/*    */   {
/* 59 */     JDBCQueryCommand query = this.manager.getQueryManager().getQueryCommand(finderMethod);
/*    */ 
/* 61 */     Collection result = query.execute(finderMethod, args, ctx, factory);
/* 62 */     if (result.isEmpty())
/*    */     {
/* 64 */       throw new ObjectNotFoundException("No such entity!");
/*    */     }
/* 66 */     if (result.size() == 1)
/*    */     {
/* 68 */       return result.iterator().next();
/*    */     }
/*    */ 
/* 72 */     throw new FinderException("More than one entity matches the finder criteria: " + result);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCFindEntityCommand
 * JD-Core Version:    0.6.0
 */