/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ import javax.ejb.FinderException;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.GenericEntityObjectFactory;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractCMPFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCFunctionMappingMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
/*     */ 
/*     */ public final class JDBCFindByPrimaryKeyQuery extends JDBCAbstractQueryCommand
/*     */ {
/*     */   private JDBCStoreManager manager;
/*     */   private boolean rowLocking;
/*     */ 
/*     */   public JDBCFindByPrimaryKeyQuery(JDBCStoreManager manager, JDBCQueryMetaData q)
/*     */     throws DeploymentException
/*     */   {
/*  60 */     super(manager, q);
/*  61 */     this.manager = manager;
/*  62 */     this.rowLocking = manager.getMetaData().hasRowLocking();
/*     */ 
/*  64 */     JDBCEntityBridge entity = (JDBCEntityBridge)manager.getEntityBridge();
/*     */ 
/*  66 */     JDBCTypeMappingMetaData typeMapping = this.manager.getJDBCTypeFactory().getTypeMapping();
/*  67 */     AliasManager aliasManager = new AliasManager(typeMapping.getAliasHeaderPrefix(), typeMapping.getAliasHeaderSuffix(), typeMapping.getAliasMaxLength());
/*     */ 
/*  73 */     String alias = aliasManager.getAlias(entity.getEntityName());
/*     */ 
/*  75 */     StringBuffer select = new StringBuffer(200);
/*  76 */     SQLUtil.getColumnNamesClause(entity.getPrimaryKeyFields(), alias, select);
/*     */ 
/*  78 */     StringBuffer from = new StringBuffer();
/*  79 */     from.append(entity.getQualifiedTableName()).append(' ').append(alias);
/*     */ 
/*  84 */     JDBCReadAheadMetaData readAhead = q.getReadAhead();
/*  85 */     if (readAhead.isOnFind())
/*     */     {
/*  87 */       setEagerLoadGroup(readAhead.getEagerLoadGroup());
/*  88 */       if (getEagerLoadMask() != null)
/*     */       {
/*  90 */         SQLUtil.appendColumnNamesClause(entity.getTableFields(), getEagerLoadMask(), alias, select);
/*     */ 
/*  92 */         List onFindCMRList = JDBCAbstractQueryCommand.getLeftJoinCMRNodes(entity, entity.getQualifiedTableName(), readAhead.getLeftJoins(), null);
/*     */ 
/*  95 */         if (!onFindCMRList.isEmpty())
/*     */         {
/*  97 */           setOnFindCMRList(onFindCMRList);
/*  98 */           JDBCAbstractQueryCommand.leftJoinCMRNodes(alias, onFindCMRList, aliasManager, from);
/*  99 */           JDBCAbstractQueryCommand.appendLeftJoinCMRColumnNames(onFindCMRList, aliasManager, select);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 104 */     StringBuffer where = new StringBuffer();
/* 105 */     SQLUtil.getWhereClause(entity.getPrimaryKeyFields(), alias, where);
/*     */ 
/* 108 */     StringBuffer sql = new StringBuffer(300);
/* 109 */     if ((this.rowLocking) && (readAhead.isOnFind()) && (getEagerLoadMask() != null))
/*     */     {
/* 111 */       JDBCFunctionMappingMetaData rowLockingTemplate = typeMapping.getRowLockingTemplate();
/* 112 */       rowLockingTemplate.getFunctionSql(new Object[] { select, from, where.length() == 0 ? null : where, null }, sql);
/*     */     }
/*     */     else
/*     */     {
/* 124 */       sql.append("SELECT ").append(select).append(" FROM ").append(from).append(" WHERE ").append(where);
/*     */     }
/*     */ 
/* 132 */     setSQL(sql.toString());
/* 133 */     setParameterList(QueryParameter.createPrimaryKeyParameters(0, entity));
/*     */   }
/*     */ 
/*     */   public Collection execute(Method finderMethod, Object[] args, EntityEnterpriseContext ctx, GenericEntityObjectFactory factory)
/*     */     throws FinderException
/*     */   {
/* 140 */     if (this.manager.getReadAheadCache().getPreloadDataMap(args[0], false) != null)
/*     */     {
/* 143 */       Object pk = null;
/* 144 */       JDBCFieldBridge[] pkFields = this.manager.getEntityBridge().getPrimaryKeyFields();
/* 145 */       for (int i = 0; i < pkFields.length; i++)
/*     */       {
/* 147 */         JDBCAbstractCMPFieldBridge pkField = (JDBCAbstractCMPFieldBridge)pkFields[i];
/* 148 */         Object fieldValue = pkField.getPrimaryKeyValue(args[0]);
/* 149 */         pk = pkField.setPrimaryKeyValue(pk, fieldValue);
/*     */       }
/*     */ 
/* 152 */       Object ejbObject = factory.getEntityEJBObject(pk);
/* 153 */       return Collections.singletonList(ejbObject);
/*     */     }
/* 155 */     return super.execute(finderMethod, args, ctx, factory);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCFindByPrimaryKeyQuery
 * JD-Core Version:    0.6.0
 */