/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQlQueryMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ 
/*     */ public final class JDBCEJBQLQuery extends JDBCAbstractQueryCommand
/*     */ {
/*     */   public JDBCEJBQLQuery(JDBCStoreManager manager, JDBCQueryMetaData q)
/*     */     throws DeploymentException
/*     */   {
/*  46 */     super(manager, q);
/*     */ 
/*  48 */     JDBCQlQueryMetaData metadata = (JDBCQlQueryMetaData)q;
/*  49 */     if (getLog().isDebugEnabled())
/*     */     {
/*  51 */       getLog().debug("EJB-QL: " + metadata.getEjbQl());
/*     */     }
/*     */ 
/*  54 */     QLCompiler compiler = JDBCQueryManager.getInstance(metadata.getQLCompilerClass(), manager.getCatalog());
/*     */     try
/*     */     {
/*  58 */       compiler.compileEJBQL(metadata.getEjbQl(), metadata.getMethod().getReturnType(), metadata.getMethod().getParameterTypes(), metadata);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*  66 */       this.log.error(t.getMessage(), t);
/*  67 */       throw new DeploymentException("Error compiling EJB-QL statement for EJB '" + manager.getContainer().getBeanMetaData().getEjbName() + "': " + metadata.getEjbQl(), t);
/*     */     }
/*     */ 
/*  71 */     setSQL(compiler.getSQL());
/*     */ 
/*  74 */     if (compiler.isSelectEntity())
/*     */     {
/*  76 */       JDBCEntityBridge selectEntity = (JDBCEntityBridge)compiler.getSelectEntity();
/*     */ 
/*  79 */       setSelectEntity(selectEntity);
/*     */ 
/*  82 */       JDBCReadAheadMetaData readahead = metadata.getReadAhead();
/*  83 */       if (readahead.isOnFind())
/*     */       {
/*  85 */         setEagerLoadGroup(readahead.getEagerLoadGroup());
/*  86 */         setOnFindCMRList(compiler.getLeftJoinCMRList());
/*     */ 
/*  89 */         if (compiler.isSelectDistinct())
/*     */         {
/*  91 */           boolean[] mask = getEagerLoadMask();
/*  92 */           JDBCFieldBridge[] tableFields = selectEntity.getTableFields();
/*  93 */           for (int i = 0; i < tableFields.length; i++)
/*     */           {
/*  95 */             if ((mask[i] == 0) || (tableFields[i].getJDBCType().isSearchable()))
/*     */               continue;
/*  97 */             mask[i] = false;
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/* 103 */     else if (compiler.isSelectField())
/*     */     {
/* 105 */       setSelectField((JDBCCMPFieldBridge)compiler.getSelectField());
/*     */     }
/*     */     else
/*     */     {
/* 109 */       setSelectFunction(compiler.getSelectFunction(), manager);
/*     */     }
/*     */ 
/* 113 */     setParameterList(compiler.getInputParameters());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCEJBQLQuery
 * JD-Core Version:    0.6.0
 */