/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ import javax.ejb.FinderException;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.GenericEntityObjectFactory;
/*     */ import org.jboss.ejb.plugins.cmp.ejbql.Catalog;
/*     */ import org.jboss.ejb.plugins.cmp.ejbql.SelectFunction;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCDynamicQLQueryMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public final class JDBCDynamicQLQuery extends JDBCAbstractQueryCommand
/*     */ {
/*     */   private final Catalog catalog;
/*     */   private final JDBCDynamicQLQueryMetaData metadata;
/*     */ 
/*     */   public JDBCDynamicQLQuery(JDBCStoreManager manager, JDBCQueryMetaData q)
/*     */     throws DeploymentException
/*     */   {
/*  58 */     super(manager, q);
/*  59 */     this.catalog = manager.getCatalog();
/*  60 */     this.metadata = ((JDBCDynamicQLQueryMetaData)q);
/*     */   }
/*     */ 
/*     */   public Collection execute(Method finderMethod, Object[] args, EntityEnterpriseContext ctx, GenericEntityObjectFactory factory)
/*     */     throws FinderException
/*     */   {
/*  66 */     String dynamicQL = (String)args[0];
/*  67 */     if (getLog().isDebugEnabled())
/*     */     {
/*  69 */       getLog().debug("DYNAMIC-QL: " + dynamicQL);
/*     */     }
/*     */ 
/*  72 */     QLCompiler compiler = null;
/*     */     try
/*     */     {
/*  75 */       compiler = JDBCQueryManager.getInstance(this.metadata.getQLCompilerClass(), this.catalog);
/*     */     }
/*     */     catch (DeploymentException e)
/*     */     {
/*  79 */       throw new FinderException(e.getMessage());
/*     */     }
/*     */ 
/*  83 */     Object[] parameters = (Object[])(Object[])args[1];
/*     */     Class[] parameterTypes;
/*     */     Class[] parameterTypes;
/*  86 */     if (parameters == null)
/*     */     {
/*  88 */       parameterTypes = new Class[0];
/*     */     }
/*     */     else
/*     */     {
/*  93 */       parameterTypes = new Class[parameters.length];
/*  94 */       for (int i = 0; i < parameters.length; i++)
/*     */       {
/*  96 */         if (parameters[i] == null)
/*     */         {
/*  98 */           throw new FinderException("Parameter[" + i + "] is null");
/*     */         }
/* 100 */         parameterTypes[i] = parameters[i].getClass();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 107 */       compiler.compileJBossQL(dynamicQL, finderMethod.getReturnType(), parameterTypes, this.metadata);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 115 */       t.printStackTrace();
/* 116 */       throw new FinderException("Error compiling ejbql: " + t);
/*     */     }
/*     */ 
/* 119 */     int offset = toInt(parameters, compiler.getOffsetParam(), compiler.getOffsetValue());
/* 120 */     int limit = toInt(parameters, compiler.getLimitParam(), compiler.getLimitValue());
/*     */ 
/* 122 */     JDBCEntityBridge selectEntity = null;
/* 123 */     JDBCCMPFieldBridge selectField = null;
/* 124 */     SelectFunction selectFunction = null;
/* 125 */     if (compiler.isSelectEntity())
/*     */     {
/* 127 */       selectEntity = (JDBCEntityBridge)compiler.getSelectEntity();
/*     */     }
/* 129 */     else if (compiler.isSelectField())
/*     */     {
/* 131 */       selectField = (JDBCCMPFieldBridge)compiler.getSelectField();
/*     */     }
/*     */     else
/*     */     {
/* 135 */       selectFunction = compiler.getSelectFunction();
/*     */     }
/*     */ 
/* 140 */     JDBCReadAheadMetaData readahead = this.metadata.getReadAhead();
/*     */     boolean[] mask;
/*     */     List leftJoinCMRList;
/* 141 */     if ((selectEntity != null) && (readahead.isOnFind()))
/*     */     {
/* 143 */       boolean[] mask = selectEntity.getLoadGroupMask(readahead.getEagerLoadGroup());
/* 144 */       boolean modifiedMask = false;
/* 145 */       List leftJoinCMRList = compiler.getLeftJoinCMRList();
/*     */ 
/* 148 */       if (compiler.isSelectDistinct())
/*     */       {
/* 150 */         JDBCFieldBridge[] tableFields = selectEntity.getTableFields();
/* 151 */         for (int i = 0; i < tableFields.length; i++)
/*     */         {
/* 153 */           if ((mask[i] == 0) || (tableFields[i].getJDBCType().isSearchable()))
/*     */             continue;
/* 155 */           if (!modifiedMask)
/*     */           {
/* 157 */             boolean[] original = mask;
/* 158 */             mask = new boolean[original.length];
/* 159 */             System.arraycopy(original, 0, mask, 0, mask.length);
/* 160 */             modifiedMask = true;
/*     */           }
/* 162 */           mask[i] = false;
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 169 */       mask = null;
/* 170 */       leftJoinCMRList = Collections.EMPTY_LIST;
/*     */     }
/*     */ 
/* 174 */     setParameterList(compiler.getInputParameters());
/*     */ 
/* 176 */     EntityContainer con = ((JDBCStoreManager)compiler.getStoreManager()).getContainer();
/* 177 */     factory = (this.metadata.isResultTypeMappingLocal()) && (con.getLocalHomeClass() != null) ? con.getLocalProxyFactory() : con.getProxyFactory();
/*     */ 
/* 180 */     return execute(compiler.getSQL(), parameters, offset, limit, selectEntity, selectField, selectFunction, (JDBCStoreManager)compiler.getStoreManager(), mask, compiler.getInputParameters(), leftJoinCMRList, this.metadata, factory, this.log);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCDynamicQLQuery
 * JD-Core Version:    0.6.0
 */