/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.sql.DataSource;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMRFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public final class JDBCDeleteRelationsCommand
/*     */ {
/*     */   private final Logger log;
/*     */   private int maxKeysInDelete;
/*     */   private String maxKeysStatement;
/*     */ 
/*     */   public JDBCDeleteRelationsCommand(JDBCStoreManager manager)
/*     */   {
/*  49 */     this.log = Logger.getLogger(getClass().getName() + "." + manager.getMetaData().getName());
/*     */ 
/*  54 */     this.maxKeysInDelete = manager.getJDBCTypeFactory().getTypeMapping().getMaxKeysInDelete();
/*     */   }
/*     */ 
/*     */   public void execute(RelationData relationData)
/*     */   {
/*  63 */     if (relationData.removedRelations.size() == 0)
/*     */     {
/*  65 */       return;
/*     */     }
/*     */ 
/*  68 */     Iterator pairs = relationData.removedRelations.iterator();
/*  69 */     int i = 0;
/*  70 */     while (i < relationData.removedRelations.size())
/*     */     {
/*  72 */       String sql = getSQL(relationData, relationData.removedRelations.size() - i);
/*     */ 
/*  74 */       Connection con = null;
/*  75 */       PreparedStatement ps = null;
/*  76 */       JDBCCMRFieldBridge cmrField = relationData.getLeftCMRField();
/*     */       try
/*     */       {
/*  80 */         if (this.log.isDebugEnabled())
/*     */         {
/*  82 */           this.log.debug("Executing SQL: " + sql);
/*     */         }
/*     */ 
/*  86 */         DataSource dataSource = cmrField.getDataSource();
/*  87 */         con = dataSource.getConnection();
/*  88 */         ps = con.prepareStatement(sql);
/*     */ 
/*  91 */         setParameters(ps, relationData, pairs);
/*     */ 
/*  94 */         int rowsAffected = ps.executeUpdate();
/*  95 */         if (this.log.isDebugEnabled())
/*     */         {
/*  97 */           this.log.debug("Rows affected = " + rowsAffected);
/*     */         }
/*     */ 
/* 100 */         i += (this.maxKeysInDelete > 0 ? this.maxKeysInDelete : relationData.removedRelations.size());
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 104 */         throw new EJBException("Could not delete relations from " + cmrField.getQualifiedTableName(), e);
/*     */       }
/*     */       finally
/*     */       {
/* 110 */         JDBCUtil.safeClose(ps);
/* 111 */         JDBCUtil.safeClose(con);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getSQL(RelationData relationData, int keys)
/*     */   {
/* 118 */     if ((this.maxKeysInDelete > 0) && (keys >= this.maxKeysInDelete))
/*     */     {
/* 120 */       if (this.maxKeysStatement == null)
/*     */       {
/* 122 */         this.maxKeysStatement = createSQL(relationData, this.maxKeysInDelete);
/*     */       }
/* 124 */       return this.maxKeysStatement;
/*     */     }
/* 126 */     return createSQL(relationData, keys);
/*     */   }
/*     */ 
/*     */   private static String createSQL(RelationData relationData, int keysInDelete)
/*     */   {
/* 131 */     JDBCCMRFieldBridge left = relationData.getLeftCMRField();
/* 132 */     JDBCCMRFieldBridge right = relationData.getRightCMRField();
/*     */ 
/* 134 */     StringBuffer sql = new StringBuffer(300);
/* 135 */     sql.append("DELETE FROM ").append(left.getQualifiedTableName()).append(" WHERE ");
/*     */ 
/* 139 */     StringBuffer whereClause = new StringBuffer(20);
/* 140 */     whereClause.append('(');
/*     */ 
/* 142 */     SQLUtil.getWhereClause(left.getTableKeyFields(), whereClause).append(" AND ");
/*     */ 
/* 145 */     SQLUtil.getWhereClause(right.getTableKeyFields(), whereClause).append(')');
/*     */ 
/* 147 */     String whereClauseStr = whereClause.toString();
/* 148 */     sql.append(whereClauseStr);
/* 149 */     for (int i = 1; i < keysInDelete; i++)
/*     */     {
/* 151 */       sql.append(" OR ").append(whereClauseStr);
/*     */     }
/*     */ 
/* 154 */     return sql.toString();
/*     */   }
/*     */ 
/*     */   private void setParameters(PreparedStatement ps, RelationData relationData, Iterator pairs)
/*     */     throws Exception
/*     */   {
/* 160 */     int index = 1;
/* 161 */     JDBCCMPFieldBridge[] leftFields = (JDBCCMPFieldBridge[])(JDBCCMPFieldBridge[])relationData.getLeftCMRField().getTableKeyFields();
/* 162 */     JDBCCMPFieldBridge[] rightFields = (JDBCCMPFieldBridge[])(JDBCCMPFieldBridge[])relationData.getRightCMRField().getTableKeyFields();
/* 163 */     int keyIndex = 0;
/* 164 */     while (pairs.hasNext())
/*     */     {
/* 166 */       RelationPair pair = (RelationPair)pairs.next();
/*     */ 
/* 169 */       Object leftId = pair.getLeftId();
/* 170 */       for (int i = 0; i < leftFields.length; i++)
/*     */       {
/* 172 */         index = leftFields[i].setPrimaryKeyParameters(ps, index, leftId);
/*     */       }
/*     */ 
/* 176 */       Object rightId = pair.getRightId();
/* 177 */       for (int i = 0; i < rightFields.length; i++)
/*     */       {
/* 179 */         index = rightFields[i].setPrimaryKeyParameters(ps, index, rightId);
/*     */       }
/*     */ 
/* 182 */       if (this.maxKeysInDelete > 0)
/*     */       {
/* 184 */         keyIndex++;
/* 185 */         if (keyIndex == this.maxKeysInDelete)
/*     */           break;
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCDeleteRelationsCommand
 * JD-Core Version:    0.6.0
 */