/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.plugins.cmp.bridge.EntityBridgeInvocationHandler;
/*     */ import org.jboss.ejb.plugins.cmp.bridge.EntityBridgeInvocationHandler.FieldGetInvoker;
/*     */ import org.jboss.ejb.plugins.cmp.bridge.EntityBridgeInvocationHandler.FieldSetInvoker;
/*     */ import org.jboss.ejb.plugins.cmp.bridge.FieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.bridge.SelectorBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*     */ import org.jboss.proxy.compiler.InvocationHandler;
/*     */ import org.jboss.proxy.compiler.Proxy;
/*     */ 
/*     */ public final class JDBCCreateBeanClassInstanceCommand
/*     */ {
/*     */   private final JDBCEntityBridge entityBridge;
/*     */   private final Class beanClass;
/*     */   private final Constructor beanProxyConstructor;
/*     */   private final Map fieldMap;
/*     */   private final Map selectorMap;
/*     */ 
/*     */   public JDBCCreateBeanClassInstanceCommand(JDBCStoreManager manager)
/*     */     throws Exception
/*     */   {
/*  60 */     EntityContainer theContainer = manager.getContainer();
/*  61 */     this.entityBridge = ((JDBCEntityBridge)manager.getEntityBridge());
/*  62 */     this.beanClass = theContainer.getBeanClass();
/*  63 */     this.fieldMap = createFieldMap();
/*  64 */     this.selectorMap = createSelectorMap();
/*     */ 
/*  66 */     EntityBridgeInvocationHandler handler = new EntityBridgeInvocationHandler(this.fieldMap, this.selectorMap, this.beanClass);
/*  67 */     Class[] classes = { this.beanClass };
/*  68 */     ClassLoader classLoader = this.beanClass.getClassLoader();
/*     */ 
/*  70 */     Object o = Proxy.newProxyInstance(classLoader, classes, handler);
/*     */ 
/*  73 */     this.beanProxyConstructor = o.getClass().getConstructor(new Class[] { InvocationHandler.class });
/*     */ 
/*  76 */     execute();
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*  81 */     Proxy.forgetProxyForClass(this.beanClass);
/*     */   }
/*     */ 
/*     */   public Object execute() throws Exception
/*     */   {
/*  86 */     EntityBridgeInvocationHandler handler = new EntityBridgeInvocationHandler(this.fieldMap, this.selectorMap, this.beanClass);
/*  87 */     return this.beanProxyConstructor.newInstance(new Object[] { handler });
/*     */   }
/*     */ 
/*     */   private Map getAbstractAccessors()
/*     */   {
/*  92 */     Method[] methods = this.beanClass.getMethods();
/*  93 */     Map abstractAccessors = new HashMap(methods.length);
/*     */ 
/*  95 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/*  97 */       if (!Modifier.isAbstract(methods[i].getModifiers()))
/*     */         continue;
/*  99 */       String methodName = methods[i].getName();
/* 100 */       if ((!methodName.startsWith("get")) && (!methodName.startsWith("set")))
/*     */         continue;
/* 102 */       abstractAccessors.put(methodName, methods[i]);
/*     */     }
/*     */ 
/* 106 */     return abstractAccessors;
/*     */   }
/*     */ 
/*     */   private Map createFieldMap() throws DeploymentException
/*     */   {
/* 111 */     Map abstractAccessors = getAbstractAccessors();
/*     */ 
/* 113 */     List fields = this.entityBridge.getFields();
/* 114 */     Map map = new HashMap(fields.size() * 2);
/* 115 */     for (int i = 0; i < fields.size(); i++)
/*     */     {
/* 117 */       FieldBridge field = (FieldBridge)fields.get(i);
/*     */ 
/* 120 */       String fieldName = field.getFieldName();
/* 121 */       String fieldBaseName = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
/*     */ 
/* 123 */       String getterName = "get" + fieldBaseName;
/* 124 */       String setterName = "set" + fieldBaseName;
/*     */ 
/* 127 */       Method getterMethod = (Method)abstractAccessors.get(getterName);
/* 128 */       Method setterMethod = (Method)abstractAccessors.get(setterName);
/*     */ 
/* 131 */       if ((getterMethod != null) && (setterMethod == null))
/*     */       {
/* 133 */         throw new DeploymentException("Getter was found but no setter was found for field " + fieldName + " in entity " + this.entityBridge.getEntityName());
/*     */       }
/*     */ 
/* 136 */       if ((getterMethod == null) && (setterMethod != null))
/*     */       {
/* 138 */         throw new DeploymentException("Setter was found but no getter was found for field " + fieldName + " in entity " + this.entityBridge.getEntityName());
/*     */       }
/*     */ 
/* 141 */       if ((getterMethod == null) || (setterMethod == null)) {
/*     */         continue;
/*     */       }
/* 144 */       map.put(getterMethod.getName(), new EntityBridgeInvocationHandler.FieldGetInvoker(field));
/* 145 */       map.put(setterMethod.getName(), new EntityBridgeInvocationHandler.FieldSetInvoker(field));
/*     */ 
/* 148 */       abstractAccessors.remove(getterName);
/* 149 */       abstractAccessors.remove(setterName);
/*     */     }
/*     */ 
/* 152 */     return Collections.unmodifiableMap(map);
/*     */   }
/*     */ 
/*     */   private Map createSelectorMap()
/*     */   {
/* 157 */     Collection selectors = this.entityBridge.getSelectors();
/* 158 */     Map map = new HashMap(selectors.size());
/* 159 */     for (Iterator iter = selectors.iterator(); iter.hasNext(); )
/*     */     {
/* 161 */       SelectorBridge selector = (SelectorBridge)iter.next();
/*     */ 
/* 163 */       map.put(selector.getMethod(), selector);
/*     */     }
/* 165 */     return Collections.unmodifiableMap(map);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCCreateBeanClassInstanceCommand
 * JD-Core Version:    0.6.0
 */