/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ 
/*     */ public class JDBCCommandFactory
/*     */ {
/*     */   private final Logger log;
/*     */   private final JDBCStoreManager manager;
/*     */ 
/*     */   public JDBCCommandFactory(JDBCStoreManager manager)
/*     */     throws Exception
/*     */   {
/*  47 */     this.manager = manager;
/*     */ 
/*  49 */     this.log = Logger.getLogger(getClass().getName() + "." + manager.getContainer().getBeanMetaData().getEjbName());
/*     */   }
/*     */ 
/*     */   public JDBCQueryCommand createFindByPrimaryKeyQuery(JDBCQueryMetaData q)
/*     */     throws DeploymentException
/*     */   {
/*  58 */     return new JDBCFindByPrimaryKeyQuery(this.manager, q);
/*     */   }
/*     */ 
/*     */   public JDBCQueryCommand createFindAllQuery(JDBCQueryMetaData q) throws DeploymentException
/*     */   {
/*  63 */     return new JDBCFindAllQuery(this.manager, q);
/*     */   }
/*     */ 
/*     */   public JDBCQueryCommand createDeclaredSQLQuery(JDBCQueryMetaData q)
/*     */     throws DeploymentException
/*     */   {
/*  69 */     return new JDBCDeclaredSQLQuery(this.manager, q);
/*     */   }
/*     */ 
/*     */   public JDBCQueryCommand createEJBQLQuery(JDBCQueryMetaData q)
/*     */     throws DeploymentException
/*     */   {
/*  75 */     return new JDBCEJBQLQuery(this.manager, q);
/*     */   }
/*     */ 
/*     */   public JDBCQueryCommand createDynamicQLQuery(JDBCQueryMetaData q)
/*     */     throws DeploymentException
/*     */   {
/*  81 */     return new JDBCDynamicQLQuery(this.manager, q);
/*     */   }
/*     */ 
/*     */   public JDBCQueryCommand createJBossQLQuery(JDBCQueryMetaData q)
/*     */     throws DeploymentException
/*     */   {
/*  87 */     return new JDBCJBossQLQuery(this.manager, q);
/*     */   }
/*     */ 
/*     */   public JDBCQueryCommand createFindByQuery(JDBCQueryMetaData q)
/*     */     throws DeploymentException
/*     */   {
/*  93 */     return new JDBCFindByQuery(this.manager, q);
/*     */   }
/*     */ 
/*     */   public JDBCLoadRelationCommand createLoadRelationCommand()
/*     */   {
/*  98 */     return new JDBCLoadRelationCommand(this.manager);
/*     */   }
/*     */ 
/*     */   public JDBCDeleteRelationsCommand createDeleteRelationsCommand()
/*     */   {
/* 103 */     return new JDBCDeleteRelationsCommand(this.manager);
/*     */   }
/*     */ 
/*     */   public JDBCInsertRelationsCommand createInsertRelationsCommand()
/*     */   {
/* 108 */     return new JDBCInsertRelationsCommand(this.manager);
/*     */   }
/*     */ 
/*     */   public JDBCInitCommand createInitCommand()
/*     */   {
/* 115 */     return new JDBCInitCommand(this.manager);
/*     */   }
/*     */ 
/*     */   public JDBCStartCommand createStartCommand()
/*     */   {
/* 120 */     return new JDBCStartCommand(this.manager);
/*     */   }
/*     */ 
/*     */   public JDBCStopCommand createStopCommand()
/*     */   {
/* 125 */     return new JDBCStopCommand(this.manager);
/*     */   }
/*     */ 
/*     */   public JDBCDestroyCommand createDestroyCommand()
/*     */   {
/* 130 */     return new JDBCDestroyCommand(this.manager);
/*     */   }
/*     */ 
/*     */   public JDBCCreateBeanClassInstanceCommand createCreateBeanClassInstanceCommand()
/*     */     throws Exception
/*     */   {
/* 139 */     return new JDBCCreateBeanClassInstanceCommand(this.manager);
/*     */   }
/*     */ 
/*     */   public JDBCInitEntityCommand createInitEntityCommand()
/*     */   {
/* 144 */     return new JDBCInitEntityCommand(this.manager);
/*     */   }
/*     */ 
/*     */   public JDBCFindEntityCommand createFindEntityCommand()
/*     */   {
/* 149 */     return new JDBCFindEntityCommand(this.manager);
/*     */   }
/*     */ 
/*     */   public JDBCFindEntitiesCommand createFindEntitiesCommand()
/*     */   {
/* 154 */     return new JDBCFindEntitiesCommand(this.manager);
/*     */   }
/*     */ 
/*     */   public JDBCCreateCommand createCreateEntityCommand()
/*     */     throws DeploymentException
/*     */   {
/*     */     JDBCCreateCommand cec;
/*     */     try
/*     */     {
/* 164 */       cec = (JDBCCreateCommand)this.manager.getMetaData().getEntityCommand().getCommandClass().newInstance();
/*     */ 
/* 166 */       cec.init(this.manager);
/*     */     }
/*     */     catch (DeploymentException de)
/*     */     {
/* 170 */       throw de;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 174 */       throw new DeploymentException("Couldn't create entity command: ", e);
/*     */     }
/*     */ 
/* 177 */     if (this.log.isDebugEnabled()) {
/* 178 */       this.log.debug("entity-command: " + this.manager.getMetaData().getEntityCommand());
/*     */     }
/* 180 */     return cec;
/*     */   }
/*     */ 
/*     */   public JDBCPostCreateEntityCommand createPostCreateEntityCommand()
/*     */   {
/* 187 */     return new JDBCPostCreateEntityCommand(this.manager);
/*     */   }
/*     */ 
/*     */   public JDBCRemoveEntityCommand createRemoveEntityCommand()
/*     */     throws DeploymentException
/*     */   {
/* 195 */     return new JDBCRemoveEntityCommand(this.manager);
/*     */   }
/*     */ 
/*     */   public JDBCLoadEntityCommand createLoadEntityCommand() throws DeploymentException
/*     */   {
/* 200 */     return new JDBCLoadEntityCommand(this.manager);
/*     */   }
/*     */ 
/*     */   public JDBCIsModifiedCommand createIsModifiedCommand()
/*     */   {
/* 205 */     return new JDBCIsModifiedCommand(this.manager);
/*     */   }
/*     */ 
/*     */   public JDBCStoreEntityCommand createStoreEntityCommand()
/*     */   {
/* 210 */     return new JDBCStoreEntityCommand(this.manager);
/*     */   }
/*     */ 
/*     */   public JDBCActivateEntityCommand createActivateEntityCommand()
/*     */   {
/* 216 */     return new JDBCActivateEntityCommand(this.manager);
/*     */   }
/*     */ 
/*     */   public JDBCPassivateEntityCommand createPassivateEntityCommand()
/*     */   {
/* 221 */     return new JDBCPassivateEntityCommand(this.manager);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCCommandFactory
 * JD-Core Version:    0.6.0
 */