/*      */ package org.jboss.ejb.plugins.cmp.jdbc;
/*      */ 
/*      */ import java.lang.reflect.Method;
/*      */ import java.sql.Connection;
/*      */ import java.sql.PreparedStatement;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.SQLException;
/*      */ import java.util.AbstractCollection;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collection;
/*      */ import java.util.Collections;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.NoSuchElementException;
/*      */ import java.util.Set;
/*      */ import java.util.StringTokenizer;
/*      */ import javax.ejb.EJBException;
/*      */ import javax.ejb.FinderException;
/*      */ import javax.sql.DataSource;
/*      */ import javax.transaction.Synchronization;
/*      */ import javax.transaction.Transaction;
/*      */ import javax.transaction.TransactionManager;
/*      */ import org.jboss.deployment.DeploymentException;
/*      */ import org.jboss.ejb.EntityContainer;
/*      */ import org.jboss.ejb.EntityEnterpriseContext;
/*      */ import org.jboss.ejb.GenericEntityObjectFactory;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.SelectFunction;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMRFieldBridge;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCLeftJoinMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationshipRoleMetaData;
/*      */ import org.jboss.logging.Logger;
/*      */ 
/*      */ public abstract class JDBCAbstractQueryCommand
/*      */   implements JDBCQueryCommand
/*      */ {
/*      */   private JDBCQueryMetaData queryMetaData;
/*      */   protected Logger log;
/*      */   private JDBCStoreManager selectManager;
/*      */   private JDBCEntityBridge selectEntity;
/*      */   private JDBCCMPFieldBridge selectField;
/*      */   private SelectFunction selectFunction;
/*      */   private boolean[] eagerLoadMask;
/*      */   private String eagerLoadGroup;
/*      */   private String sql;
/*      */   private int offsetParam;
/*      */   private int offsetValue;
/*      */   private int limitParam;
/*      */   private int limitValue;
/*   83 */   private List parameters = new ArrayList(0);
/*   84 */   private List onFindCMRList = Collections.EMPTY_LIST;
/*      */   private QueryCollectionFactory collectionFactory;
/*      */ 
/*      */   public JDBCAbstractQueryCommand(JDBCStoreManager manager, JDBCQueryMetaData q)
/*      */     throws DeploymentException
/*      */   {
/*   90 */     this.log = Logger.getLogger(getClass().getName() + "." + manager.getMetaData().getName() + "#" + q.getMethod().getName());
/*      */ 
/*   96 */     this.queryMetaData = q;
/*   97 */     this.collectionFactory = (q.isLazyResultSetLoading() ? new LazyCollectionFactory() : new EagerCollectionFactory());
/*      */ 
/*  103 */     setSelectEntity((JDBCEntityBridge)manager.getEntityBridge());
/*      */   }
/*      */ 
/*      */   public void setOffsetValue(int offsetValue)
/*      */   {
/*  108 */     this.offsetValue = offsetValue;
/*      */   }
/*      */ 
/*      */   public void setLimitValue(int limitValue)
/*      */   {
/*  113 */     this.limitValue = limitValue;
/*      */   }
/*      */ 
/*      */   public void setOffsetParam(int offsetParam)
/*      */   {
/*  118 */     this.offsetParam = offsetParam;
/*      */   }
/*      */ 
/*      */   public void setLimitParam(int limitParam)
/*      */   {
/*  123 */     this.limitParam = limitParam;
/*      */   }
/*      */ 
/*      */   public void setOnFindCMRList(List onFindCMRList)
/*      */   {
/*  128 */     this.onFindCMRList = onFindCMRList;
/*      */   }
/*      */ 
/*      */   public JDBCStoreManager getSelectManager()
/*      */   {
/*  133 */     return this.selectManager;
/*      */   }
/*      */ 
/*      */   public Collection execute(Method finderMethod, Object[] args, EntityEnterpriseContext ctx, GenericEntityObjectFactory factory)
/*      */     throws FinderException
/*      */   {
/*  142 */     int offset = toInt(args, this.offsetParam, this.offsetValue);
/*  143 */     int limit = toInt(args, this.limitParam, this.limitValue);
/*  144 */     return execute(this.sql, args, offset, limit, this.selectEntity, this.selectField, this.selectFunction, this.selectManager, this.eagerLoadMask, this.parameters, this.onFindCMRList, this.queryMetaData, factory, this.log);
/*      */   }
/*      */ 
/*      */   protected static int toInt(Object[] params, int paramNumber, int defaultValue)
/*      */   {
/*  162 */     if (paramNumber == 0)
/*      */     {
/*  164 */       return defaultValue;
/*      */     }
/*  166 */     Integer arg = (Integer)params[(paramNumber - 1)];
/*  167 */     return arg.intValue();
/*      */   }
/*      */ 
/*      */   protected Collection execute(String sql, Object[] args, int offset, int limit, JDBCEntityBridge selectEntity, JDBCCMPFieldBridge selectField, SelectFunction selectFunction, JDBCStoreManager selectManager, boolean[] eagerLoadMask, List parameters, List onFindCMRList, JDBCQueryMetaData queryMetaData, GenericEntityObjectFactory factory, Logger log)
/*      */     throws FinderException
/*      */   {
/*  186 */     int count = offset;
/*  187 */     Connection con = null;
/*  188 */     PreparedStatement ps = null;
/*  189 */     ResultSet rs = null;
/*  190 */     JDBCEntityBridge entityBridge = (JDBCEntityBridge)selectManager.getEntityBridge();
/*  191 */     boolean throwRuntimeExceptions = entityBridge.getMetaData().getThrowRuntimeExceptions();
/*      */ 
/*  195 */     if (throwRuntimeExceptions)
/*      */     {
/*      */       try
/*      */       {
/*  199 */         con = entityBridge.getDataSource().getConnection();
/*      */       }
/*      */       catch (SQLException sqle)
/*      */       {
/*  203 */         EJBException ejbe = new EJBException("Could not get a connection; " + sqle);
/*  204 */         ejbe.initCause(sqle);
/*  205 */         throw ejbe;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  213 */       if (log.isDebugEnabled())
/*      */       {
/*  215 */         log.debug("Executing SQL: " + sql);
/*  216 */         if ((limit != 0) || (offset != 0))
/*      */         {
/*  218 */           log.debug("Query offset=" + offset + ", limit=" + limit);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  223 */       if (!throwRuntimeExceptions)
/*      */       {
/*  225 */         con = entityBridge.getDataSource().getConnection();
/*      */       }
/*  227 */       ps = con.prepareStatement(sql);
/*      */ 
/*  230 */       if (entityBridge.getFetchSize() > 0)
/*      */       {
/*  232 */         ps.setFetchSize(entityBridge.getFetchSize());
/*      */       }
/*      */ 
/*  236 */       for (int i = 0; i < parameters.size(); i++)
/*      */       {
/*  238 */         QueryParameter parameter = (QueryParameter)parameters.get(i);
/*  239 */         parameter.set(log, ps, i + 1, args);
/*      */       }
/*      */ 
/*  243 */       rs = ps.executeQuery();
/*      */ 
/*  246 */       while ((count > 0) && (rs.next()))
/*      */       {
/*  248 */         count--;
/*      */       }
/*      */ 
/*  251 */       count = limit;
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  255 */       JDBCUtil.safeClose(rs);
/*  256 */       JDBCUtil.safeClose(ps);
/*  257 */       JDBCUtil.safeClose(con);
/*      */ 
/*  259 */       log.error("Find failed", e);
/*  260 */       FinderException fe = new FinderException("Find failed: " + e);
/*  261 */       fe.initCause(e);
/*  262 */       throw fe;
/*      */     }
/*      */ 
/*  265 */     return this.collectionFactory.createCollection(con, ps, rs, limit, count, selectEntity, selectField, selectFunction, selectManager, onFindCMRList, eagerLoadMask, factory);
/*      */   }
/*      */ 
/*      */   protected Logger getLog()
/*      */   {
/*  281 */     return this.log;
/*      */   }
/*      */ 
/*      */   protected void setSQL(String sql)
/*      */   {
/*  286 */     this.sql = sql;
/*  287 */     if (this.log.isDebugEnabled())
/*      */     {
/*  289 */       this.log.debug("SQL: " + sql);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void setParameterList(List p)
/*      */   {
/*  295 */     for (int i = 0; i < p.size(); i++)
/*      */     {
/*  297 */       if ((p.get(i) instanceof QueryParameter))
/*      */         continue;
/*  299 */       throw new IllegalArgumentException("Element " + i + " of list " + "is not an instance of QueryParameter, but " + p.get(i).getClass().getName());
/*      */     }
/*      */ 
/*  306 */     this.parameters = new ArrayList(p);
/*      */   }
/*      */ 
/*      */   protected JDBCEntityBridge getSelectEntity()
/*      */   {
/*  311 */     return this.selectEntity;
/*      */   }
/*      */ 
/*      */   protected void setSelectEntity(JDBCEntityBridge selectEntity)
/*      */     throws DeploymentException
/*      */   {
/*  317 */     if ((this.queryMetaData.getMethod().getName().startsWith("find")) && (this.selectEntity != null) && (this.selectEntity != selectEntity))
/*      */     {
/*  320 */       throw new DeploymentException("Finder " + this.queryMetaData.getMethod().getName() + " defined on " + this.selectEntity.getEntityName() + " should return only instances of " + this.selectEntity.getEntityName() + " but the query results in instances of " + selectEntity.getEntityName());
/*      */     }
/*      */ 
/*  326 */     this.selectField = null;
/*  327 */     this.selectFunction = null;
/*  328 */     this.selectEntity = selectEntity;
/*  329 */     this.selectManager = ((JDBCStoreManager)selectEntity.getManager());
/*      */   }
/*      */ 
/*      */   protected JDBCCMPFieldBridge getSelectField()
/*      */   {
/*  334 */     return this.selectField;
/*      */   }
/*      */ 
/*      */   protected void setSelectField(JDBCCMPFieldBridge selectField)
/*      */   {
/*  339 */     this.selectEntity = null;
/*  340 */     this.selectFunction = null;
/*  341 */     this.selectField = selectField;
/*  342 */     this.selectManager = ((JDBCStoreManager)selectField.getManager());
/*      */   }
/*      */ 
/*      */   protected void setSelectFunction(SelectFunction func, JDBCStoreManager manager)
/*      */   {
/*  347 */     this.selectEntity = null;
/*  348 */     this.selectField = null;
/*  349 */     this.selectFunction = func;
/*  350 */     this.selectManager = manager;
/*      */   }
/*      */ 
/*      */   protected void setEagerLoadGroup(String eagerLoadGroup)
/*      */   {
/*  355 */     this.eagerLoadGroup = eagerLoadGroup;
/*  356 */     boolean[] originalMask = this.selectEntity.getLoadGroupMask(eagerLoadGroup);
/*  357 */     this.eagerLoadMask = new boolean[originalMask.length];
/*  358 */     System.arraycopy(originalMask, 0, this.eagerLoadMask, 0, this.eagerLoadMask.length);
/*      */   }
/*      */ 
/*      */   protected String getEagerLoadGroup()
/*      */   {
/*  363 */     return this.eagerLoadGroup;
/*      */   }
/*      */ 
/*      */   protected boolean[] getEagerLoadMask()
/*      */   {
/*  368 */     return this.eagerLoadMask;
/*      */   }
/*      */ 
/*      */   protected String parseParameters(String sql)
/*      */     throws DeploymentException
/*      */   {
/*  383 */     StringBuffer sqlBuf = new StringBuffer();
/*  384 */     ArrayList params = new ArrayList();
/*      */ 
/*  387 */     if (sql != null)
/*      */     {
/*  389 */       sql = sql.trim();
/*      */ 
/*  391 */       StringTokenizer tokens = new StringTokenizer(sql, "{}", true);
/*  392 */       while (tokens.hasMoreTokens())
/*      */       {
/*  394 */         String token = tokens.nextToken();
/*  395 */         if (token.equals("{"))
/*      */         {
/*  397 */           token = tokens.nextToken();
/*  398 */           if (Character.isDigit(token.charAt(0)))
/*      */           {
/*  400 */             QueryParameter parameter = new QueryParameter(this.selectManager, this.queryMetaData.getMethod(), token);
/*      */ 
/*  404 */             sqlBuf.append("?");
/*  405 */             params.add(parameter);
/*      */ 
/*  407 */             if (!tokens.nextToken().equals("}"))
/*      */             {
/*  409 */               throw new DeploymentException("Invalid parameter - missing closing '}' : " + sql);
/*      */             }
/*      */ 
/*      */           }
/*      */           else
/*      */           {
/*  416 */             sqlBuf.append("{").append(token);
/*      */           }
/*      */ 
/*      */         }
/*      */         else
/*      */         {
/*  422 */           sqlBuf.append(token);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  427 */     this.parameters = params;
/*      */ 
/*  429 */     return sqlBuf.toString();
/*      */   }
/*      */ 
/*      */   public static List getLeftJoinCMRNodes(JDBCEntityBridge entity, String path, Iterator leftJoinIter, Set declaredPaths)
/*      */     throws DeploymentException
/*      */   {
/*  439 */     if (leftJoinIter.hasNext())
/*      */     {
/*  441 */       List leftJoinCMRNodes = new ArrayList();
/*  442 */       while (leftJoinIter.hasNext())
/*      */       {
/*  444 */         JDBCLeftJoinMetaData leftJoin = (JDBCLeftJoinMetaData)leftJoinIter.next();
/*  445 */         JDBCCMRFieldBridge cmrField = entity.getCMRFieldByName(leftJoin.getCmrField());
/*  446 */         if (cmrField == null)
/*      */         {
/*  448 */           throw new DeploymentException("cmr-field in left-join was not found: cmr-field=" + leftJoin.getCmrField() + ", entity=" + entity.getEntityName());
/*      */         }
/*      */ 
/*  453 */         JDBCEntityBridge relatedEntity = cmrField.getRelatedJDBCEntity();
/*  454 */         String childPath = path + '.' + cmrField.getFieldName();
/*  455 */         if (declaredPaths != null)
/*      */         {
/*  457 */           declaredPaths.add(childPath);
/*      */         }
/*      */ 
/*  460 */         List subNodes = getLeftJoinCMRNodes(relatedEntity, childPath, leftJoin.getLeftJoins(), declaredPaths);
/*      */ 
/*  462 */         boolean[] mask = relatedEntity.getLoadGroupMask(leftJoin.getEagerLoadGroup());
/*  463 */         LeftJoinCMRNode node = new LeftJoinCMRNode(childPath, cmrField, mask, subNodes);
/*  464 */         leftJoinCMRNodes.add(node);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  469 */     List leftJoinCMRNodes = Collections.EMPTY_LIST;
/*      */ 
/*  472 */     return leftJoinCMRNodes;
/*      */   }
/*      */ 
/*      */   public static final void leftJoinCMRNodes(String alias, List onFindCMRNodes, AliasManager aliasManager, StringBuffer sb)
/*      */   {
/*  480 */     for (int i = 0; i < onFindCMRNodes.size(); i++)
/*      */     {
/*  482 */       LeftJoinCMRNode node = (LeftJoinCMRNode)onFindCMRNodes.get(i);
/*  483 */       JDBCCMRFieldBridge cmrField = node.cmrField;
/*  484 */       JDBCEntityBridge relatedEntity = cmrField.getRelatedJDBCEntity();
/*  485 */       String relatedAlias = aliasManager.getAlias(node.path);
/*      */ 
/*  487 */       JDBCRelationMetaData relation = cmrField.getMetaData().getRelationMetaData();
/*  488 */       if (relation.isTableMappingStyle())
/*      */       {
/*  490 */         String relTableAlias = aliasManager.getRelationTableAlias(node.path);
/*  491 */         sb.append(" LEFT OUTER JOIN ").append(cmrField.getQualifiedTableName()).append(' ').append(relTableAlias).append(" ON ");
/*      */ 
/*  496 */         SQLUtil.getRelationTableJoinClause(cmrField, alias, relTableAlias, sb);
/*      */ 
/*  498 */         sb.append(" LEFT OUTER JOIN ").append(relatedEntity.getQualifiedTableName()).append(' ').append(relatedAlias).append(" ON ");
/*      */ 
/*  503 */         SQLUtil.getRelationTableJoinClause(cmrField.getRelatedCMRField(), relatedAlias, relTableAlias, sb);
/*      */       }
/*      */       else
/*      */       {
/*  508 */         sb.append(" LEFT OUTER JOIN ").append(relatedEntity.getQualifiedTableName()).append(' ').append(relatedAlias).append(" ON ");
/*      */ 
/*  513 */         SQLUtil.getJoinClause(cmrField, alias, relatedAlias, sb);
/*      */       }
/*      */ 
/*  519 */       List subNodes = node.onFindCMRNodes;
/*  520 */       if (subNodes.isEmpty())
/*      */         continue;
/*  522 */       leftJoinCMRNodes(relatedAlias, subNodes, aliasManager, sb);
/*      */     }
/*      */   }
/*      */ 
/*      */   public static final void appendLeftJoinCMRColumnNames(List onFindCMRNodes, AliasManager aliasManager, StringBuffer sb)
/*      */   {
/*  531 */     for (int i = 0; i < onFindCMRNodes.size(); i++)
/*      */     {
/*  533 */       LeftJoinCMRNode node = (LeftJoinCMRNode)onFindCMRNodes.get(i);
/*  534 */       JDBCCMRFieldBridge cmrField = node.cmrField;
/*  535 */       JDBCEntityBridge relatedEntity = cmrField.getRelatedJDBCEntity();
/*  536 */       String childAlias = aliasManager.getAlias(node.path);
/*      */ 
/*  539 */       SQLUtil.appendColumnNamesClause(relatedEntity.getPrimaryKeyFields(), childAlias, sb);
/*      */ 
/*  544 */       if (node.eagerLoadMask != null)
/*      */       {
/*  546 */         SQLUtil.appendColumnNamesClause(relatedEntity.getTableFields(), node.eagerLoadMask, childAlias, sb);
/*      */       }
/*      */ 
/*  552 */       List subNodes = node.onFindCMRNodes;
/*  553 */       if (subNodes.isEmpty())
/*      */         continue;
/*  555 */       appendLeftJoinCMRColumnNames(subNodes, aliasManager, sb);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static int loadOnFindCMRFields(Object pk, List onFindCMRNodes, ResultSet rs, int index, Logger log)
/*      */   {
/*  562 */     Object[] ref = new Object[1];
/*  563 */     for (int nodeInd = 0; nodeInd < onFindCMRNodes.size(); nodeInd++)
/*      */     {
/*  565 */       LeftJoinCMRNode node = (LeftJoinCMRNode)onFindCMRNodes.get(nodeInd);
/*  566 */       JDBCCMRFieldBridge cmrField = node.cmrField;
/*  567 */       ReadAheadCache myCache = cmrField.getJDBCStoreManager().getReadAheadCache();
/*  568 */       JDBCEntityBridge relatedEntity = cmrField.getRelatedJDBCEntity();
/*  569 */       ReadAheadCache relatedCache = cmrField.getRelatedManager().getReadAheadCache();
/*      */ 
/*  572 */       ref[0] = null;
/*  573 */       index = relatedEntity.loadPrimaryKeyResults(rs, index, ref);
/*  574 */       Object relatedId = ref[0];
/*  575 */       boolean cacheRelatedData = relatedId != null;
/*      */ 
/*  577 */       if (pk != null)
/*      */       {
/*  579 */         if (cmrField.getMetaData().getRelatedRole().isMultiplicityOne())
/*      */         {
/*  582 */           myCache.addPreloadData(pk, cmrField, relatedId == null ? Collections.EMPTY_LIST : Collections.singletonList(relatedId));
/*      */         }
/*      */         else
/*      */         {
/*  588 */           Collection cachedValue = myCache.getCachedCMRValue(pk, cmrField);
/*  589 */           if (cachedValue == null)
/*      */           {
/*  591 */             cachedValue = new ArrayList();
/*  592 */             myCache.addPreloadData(pk, cmrField, cachedValue);
/*      */           }
/*      */ 
/*  595 */           if (relatedId != null)
/*      */           {
/*  597 */             if (cachedValue.contains(relatedId))
/*      */             {
/*  599 */               cacheRelatedData = false;
/*      */             }
/*      */             else
/*      */             {
/*  603 */               cachedValue.add(relatedId);
/*      */             }
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  610 */       if (node.eagerLoadMask != null)
/*      */       {
/*  612 */         JDBCFieldBridge[] tableFields = relatedEntity.getTableFields();
/*  613 */         for (int fieldInd = 0; fieldInd < tableFields.length; fieldInd++)
/*      */         {
/*  615 */           if (node.eagerLoadMask[fieldInd] == 0)
/*      */             continue;
/*  617 */           JDBCFieldBridge field = tableFields[fieldInd];
/*  618 */           ref[0] = null;
/*  619 */           index = field.loadArgumentResults(rs, index, ref);
/*      */ 
/*  621 */           if (!cacheRelatedData)
/*      */             continue;
/*  623 */           if (log.isTraceEnabled())
/*      */           {
/*  625 */             log.trace("Caching " + relatedEntity.getEntityName() + '[' + relatedId + "]." + field.getFieldName() + "=" + ref[0]);
/*      */           }
/*      */ 
/*  632 */           relatedCache.addPreloadData(relatedId, field, ref[0]);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  638 */       List subNodes = node.onFindCMRNodes;
/*  639 */       if (subNodes.isEmpty())
/*      */         continue;
/*  641 */       index = loadOnFindCMRFields(relatedId, subNodes, rs, index, log);
/*      */     }
/*      */ 
/*  645 */     return index;
/*      */   }
/*      */ 
/*      */   class LazyCollectionFactory
/*      */     implements JDBCAbstractQueryCommand.QueryCollectionFactory
/*      */   {
/*      */     LazyCollectionFactory()
/*      */     {
/*      */     }
/*      */ 
/*      */     public Collection createCollection(Connection con, PreparedStatement ps, ResultSet rs, int limit, int count, JDBCEntityBridge selectEntity, JDBCCMPFieldBridge selectField, SelectFunction selectFunction, JDBCStoreManager selectManager, List onFindCMRList, boolean[] eagerLoadMask, GenericEntityObjectFactory factory)
/*      */       throws FinderException
/*      */     {
/*  843 */       return new LazyCollection(con, ps, rs, limit, count, selectEntity, selectField, selectFunction, selectManager, eagerLoadMask, factory);
/*      */     }
/*      */ 
/*      */     private class LazyCollection extends AbstractCollection
/*      */     {
/*      */       private final Connection con;
/*      */       private final PreparedStatement ps;
/*      */       private final ResultSet rs;
/*      */       private final int limit;
/*      */       private int count;
/*      */       private final JDBCEntityBridge selectEntity;
/*      */       private final JDBCCMPFieldBridge selectField;
/*      */       private final SelectFunction selectFunction;
/*      */       private final JDBCStoreManager selectManager;
/*      */       private final boolean[] eagerLoadMask;
/*      */       private final GenericEntityObjectFactory factory;
/*      */       private Object prevPk;
/*      */       private Object curPk;
/*      */       private Object currentResult;
/*  874 */       Object[] ref = new Object[1];
/*      */       boolean loadOnFindCmr;
/*  878 */       private List results = null;
/*      */       private Iterator firstIterator;
/*      */       private int size;
/*      */       private boolean resourcesClosed;
/*      */ 
/*      */       public LazyCollection(Connection con, PreparedStatement ps, ResultSet rs, int limit, int count, JDBCEntityBridge selectEntity, JDBCCMPFieldBridge selectField, SelectFunction selectFunction, JDBCStoreManager selectManager, boolean[] eagerLoadMask, GenericEntityObjectFactory factory)
/*      */       {
/*  895 */         this.con = con;
/*  896 */         this.ps = ps;
/*  897 */         this.rs = rs;
/*  898 */         this.limit = limit;
/*  899 */         this.count = count;
/*  900 */         this.selectEntity = selectEntity;
/*  901 */         this.selectField = selectField;
/*  902 */         this.selectFunction = selectFunction;
/*  903 */         this.selectManager = selectManager;
/*  904 */         this.eagerLoadMask = eagerLoadMask;
/*  905 */         this.factory = factory;
/*  906 */         this.loadOnFindCmr = (!JDBCAbstractQueryCommand.this.onFindCMRList.isEmpty());
/*      */ 
/*  908 */         this.firstIterator = getFirstIterator();
/*  909 */         if (this.firstIterator.hasNext())
/*      */         {
/*      */           try
/*      */           {
/*  913 */             this.size = rs.getInt(1);
/*      */           }
/*      */           catch (SQLException e)
/*      */           {
/*  917 */             throw new EJBException("Failed to read ResultSet.", e);
/*      */           }
/*      */ 
/*  920 */           if ((limit > 0) && (this.size > limit))
/*      */           {
/*  922 */             this.size = limit;
/*      */           }
/*      */         }
/*      */ 
/*  926 */         if (this.size < 1)
/*      */         {
/*  928 */           this.firstIterator = null;
/*  929 */           this.results = new ArrayList(0);
/*  930 */           closeResources();
/*      */         }
/*      */         else
/*      */         {
/*  934 */           this.results = new ArrayList(this.size);
/*      */           try
/*      */           {
/*  937 */             selectManager.getContainer().getTransactionManager().getTransaction().registerSynchronization(new Synchronization(JDBCAbstractQueryCommand.LazyCollectionFactory.this)
/*      */             {
/*      */               public void beforeCompletion()
/*      */               {
/*  941 */                 JDBCAbstractQueryCommand.LazyCollectionFactory.LazyCollection.this.closeResources();
/*      */               }
/*      */ 
/*      */               public void afterCompletion(int status)
/*      */               {
/*  946 */                 JDBCAbstractQueryCommand.LazyCollectionFactory.LazyCollection.this.closeResources();
/*      */               }
/*      */             });
/*      */           }
/*      */           catch (Exception e) {
/*  952 */             throw new EJBException("Failed to obtain current transaction", e);
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/*      */       private void closeResources()
/*      */       {
/*  959 */         if (!this.resourcesClosed)
/*      */         {
/*  961 */           JDBCUtil.safeClose(this.rs);
/*  962 */           JDBCUtil.safeClose(this.ps);
/*  963 */           JDBCUtil.safeClose(this.con);
/*  964 */           this.resourcesClosed = true;
/*      */         }
/*      */       }
/*      */ 
/*      */       public Iterator iterator()
/*      */       {
/*  970 */         return this.firstIterator != null ? this.firstIterator : this.results.iterator();
/*      */       }
/*      */ 
/*      */       public int size()
/*      */       {
/*  975 */         return this.firstIterator != null ? this.size : this.results.size();
/*      */       }
/*      */ 
/*      */       public boolean add(Object o)
/*      */       {
/*  980 */         if (this.firstIterator == null)
/*      */         {
/*  982 */           return this.results.add(o);
/*      */         }
/*  984 */         throw new IllegalStateException("Can't modify collection while the first iterator is not exhausted.");
/*      */       }
/*      */ 
/*      */       public boolean remove(Object o)
/*      */       {
/*  989 */         if (this.firstIterator == null)
/*      */         {
/*  991 */           return this.results.remove(o);
/*      */         }
/*  993 */         throw new IllegalStateException("Can't modify collection while the first iterator is not exhausted.");
/*      */       }
/*      */ 
/*      */       private boolean hasNextResult()
/*      */       {
/*      */         try
/*      */         {
/* 1000 */           boolean has = ((this.limit == 0) || (this.count-- > 0)) && (this.rs.next());
/* 1001 */           if (!has)
/*      */           {
/* 1003 */             if (JDBCAbstractQueryCommand.this.log.isTraceEnabled())
/*      */             {
/* 1005 */               JDBCAbstractQueryCommand.this.log.trace("first iterator exhausted!");
/*      */             }
/* 1007 */             this.firstIterator = null;
/* 1008 */             closeResources();
/*      */           }
/* 1010 */           return has;
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/* 1014 */           JDBCAbstractQueryCommand.this.log.error("Failed to read ResultSet.", e);
/* 1015 */         }throw new EJBException("Failed to read ResultSet: " + e.getMessage());
/*      */       }
/*      */ 
/*      */       private Object readNext()
/*      */       {
/*      */         try
/*      */         {
/* 1023 */           if (this.selectEntity != null)
/*      */           {
/* 1025 */             ReadAheadCache selectReadAheadCache = this.selectManager.getReadAheadCache();
/*      */ 
/* 1028 */             int index = 2;
/*      */ 
/* 1031 */             index = this.selectEntity.loadPrimaryKeyResults(this.rs, index, this.ref);
/* 1032 */             this.curPk = this.ref[0];
/*      */ 
/* 1034 */             boolean addPk = !this.curPk.equals(this.prevPk);
/* 1035 */             if (addPk)
/*      */             {
/* 1037 */               this.prevPk = this.curPk;
/* 1038 */               this.currentResult = this.factory.getEntityEJBObject(this.curPk);
/*      */             }
/*      */ 
/* 1042 */             if (this.eagerLoadMask != null)
/*      */             {
/* 1044 */               JDBCFieldBridge[] tableFields = this.selectEntity.getTableFields();
/* 1045 */               for (int i = 0; i < this.eagerLoadMask.length; i++)
/*      */               {
/* 1047 */                 if (this.eagerLoadMask[i] == 0)
/*      */                   continue;
/* 1049 */                 JDBCFieldBridge field = tableFields[i];
/* 1050 */                 this.ref[0] = null;
/*      */ 
/* 1053 */                 index = field.loadArgumentResults(this.rs, index, this.ref);
/*      */ 
/* 1055 */                 if (!addPk)
/*      */                   continue;
/* 1057 */                 selectReadAheadCache.addPreloadData(this.curPk, field, this.ref[0]);
/*      */               }
/*      */ 
/* 1062 */               if (!JDBCAbstractQueryCommand.this.onFindCMRList.isEmpty())
/*      */               {
/* 1064 */                 index = JDBCAbstractQueryCommand.access$000(this.curPk, JDBCAbstractQueryCommand.this.onFindCMRList, this.rs, index, JDBCAbstractQueryCommand.this.log);
/*      */               }
/*      */             }
/*      */           }
/* 1068 */           else if (this.selectField != null)
/*      */           {
/* 1071 */             this.selectField.loadArgumentResults(this.rs, 2, this.ref);
/* 1072 */             this.currentResult = this.ref[0];
/*      */           }
/*      */           else
/*      */           {
/* 1076 */             this.currentResult = this.selectFunction.readResult(this.rs);
/*      */           }
/*      */ 
/* 1079 */           if ((JDBCAbstractQueryCommand.this.log.isTraceEnabled()) && (this.limit != 0) && (this.count == 0))
/*      */           {
/* 1081 */             JDBCAbstractQueryCommand.this.log.trace("Query result was limited to " + this.limit + " row(s)");
/*      */           }
/*      */ 
/* 1084 */           return this.currentResult;
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/* 1088 */           JDBCAbstractQueryCommand.this.log.error("Failed to read ResultSet", e);
/* 1089 */         }throw new EJBException("Failed to read ResultSet: " + e.getMessage());
/*      */       }
/*      */ 
/*      */       private Iterator getFirstIterator()
/*      */       {
/* 1095 */         return new Iterator() {
/*      */           private boolean hasNext;
/*      */           private Object cursor;
/*      */ 
/*      */           public boolean hasNext() {
/* 1102 */             return this.hasNext = JDBCAbstractQueryCommand.LazyCollectionFactory.LazyCollection.this.hasNextResult();
/*      */           }
/*      */ 
/*      */           public Object next()
/*      */           {
/* 1107 */             if (!hasNext())
/*      */             {
/* 1109 */               throw new NoSuchElementException();
/*      */             }
/* 1111 */             this.hasNext = false;
/*      */ 
/* 1113 */             this.cursor = JDBCAbstractQueryCommand.LazyCollectionFactory.LazyCollection.this.readNext();
/* 1114 */             JDBCAbstractQueryCommand.LazyCollectionFactory.LazyCollection.this.results.add(this.cursor);
/*      */ 
/* 1116 */             return this.cursor;
/*      */           }
/*      */ 
/*      */           public void remove()
/*      */           {
/* 1121 */             JDBCAbstractQueryCommand.LazyCollectionFactory.LazyCollection.access$706(JDBCAbstractQueryCommand.LazyCollectionFactory.LazyCollection.this);
/* 1122 */             JDBCAbstractQueryCommand.LazyCollectionFactory.LazyCollection.this.results.remove(this.cursor);
/*      */           }
/*      */         };
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   class EagerCollectionFactory
/*      */     implements JDBCAbstractQueryCommand.QueryCollectionFactory
/*      */   {
/*      */     EagerCollectionFactory()
/*      */     {
/*      */     }
/*      */ 
/*      */     public Collection createCollection(Connection con, PreparedStatement ps, ResultSet rs, int limit, int count, JDBCEntityBridge selectEntity, JDBCCMPFieldBridge selectField, SelectFunction selectFunction, JDBCStoreManager selectManager, List onFindCMRList, boolean[] eagerLoadMask, GenericEntityObjectFactory factory)
/*      */       throws FinderException
/*      */     {
/*      */       try
/*      */       {
/*  728 */         List results = new ArrayList();
/*      */ 
/*  730 */         if (selectEntity != null)
/*      */         {
/*  732 */           ReadAheadCache selectReadAheadCache = selectManager.getReadAheadCache();
/*  733 */           List ids = new ArrayList();
/*      */ 
/*  735 */           boolean loadOnFindCmr = !onFindCMRList.isEmpty();
/*  736 */           Object[] ref = new Object[1];
/*  737 */           Object prevPk = null;
/*      */ 
/*  739 */           while (((limit == 0) || (count-- > 0)) && (rs.next()))
/*      */           {
/*  741 */             int index = 1;
/*      */ 
/*  744 */             index = selectEntity.loadPrimaryKeyResults(rs, index, ref);
/*  745 */             Object pk = ref[0];
/*      */ 
/*  747 */             boolean addPk = !pk.equals(prevPk);
/*  748 */             if (addPk)
/*      */             {
/*  750 */               ids.add(pk);
/*  751 */               results.add(factory.getEntityEJBObject(pk));
/*  752 */               prevPk = pk;
/*      */             }
/*      */ 
/*  756 */             if (eagerLoadMask != null)
/*      */             {
/*  758 */               JDBCFieldBridge[] tableFields = selectEntity.getTableFields();
/*  759 */               for (int i = 0; i < eagerLoadMask.length; i++)
/*      */               {
/*  761 */                 if (eagerLoadMask[i] == 0)
/*      */                   continue;
/*  763 */                 JDBCFieldBridge field = tableFields[i];
/*  764 */                 ref[0] = null;
/*      */ 
/*  767 */                 index = field.loadArgumentResults(rs, index, ref);
/*      */ 
/*  769 */                 if (!addPk)
/*      */                   continue;
/*  771 */                 selectReadAheadCache.addPreloadData(pk, field, ref[0]);
/*      */               }
/*      */ 
/*  776 */               if (!onFindCMRList.isEmpty())
/*      */               {
/*  778 */                 index = JDBCAbstractQueryCommand.access$000(pk, onFindCMRList, rs, index, JDBCAbstractQueryCommand.this.log);
/*      */               }
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*  784 */           selectReadAheadCache.addFinderResults(ids, JDBCAbstractQueryCommand.this.queryMetaData.getReadAhead());
/*      */         }
/*  786 */         else if (selectField != null)
/*      */         {
/*  789 */           valueRef = new Object[1];
/*  790 */           while (((limit == 0) || (count-- > 0)) && (rs.next()))
/*      */           {
/*  792 */             valueRef[0] = null;
/*  793 */             selectField.loadArgumentResults(rs, 1, valueRef);
/*  794 */             results.add(valueRef[0]);
/*      */           }
/*      */         }
/*      */         else
/*      */         {
/*  799 */           while (rs.next())
/*      */           {
/*  801 */             results.add(selectFunction.readResult(rs));
/*      */           }
/*      */         }
/*      */ 
/*  805 */         if ((JDBCAbstractQueryCommand.this.log.isDebugEnabled()) && (limit != 0) && (count == 0))
/*      */         {
/*  807 */           JDBCAbstractQueryCommand.this.log.debug("Query result was limited to " + limit + " row(s)");
/*      */         }
/*      */ 
/*  810 */         valueRef = results;
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*      */         Object[] valueRef;
/*  814 */         JDBCAbstractQueryCommand.this.log.error("Find failed", e);
/*  815 */         throw new FinderException("Find failed: " + e);
/*      */       }
/*      */       finally
/*      */       {
/*  819 */         JDBCUtil.safeClose(rs);
/*  820 */         JDBCUtil.safeClose(ps);
/*  821 */         JDBCUtil.safeClose(con);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   static abstract interface QueryCollectionFactory
/*      */   {
/*      */     public abstract Collection createCollection(Connection paramConnection, PreparedStatement paramPreparedStatement, ResultSet paramResultSet, int paramInt1, int paramInt2, JDBCEntityBridge paramJDBCEntityBridge, JDBCCMPFieldBridge paramJDBCCMPFieldBridge, SelectFunction paramSelectFunction, JDBCStoreManager paramJDBCStoreManager, List paramList, boolean[] paramArrayOfBoolean, GenericEntityObjectFactory paramGenericEntityObjectFactory)
/*      */       throws FinderException;
/*      */   }
/*      */ 
/*      */   public static final class LeftJoinCMRNode
/*      */   {
/*      */     public final String path;
/*      */     public final JDBCCMRFieldBridge cmrField;
/*      */     public final boolean[] eagerLoadMask;
/*      */     public final List onFindCMRNodes;
/*      */ 
/*      */     public LeftJoinCMRNode(String path, JDBCCMRFieldBridge cmrField, boolean[] eagerLoadMask, List onFindCMRNodes)
/*      */     {
/*  657 */       this.path = path;
/*  658 */       this.cmrField = cmrField;
/*  659 */       this.eagerLoadMask = eagerLoadMask;
/*  660 */       this.onFindCMRNodes = onFindCMRNodes;
/*      */     }
/*      */ 
/*      */     public boolean equals(Object o)
/*      */     {
/*      */       boolean result;
/*      */       boolean result;
/*  666 */       if (o == this)
/*      */       {
/*  668 */         result = true;
/*      */       }
/*      */       else
/*      */       {
/*      */         boolean result;
/*  670 */         if ((o instanceof LeftJoinCMRNode))
/*      */         {
/*  672 */           LeftJoinCMRNode other = (LeftJoinCMRNode)o;
/*  673 */           result = this.cmrField == other.cmrField;
/*      */         }
/*      */         else
/*      */         {
/*  677 */           result = false;
/*      */         }
/*      */       }
/*  679 */       return result;
/*      */     }
/*      */ 
/*      */     public int hashCode()
/*      */     {
/*  684 */       return this.cmrField == null ? -2147483648 : this.cmrField.hashCode();
/*      */     }
/*      */ 
/*      */     public String toString()
/*      */     {
/*  689 */       return '[' + this.cmrField.getFieldName() + ": " + this.onFindCMRNodes + ']';
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCAbstractQueryCommand
 * JD-Core Version:    0.6.0
 */