/*      */ package org.jboss.ejb.plugins.cmp.jdbc;
/*      */ 
/*      */ import java.io.StringReader;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collection;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.Map.Entry;
/*      */ import java.util.Set;
/*      */ import org.jboss.ejb.EntityPersistenceStore;
/*      */ import org.jboss.ejb.plugins.cmp.bridge.CMPFieldBridge;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTAbs;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTAbstractSchema;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTAnd;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTApproximateNumericLiteral;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTArithmeticComparison;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTArithmeticParenthetical;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTAvg;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTBetween;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTBooleanComparison;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTBooleanLiteral;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTCollectionMemberDeclaration;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTConcat;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTConditionalParenthetical;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTCount;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTDatetimeComparison;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTEJBQL;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTEntityComparison;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTExactNumericLiteral;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTFrom;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTIdentifier;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTIn;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTIsEmpty;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTLCase;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTLength;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTLike;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTLimitOffset;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTLocate;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTMax;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTMemberOf;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTMin;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTMod;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTMultDiv;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTNegation;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTNot;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTNullComparison;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTOr;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTOrderBy;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTOrderByPath;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTParameter;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTPath;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTPlusMinus;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTRangeVariableDeclaration;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTSelect;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTSqrt;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTStringComparison;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTStringLiteral;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTStringParenthetical;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTSubstring;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTSum;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTUCase;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTValueClassComparison;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTWhere;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.ASTWhereConditionalTerm;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.Catalog;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.EJBQLParser;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.EJBQLTypes;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.JBossQLParser;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.JBossQLParserVisitor;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.Node;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.SelectFunction;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.SimpleNode;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractCMRFieldBridge;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCFunctionMappingMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationshipRoleMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
/*      */ import org.jboss.logging.Logger;
/*      */ 
/*      */ public final class EJBQLToSQL92Compiler
/*      */   implements QLCompiler, JBossQLParserVisitor
/*      */ {
/*   56 */   private static final Logger log = Logger.getLogger(EJBQLToSQL92Compiler.class);
/*      */   private final Catalog catalog;
/*      */   private Class returnType;
/*      */   private Class[] parameterTypes;
/*      */   private JDBCReadAheadMetaData readAhead;
/*      */   private AliasManager aliasManager;
/*   66 */   private Map joinPaths = new HashMap();
/*   67 */   private Map identifierToTable = new HashMap();
/*   68 */   private Set joinedAliases = new HashSet();
/*      */   private JDBCTypeMappingMetaData typeMapping;
/*      */   private JDBCTypeFactory typeFactory;
/*      */   private boolean forceDistinct;
/*      */   private String sql;
/*      */   private int offsetParam;
/*      */   private int offsetValue;
/*      */   private int limitParam;
/*      */   private int limitValue;
/*      */   private JDBCEntityPersistenceStore selectManager;
/*      */   private Object selectObject;
/*   83 */   private List inputParameters = new ArrayList();
/*      */ 
/*   85 */   private List leftJoinCMRList = new ArrayList();
/*      */   private StringBuffer onFindCMRJoin;
/*      */   private boolean countCompositePk;
/*      */   private boolean selectDistinct;
/*      */ 
/*      */   public EJBQLToSQL92Compiler(Catalog catalog)
/*      */   {
/*   93 */     this.catalog = catalog;
/*      */   }
/*      */ 
/*      */   public void compileEJBQL(String ejbql, Class returnType, Class[] parameterTypes, JDBCQueryMetaData metadata)
/*      */     throws Exception
/*      */   {
/*  100 */     reset();
/*      */ 
/*  103 */     this.returnType = returnType;
/*  104 */     this.parameterTypes = parameterTypes;
/*  105 */     this.readAhead = metadata.getReadAhead();
/*      */ 
/*  108 */     EJBQLParser parser = new EJBQLParser(new StringReader(""));
/*      */     try
/*      */     {
/*  113 */       ASTEJBQL ejbqlNode = parser.parse(this.catalog, parameterTypes, ejbql);
/*      */ 
/*  116 */       this.sql = ejbqlNode.jjtAccept(this, new StringBuffer()).toString();
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  121 */       reset();
/*  122 */       throw e;
/*      */     }
/*      */     catch (Error e)
/*      */     {
/*  127 */       reset();
/*  128 */       throw e;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void compileJBossQL(String ejbql, Class returnType, Class[] parameterTypes, JDBCQueryMetaData metadata)
/*      */     throws Exception
/*      */   {
/*  136 */     reset();
/*      */ 
/*  139 */     this.returnType = returnType;
/*  140 */     this.parameterTypes = parameterTypes;
/*  141 */     this.readAhead = metadata.getReadAhead();
/*      */ 
/*  144 */     JBossQLParser parser = new JBossQLParser(new StringReader(""));
/*      */     try
/*      */     {
/*  149 */       ASTEJBQL ejbqlNode = parser.parse(this.catalog, parameterTypes, ejbql);
/*      */ 
/*  152 */       this.sql = ejbqlNode.jjtAccept(this, new StringBuffer()).toString();
/*      */ 
/*  154 */       if (log.isTraceEnabled())
/*      */       {
/*  156 */         log.trace("ejbql: " + ejbql);
/*  157 */         log.trace("sql: " + this.sql);
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  163 */       reset();
/*  164 */       throw e;
/*      */     }
/*      */     catch (Error e)
/*      */     {
/*  169 */       reset();
/*  170 */       throw e;
/*      */     }
/*      */   }
/*      */ 
/*      */   public String getSQL()
/*      */   {
/*  176 */     return this.sql;
/*      */   }
/*      */ 
/*      */   public int getOffsetValue()
/*      */   {
/*  181 */     return this.offsetValue;
/*      */   }
/*      */ 
/*      */   public int getOffsetParam()
/*      */   {
/*  186 */     return this.offsetParam;
/*      */   }
/*      */ 
/*      */   public int getLimitValue()
/*      */   {
/*  191 */     return this.limitValue;
/*      */   }
/*      */ 
/*      */   public int getLimitParam()
/*      */   {
/*  196 */     return this.limitParam;
/*      */   }
/*      */ 
/*      */   public boolean isSelectEntity()
/*      */   {
/*  201 */     return this.selectObject instanceof JDBCAbstractEntityBridge;
/*      */   }
/*      */ 
/*      */   public JDBCAbstractEntityBridge getSelectEntity()
/*      */   {
/*  206 */     return (JDBCAbstractEntityBridge)this.selectObject;
/*      */   }
/*      */ 
/*      */   public boolean isSelectField()
/*      */   {
/*      */     boolean result;
/*      */     boolean result;
/*  212 */     if ((this.selectObject instanceof JDBCFieldBridge))
/*      */     {
/*  214 */       JDBCFieldBridge field = (JDBCFieldBridge)this.selectObject;
/*  215 */       result = field.isCMPField();
/*      */     }
/*      */     else
/*      */     {
/*  219 */       result = false;
/*      */     }
/*  221 */     return result;
/*      */   }
/*      */ 
/*      */   public JDBCFieldBridge getSelectField()
/*      */   {
/*  226 */     return (JDBCFieldBridge)this.selectObject;
/*      */   }
/*      */ 
/*      */   public SelectFunction getSelectFunction()
/*      */   {
/*  231 */     return (SelectFunction)this.selectObject;
/*      */   }
/*      */ 
/*      */   public EntityPersistenceStore getStoreManager()
/*      */   {
/*  236 */     return this.selectManager;
/*      */   }
/*      */ 
/*      */   public List getInputParameters()
/*      */   {
/*  241 */     return this.inputParameters;
/*      */   }
/*      */ 
/*      */   public List getLeftJoinCMRList()
/*      */   {
/*  246 */     return this.leftJoinCMRList;
/*      */   }
/*      */ 
/*      */   public boolean isSelectDistinct()
/*      */   {
/*  251 */     return this.selectDistinct;
/*      */   }
/*      */ 
/*      */   public Object visit(SimpleNode node, Object data)
/*      */   {
/*  256 */     throw new RuntimeException("Internal error: Found unknown node type in EJB-QL abstract syntax tree: node=" + node);
/*      */   }
/*      */ 
/*      */   public Object visit(ASTEJBQL node, Object data)
/*      */   {
/*  262 */     Node selectNode = node.jjtGetChild(0);
/*  263 */     Node fromNode = node.jjtGetChild(1);
/*      */ 
/*  266 */     StringBuffer selectClause = new StringBuffer(50);
/*  267 */     selectNode.jjtAccept(this, selectClause);
/*      */ 
/*  269 */     StringBuffer whereClause = null;
/*  270 */     StringBuffer orderByClause = null;
/*  271 */     for (int i = 2; i < node.jjtGetNumChildren(); i++)
/*      */     {
/*  273 */       Node childNode = node.jjtGetChild(i);
/*  274 */       if ((childNode instanceof ASTWhere))
/*      */       {
/*  276 */         whereClause = new StringBuffer(20);
/*  277 */         childNode.jjtAccept(this, whereClause);
/*      */       }
/*  279 */       else if ((childNode instanceof ASTOrderBy))
/*      */       {
/*  281 */         orderByClause = new StringBuffer();
/*  282 */         childNode.jjtAccept(this, orderByClause);
/*      */       } else {
/*  284 */         if (!(childNode instanceof ASTLimitOffset))
/*      */           continue;
/*  286 */         childNode.jjtAccept(this, null);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  291 */     StringBuffer fromClause = new StringBuffer(30);
/*  292 */     fromNode.jjtAccept(this, fromClause);
/*      */ 
/*  295 */     for (Iterator iter = this.identifierToTable.entrySet().iterator(); iter.hasNext(); )
/*      */     {
/*  297 */       Map.Entry entry = (Map.Entry)iter.next();
/*  298 */       String identifier = (String)entry.getKey();
/*  299 */       String table = (String)entry.getValue();
/*  300 */       String alias = this.aliasManager.getAlias(identifier);
/*      */ 
/*  302 */       fromClause.append(table).append(' ').append(alias);
/*  303 */       join(alias, fromClause);
/*      */ 
/*  305 */       if (iter.hasNext())
/*      */       {
/*  307 */         fromClause.append(", ");
/*      */       }
/*      */     }
/*      */ 
/*  311 */     this.selectDistinct = ((((ASTSelect)selectNode).distinct) || (this.returnType == Set.class) || (this.forceDistinct));
/*      */ 
/*  314 */     StringBuffer sql = (StringBuffer)data;
/*  315 */     if ((this.selectManager.getMetaData().hasRowLocking()) && (!(this.selectObject instanceof SelectFunction)))
/*      */     {
/*  317 */       JDBCFunctionMappingMetaData rowLockingTemplate = this.typeMapping.getRowLockingTemplate();
/*  318 */       if (rowLockingTemplate == null)
/*      */       {
/*  320 */         throw new IllegalStateException("Row locking template is not defined for given mapping: " + this.typeMapping.getName());
/*      */       }
/*      */ 
/*  323 */       boolean distinct = this.selectDistinct;
/*      */ 
/*  325 */       Object[] args = { distinct ? "DISTINCT " + selectClause : selectClause.toString(), fromClause, (whereClause == null) || (whereClause.length() == 0) ? null : whereClause, (orderByClause == null) || (orderByClause.length() == 0) ? null : orderByClause };
/*      */ 
/*  331 */       rowLockingTemplate.getFunctionSql(args, sql);
/*      */     }
/*      */     else
/*      */     {
/*  335 */       sql.append("SELECT ");
/*  336 */       if (this.selectDistinct)
/*      */       {
/*  338 */         sql.append("DISTINCT ");
/*      */       }
/*  340 */       sql.append(selectClause).append(" FROM ").append(fromClause);
/*      */ 
/*  344 */       if ((whereClause != null) && (whereClause.length() > 0))
/*      */       {
/*  346 */         sql.append(" WHERE ").append(whereClause);
/*      */       }
/*      */ 
/*  349 */       if ((orderByClause != null) && (orderByClause.length() > 0))
/*      */       {
/*  351 */         sql.append(" ORDER BY ").append(orderByClause);
/*      */       }
/*      */     }
/*      */ 
/*  355 */     if (this.countCompositePk)
/*      */     {
/*  357 */       sql.insert(0, "SELECT COUNT(*) FROM (").append(") t_count");
/*      */     }
/*      */ 
/*  360 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTOrderBy node, Object data)
/*      */   {
/*  365 */     StringBuffer buf = (StringBuffer)data;
/*  366 */     node.jjtGetChild(0).jjtAccept(this, data);
/*  367 */     for (int i = 1; i < node.jjtGetNumChildren(); i++)
/*      */     {
/*  369 */       buf.append(", ");
/*  370 */       node.jjtGetChild(i).jjtAccept(this, data);
/*      */     }
/*  372 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTOrderByPath node, Object data)
/*      */   {
/*  377 */     StringBuffer buf = (StringBuffer)data;
/*  378 */     node.jjtGetChild(0).jjtAccept(this, data);
/*  379 */     if (node.ascending)
/*      */     {
/*  381 */       buf.append(" ASC");
/*      */     }
/*      */     else
/*      */     {
/*  385 */       buf.append(" DESC");
/*      */     }
/*  387 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTLimitOffset node, Object data)
/*      */   {
/*  392 */     int child = 0;
/*  393 */     if (node.hasOffset)
/*      */     {
/*  395 */       Node offsetNode = node.jjtGetChild(child++);
/*  396 */       if ((offsetNode instanceof ASTParameter))
/*      */       {
/*  398 */         ASTParameter param = (ASTParameter)offsetNode;
/*  399 */         Class parameterType = getParameterType(param.number);
/*  400 */         if ((Integer.TYPE != parameterType) && (Integer.class != parameterType))
/*      */         {
/*  402 */           throw new IllegalStateException("OFFSET parameter must be an int");
/*      */         }
/*  404 */         this.offsetParam = param.number;
/*      */       }
/*      */       else
/*      */       {
/*  408 */         ASTExactNumericLiteral param = (ASTExactNumericLiteral)offsetNode;
/*  409 */         this.offsetValue = (int)param.value;
/*      */       }
/*      */     }
/*      */ 
/*  413 */     if (node.hasLimit)
/*      */     {
/*  415 */       Node limitNode = node.jjtGetChild(child);
/*  416 */       if ((limitNode instanceof ASTParameter))
/*      */       {
/*  418 */         ASTParameter param = (ASTParameter)limitNode;
/*  419 */         Class parameterType = getParameterType(param.number);
/*  420 */         if ((Integer.TYPE != parameterType) && (Integer.class != parameterType))
/*      */         {
/*  422 */           throw new IllegalStateException("LIMIT parameter must be an int");
/*      */         }
/*  424 */         this.limitParam = param.number;
/*      */       }
/*      */       else
/*      */       {
/*  428 */         ASTExactNumericLiteral param = (ASTExactNumericLiteral)limitNode;
/*  429 */         this.limitValue = (int)param.value;
/*      */       }
/*      */     }
/*  432 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTSelect select, Object data)
/*      */   {
/*  437 */     StringBuffer sql = (StringBuffer)data;
/*      */ 
/*  439 */     Node child0 = select.jjtGetChild(0);
/*      */ 
/*  441 */     if ((child0 instanceof ASTPath))
/*      */     {
/*  443 */       ASTPath path = (ASTPath)child0;
/*      */ 
/*  445 */       if (path.isCMPField())
/*      */       {
/*  448 */         JDBCFieldBridge selectField = path.getCMPField();
/*  449 */         this.selectManager = selectField.getManager();
/*  450 */         this.selectObject = selectField;
/*  451 */         setTypeFactory(this.selectManager.getJDBCTypeFactory());
/*      */ 
/*  455 */         addInnerJoinPath(path);
/*      */ 
/*  457 */         String alias = this.aliasManager.getAlias(path.getPath(path.size() - 2));
/*  458 */         SQLUtil.getColumnNamesClause(selectField, alias, sql);
/*      */       }
/*      */       else
/*      */       {
/*  462 */         JDBCAbstractEntityBridge selectEntity = (JDBCAbstractEntityBridge)path.getEntity();
/*  463 */         this.selectManager = selectEntity.getManager();
/*  464 */         this.selectObject = selectEntity;
/*  465 */         setTypeFactory(selectEntity.getManager().getJDBCTypeFactory());
/*      */ 
/*  467 */         String alias = this.aliasManager.getAlias(path.getPath());
/*  468 */         if (select.distinct)
/*      */         {
/*  470 */           SQLUtil.getSearchableColumnNamesClause(selectEntity.getTableFields(), alias, sql);
/*      */         }
/*      */         else
/*      */         {
/*  474 */           SQLUtil.getColumnNamesClause(selectEntity.getTableFields(), alias, sql);
/*      */         }
/*      */ 
/*  491 */         addLeftJoinPath(path);
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  497 */       ASTPath path = getPathFromChildren(child0);
/*      */ 
/*  499 */       if (path == null)
/*      */       {
/*  501 */         throw new IllegalStateException("The function in SELECT clause does not contain a path expression.");
/*      */       }
/*      */ 
/*  504 */       if (path.isCMPField())
/*      */       {
/*  506 */         JDBCFieldBridge selectField = path.getCMPField();
/*  507 */         this.selectManager = selectField.getManager();
/*  508 */         setTypeFactory(this.selectManager.getJDBCTypeFactory());
/*      */       }
/*  510 */       else if (path.isCMRField())
/*      */       {
/*  512 */         JDBCFieldBridge cmrField = (JDBCFieldBridge)path.getCMRField();
/*  513 */         this.selectManager = cmrField.getManager();
/*  514 */         setTypeFactory(this.selectManager.getJDBCTypeFactory());
/*  515 */         addLeftJoinPath(path);
/*      */       }
/*      */       else
/*      */       {
/*  519 */         JDBCAbstractEntityBridge entity = (JDBCAbstractEntityBridge)path.getEntity();
/*  520 */         this.selectManager = entity.getManager();
/*  521 */         setTypeFactory(this.selectManager.getJDBCTypeFactory());
/*  522 */         addLeftJoinPath(path);
/*      */       }
/*      */ 
/*  525 */       this.selectObject = child0;
/*  526 */       child0.jjtAccept(this, data);
/*      */     }
/*      */ 
/*  529 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTWhere node, Object data)
/*      */   {
/*  534 */     node.jjtGetChild(0).jjtAccept(this, data);
/*  535 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTOr node, Object data)
/*      */   {
/*  540 */     StringBuffer buf = (StringBuffer)data;
/*  541 */     node.jjtGetChild(0).jjtAccept(this, data);
/*  542 */     for (int i = 1; i < node.jjtGetNumChildren(); i++)
/*      */     {
/*  544 */       buf.append(" OR ");
/*  545 */       node.jjtGetChild(i).jjtAccept(this, data);
/*      */     }
/*  547 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTWhereConditionalTerm node, Object data)
/*      */   {
/*  552 */     for (int i = 0; i < node.jjtGetNumChildren(); i++)
/*      */     {
/*  554 */       node.jjtGetChild(i).jjtAccept(this, data);
/*      */     }
/*  556 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTAnd node, Object data)
/*      */   {
/*  561 */     StringBuffer buf = (StringBuffer)data;
/*  562 */     node.jjtGetChild(0).jjtAccept(this, data);
/*  563 */     for (int i = 1; i < node.jjtGetNumChildren(); i++)
/*      */     {
/*  565 */       buf.append(" AND ");
/*  566 */       node.jjtGetChild(i).jjtAccept(this, data);
/*      */     }
/*  568 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTNot node, Object data)
/*      */   {
/*  573 */     StringBuffer buf = (StringBuffer)data;
/*  574 */     buf.append(" NOT ");
/*  575 */     node.jjtGetChild(0).jjtAccept(this, data);
/*  576 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTConditionalParenthetical node, Object data)
/*      */   {
/*  581 */     StringBuffer buf = (StringBuffer)data;
/*  582 */     buf.append('(');
/*  583 */     node.jjtGetChild(0).jjtAccept(this, data);
/*  584 */     buf.append(')');
/*  585 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTBetween node, Object data)
/*      */   {
/*  590 */     StringBuffer buf = (StringBuffer)data;
/*  591 */     node.jjtGetChild(0).jjtAccept(this, data);
/*  592 */     if (node.not)
/*      */     {
/*  594 */       buf.append(" NOT ");
/*      */     }
/*  596 */     buf.append(" BETWEEN ");
/*  597 */     node.jjtGetChild(1).jjtAccept(this, data);
/*  598 */     buf.append(" AND ");
/*  599 */     node.jjtGetChild(2).jjtAccept(this, data);
/*  600 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTIn node, Object data)
/*      */   {
/*  605 */     StringBuffer buf = (StringBuffer)data;
/*  606 */     node.jjtGetChild(0).jjtAccept(this, data);
/*  607 */     if (node.not)
/*      */     {
/*  609 */       buf.append(" NOT ");
/*      */     }
/*  611 */     buf.append(" IN ").append('(');
/*  612 */     node.jjtGetChild(1).jjtAccept(this, data);
/*  613 */     for (int i = 2; i < node.jjtGetNumChildren(); i++)
/*      */     {
/*  615 */       buf.append(", ");
/*  616 */       node.jjtGetChild(i).jjtAccept(this, data);
/*      */     }
/*  618 */     buf.append(')');
/*  619 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTLike node, Object data)
/*      */   {
/*  624 */     StringBuffer buf = (StringBuffer)data;
/*  625 */     node.jjtGetChild(0).jjtAccept(this, data);
/*  626 */     if (node.not)
/*      */     {
/*  628 */       buf.append(" NOT ");
/*      */     }
/*  630 */     buf.append(" LIKE ");
/*  631 */     node.jjtGetChild(1).jjtAccept(this, data);
/*  632 */     if (node.jjtGetNumChildren() == 3)
/*      */     {
/*  634 */       buf.append(" {ESCAPE ");
/*  635 */       node.jjtGetChild(2).jjtAccept(this, data);
/*  636 */       buf.append('}');
/*      */     }
/*  638 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTNullComparison node, Object data)
/*      */   {
/*  643 */     StringBuffer sql = (StringBuffer)data;
/*      */ 
/*  645 */     Node child0 = node.jjtGetChild(0);
/*  646 */     if ((child0 instanceof ASTPath))
/*      */     {
/*  648 */       ASTPath path = (ASTPath)child0;
/*  649 */       addLeftJoinPath(path);
/*      */ 
/*  651 */       JDBCFieldBridge field = (JDBCFieldBridge)path.getField();
/*      */ 
/*  653 */       if ((field instanceof JDBCAbstractCMRFieldBridge))
/*      */       {
/*  655 */         JDBCAbstractCMRFieldBridge cmrField = (JDBCAbstractCMRFieldBridge)field;
/*      */         JDBCFieldBridge[] keyFields;
/*      */         String alias;
/*      */         JDBCFieldBridge[] keyFields;
/*  659 */         if (cmrField.hasForeignKey())
/*      */         {
/*  661 */           String alias = this.aliasManager.getAlias(path.getPath(path.size() - 2));
/*  662 */           keyFields = cmrField.getForeignKeyFields();
/*      */         }
/*      */         else
/*      */         {
/*  666 */           alias = this.aliasManager.getAlias(path.getPath());
/*      */           JDBCFieldBridge[] keyFields;
/*  667 */           if (cmrField.getMetaData().getRelationMetaData().isTableMappingStyle())
/*      */           {
/*  669 */             keyFields = cmrField.getRelatedCMRField().getEntity().getPrimaryKeyFields();
/*      */           }
/*      */           else
/*      */           {
/*  673 */             keyFields = cmrField.getRelatedCMRField().getForeignKeyFields();
/*      */           }
/*      */         }
/*      */ 
/*  677 */         SQLUtil.getIsNullClause(node.not, keyFields, alias, sql);
/*      */       }
/*      */       else
/*      */       {
/*  681 */         String alias = this.aliasManager.getAlias(path.getPath(path.size() - 2));
/*  682 */         SQLUtil.getIsNullClause(node.not, field, alias, sql);
/*      */       }
/*      */     }
/*  685 */     else if ((child0 instanceof ASTParameter))
/*      */     {
/*  687 */       ASTParameter param = (ASTParameter)child0;
/*  688 */       Class type = getParameterType(param.number);
/*      */ 
/*  690 */       QueryParameter queryParam = new QueryParameter(param.number - 1, this.typeFactory.getJDBCType(type));
/*  691 */       this.inputParameters.add(queryParam);
/*      */ 
/*  693 */       sql.append("? IS ");
/*  694 */       if (node.not)
/*      */       {
/*  696 */         sql.append(" NOT ");
/*      */       }
/*  698 */       sql.append("NULL");
/*      */     }
/*      */     else
/*      */     {
/*  702 */       throw new IllegalStateException("Unexpected node in IS NULL clause: " + node);
/*      */     }
/*      */ 
/*  705 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTIsEmpty node, Object data)
/*      */   {
/*  710 */     ASTPath path = (ASTPath)node.jjtGetChild(0);
/*  711 */     if (!path.isCMRField())
/*      */     {
/*  713 */       throw new IllegalStateException("IS EMPTY can be applied only to collection valued CMR field.");
/*      */     }
/*      */ 
/*  716 */     addLeftJoinPath(path);
/*      */ 
/*  718 */     StringBuffer sql = (StringBuffer)data;
/*  719 */     JDBCAbstractCMRFieldBridge cmrField = (JDBCAbstractCMRFieldBridge)path.getCMRField();
/*  720 */     JDBCAbstractEntityBridge relatedEntity = (JDBCAbstractEntityBridge)cmrField.getRelatedEntity();
/*  721 */     String alias = this.aliasManager.getAlias(path.getPath());
/*  722 */     SQLUtil.getIsNullClause(node.not, relatedEntity.getPrimaryKeyFields(), alias, sql);
/*      */ 
/*  724 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTMemberOf node, Object data)
/*      */   {
/*  729 */     Node member = node.jjtGetChild(0);
/*  730 */     ASTPath colPath = (ASTPath)node.jjtGetChild(1);
/*  731 */     JDBCAbstractEntityBridge colEntity = (JDBCAbstractEntityBridge)colPath.getEntity();
/*      */ 
/*  733 */     StringBuffer sql = (StringBuffer)data;
/*      */ 
/*  735 */     if (node.not)
/*      */     {
/*  737 */       sql.append(" NOT ");
/*      */     }
/*      */ 
/*  740 */     sql.append("EXISTS ").append('(').append("SELECT ");
/*      */ 
/*  742 */     if ((member instanceof ASTParameter))
/*      */     {
/*  744 */       ASTParameter toParam = (ASTParameter)member;
/*  745 */       verifyParameterEntityType(toParam.number, colEntity);
/*  746 */       this.inputParameters.addAll(QueryParameter.createParameters(toParam.number - 1, colEntity));
/*      */ 
/*  748 */       String parentAlias = this.aliasManager.getAlias(colPath.getPath(0));
/*  749 */       String localParentAlias = this.aliasManager.getAlias(colPath.getPath(0) + "_local");
/*  750 */       JDBCAbstractEntityBridge parentEntity = (JDBCAbstractEntityBridge)colPath.getEntity(0);
/*  751 */       SQLUtil.getColumnNamesClause(parentEntity.getPrimaryKeyFields(), localParentAlias, sql);
/*  752 */       sql.append(" FROM ").append(parentEntity.getQualifiedTableName()).append(' ').append(localParentAlias);
/*      */ 
/*  754 */       innerJoinPath(colPath, sql);
/*      */ 
/*  756 */       sql.append(" WHERE ");
/*      */ 
/*  758 */       JDBCAbstractEntityBridge col0 = (JDBCAbstractEntityBridge)colPath.getEntity(0);
/*  759 */       SQLUtil.getSelfCompareWhereClause(col0.getPrimaryKeyFields(), parentAlias, localParentAlias, sql);
/*  760 */       sql.append(" AND ");
/*      */ 
/*  762 */       String localColAlias = this.aliasManager.getAlias(colPath.getPath() + "_local");
/*  763 */       SQLUtil.getWhereClause(colEntity.getPrimaryKeyFields(), localColAlias, sql);
/*      */     }
/*      */     else
/*      */     {
/*  767 */       ASTPath memberPath = (ASTPath)member;
/*  768 */       JDBCAbstractEntityBridge memberEntity = (JDBCAbstractEntityBridge)memberPath.getEntity();
/*      */ 
/*  770 */       if (!memberEntity.equals(colEntity))
/*      */       {
/*  772 */         throw new IllegalStateException("Member must be if the same type as the collection, got: member=" + memberEntity.getEntityName() + ", collection=" + colEntity.getEntityName());
/*      */       }
/*      */ 
/*  778 */       String memberAlias = this.aliasManager.getAlias(memberPath.getPath());
/*      */ 
/*  780 */       if (memberPath.size() > 1)
/*      */       {
/*  782 */         String parentAlias = this.aliasManager.getAlias(memberPath.getPath(0) + "_local");
/*  783 */         JDBCAbstractEntityBridge parentEntity = (JDBCAbstractEntityBridge)memberPath.getEntity(0);
/*  784 */         SQLUtil.getColumnNamesClause(parentEntity.getPrimaryKeyFields(), parentAlias, sql);
/*  785 */         sql.append(" FROM ").append(parentEntity.getQualifiedTableName()).append(' ').append(parentAlias);
/*      */ 
/*  787 */         innerJoinPath(memberPath, sql);
/*  788 */         innerJoinPath(colPath, sql);
/*      */       }
/*  790 */       else if (colPath.size() > 1)
/*      */       {
/*  792 */         String parentAlias = this.aliasManager.getAlias(colPath.getPath(0) + "_local");
/*  793 */         JDBCAbstractEntityBridge parentEntity = (JDBCAbstractEntityBridge)colPath.getEntity(0);
/*  794 */         SQLUtil.getColumnNamesClause(parentEntity.getPrimaryKeyFields(), parentAlias, sql);
/*  795 */         sql.append(" FROM ").append(parentEntity.getQualifiedTableName()).append(' ').append(parentAlias);
/*      */ 
/*  797 */         innerJoinPath(colPath, sql);
/*      */       }
/*      */       else
/*      */       {
/*  801 */         throw new IllegalStateException("There should be collection valued path expression, not identification variable.");
/*      */       }
/*      */ 
/*  805 */       sql.append(" WHERE ");
/*      */ 
/*  807 */       JDBCAbstractEntityBridge member0 = (JDBCAbstractEntityBridge)memberPath.getEntity(0);
/*  808 */       String colAliasLocal = this.aliasManager.getAlias(colPath.getPath() + "_local");
/*  809 */       if (memberPath.size() > 1)
/*      */       {
/*  811 */         String memberAliasLocal = this.aliasManager.getAlias(memberPath.getPath() + "_local");
/*  812 */         SQLUtil.getSelfCompareWhereClause(colEntity.getPrimaryKeyFields(), memberAliasLocal, colAliasLocal, sql);
/*      */ 
/*  817 */         sql.append(" AND ");
/*      */ 
/*  819 */         String member0Alias = this.aliasManager.getAlias(memberPath.getPath(0));
/*  820 */         String member0AliasLocal = this.aliasManager.getAlias(memberPath.getPath(0) + "_local");
/*  821 */         SQLUtil.getSelfCompareWhereClause(member0.getPrimaryKeyFields(), member0Alias, member0AliasLocal, sql);
/*      */       }
/*      */       else
/*      */       {
/*  828 */         SQLUtil.getSelfCompareWhereClause(member0.getPrimaryKeyFields(), memberAlias, colAliasLocal, sql);
/*      */       }
/*      */     }
/*      */ 
/*  832 */     sql.append(')');
/*      */ 
/*  834 */     return data;
/*      */   }
/*      */ 
/*      */   private void innerJoinPath(ASTPath path, StringBuffer sql)
/*      */   {
/*  839 */     if (path.size() < 2)
/*      */     {
/*  841 */       return;
/*      */     }
/*      */ 
/*  844 */     String parentAlias = this.aliasManager.getAlias(path.getPath(0) + "_local");
/*  845 */     String leftAlias = parentAlias;
/*  846 */     for (int i = 1; i < path.size(); i++)
/*      */     {
/*  848 */       String curPath = path.getPath(i);
/*  849 */       String joinAlias = this.aliasManager.getAlias(curPath + "_local");
/*      */ 
/*  851 */       JDBCAbstractCMRFieldBridge cmrField = (JDBCAbstractCMRFieldBridge)path.getCMRField(i);
/*  852 */       JDBCAbstractEntityBridge joinEntity = (JDBCAbstractEntityBridge)cmrField.getRelatedEntity();
/*      */ 
/*  854 */       JDBCRelationMetaData relation = cmrField.getMetaData().getRelationMetaData();
/*      */ 
/*  856 */       String join = " INNER JOIN ";
/*      */ 
/*  858 */       if (relation.isTableMappingStyle())
/*      */       {
/*  860 */         String relTableAlias = this.aliasManager.getRelationTableAlias(curPath + "_local");
/*  861 */         sql.append(join).append(cmrField.getQualifiedTableName()).append(' ').append(relTableAlias).append(" ON ");
/*      */ 
/*  866 */         SQLUtil.getRelationTableJoinClause(cmrField, leftAlias, relTableAlias, sql);
/*      */ 
/*  868 */         sql.append(join).append(joinEntity.getQualifiedTableName()).append(' ').append(joinAlias).append(" ON ");
/*      */ 
/*  873 */         SQLUtil.getRelationTableJoinClause(cmrField.getRelatedCMRField(), joinAlias, relTableAlias, sql);
/*      */       }
/*      */       else
/*      */       {
/*  877 */         sql.append(join).append(joinEntity.getQualifiedTableName()).append(' ').append(joinAlias).append(" ON ");
/*      */ 
/*  883 */         SQLUtil.getJoinClause(cmrField, leftAlias, joinAlias, sql);
/*      */       }
/*      */ 
/*  886 */       leftAlias = joinAlias;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object visit(ASTStringComparison node, Object data)
/*      */   {
/*  892 */     StringBuffer buf = (StringBuffer)data;
/*  893 */     node.jjtGetChild(0).jjtAccept(this, data);
/*  894 */     buf.append(' ').append(node.opp).append(' ');
/*  895 */     node.jjtGetChild(1).jjtAccept(this, data);
/*  896 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTBooleanComparison node, Object data)
/*      */   {
/*  901 */     StringBuffer buf = (StringBuffer)data;
/*  902 */     node.jjtGetChild(0).jjtAccept(this, data);
/*  903 */     if (node.jjtGetNumChildren() == 2)
/*      */     {
/*  905 */       buf.append(' ').append(node.opp).append(' ');
/*  906 */       node.jjtGetChild(1).jjtAccept(this, data);
/*      */     }
/*  908 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTDatetimeComparison node, Object data)
/*      */   {
/*  913 */     StringBuffer buf = (StringBuffer)data;
/*  914 */     node.jjtGetChild(0).jjtAccept(this, data);
/*  915 */     buf.append(' ').append(node.opp).append(' ');
/*  916 */     node.jjtGetChild(1).jjtAccept(this, data);
/*  917 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTValueClassComparison node, Object data)
/*      */   {
/*  922 */     StringBuffer buf = (StringBuffer)data;
/*      */ 
/*  924 */     boolean not = node.opp.equals("<>");
/*  925 */     String comparison = node.opp;
/*  926 */     buf.append('(');
/*  927 */     if (not)
/*      */     {
/*  929 */       buf.append(" NOT ").append('(');
/*  930 */       comparison = "=";
/*      */     }
/*      */ 
/*  934 */     ASTPath fromPath = (ASTPath)node.jjtGetChild(0);
/*  935 */     addInnerJoinPath(fromPath);
/*  936 */     String fromAlias = this.aliasManager.getAlias(fromPath.getPath(fromPath.size() - 2));
/*  937 */     CMPFieldBridge fromCMPField = fromPath.getCMPField();
/*      */ 
/*  939 */     Node toNode = node.jjtGetChild(1);
/*  940 */     if ((toNode instanceof ASTParameter))
/*      */     {
/*  942 */       ASTParameter toParam = (ASTParameter)toNode;
/*      */ 
/*  945 */       Class parameterType = getParameterType(toParam.number);
/*  946 */       if (!fromCMPField.getFieldType().equals(parameterType))
/*      */       {
/*  948 */         throw new IllegalStateException("Only like types can be compared: from CMP field=" + fromCMPField.getFieldType() + " to parameter=" + parameterType);
/*      */       }
/*      */ 
/*  954 */       this.inputParameters.addAll(QueryParameter.createParameters(toParam.number - 1, fromCMPField));
/*  955 */       SQLUtil.getWhereClause(fromCMPField.getJDBCType(), fromAlias, comparison, buf);
/*      */     }
/*      */     else
/*      */     {
/*  959 */       ASTPath toPath = (ASTPath)toNode;
/*  960 */       addInnerJoinPath(toPath);
/*  961 */       String toAlias = this.aliasManager.getAlias(toPath.getPath(toPath.size() - 2));
/*  962 */       JDBCCMPFieldBridge toCMPField = (JDBCCMPFieldBridge)toPath.getCMPField();
/*      */ 
/*  965 */       if (!fromCMPField.getFieldType().equals(toCMPField.getFieldType()))
/*      */       {
/*  967 */         throw new IllegalStateException("Only like types can be compared: from CMP field=" + fromCMPField.getFieldType() + " to CMP field=" + toCMPField.getFieldType());
/*      */       }
/*      */ 
/*  973 */       SQLUtil.getSelfCompareWhereClause(fromCMPField, toCMPField, fromAlias, toAlias, comparison, buf);
/*      */     }
/*      */ 
/*  976 */     return (not ? buf.append(')') : buf).append(')');
/*      */   }
/*      */ 
/*      */   public Object visit(ASTEntityComparison node, Object data)
/*      */   {
/*  981 */     StringBuffer buf = (StringBuffer)data;
/*  982 */     Node arg0 = node.jjtGetChild(0);
/*  983 */     Node arg1 = node.jjtGetChild(1);
/*  984 */     if (node.opp.equals("<>"))
/*      */     {
/*  986 */       compareEntity(true, arg0, arg1, buf);
/*      */     }
/*      */     else
/*      */     {
/*  990 */       compareEntity(false, arg0, arg1, buf);
/*      */     }
/*  992 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTArithmeticComparison node, Object data)
/*      */   {
/*  997 */     StringBuffer buf = (StringBuffer)data;
/*  998 */     node.jjtGetChild(0).jjtAccept(this, data);
/*  999 */     buf.append(' ').append(node.opp).append(' ');
/* 1000 */     node.jjtGetChild(1).jjtAccept(this, data);
/* 1001 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTPlusMinus node, Object data)
/*      */   {
/* 1006 */     StringBuffer buf = (StringBuffer)data;
/* 1007 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 1008 */     for (int i = 1; i < node.jjtGetNumChildren(); i++)
/*      */     {
/* 1010 */       buf.append(' ').append(node.opps.get(i - 1)).append(' ');
/* 1011 */       node.jjtGetChild(i).jjtAccept(this, data);
/*      */     }
/* 1013 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTMultDiv node, Object data)
/*      */   {
/* 1018 */     StringBuffer buf = (StringBuffer)data;
/* 1019 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 1020 */     for (int i = 1; i < node.jjtGetNumChildren(); i++)
/*      */     {
/* 1022 */       buf.append(' ').append(node.opps.get(i - 1)).append(' ');
/* 1023 */       node.jjtGetChild(i).jjtAccept(this, data);
/*      */     }
/* 1025 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTNegation node, Object data)
/*      */   {
/* 1030 */     StringBuffer buf = (StringBuffer)data;
/* 1031 */     buf.append('-');
/* 1032 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 1033 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTArithmeticParenthetical node, Object data)
/*      */   {
/* 1038 */     StringBuffer buf = (StringBuffer)data;
/* 1039 */     buf.append('(');
/* 1040 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 1041 */     buf.append(')');
/* 1042 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTStringParenthetical node, Object data)
/*      */   {
/* 1047 */     StringBuffer buf = (StringBuffer)data;
/* 1048 */     buf.append('(');
/* 1049 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 1050 */     buf.append(')');
/* 1051 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTConcat node, Object data)
/*      */   {
/* 1056 */     StringBuffer buf = (StringBuffer)data;
/* 1057 */     JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("concat");
/* 1058 */     Object[] args = childrenToStringArr(2, node);
/* 1059 */     function.getFunctionSql(args, buf);
/* 1060 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTSubstring node, Object data)
/*      */   {
/* 1065 */     StringBuffer buf = (StringBuffer)data;
/* 1066 */     JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("substring");
/* 1067 */     Object[] args = childrenToStringArr(3, node);
/* 1068 */     function.getFunctionSql(args, buf);
/* 1069 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTUCase node, Object data)
/*      */   {
/* 1074 */     StringBuffer buf = (StringBuffer)data;
/* 1075 */     JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("ucase");
/* 1076 */     Object[] args = childrenToStringArr(1, node);
/* 1077 */     function.getFunctionSql(args, buf);
/* 1078 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTLCase node, Object data)
/*      */   {
/* 1083 */     StringBuffer buf = (StringBuffer)data;
/* 1084 */     JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("lcase");
/* 1085 */     Object[] args = childrenToStringArr(1, node);
/* 1086 */     function.getFunctionSql(args, buf);
/* 1087 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTLength node, Object data)
/*      */   {
/* 1092 */     StringBuffer buf = (StringBuffer)data;
/* 1093 */     JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("length");
/* 1094 */     Object[] args = childrenToStringArr(1, node);
/* 1095 */     function.getFunctionSql(args, buf);
/* 1096 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTLocate node, Object data)
/*      */   {
/* 1101 */     StringBuffer buf = (StringBuffer)data;
/* 1102 */     JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("locate");
/* 1103 */     Object[] args = new Object[3];
/* 1104 */     args[0] = node.jjtGetChild(0).jjtAccept(this, new StringBuffer()).toString();
/* 1105 */     args[1] = node.jjtGetChild(1).jjtAccept(this, new StringBuffer()).toString();
/* 1106 */     if (node.jjtGetNumChildren() == 3)
/*      */     {
/* 1108 */       args[2] = node.jjtGetChild(2).jjtAccept(this, new StringBuffer()).toString();
/*      */     }
/*      */     else
/*      */     {
/* 1112 */       args[2] = "1";
/*      */     }
/* 1114 */     function.getFunctionSql(args, buf);
/* 1115 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTAbs node, Object data)
/*      */   {
/* 1120 */     StringBuffer buf = (StringBuffer)data;
/* 1121 */     JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("abs");
/* 1122 */     Object[] args = childrenToStringArr(1, node);
/* 1123 */     function.getFunctionSql(args, buf);
/* 1124 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTSqrt node, Object data)
/*      */   {
/* 1129 */     StringBuffer buf = (StringBuffer)data;
/* 1130 */     JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("sqrt");
/* 1131 */     Object[] args = childrenToStringArr(1, node);
/* 1132 */     function.getFunctionSql(args, buf);
/* 1133 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTMod node, Object data)
/*      */   {
/* 1138 */     StringBuffer buf = (StringBuffer)data;
/* 1139 */     JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("mod");
/* 1140 */     Object[] args = childrenToStringArr(2, node);
/* 1141 */     function.getFunctionSql(args, buf);
/* 1142 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTAvg node, Object data)
/*      */   {
/* 1147 */     node.setResultType(this.returnType);
/* 1148 */     StringBuffer buf = (StringBuffer)data;
/* 1149 */     Object[] args = { node.distinct, node.jjtGetChild(0).jjtAccept(this, new StringBuffer()).toString() };
/*      */ 
/* 1153 */     JDBCTypeMappingMetaData.AVG_FUNC.getFunctionSql(args, buf);
/* 1154 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTMax node, Object data)
/*      */   {
/* 1159 */     node.setResultType(this.returnType);
/* 1160 */     StringBuffer buf = (StringBuffer)data;
/* 1161 */     Object[] args = { node.distinct, node.jjtGetChild(0).jjtAccept(this, new StringBuffer()).toString() };
/*      */ 
/* 1165 */     JDBCTypeMappingMetaData.MAX_FUNC.getFunctionSql(args, buf);
/* 1166 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTMin node, Object data)
/*      */   {
/* 1171 */     node.setResultType(this.returnType);
/* 1172 */     StringBuffer buf = (StringBuffer)data;
/* 1173 */     Object[] args = { node.distinct, node.jjtGetChild(0).jjtAccept(this, new StringBuffer()).toString() };
/*      */ 
/* 1177 */     JDBCTypeMappingMetaData.MIN_FUNC.getFunctionSql(args, buf);
/* 1178 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTSum node, Object data)
/*      */   {
/* 1183 */     node.setResultType(this.returnType);
/* 1184 */     StringBuffer buf = (StringBuffer)data;
/* 1185 */     Object[] args = { node.distinct, node.jjtGetChild(0).jjtAccept(this, new StringBuffer()).toString() };
/*      */ 
/* 1189 */     JDBCTypeMappingMetaData.SUM_FUNC.getFunctionSql(args, buf);
/* 1190 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTCount node, Object data)
/*      */   {
/* 1195 */     StringBuffer buf = (StringBuffer)data;
/* 1196 */     node.setResultType(this.returnType);
/*      */ 
/* 1199 */     ASTPath cntPath = (ASTPath)node.jjtGetChild(0);
/*      */     Object[] args;
/*      */     Object[] args;
/* 1200 */     if (cntPath.isCMPField())
/*      */     {
/* 1202 */       args = new Object[] { node.distinct, node.jjtGetChild(0).jjtAccept(this, new StringBuffer()).toString() };
/*      */     }
/*      */     else
/*      */     {
/* 1206 */       JDBCAbstractEntityBridge entity = (JDBCAbstractEntityBridge)cntPath.getEntity();
/* 1207 */       JDBCFieldBridge[] pkFields = entity.getPrimaryKeyFields();
/* 1208 */       if (pkFields.length > 1)
/*      */       {
/* 1210 */         this.countCompositePk = true;
/* 1211 */         this.forceDistinct = (node.distinct.length() > 0);
/*      */ 
/* 1213 */         addLeftJoinPath(cntPath);
/*      */ 
/* 1215 */         String alias = this.aliasManager.getAlias(cntPath.getPath());
/* 1216 */         SQLUtil.getColumnNamesClause(entity.getPrimaryKeyFields(), alias, buf);
/*      */ 
/* 1220 */         return buf;
/*      */       }
/*      */ 
/* 1224 */       String alias = this.aliasManager.getAlias(cntPath.getPath());
/* 1225 */       StringBuffer keyColumn = new StringBuffer(20);
/* 1226 */       SQLUtil.getColumnNamesClause(pkFields[0], alias, keyColumn);
/* 1227 */       args = new Object[] { node.distinct, keyColumn.toString() };
/*      */     }
/*      */ 
/* 1231 */     JDBCTypeMappingMetaData.COUNT_FUNC.getFunctionSql(args, buf);
/* 1232 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTPath node, Object data)
/*      */   {
/* 1237 */     StringBuffer buf = (StringBuffer)data;
/* 1238 */     if (!node.isCMPField())
/*      */     {
/* 1240 */       throw new IllegalStateException("Can only visit cmp valued path node. Should have been handled at a higher level.");
/*      */     }
/*      */ 
/* 1244 */     JDBCFieldBridge cmpField = node.getCMPField();
/*      */ 
/* 1247 */     switch (node.type)
/*      */     {
/*      */     case 5:
/*      */     case 6:
/* 1251 */       if ((cmpField.getJDBCType().hasMapper()) || (cmpField.getJDBCType().getParameterSetter() != null))
/*      */       {
/*      */         break;
/*      */       }
/*      */ 
/*      */     case -1:
/* 1257 */       throw new IllegalStateException("Can not visit multi-column path node. Should have been handled at a higher level.");
/*      */     }
/*      */ 
/* 1261 */     addLeftJoinPath(node);
/* 1262 */     String alias = this.aliasManager.getAlias(node.getPath(node.size() - 2));
/* 1263 */     SQLUtil.getColumnNamesClause(cmpField, alias, buf);
/* 1264 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTAbstractSchema node, Object data)
/*      */   {
/* 1269 */     throw new IllegalStateException("Can not visit abstract schema node.  Should have been handled at a higher level.");
/*      */   }
/*      */ 
/*      */   public Object visit(ASTIdentifier node, Object data)
/*      */   {
/* 1275 */     throw new UnsupportedOperationException("Must not visit ASTIdentifier noe.");
/*      */   }
/*      */ 
/*      */   public Object visit(ASTParameter node, Object data)
/*      */   {
/* 1280 */     StringBuffer buf = (StringBuffer)data;
/* 1281 */     Class type = getParameterType(node.number);
/*      */ 
/* 1284 */     int ejbqlType = EJBQLTypes.getEJBQLType(type);
/* 1285 */     if ((ejbqlType == 5) || (ejbqlType == 6) || (ejbqlType == -1))
/*      */     {
/* 1290 */       throw new IllegalStateException("Can not visit multi-column parameter node. Should have been handled at a higher level.");
/*      */     }
/*      */ 
/* 1294 */     QueryParameter param = new QueryParameter(node.number - 1, this.typeFactory.getJDBCType(type));
/* 1295 */     this.inputParameters.add(param);
/* 1296 */     buf.append('?');
/*      */ 
/* 1298 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTExactNumericLiteral node, Object data)
/*      */   {
/* 1303 */     StringBuffer buf = (StringBuffer)data;
/* 1304 */     buf.append(node.literal);
/* 1305 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTApproximateNumericLiteral node, Object data)
/*      */   {
/* 1310 */     StringBuffer buf = (StringBuffer)data;
/* 1311 */     buf.append(node.literal);
/* 1312 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTStringLiteral node, Object data)
/*      */   {
/* 1317 */     StringBuffer buf = (StringBuffer)data;
/* 1318 */     buf.append(node.value);
/* 1319 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTBooleanLiteral node, Object data)
/*      */   {
/* 1324 */     StringBuffer buf = (StringBuffer)data;
/* 1325 */     if (node.value)
/*      */     {
/* 1327 */       buf.append(this.typeMapping.getTrueMapping());
/*      */     }
/*      */     else
/*      */     {
/* 1331 */       buf.append(this.typeMapping.getFalseMapping());
/*      */     }
/* 1333 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTFrom from, Object data)
/*      */   {
/* 1338 */     StringBuffer sql = (StringBuffer)data;
/* 1339 */     from.jjtGetChild(0).jjtAccept(this, data);
/* 1340 */     for (int i = 1; i < from.jjtGetNumChildren(); i++)
/*      */     {
/* 1342 */       from.jjtGetChild(i).jjtAccept(this, data);
/*      */     }
/*      */ 
/* 1345 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTCollectionMemberDeclaration node, Object data)
/*      */   {
/* 1350 */     ASTPath path = (ASTPath)node.jjtGetChild(0);
/*      */ 
/* 1353 */     ASTIdentifier id = (ASTIdentifier)node.jjtGetChild(1);
/* 1354 */     String alias = this.aliasManager.getAlias(id.identifier);
/* 1355 */     this.aliasManager.addAlias(path.getPath(), alias);
/*      */ 
/* 1357 */     addInnerJoinPath(path);
/*      */ 
/* 1359 */     return data;
/*      */   }
/*      */ 
/*      */   public Object visit(ASTRangeVariableDeclaration node, Object data)
/*      */   {
/* 1364 */     ASTAbstractSchema schema = (ASTAbstractSchema)node.jjtGetChild(0);
/* 1365 */     JDBCAbstractEntityBridge entity = (JDBCAbstractEntityBridge)schema.entity;
/* 1366 */     ASTIdentifier id = (ASTIdentifier)node.jjtGetChild(1);
/* 1367 */     declareTable(id.identifier, entity.getQualifiedTableName());
/* 1368 */     return data;
/*      */   }
/*      */ 
/*      */   private void compareEntity(boolean not, Node fromNode, Node toNode, StringBuffer buf)
/*      */   {
/* 1375 */     buf.append('(');
/* 1376 */     if (not)
/*      */     {
/* 1378 */       buf.append(" NOT ").append('(');
/*      */     }
/*      */ 
/* 1381 */     ASTPath fromPath = (ASTPath)fromNode;
/* 1382 */     addLeftJoinPath(fromPath);
/* 1383 */     String fromAlias = this.aliasManager.getAlias(fromPath.getPath());
/* 1384 */     JDBCAbstractEntityBridge fromEntity = (JDBCAbstractEntityBridge)fromPath.getEntity();
/*      */ 
/* 1386 */     if ((toNode instanceof ASTParameter))
/*      */     {
/* 1388 */       ASTParameter toParam = (ASTParameter)toNode;
/*      */ 
/* 1391 */       verifyParameterEntityType(toParam.number, fromEntity);
/*      */ 
/* 1393 */       this.inputParameters.addAll(QueryParameter.createParameters(toParam.number - 1, fromEntity));
/*      */ 
/* 1395 */       SQLUtil.getWhereClause(fromEntity.getPrimaryKeyFields(), fromAlias, buf);
/*      */     }
/*      */     else
/*      */     {
/* 1399 */       ASTPath toPath = (ASTPath)toNode;
/* 1400 */       addLeftJoinPath(toPath);
/* 1401 */       String toAlias = this.aliasManager.getAlias(toPath.getPath());
/* 1402 */       JDBCAbstractEntityBridge toEntity = (JDBCAbstractEntityBridge)toPath.getEntity();
/*      */ 
/* 1405 */       if (!fromEntity.equals(toEntity))
/*      */       {
/* 1407 */         throw new IllegalStateException("Only like types can be compared: from entity=" + fromEntity.getEntityName() + " to entity=" + toEntity.getEntityName());
/*      */       }
/*      */ 
/* 1415 */       SQLUtil.getSelfCompareWhereClause(fromEntity.getPrimaryKeyFields(), fromAlias, toAlias, buf);
/*      */     }
/*      */ 
/* 1418 */     if (not)
/*      */     {
/* 1420 */       buf.append(')');
/*      */     }
/* 1422 */     buf.append(')');
/*      */   }
/*      */ 
/*      */   private void join(String alias, StringBuffer sql)
/*      */   {
/* 1427 */     Map paths = (Map)this.joinPaths.get(alias);
/* 1428 */     if ((paths == null) || (paths.isEmpty()))
/*      */     {
/* 1430 */       return;
/*      */     }
/*      */ 
/* 1433 */     for (Iterator iter = paths.values().iterator(); iter.hasNext(); )
/*      */     {
/* 1435 */       String leftAlias = alias;
/* 1436 */       ASTPath path = (ASTPath)iter.next();
/* 1437 */       for (int i = 1; i < path.size(); i++)
/*      */       {
/* 1439 */         if (!path.isCMRField(i))
/*      */           continue;
/* 1441 */         String curPath = path.getPath(i);
/* 1442 */         String joinAlias = this.aliasManager.getAlias(curPath);
/*      */ 
/* 1444 */         if (this.joinedAliases.add(joinAlias))
/*      */         {
/* 1446 */           JDBCAbstractCMRFieldBridge cmrField = (JDBCAbstractCMRFieldBridge)path.getCMRField(i);
/* 1447 */           JDBCAbstractEntityBridge joinEntity = (JDBCAbstractEntityBridge)cmrField.getRelatedEntity();
/*      */ 
/* 1449 */           JDBCRelationMetaData relation = cmrField.getMetaData().getRelationMetaData();
/*      */ 
/* 1451 */           String join = path.innerJoin ? " INNER JOIN " : " LEFT OUTER JOIN ";
/*      */ 
/* 1453 */           if (relation.isTableMappingStyle())
/*      */           {
/* 1455 */             String relTableAlias = this.aliasManager.getRelationTableAlias(curPath);
/* 1456 */             sql.append(join).append(cmrField.getQualifiedTableName()).append(' ').append(relTableAlias).append(" ON ");
/*      */ 
/* 1461 */             SQLUtil.getRelationTableJoinClause(cmrField, leftAlias, relTableAlias, sql);
/*      */ 
/* 1463 */             sql.append(join).append(joinEntity.getQualifiedTableName()).append(' ').append(joinAlias).append(" ON ");
/*      */ 
/* 1468 */             SQLUtil.getRelationTableJoinClause(cmrField.getRelatedCMRField(), joinAlias, relTableAlias, sql);
/*      */           }
/*      */           else
/*      */           {
/* 1472 */             sql.append(join).append(joinEntity.getQualifiedTableName()).append(' ').append(joinAlias).append(" ON ");
/*      */ 
/* 1478 */             SQLUtil.getJoinClause(cmrField, leftAlias, joinAlias, sql);
/*      */           }
/*      */ 
/* 1481 */           join(joinAlias, sql);
/*      */         }
/* 1483 */         leftAlias = joinAlias;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void declareTable(String alias, String table)
/*      */   {
/* 1491 */     this.identifierToTable.put(alias, table);
/*      */   }
/*      */ 
/*      */   private void addLeftJoinPath(ASTPath path)
/*      */   {
/* 1496 */     if ((path.size() > 1) && (path.isCMRField(1)))
/*      */     {
/* 1498 */       String identifier = path.getPath(0);
/* 1499 */       String alias = this.aliasManager.getAlias(identifier);
/* 1500 */       Map paths = (Map)this.joinPaths.get(alias);
/* 1501 */       if (paths == null)
/*      */       {
/* 1503 */         paths = new HashMap();
/* 1504 */         this.joinPaths.put(alias, paths);
/*      */       }
/*      */ 
/* 1507 */       ASTPath oldPath = (ASTPath)paths.put(path, path);
/* 1508 */       if ((oldPath != null) && (oldPath.innerJoin))
/*      */       {
/* 1510 */         path.innerJoin = true;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addInnerJoinPath(ASTPath path)
/*      */   {
/* 1517 */     if ((path.size() > 1) && (path.isCMRField(1)))
/*      */     {
/* 1519 */       String identifier = path.getPath(0);
/* 1520 */       String alias = this.aliasManager.getAlias(identifier);
/* 1521 */       Map paths = (Map)this.joinPaths.get(alias);
/* 1522 */       if (paths == null)
/*      */       {
/* 1524 */         paths = new HashMap();
/* 1525 */         this.joinPaths.put(alias, paths);
/*      */       }
/*      */ 
/* 1528 */       path.innerJoin = true;
/* 1529 */       paths.put(path, path);
/*      */     }
/*      */   }
/*      */ 
/*      */   private Object[] childrenToStringArr(int numChildren, Node node)
/*      */   {
/* 1535 */     Object[] args = new Object[numChildren];
/* 1536 */     for (int i = 0; i < numChildren; i++)
/*      */     {
/* 1538 */       args[i] = node.jjtGetChild(i).jjtAccept(this, new StringBuffer()).toString();
/*      */     }
/* 1540 */     return args;
/*      */   }
/*      */ 
/*      */   private ASTPath getPathFromChildren(Node selectFunction)
/*      */   {
/* 1551 */     for (int childInd = 0; childInd < selectFunction.jjtGetNumChildren(); childInd++)
/*      */     {
/* 1553 */       Node child = selectFunction.jjtGetChild(childInd);
/* 1554 */       if ((child instanceof ASTPath))
/*      */       {
/* 1556 */         return (ASTPath)child;
/*      */       }
/* 1558 */       if (!(child instanceof SelectFunction))
/*      */         continue;
/* 1560 */       Node path = getPathFromChildren(child);
/* 1561 */       if (path != null)
/*      */       {
/* 1563 */         return (ASTPath)path;
/*      */       }
/*      */     }
/*      */ 
/* 1567 */     return null;
/*      */   }
/*      */ 
/*      */   private void setTypeFactory(JDBCTypeFactory typeFactory)
/*      */   {
/* 1572 */     this.typeFactory = typeFactory;
/* 1573 */     this.typeMapping = typeFactory.getTypeMapping();
/* 1574 */     this.aliasManager = new AliasManager(this.typeMapping.getAliasHeaderPrefix(), this.typeMapping.getAliasHeaderSuffix(), this.typeMapping.getAliasMaxLength());
/*      */   }
/*      */ 
/*      */   private Class getParameterType(int index)
/*      */   {
/* 1581 */     int zeroBasedIndex = index - 1;
/* 1582 */     Class[] params = this.parameterTypes;
/* 1583 */     if (zeroBasedIndex < params.length)
/*      */     {
/* 1585 */       return params[zeroBasedIndex];
/*      */     }
/* 1587 */     return null;
/*      */   }
/*      */ 
/*      */   private void verifyParameterEntityType(int number, JDBCAbstractEntityBridge entity)
/*      */   {
/* 1593 */     Class parameterType = getParameterType(number);
/* 1594 */     Class remoteClass = entity.getRemoteInterface();
/* 1595 */     Class localClass = entity.getLocalInterface();
/* 1596 */     if (((localClass == null) || (!localClass.isAssignableFrom(parameterType))) && ((remoteClass == null) || (!remoteClass.isAssignableFrom(parameterType))))
/*      */     {
/* 1599 */       throw new IllegalStateException("Only like types can be compared: from entity=" + entity.getEntityName() + " to parameter type=" + parameterType);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void reset()
/*      */   {
/* 1606 */     this.returnType = null;
/* 1607 */     this.parameterTypes = null;
/* 1608 */     this.readAhead = null;
/* 1609 */     this.inputParameters.clear();
/* 1610 */     this.selectObject = null;
/* 1611 */     this.selectManager = null;
/* 1612 */     this.typeFactory = null;
/* 1613 */     this.typeMapping = null;
/* 1614 */     this.aliasManager = null;
/* 1615 */     this.forceDistinct = false;
/* 1616 */     this.limitParam = 0;
/* 1617 */     this.limitValue = 0;
/* 1618 */     this.offsetParam = 0;
/* 1619 */     this.offsetValue = 0;
/* 1620 */     this.leftJoinCMRList.clear();
/* 1621 */     this.onFindCMRJoin = null;
/* 1622 */     this.countCompositePk = false;
/* 1623 */     this.joinPaths.clear();
/* 1624 */     this.identifierToTable.clear();
/* 1625 */     this.joinedAliases.clear();
/* 1626 */     this.selectDistinct = false;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.EJBQLToSQL92Compiler
 * JD-Core Version:    0.6.0
 */