/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.rmi.RemoteException;
/*     */ import java.security.AccessController;
/*     */ import java.security.Principal;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.ejb.EJBLocalObject;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.RemoveException;
/*     */ import javax.sql.DataSource;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EJBProxyFactory;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.LocalProxyFactory;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractCMRFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMRFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationshipRoleMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.SecurityAssociation;
/*     */ 
/*     */ public abstract class CascadeDeleteStrategy
/*     */ {
/*     */   protected final JDBCCMRFieldBridge cmrField;
/*     */   protected final JDBCEntityBridge entity;
/*     */   protected final JDBCStoreManager relatedManager;
/*     */   protected final Logger log;
/*     */ 
/*     */   public static CascadeDeleteStrategy getCascadeDeleteStrategy(JDBCCMRFieldBridge cmrField)
/*     */     throws DeploymentException
/*     */   {
/* 209 */     JDBCRelationshipRoleMetaData relatedRole = cmrField.getMetaData().getRelatedRole();
/*     */     CascadeDeleteStrategy result;
/*     */     CascadeDeleteStrategy result;
/* 210 */     if (relatedRole.isBatchCascadeDelete())
/*     */     {
/* 212 */       result = new BatchCascadeDeleteStrategy(cmrField);
/*     */     }
/*     */     else
/*     */     {
/*     */       CascadeDeleteStrategy result;
/* 214 */       if (relatedRole.isCascadeDelete())
/*     */       {
/* 216 */         result = new DefaultCascadeDeleteStrategy(cmrField);
/*     */       }
/*     */       else
/*     */       {
/* 220 */         result = new NoneCascadeDeleteStrategy(cmrField);
/*     */       }
/*     */     }
/* 222 */     return result;
/*     */   }
/*     */ 
/*     */   public CascadeDeleteStrategy(JDBCCMRFieldBridge cmrField)
/*     */     throws DeploymentException
/*     */   {
/* 232 */     this.cmrField = cmrField;
/* 233 */     this.entity = ((JDBCEntityBridge)cmrField.getEntity());
/* 234 */     this.relatedManager = cmrField.getRelatedManager();
/*     */ 
/* 236 */     this.log = Logger.getLogger(getClass().getName() + "." + cmrField.getEntity().getEntityName());
/*     */   }
/*     */ 
/*     */   public abstract void removedIds(EntityEnterpriseContext paramEntityEnterpriseContext, Object[] paramArrayOfObject, List paramList);
/*     */ 
/*     */   public abstract void cascadeDelete(EntityEnterpriseContext paramEntityEnterpriseContext, List paramList) throws RemoveException, RemoteException;
/*     */ 
/*     */   protected void scheduleCascadeDelete(Object[] oldRelationsRef, List values) {
/* 246 */     Map oldRelations = (Map)oldRelationsRef[0];
/* 247 */     if (oldRelations == null)
/*     */     {
/* 249 */       oldRelations = new HashMap();
/* 250 */       oldRelationsRef[0] = oldRelations;
/*     */     }
/* 252 */     oldRelations.put(this.cmrField, values);
/* 253 */     this.relatedManager.scheduleCascadeDelete(values);
/*     */   }
/*     */ 
/*     */   protected void executeDeleteSQL(String sql, Object key) throws RemoveException
/*     */   {
/* 258 */     Connection con = null;
/* 259 */     PreparedStatement ps = null;
/* 260 */     int rowsAffected = 0;
/*     */     try
/*     */     {
/* 263 */       if (this.log.isDebugEnabled()) {
/* 264 */         this.log.debug("Executing SQL: " + sql);
/*     */       }
/*     */ 
/* 267 */       con = this.entity.getDataSource().getConnection();
/* 268 */       ps = con.prepareStatement(sql);
/*     */ 
/* 271 */       this.entity.setPrimaryKeyParameters(ps, 1, key);
/*     */ 
/* 274 */       rowsAffected = ps.executeUpdate();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 278 */       this.log.error("Could not remove " + key, e);
/* 279 */       throw new RemoveException("Could not remove " + key);
/*     */     }
/*     */     finally
/*     */     {
/* 283 */       JDBCUtil.safeClose(ps);
/* 284 */       JDBCUtil.safeClose(con);
/*     */     }
/*     */ 
/* 288 */     if (rowsAffected == 0)
/*     */     {
/* 290 */       this.log.error("Could not remove entity " + key);
/* 291 */       throw new RemoveException("Could not remove entity");
/*     */     }
/*     */ 
/* 294 */     if (this.log.isDebugEnabled())
/* 295 */       this.log.debug("Remove: Rows affected = " + rowsAffected);
/*     */   }
/*     */ 
/*     */   public void invokeRemoveRelated(Object relatedId) throws RemoveException, RemoteException
/*     */   {
/* 300 */     EntityContainer container = this.relatedManager.getContainer();
/*     */ 
/* 333 */     if (container.getLocalProxyFactory() != null)
/*     */     {
/* 335 */       EJBLocalObject ejbObject = container.getLocalProxyFactory().getEntityEJBLocalObject(relatedId);
/* 336 */       ejbObject.remove();
/*     */     }
/*     */     else
/*     */     {
/* 340 */       EJBObject ejbObject = (EJBObject)container.getProxyFactory().getEntityEJBObject(relatedId);
/* 341 */       ejbObject.remove();
/*     */     }
/*     */   }
/*     */ 
/*     */   static abstract interface SecurityActions
/*     */   {
/* 355 */     public static final SecurityActions NON_PRIVILEGED = new SecurityActions()
/*     */     {
/*     */       public Principal getPrincipal()
/*     */       {
/* 359 */         return SecurityAssociation.getPrincipal();
/*     */       }
/*     */ 
/*     */       public Object getCredential()
/*     */       {
/* 364 */         return SecurityAssociation.getCredential();
/*     */       }
/* 355 */     };
/*     */ 
/* 368 */     public static final SecurityActions PRIVILEGED = new SecurityActions()
/*     */     {
/* 370 */       private final PrivilegedAction getPrincipalAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/* 374 */           return SecurityAssociation.getPrincipal();
/*     */         }
/* 370 */       };
/*     */ 
/* 378 */       private final PrivilegedAction getCredentialAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/* 382 */           return SecurityAssociation.getCredential();
/*     */         }
/* 378 */       };
/*     */ 
/*     */       public Principal getPrincipal()
/*     */       {
/* 388 */         return (Principal)AccessController.doPrivileged(this.getPrincipalAction);
/*     */       }
/*     */ 
/*     */       public Object getCredential()
/*     */       {
/* 393 */         return AccessController.doPrivileged(this.getCredentialAction);
/*     */       }
/* 368 */     };
/*     */ 
/*     */     public abstract Principal getPrincipal();
/*     */ 
/*     */     public abstract Object getCredential();
/*     */ 
/*     */     public static class UTIL
/*     */     {
/*     */       static CascadeDeleteStrategy.SecurityActions getSecurityActions()
/*     */       {
/* 351 */         return System.getSecurityManager() == null ? CascadeDeleteStrategy.SecurityActions.NON_PRIVILEGED : CascadeDeleteStrategy.SecurityActions.PRIVILEGED;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static final class BatchCascadeDeleteStrategy extends CascadeDeleteStrategy
/*     */   {
/*     */     private final String batchCascadeDeleteSql;
/*     */ 
/*     */     public BatchCascadeDeleteStrategy(JDBCCMRFieldBridge cmrField)
/*     */       throws DeploymentException
/*     */     {
/* 145 */       super();
/*     */ 
/* 147 */       if (cmrField.hasForeignKey())
/*     */       {
/* 149 */         throw new DeploymentException("Batch cascade-delete was setup for the role with a foreign key: relationship " + cmrField.getMetaData().getRelationMetaData().getRelationName() + ", role " + cmrField.getMetaData().getRelationshipRoleName() + ". Batch cascade-delete supported only for roles with no foreign keys.");
/*     */       }
/*     */ 
/* 157 */       StringBuffer buf = new StringBuffer(100);
/* 158 */       buf.append("DELETE FROM ").append(cmrField.getRelatedJDBCEntity().getQualifiedTableName()).append(" WHERE ");
/*     */ 
/* 161 */       SQLUtil.getWhereClause(cmrField.getRelatedCMRField().getForeignKeyFields(), buf);
/* 162 */       this.batchCascadeDeleteSql = buf.toString();
/*     */ 
/* 164 */       this.log.debug(cmrField.getMetaData().getRelationMetaData().getRelationName() + " batch cascade delete SQL: " + this.batchCascadeDeleteSql);
/*     */     }
/*     */ 
/*     */     public void removedIds(EntityEnterpriseContext ctx, Object[] oldRelationRefs, List ids)
/*     */     {
/* 172 */       this.cmrField.scheduleChildrenForBatchCascadeDelete(ctx);
/* 173 */       scheduleCascadeDelete(oldRelationRefs, new ArrayList(ids));
/*     */     }
/*     */ 
/*     */     public void cascadeDelete(EntityEnterpriseContext ctx, List oldValues) throws RemoveException, RemoteException
/*     */     {
/* 178 */       boolean didDelete = false;
/* 179 */       boolean trace = this.log.isTraceEnabled();
/* 180 */       for (int i = 0; i < oldValues.size(); i++)
/*     */       {
/* 182 */         Object oldValue = oldValues.get(i);
/* 183 */         if (this.relatedManager.unscheduledCascadeDelete(oldValue))
/*     */         {
/* 185 */           if (trace)
/*     */           {
/* 187 */             this.log.trace("Removing " + oldValue);
/*     */           }
/* 189 */           invokeRemoveRelated(oldValue);
/* 190 */           didDelete = true;
/*     */         } else {
/* 192 */           if (!trace)
/*     */             continue;
/* 194 */           this.log.trace(oldValue + " already removed");
/*     */         }
/*     */       }
/*     */ 
/* 198 */       if (didDelete)
/*     */       {
/* 200 */         executeDeleteSQL(this.batchCascadeDeleteSql, ctx.getId());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static final class DefaultCascadeDeleteStrategy extends CascadeDeleteStrategy
/*     */   {
/*     */     public DefaultCascadeDeleteStrategy(JDBCCMRFieldBridge cmrField)
/*     */       throws DeploymentException
/*     */     {
/* 101 */       super();
/*     */     }
/*     */ 
/*     */     public void removedIds(EntityEnterpriseContext ctx, Object[] oldRelationRef, List ids)
/*     */     {
/* 106 */       this.cmrField.scheduleChildrenForCascadeDelete(ctx);
/* 107 */       scheduleCascadeDelete(oldRelationRef, new ArrayList(ids));
/* 108 */       this.cmrField.setInstanceValue(ctx, null);
/*     */     }
/*     */ 
/*     */     public void cascadeDelete(EntityEnterpriseContext ctx, List oldValues) throws RemoveException, RemoteException
/*     */     {
/* 113 */       boolean trace = this.log.isTraceEnabled();
/* 114 */       for (int i = 0; i < oldValues.size(); i++)
/*     */       {
/* 116 */         Object oldValue = oldValues.get(i);
/* 117 */         if (this.relatedManager.unscheduledCascadeDelete(oldValue))
/*     */         {
/* 119 */           if (trace)
/*     */           {
/* 121 */             this.log.trace("Removing " + oldValue);
/*     */           }
/* 123 */           invokeRemoveRelated(oldValue);
/*     */         } else {
/* 125 */           if (!trace)
/*     */             continue;
/* 127 */           this.log.trace(oldValue + " already removed");
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static final class NoneCascadeDeleteStrategy extends CascadeDeleteStrategy
/*     */   {
/*     */     public NoneCascadeDeleteStrategy(JDBCCMRFieldBridge cmrField)
/*     */       throws DeploymentException
/*     */     {
/*  62 */       super();
/*     */     }
/*     */ 
/*     */     public void removedIds(EntityEnterpriseContext ctx, Object[] oldRelationRefs, List ids)
/*     */     {
/*  67 */       this.cmrField.setInstanceValue(ctx, null);
/*     */     }
/*     */ 
/*     */     public void cascadeDelete(EntityEnterpriseContext ctx, List oldValues) throws RemoveException, RemoteException
/*     */     {
/*  72 */       boolean trace = this.log.isTraceEnabled();
/*  73 */       for (int i = 0; i < oldValues.size(); i++)
/*     */       {
/*  75 */         Object oldValue = oldValues.get(i);
/*  76 */         if (this.relatedManager.unscheduledCascadeDelete(oldValue))
/*     */         {
/*  78 */           if (trace)
/*     */           {
/*  80 */             this.log.trace("Removing " + oldValue);
/*     */           }
/*     */ 
/*  83 */           invokeRemoveRelated(oldValue);
/*     */         } else {
/*  85 */           if (!trace)
/*     */             continue;
/*  87 */           this.log.trace(oldValue + " already removed");
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.CascadeDeleteStrategy
 * JD-Core Version:    0.6.0
 */