/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.sql.Blob;
/*     */ import java.sql.SQLException;
/*     */ 
/*     */ public final class ByteArrayBlob
/*     */   implements Blob
/*     */ {
/*     */   private final byte[] mBytes;
/*     */ 
/*     */   public ByteArrayBlob(byte[] bytes)
/*     */   {
/*  56 */     if (bytes == null)
/*     */     {
/*  58 */       bytes = new byte[0];
/*     */     }
/*     */ 
/*  61 */     this.mBytes = bytes;
/*     */   }
/*     */ 
/*     */   public InputStream getBinaryStream() throws SQLException
/*     */   {
/*  66 */     return new ByteArrayInputStream(this.mBytes);
/*     */   }
/*     */ 
/*     */   public byte[] getBytes(long pos, int length)
/*     */     throws SQLException
/*     */   {
/*  72 */     if ((length < 0) || (length > this.mBytes.length) || (pos > this.mBytes.length))
/*     */     {
/*  74 */       return new byte[0];
/*     */     }
/*     */ 
/*  77 */     if (pos <= 0L)
/*     */     {
/*  79 */       pos = 1L;
/*     */     }
/*     */ 
/*  82 */     byte[] buffer = new byte[length];
/*     */ 
/*  84 */     System.arraycopy(this.mBytes, (int)pos - 1, buffer, 0, length);
/*  85 */     return buffer;
/*     */   }
/*     */ 
/*     */   public long length() throws SQLException
/*     */   {
/*  90 */     return this.mBytes.length;
/*     */   }
/*     */ 
/*     */   public long position(Blob pattern, long start) throws SQLException
/*     */   {
/*  95 */     return position(pattern.getBytes(0L, (int)pattern.length()), start);
/*     */   }
/*     */ 
/*     */   public long position(byte[] pattern, long start)
/*     */     throws SQLException
/*     */   {
/* 101 */     int max = this.mBytes.length - pattern.length;
/*     */ 
/* 103 */     if (start < 0L)
/*     */     {
/* 105 */       start = 0L;
/* 106 */     } else if (start >= this.mBytes.length)
/*     */     {
/* 108 */       return -1L;
/*     */     }
/*     */ 
/* 111 */     if (pattern.length == 0)
/*     */     {
/* 113 */       return -1L;
/*     */     }
/*     */ 
/* 116 */     byte first = pattern[0];
/* 117 */     int i = (int)start;
/*     */     while (true)
/*     */     {
/* 122 */       if ((i <= max) && (this.mBytes[i] != first))
/*     */       {
/* 124 */         i++; continue;
/*     */       }
/*     */ 
/* 127 */       if (i > max)
/*     */       {
/* 129 */         return -1L;
/*     */       }
/*     */ 
/* 133 */       int j = i + 1;
/* 134 */       int end = j + pattern.length - 1;
/* 135 */       int k = 1;
/* 136 */       boolean cont = true;
/*     */ 
/* 140 */       while ((cont) && (j < end))
/*     */       {
/* 142 */         if (this.mBytes[(j++)] == pattern[(k++)])
/*     */           continue;
/* 144 */         i++;
/* 145 */         cont = false;
/*     */       }
/*     */ 
/* 149 */       if (cont)
/*     */       {
/* 151 */         return i;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void free() throws SQLException
/*     */   {
/*     */   }
/*     */ 
/*     */   public InputStream getBinaryStream(long pos, long length) throws SQLException
/*     */   {
/* 162 */     throw new UnsupportedOperationException("Unimplemented JDK6 method");
/*     */   }
/*     */ 
/*     */   public OutputStream setBinaryStream(long pos)
/*     */     throws SQLException
/*     */   {
/* 168 */     throw new UnsupportedOperationException("ByteArrayBlob is immutable");
/*     */   }
/*     */ 
/*     */   public int setBytes(long pos, byte[] bytes) throws SQLException
/*     */   {
/* 173 */     throw new UnsupportedOperationException("ByteArrayBlob is immutable");
/*     */   }
/*     */ 
/*     */   public int setBytes(long pos, byte[] bytes, int offset, int length) throws SQLException
/*     */   {
/* 178 */     throw new UnsupportedOperationException("ByteArrayBlob is immutable");
/*     */   }
/*     */ 
/*     */   public void truncate(long length) throws SQLException
/*     */   {
/* 183 */     throw new UnsupportedOperationException("ByteArrayBlob is immutable");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.ByteArrayBlob
 * JD-Core Version:    0.6.0
 */