/*    */ package org.jboss.ejb.plugins.cmp.jdbc;
/*    */ 
/*    */ import java.util.HashMap;
/*    */ import java.util.Map;
/*    */ 
/*    */ final class AliasManager
/*    */ {
/*    */   private static final String RELATION_TABLE_SUFFIX = "_RELATION_TABLE";
/*    */   private final String prefix;
/*    */   private final String suffix;
/*    */   private final int maxLength;
/* 41 */   private final Map aliases = new HashMap();
/* 42 */   private final Map relationTableAliases = new HashMap();
/*    */ 
/* 44 */   private int count = 0;
/*    */ 
/*    */   public AliasManager(String prefix, String suffix, int maxLength)
/*    */   {
/* 48 */     this.prefix = prefix;
/* 49 */     this.suffix = suffix;
/* 50 */     this.maxLength = maxLength;
/*    */   }
/*    */ 
/*    */   public String getAlias(String path)
/*    */   {
/* 55 */     String alias = (String)this.aliases.get(path);
/* 56 */     if (alias == null)
/*    */     {
/* 58 */       alias = createAlias(path);
/* 59 */       this.aliases.put(path, alias);
/*    */     }
/* 61 */     return alias;
/*    */   }
/*    */ 
/*    */   private String createAlias(String path)
/*    */   {
/* 66 */     StringBuffer alias = new StringBuffer();
/* 67 */     alias.append(this.prefix).append(this.count++).append(this.suffix);
/* 68 */     alias.append(path.replace('.', '_'));
/*    */ 
/* 70 */     return alias.substring(0, Math.min(this.maxLength, alias.length()));
/*    */   }
/*    */ 
/*    */   public void addAlias(String path, String alias)
/*    */   {
/* 75 */     this.aliases.put(path, alias);
/*    */   }
/*    */ 
/*    */   public String getRelationTableAlias(String path)
/*    */   {
/* 80 */     String relationTableAlias = (String)this.relationTableAliases.get(path);
/* 81 */     if (relationTableAlias == null)
/*    */     {
/* 83 */       relationTableAlias = createRelationTableAlias(path);
/* 84 */       this.relationTableAliases.put(path, relationTableAlias);
/*    */     }
/* 86 */     return relationTableAlias;
/*    */   }
/*    */ 
/*    */   private String createRelationTableAlias(String path)
/*    */   {
/* 91 */     StringBuffer relationTableAlias = new StringBuffer();
/*    */ 
/* 93 */     relationTableAlias.append(this.prefix).append(this.count++).append(this.suffix);
/*    */ 
/* 95 */     relationTableAlias.append(path.replace('.', '_'));
/* 96 */     relationTableAlias.append("_RELATION_TABLE");
/*    */ 
/* 98 */     return relationTableAlias.substring(0, Math.min(this.maxLength, relationTableAlias.length()));
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.AliasManager
 * JD-Core Version:    0.6.0
 */