/*      */ package org.jboss.ejb.plugins.cmp.ejbql;
/*      */ 
/*      */ import java.io.CharArrayReader;
/*      */ import java.io.InputStream;
/*      */ import java.io.Reader;
/*      */ import java.util.Enumeration;
/*      */ import java.util.Vector;
/*      */ 
/*      */ public class JBossQLParser
/*      */   implements JBossQLParserTreeConstants, JBossQLParserConstants
/*      */ {
/*   20 */   protected JJTJBossQLParserState jjtree = new JJTJBossQLParserState();
/*      */   private Catalog catalog;
/*      */   private Class[] argumentTypes;
/*      */   private IdentifierManager idManager;
/*      */   private boolean selectDistinct;
/*      */   private String selectPath;
/*      */   public JBossQLParserTokenManager token_source;
/*      */   JavaCharStream jj_input_stream;
/*      */   public Token token;
/*      */   public Token jj_nt;
/*      */   private int jj_ntk;
/*      */   private Token jj_scanpos;
/*      */   private Token jj_lastpos;
/*      */   private int jj_la;
/* 5016 */   public boolean lookingAhead = false;
/*      */   private boolean jj_semLA;
/*      */   private int jj_gen;
/* 5019 */   private final int[] jj_la1 = new int[80];
/*      */   private static int[] jj_la1_0;
/*      */   private static int[] jj_la1_1;
/*      */   private static int[] jj_la1_2;
/* 5037 */   private final JJCalls[] jj_2_rtns = new JJCalls[10];
/* 5038 */   private boolean jj_rescan = false;
/* 5039 */   private int jj_gc = 0;
/*      */ 
/* 5127 */   private final LookaheadSuccess jj_ls = new LookaheadSuccess(null);
/*      */ 
/* 5173 */   private Vector jj_expentries = new Vector();
/*      */   private int[] jj_expentry;
/* 5175 */   private int jj_kind = -1;
/* 5176 */   private int[] jj_lasttokens = new int[100];
/*      */   private int jj_endpos;
/*      */ 
/*      */   public ASTEJBQL parse(Catalog catalog, Class[] argumentTypes, String ejbql)
/*      */     throws ParseException
/*      */   {
/*   29 */     this.catalog = catalog;
/*   30 */     this.token_source.catalog = catalog;
/*   31 */     this.argumentTypes = argumentTypes;
/*   32 */     this.token_source.argumentTypes = argumentTypes;
/*   33 */     this.idManager = new IdentifierManager(catalog);
/*   34 */     this.token_source.idManager = this.idManager;
/*      */ 
/*   36 */     String lowerCase = ejbql.toLowerCase();
/*   37 */     int fromBeginIndex = indexOf(lowerCase, "from");
/*   38 */     if (fromBeginIndex < 0) {
/*   39 */       throw new ParseException("FROM not found");
/*      */     }
/*      */ 
/*   42 */     int fromEndIndex = indexOf(lowerCase, "where");
/*      */ 
/*   44 */     if (fromEndIndex < 0) {
/*   45 */       fromEndIndex = indexOfOrderBy(lowerCase);
/*      */     }
/*   47 */     if (fromEndIndex < 0) {
/*   48 */       fromEndIndex = indexOf(lowerCase, "offset");
/*      */     }
/*   50 */     if (fromEndIndex < 0) {
/*   51 */       fromEndIndex = indexOf(lowerCase, "limit");
/*      */     }
/*   53 */     if (fromEndIndex < 0) {
/*   54 */       fromEndIndex = ejbql.length();
/*      */     }
/*      */ 
/*   59 */     char[] from = ejbql.toCharArray();
/*   60 */     clear(from, 0, fromBeginIndex);
/*   61 */     clear(from, fromEndIndex, from.length);
/*      */ 
/*   64 */     char[] sansFrom = ejbql.toCharArray();
/*   65 */     clear(sansFrom, fromBeginIndex + 4, fromEndIndex);
/*      */ 
/*   68 */     ReInit(new CharArrayReader(from));
/*   69 */     ASTFrom fromNode = ParseFromClause();
/*      */ 
/*   72 */     ReInit(new CharArrayReader(sansFrom));
/*   73 */     ASTEJBQL ejbqlNode = EJBQL();
/*      */ 
/*   77 */     ejbqlNode.jjtAddChild(fromNode, 1);
/*      */ 
/*   79 */     return ejbqlNode;
/*      */   }
/*      */ 
/*      */   private static final int indexOf(String ql, String word)
/*      */   {
/*   88 */     return indexOf(ql, word, 0);
/*      */   }
/*      */ 
/*      */   private static final int indexOf(String ql, String word, int startInd)
/*      */   {
/*   97 */     int i = ql.indexOf(word, startInd);
/*   98 */     if (i < 0)
/*      */     {
/*  100 */       return -1;
/*      */     }
/*      */ 
/*  103 */     int qlLength = ql.length();
/*  104 */     int wordLength = word.length();
/*  105 */     while (i >= 0)
/*      */     {
/*  107 */       int endInd = i + wordLength;
/*  108 */       if (((i == 0) || (Character.isWhitespace(ql.charAt(i - 1)))) && ((endInd == qlLength) || ((endInd < qlLength) && (Character.isWhitespace(ql.charAt(endInd))))))
/*      */       {
/*      */         break;
/*      */       }
/*      */ 
/*  114 */       i = ql.indexOf(word, i + 1);
/*      */     }
/*  116 */     return i;
/*      */   }
/*      */ 
/*      */   private static final int indexOfOrderBy(String ql)
/*      */   {
/*  121 */     int orderInd = indexOf(ql, "order", 0);
/*  122 */     int byInd = -1;
/*  123 */     while (orderInd > 0)
/*      */     {
/*  125 */       if (byInd < orderInd)
/*      */       {
/*  127 */         byInd = indexOf(ql, "by", orderInd + 5);
/*      */       }
/*      */ 
/*  130 */       if (byInd > 0)
/*      */       {
/*  132 */         int i = byInd - 1;
/*  133 */         while ((i >= orderInd + 5) && (Character.isWhitespace(ql.charAt(i--))));
/*  134 */         if (i == orderInd + 4)
/*      */         {
/*      */           break;
/*      */         }
/*      */ 
/*  140 */         orderInd = indexOf(ql, "order", orderInd + 5);
/*      */ 
/*  142 */         continue;
/*      */       }
/*      */ 
/*  145 */       orderInd = -1;
/*      */     }
/*      */ 
/*  148 */     return orderInd;
/*      */   }
/*      */ 
/*      */   private final void clear(char[] c, int beginIndex, int endIndex) {
/*  152 */     for (int i = beginIndex; i < endIndex; i++)
/*  153 */       if ((c[i] != '\r') && (c[i] != '\n') && (c[i] != '\t'))
/*  154 */         c[i] = ' ';
/*      */   }
/*      */ 
/*      */   private final void initPathNode(ASTPath pathNode, String path, int type)
/*      */   {
/*  160 */     pathNode.pathList = this.idManager.getPathList(path);
/*  161 */     pathNode.fieldList = this.idManager.getFieldList(path);
/*  162 */     pathNode.type = type;
/*      */   }
/*      */ 
/*      */   private final void initParameterNode(ASTParameter parameterNode, String number, int type)
/*      */   {
/*  170 */     parameterNode.number = Integer.parseInt(number);
/*  171 */     parameterNode.type = type;
/*      */   }
/*      */ 
/*      */   public final ASTEJBQL EJBQL()
/*      */     throws ParseException
/*      */   {
/*  177 */     ASTEJBQL jjtn000 = new ASTEJBQL(0);
/*  178 */     boolean jjtc000 = true;
/*  179 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/*  181 */       SelectClause();
/*  182 */       FromKeyword();
/*  183 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 33:
/*  185 */         WhereClause();
/*  186 */         break;
/*      */       default:
/*  188 */         this.jj_la1[0] = this.jj_gen;
/*      */       }
/*      */ 
/*  191 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 40:
/*  193 */         OrderByClause();
/*  194 */         break;
/*      */       default:
/*  196 */         this.jj_la1[1] = this.jj_gen;
/*      */       }
/*      */ 
/*  199 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 38:
/*      */       case 39:
/*  202 */         LimitClause();
/*  203 */         break;
/*      */       default:
/*  205 */         this.jj_la1[2] = this.jj_gen;
/*      */       }
/*      */ 
/*  208 */       jj_consume_token(0);
/*  209 */       this.jjtree.closeNodeScope(jjtn000, true);
/*  210 */       jjtc000 = false;
/*  211 */       localASTEJBQL1 = jjtn000;
/*      */     }
/*      */     catch (Throwable jjte000)
/*      */     {
/*      */       ASTEJBQL localASTEJBQL1;
/*  213 */       if (jjtc000) {
/*  214 */         this.jjtree.clearNodeScope(jjtn000);
/*  215 */         jjtc000 = false;
/*      */       } else {
/*  217 */         this.jjtree.popNode();
/*      */       }
/*  219 */       if ((jjte000 instanceof RuntimeException)) {
/*  220 */         throw ((RuntimeException)jjte000);
/*      */       }
/*  222 */       if ((jjte000 instanceof ParseException)) {
/*  223 */         throw ((ParseException)jjte000);
/*      */       }
/*  225 */       throw ((Error)jjte000);
/*      */     } finally {
/*  227 */       if (jjtc000)
/*  228 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final ASTOrderBy OrderByClause()
/*      */     throws ParseException
/*      */   {
/*  236 */     ASTOrderBy jjtn000 = new ASTOrderBy(1);
/*  237 */     boolean jjtc000 = true;
/*  238 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/*  240 */       jj_consume_token(40);
/*  241 */       jj_consume_token(41);
/*  242 */       OrderByPathExpression();
/*      */       while (true)
/*      */       {
/*  245 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */         {
/*      */         case 46:
/*  248 */           break;
/*      */         default:
/*  250 */           this.jj_la1[3] = this.jj_gen;
/*  251 */           break;
/*      */         }
/*  253 */         jj_consume_token(46);
/*  254 */         OrderByPathExpression();
/*      */       }
/*  256 */       this.jjtree.closeNodeScope(jjtn000, true);
/*  257 */       jjtc000 = false;
/*  258 */       localASTOrderBy1 = jjtn000;
/*      */     }
/*      */     catch (Throwable jjte000)
/*      */     {
/*      */       ASTOrderBy localASTOrderBy1;
/*  260 */       if (jjtc000) {
/*  261 */         this.jjtree.clearNodeScope(jjtn000);
/*  262 */         jjtc000 = false;
/*      */       } else {
/*  264 */         this.jjtree.popNode();
/*      */       }
/*  266 */       if ((jjte000 instanceof RuntimeException)) {
/*  267 */         throw ((RuntimeException)jjte000);
/*      */       }
/*  269 */       if ((jjte000 instanceof ParseException)) {
/*  270 */         throw ((ParseException)jjte000);
/*      */       }
/*  272 */       throw ((Error)jjte000);
/*      */     } finally {
/*  274 */       if (jjtc000)
/*  275 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void OrderByPathExpression()
/*      */     throws ParseException
/*      */   {
/*  283 */     ASTOrderByPath jjtn000 = new ASTOrderByPath(2);
/*  284 */     boolean jjtc000 = true;
/*  285 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/*  287 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 83:
/*  289 */         NumericValuedPath();
/*  290 */         break;
/*      */       case 84:
/*  292 */         StringValuedPath();
/*  293 */         break;
/*      */       case 85:
/*  295 */         DatetimeValuedPath();
/*  296 */         break;
/*      */       case 79:
/*      */       case 88:
/*  299 */         ValueClassExpression();
/*  300 */         break;
/*      */       case 80:
/*      */       case 81:
/*      */       case 82:
/*      */       case 86:
/*      */       case 87:
/*      */       default:
/*  302 */         this.jj_la1[4] = this.jj_gen;
/*  303 */         jj_consume_token(-1);
/*  304 */         throw new ParseException();
/*      */       }
/*  306 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 35:
/*      */       case 36:
/*  309 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 35:
/*  311 */           jj_consume_token(35);
/*  312 */           break;
/*      */         case 36:
/*  314 */           jj_consume_token(36);
/*  315 */           jjtn000.ascending = false;
/*  316 */           break;
/*      */         default:
/*  318 */           this.jj_la1[5] = this.jj_gen;
/*  319 */           jj_consume_token(-1);
/*  320 */           throw new ParseException();
/*      */         }
/*      */ 
/*      */       default:
/*  324 */         this.jj_la1[6] = this.jj_gen;
/*      */       }
/*      */     }
/*      */     catch (Throwable jjte000) {
/*  328 */       if (jjtc000) {
/*  329 */         this.jjtree.clearNodeScope(jjtn000);
/*  330 */         jjtc000 = false;
/*      */       } else {
/*  332 */         this.jjtree.popNode();
/*      */       }
/*  334 */       if ((jjte000 instanceof RuntimeException)) {
/*  335 */         throw ((RuntimeException)jjte000);
/*      */       }
/*  337 */       if ((jjte000 instanceof ParseException)) {
/*  338 */         throw ((ParseException)jjte000);
/*      */       }
/*  340 */       throw ((Error)jjte000);
/*      */     } finally {
/*  342 */       if (jjtc000)
/*  343 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void LimitClause()
/*      */     throws ParseException
/*      */   {
/*  350 */     ASTLimitOffset jjtn000 = new ASTLimitOffset(3);
/*  351 */     boolean jjtc000 = true;
/*  352 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/*  354 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 39:
/*  356 */         jj_consume_token(39);
/*  357 */         ArithmeticValue();
/*  358 */         jjtn000.hasOffset = true;
/*  359 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 38:
/*  361 */           jj_consume_token(38);
/*  362 */           ArithmeticValue();
/*  363 */           jjtn000.hasLimit = true;
/*  364 */           break;
/*      */         default:
/*  366 */           this.jj_la1[7] = this.jj_gen;
/*      */         }
/*      */ 
/*  369 */         break;
/*      */       case 38:
/*  371 */         jj_consume_token(38);
/*  372 */         ArithmeticValue();
/*  373 */         this.jjtree.closeNodeScope(jjtn000, true);
/*  374 */         jjtc000 = false;
/*  375 */         jjtn000.hasLimit = true;
/*  376 */         break;
/*      */       default:
/*  378 */         this.jj_la1[8] = this.jj_gen;
/*  379 */         jj_consume_token(-1);
/*  380 */         throw new ParseException();
/*      */       }
/*      */     } catch (Throwable jjte000) {
/*  383 */       if (jjtc000) {
/*  384 */         this.jjtree.clearNodeScope(jjtn000);
/*  385 */         jjtc000 = false;
/*      */       } else {
/*  387 */         this.jjtree.popNode();
/*      */       }
/*  389 */       if ((jjte000 instanceof RuntimeException)) {
/*  390 */         throw ((RuntimeException)jjte000);
/*      */       }
/*  392 */       if ((jjte000 instanceof ParseException)) {
/*  393 */         throw ((ParseException)jjte000);
/*      */       }
/*  395 */       throw ((Error)jjte000);
/*      */     } finally {
/*  397 */       if (jjtc000)
/*  398 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void FromKeyword()
/*      */     throws ParseException
/*      */   {
/*  406 */     ASTFrom jjtn000 = new ASTFrom(4);
/*  407 */     boolean jjtc000 = true;
/*  408 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/*  410 */       jj_consume_token(18);
/*      */     } finally {
/*  412 */       if (jjtc000)
/*  413 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final ASTFrom ParseFromClause()
/*      */     throws ParseException
/*      */   {
/*  420 */     ASTFrom node = FromClause();
/*  421 */     jj_consume_token(0);
/*  422 */     return node;
/*      */   }
/*      */ 
/*      */   public final ASTFrom FromClause()
/*      */     throws ParseException
/*      */   {
/*  428 */     ASTFrom jjtn000 = new ASTFrom(4);
/*  429 */     boolean jjtc000 = true;
/*  430 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/*  432 */       jj_consume_token(18);
/*  433 */       IdentificationVariableDeclaration();
/*      */       while (true)
/*      */       {
/*  436 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */         {
/*      */         case 46:
/*  439 */           break;
/*      */         default:
/*  441 */           this.jj_la1[9] = this.jj_gen;
/*  442 */           break;
/*      */         }
/*  444 */         jj_consume_token(46);
/*  445 */         IdentificationVariableDeclaration();
/*      */       }
/*  447 */       this.jjtree.closeNodeScope(jjtn000, true);
/*  448 */       jjtc000 = false;
/*  449 */       localASTFrom1 = jjtn000;
/*      */     }
/*      */     catch (Throwable jjte000)
/*      */     {
/*      */       ASTFrom localASTFrom1;
/*  451 */       if (jjtc000) {
/*  452 */         this.jjtree.clearNodeScope(jjtn000);
/*  453 */         jjtc000 = false;
/*      */       } else {
/*  455 */         this.jjtree.popNode();
/*      */       }
/*  457 */       if ((jjte000 instanceof RuntimeException)) {
/*  458 */         throw ((RuntimeException)jjte000);
/*      */       }
/*  460 */       if ((jjte000 instanceof ParseException)) {
/*  461 */         throw ((ParseException)jjte000);
/*      */       }
/*  463 */       throw ((Error)jjte000);
/*      */     } finally {
/*  465 */       if (jjtc000)
/*  466 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void IdentificationVariableDeclaration()
/*      */     throws ParseException
/*      */   {
/*  473 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 19:
/*  475 */       CollectionMemberDeclaration();
/*  476 */       break;
/*      */     case 40:
/*      */     case 68:
/*  479 */       RangeVariableDeclaration();
/*  480 */       break;
/*      */     default:
/*  482 */       this.jj_la1[10] = this.jj_gen;
/*  483 */       jj_consume_token(-1);
/*  484 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void CollectionMemberDeclaration() throws ParseException
/*      */   {
/*  490 */     ASTCollectionMemberDeclaration jjtn000 = new ASTCollectionMemberDeclaration(6);
/*  491 */     boolean jjtc000 = true;
/*  492 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try
/*      */     {
/*  495 */       jj_consume_token(19);
/*  496 */       jj_consume_token(44);
/*  497 */       Token path = CollectionValuedPath();
/*  498 */       jj_consume_token(45);
/*  499 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 7:
/*  501 */         jj_consume_token(7);
/*  502 */         break;
/*      */       default:
/*  504 */         this.jj_la1[11] = this.jj_gen;
/*      */       }
/*      */ 
/*  507 */       Token id = Identifier();
/*  508 */       this.jjtree.closeNodeScope(jjtn000, true);
/*  509 */       jjtc000 = false;
/*  510 */       this.idManager.declareCollectionMember(id.image, path.image);
/*      */     } catch (Throwable jjte000) {
/*  512 */       if (jjtc000) {
/*  513 */         this.jjtree.clearNodeScope(jjtn000);
/*  514 */         jjtc000 = false;
/*      */       } else {
/*  516 */         this.jjtree.popNode();
/*      */       }
/*  518 */       if ((jjte000 instanceof RuntimeException)) {
/*  519 */         throw ((RuntimeException)jjte000);
/*      */       }
/*  521 */       if ((jjte000 instanceof ParseException)) {
/*  522 */         throw ((ParseException)jjte000);
/*      */       }
/*  524 */       throw ((Error)jjte000);
/*      */     } finally {
/*  526 */       if (jjtc000)
/*  527 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void RangeVariableDeclaration()
/*      */     throws ParseException
/*      */   {
/*  534 */     ASTRangeVariableDeclaration jjtn000 = new ASTRangeVariableDeclaration(7);
/*  535 */     boolean jjtc000 = true;
/*  536 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try
/*      */     {
/*  539 */       Token schema = AbstractSchema();
/*  540 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 7:
/*  542 */         jj_consume_token(7);
/*  543 */         break;
/*      */       default:
/*  545 */         this.jj_la1[12] = this.jj_gen;
/*      */       }
/*      */ 
/*  548 */       Token id = Identifier();
/*  549 */       this.jjtree.closeNodeScope(jjtn000, true);
/*  550 */       jjtc000 = false;
/*  551 */       this.idManager.declareRangeVariable(id.image, schema.image);
/*      */     } catch (Throwable jjte000) {
/*  553 */       if (jjtc000) {
/*  554 */         this.jjtree.clearNodeScope(jjtn000);
/*  555 */         jjtc000 = false;
/*      */       } else {
/*  557 */         this.jjtree.popNode();
/*      */       }
/*  559 */       if ((jjte000 instanceof RuntimeException)) {
/*  560 */         throw ((RuntimeException)jjte000);
/*      */       }
/*  562 */       if ((jjte000 instanceof ParseException)) {
/*  563 */         throw ((ParseException)jjte000);
/*      */       }
/*  565 */       throw ((Error)jjte000);
/*      */     } finally {
/*  567 */       if (jjtc000)
/*  568 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final ASTSelect SelectClause()
/*      */     throws ParseException
/*      */   {
/*  575 */     ASTSelect jjtn000 = new ASTSelect(8);
/*  576 */     boolean jjtc000 = true;
/*  577 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/*  579 */       jj_consume_token(29);
/*  580 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 15:
/*  582 */         jj_consume_token(15);
/*  583 */         jjtn000.distinct = true;
/*  584 */         break;
/*      */       default:
/*  586 */         this.jj_la1[13] = this.jj_gen;
/*      */       }
/*      */ 
/*  589 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 26:
/*  591 */         jj_consume_token(26);
/*  592 */         jj_consume_token(44);
/*  593 */         IdentificationVariable();
/*  594 */         jj_consume_token(45);
/*  595 */         break;
/*      */       case 83:
/*      */       case 84:
/*      */       case 85:
/*      */       case 86:
/*      */       case 87:
/*      */       case 88:
/*  602 */         SingleValuedPath();
/*  603 */         break;
/*      */       case 5:
/*      */       case 9:
/*      */       case 10:
/*      */       case 11:
/*      */       case 12:
/*      */       case 13:
/*      */       case 14:
/*      */       case 21:
/*      */       case 23:
/*      */       case 30:
/*      */       case 31:
/*      */       case 37:
/*      */       case 42:
/*      */       case 43:
/*  618 */         FunctionsAllowedInSelect();
/*  619 */         break;
/*      */       case 6:
/*      */       case 7:
/*      */       case 8:
/*      */       case 15:
/*      */       case 16:
/*      */       case 17:
/*      */       case 18:
/*      */       case 19:
/*      */       case 20:
/*      */       case 22:
/*      */       case 24:
/*      */       case 25:
/*      */       case 27:
/*      */       case 28:
/*      */       case 29:
/*      */       case 32:
/*      */       case 33:
/*      */       case 34:
/*      */       case 35:
/*      */       case 36:
/*      */       case 38:
/*      */       case 39:
/*      */       case 40:
/*      */       case 41:
/*      */       case 44:
/*      */       case 45:
/*      */       case 46:
/*      */       case 47:
/*      */       case 48:
/*      */       case 49:
/*      */       case 50:
/*      */       case 51:
/*      */       case 52:
/*      */       case 53:
/*      */       case 54:
/*      */       case 55:
/*      */       case 56:
/*      */       case 57:
/*      */       case 58:
/*      */       case 59:
/*      */       case 60:
/*      */       case 61:
/*      */       case 62:
/*      */       case 63:
/*      */       case 64:
/*      */       case 65:
/*      */       case 66:
/*      */       case 67:
/*      */       case 68:
/*      */       case 69:
/*      */       case 70:
/*      */       case 71:
/*      */       case 72:
/*      */       case 73:
/*      */       case 74:
/*      */       case 75:
/*      */       case 76:
/*      */       case 77:
/*      */       case 78:
/*      */       case 79:
/*      */       case 80:
/*      */       case 81:
/*      */       case 82:
/*      */       default:
/*  621 */         this.jj_la1[14] = this.jj_gen;
/*  622 */         jj_consume_token(-1);
/*  623 */         throw new ParseException();
/*      */       }
/*  625 */       this.jjtree.closeNodeScope(jjtn000, true);
/*  626 */       jjtc000 = false;
/*  627 */       localASTSelect1 = jjtn000;
/*      */     }
/*      */     catch (Throwable jjte000)
/*      */     {
/*      */       ASTSelect localASTSelect1;
/*  629 */       if (jjtc000) {
/*  630 */         this.jjtree.clearNodeScope(jjtn000);
/*  631 */         jjtc000 = false;
/*      */       } else {
/*  633 */         this.jjtree.popNode();
/*      */       }
/*  635 */       if ((jjte000 instanceof RuntimeException)) {
/*  636 */         throw ((RuntimeException)jjte000);
/*      */       }
/*  638 */       if ((jjte000 instanceof ParseException)) {
/*  639 */         throw ((ParseException)jjte000);
/*      */       }
/*  641 */       throw ((Error)jjte000);
/*      */     } finally {
/*  643 */       if (jjtc000)
/*  644 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final ASTWhere WhereClause()
/*      */     throws ParseException
/*      */   {
/*  652 */     ASTWhere jjtn000 = new ASTWhere(9);
/*  653 */     boolean jjtc000 = true;
/*  654 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/*  656 */       jj_consume_token(33);
/*  657 */       WhereExpression();
/*  658 */       this.jjtree.closeNodeScope(jjtn000, true);
/*  659 */       jjtc000 = false;
/*  660 */       localASTWhere1 = jjtn000;
/*      */     }
/*      */     catch (Throwable jjte000)
/*      */     {
/*      */       ASTWhere localASTWhere1;
/*  662 */       if (jjtc000) {
/*  663 */         this.jjtree.clearNodeScope(jjtn000);
/*  664 */         jjtc000 = false;
/*      */       } else {
/*  666 */         this.jjtree.popNode();
/*      */       }
/*  668 */       if ((jjte000 instanceof RuntimeException)) {
/*  669 */         throw ((RuntimeException)jjte000);
/*      */       }
/*  671 */       if ((jjte000 instanceof ParseException)) {
/*  672 */         throw ((ParseException)jjte000);
/*      */       }
/*  674 */       throw ((Error)jjte000);
/*      */     } finally {
/*  676 */       if (jjtc000)
/*  677 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void WhereExpression()
/*      */     throws ParseException
/*      */   {
/*  689 */     ASTOr jjtn001 = new ASTOr(10);
/*  690 */     boolean jjtc001 = true;
/*  691 */     this.jjtree.openNodeScope(jjtn001);
/*      */     try {
/*  693 */       WhereConditionalTerm();
/*      */       while (true)
/*      */       {
/*  696 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */         {
/*      */         case 28:
/*  699 */           break;
/*      */         default:
/*  701 */           this.jj_la1[15] = this.jj_gen;
/*  702 */           break;
/*      */         }
/*  704 */         jj_consume_token(28);
/*  705 */         WhereConditionalTerm();
/*      */       }
/*      */     } catch (Throwable jjte001) {
/*  708 */       if (jjtc001) {
/*  709 */         this.jjtree.clearNodeScope(jjtn001);
/*  710 */         jjtc001 = false;
/*      */       } else {
/*  712 */         this.jjtree.popNode();
/*      */       }
/*  714 */       if ((jjte001 instanceof RuntimeException)) {
/*  715 */         throw ((RuntimeException)jjte001);
/*      */       }
/*  717 */       if ((jjte001 instanceof ParseException)) {
/*  718 */         throw ((ParseException)jjte001);
/*      */       }
/*  720 */       throw ((Error)jjte001);
/*      */     } finally {
/*  722 */       if (jjtc001)
/*  723 */         this.jjtree.closeNodeScope(jjtn001, this.jjtree.nodeArity() > 1);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final ASTWhereConditionalTerm WhereConditionalTerm()
/*      */     throws ParseException
/*      */   {
/*  730 */     ASTWhereConditionalTerm jjtn000 = new ASTWhereConditionalTerm(11);
/*  731 */     boolean jjtc000 = true;
/*  732 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/*  734 */       ASTAnd jjtn001 = new ASTAnd(12);
/*  735 */       boolean jjtc001 = true;
/*  736 */       this.jjtree.openNodeScope(jjtn001);
/*      */       try {
/*  738 */         ConditionalFactor();
/*      */         while (true)
/*      */         {
/*  741 */           switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */           {
/*      */           case 6:
/*  744 */             break;
/*      */           default:
/*  746 */             this.jj_la1[16] = this.jj_gen;
/*  747 */             break;
/*      */           }
/*  749 */           jj_consume_token(6);
/*  750 */           ConditionalFactor();
/*      */         }
/*      */       } catch (Throwable jjte001) {
/*  753 */         if (jjtc001) {
/*  754 */           this.jjtree.clearNodeScope(jjtn001);
/*  755 */           jjtc001 = false;
/*      */         } else {
/*  757 */           this.jjtree.popNode();
/*      */         }
/*  759 */         if ((jjte001 instanceof RuntimeException)) {
/*  760 */           throw ((RuntimeException)jjte001);
/*      */         }
/*  762 */         if ((jjte001 instanceof ParseException)) {
/*  763 */           throw ((ParseException)jjte001);
/*      */         }
/*  765 */         throw ((Error)jjte001);
/*      */       } finally {
/*  767 */         if (jjtc001) {
/*  768 */           this.jjtree.closeNodeScope(jjtn001, this.jjtree.nodeArity() > 1);
/*      */         }
/*      */       }
/*  771 */       this.jjtree.closeNodeScope(jjtn000, true);
/*  772 */       jjtc000 = false;
/*  773 */       jjte001 = jjtn000;
/*      */     } catch (Throwable jjte000) {
/*  775 */       if (jjtc000) {
/*  776 */         this.jjtree.clearNodeScope(jjtn000);
/*  777 */         jjtc000 = false;
/*      */       } else {
/*  779 */         this.jjtree.popNode();
/*      */       }
/*  781 */       if ((jjte000 instanceof RuntimeException)) {
/*  782 */         throw ((RuntimeException)jjte000);
/*      */       }
/*  784 */       if ((jjte000 instanceof ParseException)) {
/*  785 */         throw ((ParseException)jjte000);
/*      */       }
/*  787 */       throw ((Error)jjte000);
/*      */     } finally {
/*  789 */       if (jjtc000)
/*  790 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void ConditionalExpression()
/*      */     throws ParseException
/*      */   {
/*  797 */     ASTOr jjtn001 = new ASTOr(10);
/*  798 */     boolean jjtc001 = true;
/*  799 */     this.jjtree.openNodeScope(jjtn001);
/*      */     try {
/*  801 */       ConditionalTerm();
/*      */       while (true)
/*      */       {
/*  804 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */         {
/*      */         case 28:
/*  807 */           break;
/*      */         default:
/*  809 */           this.jj_la1[17] = this.jj_gen;
/*  810 */           break;
/*      */         }
/*  812 */         jj_consume_token(28);
/*  813 */         ConditionalTerm();
/*      */       }
/*      */     } catch (Throwable jjte001) {
/*  816 */       if (jjtc001) {
/*  817 */         this.jjtree.clearNodeScope(jjtn001);
/*  818 */         jjtc001 = false;
/*      */       } else {
/*  820 */         this.jjtree.popNode();
/*      */       }
/*  822 */       if ((jjte001 instanceof RuntimeException)) {
/*  823 */         throw ((RuntimeException)jjte001);
/*      */       }
/*  825 */       if ((jjte001 instanceof ParseException)) {
/*  826 */         throw ((ParseException)jjte001);
/*      */       }
/*  828 */       throw ((Error)jjte001);
/*      */     } finally {
/*  830 */       if (jjtc001)
/*  831 */         this.jjtree.closeNodeScope(jjtn001, this.jjtree.nodeArity() > 1);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void ConditionalTerm() throws ParseException
/*      */   {
/*  837 */     ASTAnd jjtn001 = new ASTAnd(12);
/*  838 */     boolean jjtc001 = true;
/*  839 */     this.jjtree.openNodeScope(jjtn001);
/*      */     try {
/*  841 */       ConditionalFactor();
/*      */       while (true)
/*      */       {
/*  844 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */         {
/*      */         case 6:
/*  847 */           break;
/*      */         default:
/*  849 */           this.jj_la1[18] = this.jj_gen;
/*  850 */           break;
/*      */         }
/*  852 */         jj_consume_token(6);
/*  853 */         ConditionalFactor();
/*      */       }
/*      */     } catch (Throwable jjte001) {
/*  856 */       if (jjtc001) {
/*  857 */         this.jjtree.clearNodeScope(jjtn001);
/*  858 */         jjtc001 = false;
/*      */       } else {
/*  860 */         this.jjtree.popNode();
/*      */       }
/*  862 */       if ((jjte001 instanceof RuntimeException)) {
/*  863 */         throw ((RuntimeException)jjte001);
/*      */       }
/*  865 */       if ((jjte001 instanceof ParseException)) {
/*  866 */         throw ((ParseException)jjte001);
/*      */       }
/*  868 */       throw ((Error)jjte001);
/*      */     } finally {
/*  870 */       if (jjtc001)
/*  871 */         this.jjtree.closeNodeScope(jjtn001, this.jjtree.nodeArity() > 1);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void ConditionalFactor() throws ParseException
/*      */   {
/*  877 */     boolean not = false;
/*  878 */     ASTNot jjtn001 = new ASTNot(13);
/*  879 */     boolean jjtc001 = true;
/*  880 */     this.jjtree.openNodeScope(jjtn001);
/*      */     try {
/*  882 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 24:
/*  884 */         jj_consume_token(24);
/*  885 */         not = true;
/*  886 */         break;
/*      */       default:
/*  888 */         this.jj_la1[19] = this.jj_gen;
/*      */       }
/*      */ 
/*  891 */       ConditionalTest();
/*      */     } catch (Throwable jjte001) {
/*  893 */       if (jjtc001) {
/*  894 */         this.jjtree.clearNodeScope(jjtn001);
/*  895 */         jjtc001 = false;
/*      */       } else {
/*  897 */         this.jjtree.popNode();
/*      */       }
/*  899 */       if ((jjte001 instanceof RuntimeException)) {
/*  900 */         throw ((RuntimeException)jjte001);
/*      */       }
/*  902 */       if ((jjte001 instanceof ParseException)) {
/*  903 */         throw ((ParseException)jjte001);
/*      */       }
/*  905 */       throw ((Error)jjte001);
/*      */     } finally {
/*  907 */       if (jjtc001)
/*  908 */         this.jjtree.closeNodeScope(jjtn001, not);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void ConditionalTest() throws ParseException
/*      */   {
/*  914 */     ConditionalPrimary();
/*      */   }
/*      */ 
/*      */   public final void ConditionalPrimary() throws ParseException {
/*  918 */     if (jj_2_1(2147483647)) {
/*  919 */       ASTConditionalParenthetical jjtn001 = new ASTConditionalParenthetical(14);
/*  920 */       boolean jjtc001 = true;
/*  921 */       this.jjtree.openNodeScope(jjtn001);
/*      */       try {
/*  923 */         jj_consume_token(44);
/*  924 */         ConditionalExpression();
/*  925 */         jj_consume_token(45);
/*      */       } catch (Throwable jjte001) {
/*  927 */         if (jjtc001) {
/*  928 */           this.jjtree.clearNodeScope(jjtn001);
/*  929 */           jjtc001 = false;
/*      */         } else {
/*  931 */           this.jjtree.popNode();
/*      */         }
/*  933 */         if ((jjte001 instanceof RuntimeException)) {
/*  934 */           throw ((RuntimeException)jjte001);
/*      */         }
/*  936 */         if ((jjte001 instanceof ParseException)) {
/*  937 */           throw ((ParseException)jjte001);
/*      */         }
/*  939 */         throw ((Error)jjte001);
/*      */       } finally {
/*  941 */         if (jjtc001)
/*  942 */           this.jjtree.closeNodeScope(jjtn001, true);
/*      */       }
/*      */     }
/*  945 */     else if (jj_2_2(1)) {
/*  946 */       SimpleCondExpression();
/*      */     } else {
/*  948 */       jj_consume_token(-1);
/*  949 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void FunctionsAllowedInSelect() throws ParseException
/*      */   {
/*  955 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 5:
/*      */     case 10:
/*      */     case 11:
/*      */     case 12:
/*      */     case 13:
/*      */     case 14:
/*      */     case 21:
/*      */     case 23:
/*      */     case 31:
/*      */     case 43:
/*  966 */       FunctionsReturningNumerics();
/*  967 */       break;
/*      */     case 9:
/*      */     case 30:
/*      */     case 37:
/*      */     case 42:
/*  972 */       FunctionsReturningStrings();
/*  973 */       break;
/*      */     case 6:
/*      */     case 7:
/*      */     case 8:
/*      */     case 15:
/*      */     case 16:
/*      */     case 17:
/*      */     case 18:
/*      */     case 19:
/*      */     case 20:
/*      */     case 22:
/*      */     case 24:
/*      */     case 25:
/*      */     case 26:
/*      */     case 27:
/*      */     case 28:
/*      */     case 29:
/*      */     case 32:
/*      */     case 33:
/*      */     case 34:
/*      */     case 35:
/*      */     case 36:
/*      */     case 38:
/*      */     case 39:
/*      */     case 40:
/*      */     case 41:
/*      */     default:
/*  975 */       this.jj_la1[20] = this.jj_gen;
/*  976 */       jj_consume_token(-1);
/*  977 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void SimpleCondExpression() throws ParseException {
/*  982 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 90:
/*  984 */       EmptyCollectionComparisonExpression();
/*  985 */       break;
/*      */     default:
/*  987 */       this.jj_la1[21] = this.jj_gen;
/*  988 */       if (getToken(2).kind == 20)
/*  989 */         NullComparisonExpression();
/*  990 */       else if ((getToken(2).kind == 34) || (getToken(3).kind == 34))
/*  991 */         CollectionMemberExpression();
/*  992 */       else if (jj_2_3(2147483647))
/*  993 */         LikeExpression();
/*  994 */       else if (jj_2_4(2147483647))
/*  995 */         InExpression();
/*      */       else
/*  997 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 5:
/*      */         case 9:
/*      */         case 10:
/*      */         case 11:
/*      */         case 12:
/*      */         case 13:
/*      */         case 14:
/*      */         case 21:
/*      */         case 23:
/*      */         case 30:
/*      */         case 31:
/*      */         case 37:
/*      */         case 42:
/*      */         case 43:
/*      */         case 44:
/*      */         case 54:
/*      */         case 55:
/*      */         case 58:
/*      */         case 59:
/*      */         case 63:
/*      */         case 65:
/*      */         case 66:
/*      */         case 69:
/*      */         case 74:
/*      */         case 75:
/*      */         case 76:
/*      */         case 77:
/*      */         case 78:
/*      */         case 79:
/*      */         case 83:
/*      */         case 84:
/*      */         case 85:
/*      */         case 86:
/*      */         case 87:
/*      */         case 88:
/* 1033 */           ComparisonExpression();
/* 1034 */           break;
/*      */         case 6:
/*      */         case 7:
/*      */         case 8:
/*      */         case 15:
/*      */         case 16:
/*      */         case 17:
/*      */         case 18:
/*      */         case 19:
/*      */         case 20:
/*      */         case 22:
/*      */         case 24:
/*      */         case 25:
/*      */         case 26:
/*      */         case 27:
/*      */         case 28:
/*      */         case 29:
/*      */         case 32:
/*      */         case 33:
/*      */         case 34:
/*      */         case 35:
/*      */         case 36:
/*      */         case 38:
/*      */         case 39:
/*      */         case 40:
/*      */         case 41:
/*      */         case 45:
/*      */         case 46:
/*      */         case 47:
/*      */         case 48:
/*      */         case 49:
/*      */         case 50:
/*      */         case 51:
/*      */         case 52:
/*      */         case 53:
/*      */         case 56:
/*      */         case 57:
/*      */         case 60:
/*      */         case 61:
/*      */         case 62:
/*      */         case 64:
/*      */         case 67:
/*      */         case 68:
/*      */         case 70:
/*      */         case 71:
/*      */         case 72:
/*      */         case 73:
/*      */         case 80:
/*      */         case 81:
/*      */         case 82:
/*      */         default:
/* 1036 */           this.jj_la1[22] = this.jj_gen;
/* 1037 */           jj_consume_token(-1);
/* 1038 */           throw new ParseException();
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void BetweenExpression()
/*      */     throws ParseException
/*      */   {
/* 1046 */     ASTBetween jjtn000 = new ASTBetween(15);
/* 1047 */     boolean jjtc000 = true;
/* 1048 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 1050 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 5:
/*      */       case 10:
/*      */       case 11:
/*      */       case 12:
/*      */       case 13:
/*      */       case 14:
/*      */       case 21:
/*      */       case 23:
/*      */       case 31:
/*      */       case 43:
/*      */       case 44:
/*      */       case 54:
/*      */       case 55:
/*      */       case 59:
/*      */       case 63:
/*      */       case 74:
/*      */       case 83:
/* 1068 */         ArithmeticExpression();
/* 1069 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 24:
/* 1071 */           jj_consume_token(24);
/* 1072 */           jjtn000.not = true;
/* 1073 */           break;
/*      */         default:
/* 1075 */           this.jj_la1[23] = this.jj_gen;
/*      */         }
/*      */ 
/* 1078 */         jj_consume_token(8);
/* 1079 */         ArithmeticExpression();
/* 1080 */         jj_consume_token(6);
/* 1081 */         ArithmeticExpression();
/* 1082 */         break;
/*      */       case 76:
/*      */       case 85:
/* 1085 */         DatetimeValue();
/* 1086 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 24:
/* 1088 */           jj_consume_token(24);
/* 1089 */           jjtn000.not = true;
/* 1090 */           break;
/*      */         default:
/* 1092 */           this.jj_la1[24] = this.jj_gen;
/*      */         }
/*      */ 
/* 1095 */         jj_consume_token(8);
/* 1096 */         DatetimeValue();
/* 1097 */         jj_consume_token(6);
/* 1098 */         DatetimeValue();
/* 1099 */         break;
/*      */       case 9:
/*      */       case 30:
/*      */       case 37:
/*      */       case 42:
/*      */       case 58:
/*      */       case 75:
/*      */       case 84:
/* 1107 */         StringValue();
/* 1108 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 24:
/* 1110 */           jj_consume_token(24);
/* 1111 */           jjtn000.not = true;
/* 1112 */           break;
/*      */         default:
/* 1114 */           this.jj_la1[25] = this.jj_gen;
/*      */         }
/*      */ 
/* 1117 */         jj_consume_token(8);
/* 1118 */         StringValue();
/* 1119 */         jj_consume_token(6);
/* 1120 */         StringValue();
/* 1121 */         break;
/*      */       case 6:
/*      */       case 7:
/*      */       case 8:
/*      */       case 15:
/*      */       case 16:
/*      */       case 17:
/*      */       case 18:
/*      */       case 19:
/*      */       case 20:
/*      */       case 22:
/*      */       case 24:
/*      */       case 25:
/*      */       case 26:
/*      */       case 27:
/*      */       case 28:
/*      */       case 29:
/*      */       case 32:
/*      */       case 33:
/*      */       case 34:
/*      */       case 35:
/*      */       case 36:
/*      */       case 38:
/*      */       case 39:
/*      */       case 40:
/*      */       case 41:
/*      */       case 45:
/*      */       case 46:
/*      */       case 47:
/*      */       case 48:
/*      */       case 49:
/*      */       case 50:
/*      */       case 51:
/*      */       case 52:
/*      */       case 53:
/*      */       case 56:
/*      */       case 57:
/*      */       case 60:
/*      */       case 61:
/*      */       case 62:
/*      */       case 64:
/*      */       case 65:
/*      */       case 66:
/*      */       case 67:
/*      */       case 68:
/*      */       case 69:
/*      */       case 70:
/*      */       case 71:
/*      */       case 72:
/*      */       case 73:
/*      */       case 77:
/*      */       case 78:
/*      */       case 79:
/*      */       case 80:
/*      */       case 81:
/*      */       case 82:
/*      */       default:
/* 1123 */         this.jj_la1[26] = this.jj_gen;
/* 1124 */         jj_consume_token(-1);
/* 1125 */         throw new ParseException();
/*      */       }
/*      */     } catch (Throwable jjte000) {
/* 1128 */       if (jjtc000) {
/* 1129 */         this.jjtree.clearNodeScope(jjtn000);
/* 1130 */         jjtc000 = false;
/*      */       } else {
/* 1132 */         this.jjtree.popNode();
/*      */       }
/* 1134 */       if ((jjte000 instanceof RuntimeException)) {
/* 1135 */         throw ((RuntimeException)jjte000);
/*      */       }
/* 1137 */       if ((jjte000 instanceof ParseException)) {
/* 1138 */         throw ((ParseException)jjte000);
/*      */       }
/* 1140 */       throw ((Error)jjte000);
/*      */     } finally {
/* 1142 */       if (jjtc000)
/* 1143 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void InExpression()
/*      */     throws ParseException
/*      */   {
/* 1150 */     ASTIn jjtn000 = new ASTIn(16);
/* 1151 */     boolean jjtc000 = true;
/* 1152 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 1154 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 9:
/*      */       case 30:
/*      */       case 37:
/*      */       case 42:
/*      */       case 44:
/*      */       case 58:
/*      */       case 75:
/*      */       case 84:
/* 1163 */         StringExpression();
/* 1164 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 24:
/* 1166 */           jj_consume_token(24);
/* 1167 */           jjtn000.not = true;
/* 1168 */           break;
/*      */         default:
/* 1170 */           this.jj_la1[27] = this.jj_gen;
/*      */         }
/*      */ 
/* 1173 */         jj_consume_token(19);
/* 1174 */         jj_consume_token(44);
/* 1175 */         StringExpression();
/*      */         while (true)
/*      */         {
/* 1178 */           switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */           {
/*      */           case 46:
/* 1181 */             break;
/*      */           default:
/* 1183 */             this.jj_la1[28] = this.jj_gen;
/* 1184 */             break;
/*      */           }
/* 1186 */           jj_consume_token(46);
/* 1187 */           StringExpression();
/*      */         }
/* 1189 */         jj_consume_token(45);
/* 1190 */         break;
/*      */       case 5:
/*      */       case 10:
/*      */       case 11:
/*      */       case 12:
/*      */       case 13:
/*      */       case 14:
/*      */       case 21:
/*      */       case 23:
/*      */       case 31:
/*      */       case 43:
/*      */       case 59:
/*      */       case 63:
/*      */       case 74:
/*      */       case 83:
/* 1205 */         ArithmeticPrimary();
/* 1206 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 24:
/* 1208 */           jj_consume_token(24);
/* 1209 */           jjtn000.not = true;
/* 1210 */           break;
/*      */         default:
/* 1212 */           this.jj_la1[29] = this.jj_gen;
/*      */         }
/*      */ 
/* 1215 */         jj_consume_token(19);
/* 1216 */         jj_consume_token(44);
/* 1217 */         ArithmeticPrimary();
/*      */         while (true)
/*      */         {
/* 1220 */           switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */           {
/*      */           case 46:
/* 1223 */             break;
/*      */           default:
/* 1225 */             this.jj_la1[30] = this.jj_gen;
/* 1226 */             break;
/*      */           }
/* 1228 */           jj_consume_token(46);
/* 1229 */           ArithmeticPrimary();
/*      */         }
/* 1231 */         jj_consume_token(45);
/* 1232 */         break;
/*      */       case 76:
/*      */       case 85:
/* 1235 */         DatetimeValue();
/* 1236 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 24:
/* 1238 */           jj_consume_token(24);
/* 1239 */           jjtn000.not = true;
/* 1240 */           break;
/*      */         default:
/* 1242 */           this.jj_la1[31] = this.jj_gen;
/*      */         }
/*      */ 
/* 1245 */         jj_consume_token(19);
/* 1246 */         jj_consume_token(44);
/* 1247 */         DatetimeValue();
/*      */         while (true)
/*      */         {
/* 1250 */           switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */           {
/*      */           case 46:
/* 1253 */             break;
/*      */           default:
/* 1255 */             this.jj_la1[32] = this.jj_gen;
/* 1256 */             break;
/*      */           }
/* 1258 */           jj_consume_token(46);
/* 1259 */           DatetimeValue();
/*      */         }
/* 1261 */         jj_consume_token(45);
/* 1262 */         break;
/*      */       case 6:
/*      */       case 7:
/*      */       case 8:
/*      */       case 15:
/*      */       case 16:
/*      */       case 17:
/*      */       case 18:
/*      */       case 19:
/*      */       case 20:
/*      */       case 22:
/*      */       case 24:
/*      */       case 25:
/*      */       case 26:
/*      */       case 27:
/*      */       case 28:
/*      */       case 29:
/*      */       case 32:
/*      */       case 33:
/*      */       case 34:
/*      */       case 35:
/*      */       case 36:
/*      */       case 38:
/*      */       case 39:
/*      */       case 40:
/*      */       case 41:
/*      */       case 45:
/*      */       case 46:
/*      */       case 47:
/*      */       case 48:
/*      */       case 49:
/*      */       case 50:
/*      */       case 51:
/*      */       case 52:
/*      */       case 53:
/*      */       case 54:
/*      */       case 55:
/*      */       case 56:
/*      */       case 57:
/*      */       case 60:
/*      */       case 61:
/*      */       case 62:
/*      */       case 64:
/*      */       case 65:
/*      */       case 66:
/*      */       case 67:
/*      */       case 68:
/*      */       case 69:
/*      */       case 70:
/*      */       case 71:
/*      */       case 72:
/*      */       case 73:
/*      */       case 77:
/*      */       case 78:
/*      */       case 79:
/*      */       case 80:
/*      */       case 81:
/*      */       case 82:
/*      */       default:
/* 1264 */         this.jj_la1[33] = this.jj_gen;
/* 1265 */         jj_consume_token(-1);
/* 1266 */         throw new ParseException();
/*      */       }
/*      */     } catch (Throwable jjte000) {
/* 1269 */       if (jjtc000) {
/* 1270 */         this.jjtree.clearNodeScope(jjtn000);
/* 1271 */         jjtc000 = false;
/*      */       } else {
/* 1273 */         this.jjtree.popNode();
/*      */       }
/* 1275 */       if ((jjte000 instanceof RuntimeException)) {
/* 1276 */         throw ((RuntimeException)jjte000);
/*      */       }
/* 1278 */       if ((jjte000 instanceof ParseException)) {
/* 1279 */         throw ((ParseException)jjte000);
/*      */       }
/* 1281 */       throw ((Error)jjte000);
/*      */     } finally {
/* 1283 */       if (jjtc000)
/* 1284 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void LikeExpression()
/*      */     throws ParseException
/*      */   {
/* 1291 */     ASTLike jjtn000 = new ASTLike(17);
/* 1292 */     boolean jjtc000 = true;
/* 1293 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 1295 */       StringValue();
/* 1296 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 24:
/* 1298 */         jj_consume_token(24);
/* 1299 */         jjtn000.not = true;
/* 1300 */         break;
/*      */       default:
/* 1302 */         this.jj_la1[34] = this.jj_gen;
/*      */       }
/*      */ 
/* 1305 */       jj_consume_token(22);
/* 1306 */       StringExpression();
/* 1307 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 17:
/* 1309 */         jj_consume_token(17);
/* 1310 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 58:
/* 1312 */           StringLiteral();
/* 1313 */           break;
/*      */         case 74:
/* 1315 */           NumericValuedParameter();
/* 1316 */           break;
/*      */         default:
/* 1318 */           this.jj_la1[35] = this.jj_gen;
/* 1319 */           jj_consume_token(-1);
/* 1320 */           throw new ParseException();
/*      */         }
/*      */ 
/*      */       default:
/* 1324 */         this.jj_la1[36] = this.jj_gen;
/*      */       }
/*      */     }
/*      */     catch (Throwable jjte000) {
/* 1328 */       if (jjtc000) {
/* 1329 */         this.jjtree.clearNodeScope(jjtn000);
/* 1330 */         jjtc000 = false;
/*      */       } else {
/* 1332 */         this.jjtree.popNode();
/*      */       }
/* 1334 */       if ((jjte000 instanceof RuntimeException)) {
/* 1335 */         throw ((RuntimeException)jjte000);
/*      */       }
/* 1337 */       if ((jjte000 instanceof ParseException)) {
/* 1338 */         throw ((ParseException)jjte000);
/*      */       }
/* 1340 */       throw ((Error)jjte000);
/*      */     } finally {
/* 1342 */       if (jjtc000)
/* 1343 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void NullComparisonExpression()
/*      */     throws ParseException
/*      */   {
/* 1351 */     ASTNullComparison jjtn000 = new ASTNullComparison(18);
/* 1352 */     boolean jjtc000 = true;
/* 1353 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 1355 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 83:
/*      */       case 84:
/*      */       case 85:
/*      */       case 86:
/*      */       case 87:
/*      */       case 88:
/* 1362 */         SingleValuedPath();
/* 1363 */         break;
/*      */       case 74:
/* 1365 */         NumericValuedParameter();
/* 1366 */         break;
/*      */       case 78:
/* 1368 */         EntityValuedParameter();
/* 1369 */         break;
/*      */       case 75:
/* 1371 */         StringValuedParameter();
/* 1372 */         break;
/*      */       case 76:
/* 1374 */         DatetimeValuedParameter();
/* 1375 */         break;
/*      */       case 77:
/* 1377 */         BooleanValuedParameter();
/* 1378 */         break;
/*      */       case 79:
/*      */       case 80:
/*      */       case 81:
/*      */       case 82:
/*      */       default:
/* 1380 */         this.jj_la1[37] = this.jj_gen;
/* 1381 */         jj_consume_token(-1);
/* 1382 */         throw new ParseException();
/*      */       }
/* 1384 */       jj_consume_token(20);
/* 1385 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 24:
/* 1387 */         jj_consume_token(24);
/* 1388 */         jjtn000.not = true;
/* 1389 */         break;
/*      */       default:
/* 1391 */         this.jj_la1[38] = this.jj_gen;
/*      */       }
/*      */ 
/* 1394 */       jj_consume_token(25);
/*      */     } catch (Throwable jjte000) {
/* 1396 */       if (jjtc000) {
/* 1397 */         this.jjtree.clearNodeScope(jjtn000);
/* 1398 */         jjtc000 = false;
/*      */       } else {
/* 1400 */         this.jjtree.popNode();
/*      */       }
/* 1402 */       if ((jjte000 instanceof RuntimeException)) {
/* 1403 */         throw ((RuntimeException)jjte000);
/*      */       }
/* 1405 */       if ((jjte000 instanceof ParseException)) {
/* 1406 */         throw ((ParseException)jjte000);
/*      */       }
/* 1408 */       throw ((Error)jjte000);
/*      */     } finally {
/* 1410 */       if (jjtc000)
/* 1411 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void EmptyCollectionComparisonExpression()
/*      */     throws ParseException
/*      */   {
/* 1418 */     ASTIsEmpty jjtn000 = new ASTIsEmpty(19);
/* 1419 */     boolean jjtc000 = true;
/* 1420 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 1422 */       CollectionValuedPath();
/* 1423 */       jj_consume_token(20);
/* 1424 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 24:
/* 1426 */         jj_consume_token(24);
/* 1427 */         jjtn000.not = true;
/* 1428 */         break;
/*      */       default:
/* 1430 */         this.jj_la1[39] = this.jj_gen;
/*      */       }
/*      */ 
/* 1433 */       jj_consume_token(16);
/*      */     } catch (Throwable jjte000) {
/* 1435 */       if (jjtc000) {
/* 1436 */         this.jjtree.clearNodeScope(jjtn000);
/* 1437 */         jjtc000 = false;
/*      */       } else {
/* 1439 */         this.jjtree.popNode();
/*      */       }
/* 1441 */       if ((jjte000 instanceof RuntimeException)) {
/* 1442 */         throw ((RuntimeException)jjte000);
/*      */       }
/* 1444 */       if ((jjte000 instanceof ParseException)) {
/* 1445 */         throw ((ParseException)jjte000);
/*      */       }
/* 1447 */       throw ((Error)jjte000);
/*      */     } finally {
/* 1449 */       if (jjtc000)
/* 1450 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void CollectionMemberExpression()
/*      */     throws ParseException
/*      */   {
/* 1457 */     ASTMemberOf jjtn000 = new ASTMemberOf(20);
/* 1458 */     boolean jjtc000 = true;
/* 1459 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 1461 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 87:
/* 1463 */         EntityValuedPath();
/* 1464 */         break;
/*      */       case 69:
/* 1466 */         IdentificationVariable();
/* 1467 */         break;
/*      */       case 78:
/* 1469 */         EntityValuedParameter();
/* 1470 */         break;
/*      */       default:
/* 1472 */         this.jj_la1[40] = this.jj_gen;
/* 1473 */         jj_consume_token(-1);
/* 1474 */         throw new ParseException();
/*      */       }
/* 1476 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 24:
/* 1478 */         jj_consume_token(24);
/* 1479 */         jjtn000.not = true;
/* 1480 */         break;
/*      */       default:
/* 1482 */         this.jj_la1[41] = this.jj_gen;
/*      */       }
/*      */ 
/* 1485 */       jj_consume_token(34);
/* 1486 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 27:
/* 1488 */         jj_consume_token(27);
/* 1489 */         break;
/*      */       default:
/* 1491 */         this.jj_la1[42] = this.jj_gen;
/*      */       }
/*      */ 
/* 1494 */       CollectionValuedPath();
/*      */     } catch (Throwable jjte000) {
/* 1496 */       if (jjtc000) {
/* 1497 */         this.jjtree.clearNodeScope(jjtn000);
/* 1498 */         jjtc000 = false;
/*      */       } else {
/* 1500 */         this.jjtree.popNode();
/*      */       }
/* 1502 */       if ((jjte000 instanceof RuntimeException)) {
/* 1503 */         throw ((RuntimeException)jjte000);
/*      */       }
/* 1505 */       if ((jjte000 instanceof ParseException)) {
/* 1506 */         throw ((ParseException)jjte000);
/*      */       }
/* 1508 */       throw ((Error)jjte000);
/*      */     } finally {
/* 1510 */       if (jjtc000)
/* 1511 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void ComparisonExpression() throws ParseException
/*      */   {
/* 1517 */     if (jj_2_5(2147483647)) {
/* 1518 */       ASTStringComparison jjtn001 = new ASTStringComparison(21);
/* 1519 */       boolean jjtc001 = true;
/* 1520 */       this.jjtree.openNodeScope(jjtn001);
/*      */       try {
/* 1522 */         StringValue();
/* 1523 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 50:
/* 1525 */           jj_consume_token(50);
/* 1526 */           jjtn001.opp = "=";
/* 1527 */           break;
/*      */         case 48:
/* 1529 */           jj_consume_token(48);
/* 1530 */           jjtn001.opp = ">";
/* 1531 */           break;
/*      */         case 52:
/* 1533 */           jj_consume_token(52);
/* 1534 */           jjtn001.opp = ">=";
/* 1535 */           break;
/*      */         case 49:
/* 1537 */           jj_consume_token(49);
/* 1538 */           jjtn001.opp = "<";
/* 1539 */           break;
/*      */         case 51:
/* 1541 */           jj_consume_token(51);
/* 1542 */           jjtn001.opp = "<=";
/* 1543 */           break;
/*      */         case 53:
/* 1545 */           jj_consume_token(53);
/* 1546 */           jjtn001.opp = "<>";
/* 1547 */           break;
/*      */         default:
/* 1549 */           this.jj_la1[43] = this.jj_gen;
/* 1550 */           jj_consume_token(-1);
/* 1551 */           throw new ParseException();
/*      */         }
/* 1553 */         StringExpression();
/*      */       } catch (Throwable jjte001) {
/* 1555 */         if (jjtc001) {
/* 1556 */           this.jjtree.clearNodeScope(jjtn001);
/* 1557 */           jjtc001 = false;
/*      */         } else {
/* 1559 */           this.jjtree.popNode();
/*      */         }
/* 1561 */         if ((jjte001 instanceof RuntimeException)) {
/* 1562 */           throw ((RuntimeException)jjte001);
/*      */         }
/* 1564 */         if ((jjte001 instanceof ParseException)) {
/* 1565 */           throw ((ParseException)jjte001);
/*      */         }
/* 1567 */         throw ((Error)jjte001);
/*      */       } finally {
/* 1569 */         if (jjtc001)
/* 1570 */           this.jjtree.closeNodeScope(jjtn001, true);
/*      */       }
/*      */     }
/* 1573 */     else if (jj_2_6(2147483647)) {
/* 1574 */       ASTBooleanComparison jjtn002 = new ASTBooleanComparison(22);
/* 1575 */       boolean jjtc002 = true;
/* 1576 */       this.jjtree.openNodeScope(jjtn002);
/*      */       try {
/* 1578 */         BooleanValue();
/* 1579 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 50:
/*      */         case 53:
/* 1582 */           switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */           case 50:
/* 1584 */             jj_consume_token(50);
/* 1585 */             jjtn002.opp = "=";
/* 1586 */             break;
/*      */           case 53:
/* 1588 */             jj_consume_token(53);
/* 1589 */             jjtn002.opp = "<>";
/* 1590 */             break;
/*      */           default:
/* 1592 */             this.jj_la1[44] = this.jj_gen;
/* 1593 */             jj_consume_token(-1);
/* 1594 */             throw new ParseException();
/*      */           }
/* 1596 */           BooleanExpression();
/* 1597 */           break;
/*      */         default:
/* 1599 */           this.jj_la1[45] = this.jj_gen;
/*      */         }
/*      */       }
/*      */       catch (Throwable jjte002) {
/* 1603 */         if (jjtc002) {
/* 1604 */           this.jjtree.clearNodeScope(jjtn002);
/* 1605 */           jjtc002 = false;
/*      */         } else {
/* 1607 */           this.jjtree.popNode();
/*      */         }
/* 1609 */         if ((jjte002 instanceof RuntimeException)) {
/* 1610 */           throw ((RuntimeException)jjte002);
/*      */         }
/* 1612 */         if ((jjte002 instanceof ParseException)) {
/* 1613 */           throw ((ParseException)jjte002);
/*      */         }
/* 1615 */         throw ((Error)jjte002);
/*      */       } finally {
/* 1617 */         if (jjtc002)
/* 1618 */           this.jjtree.closeNodeScope(jjtn002, true);
/*      */       }
/*      */     }
/* 1621 */     else if (jj_2_7(2147483647)) {
/* 1622 */       ASTDatetimeComparison jjtn003 = new ASTDatetimeComparison(23);
/* 1623 */       boolean jjtc003 = true;
/* 1624 */       this.jjtree.openNodeScope(jjtn003);
/*      */       try {
/* 1626 */         DatetimeValue();
/* 1627 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 50:
/* 1629 */           jj_consume_token(50);
/* 1630 */           jjtn003.opp = "=";
/* 1631 */           break;
/*      */         case 48:
/* 1633 */           jj_consume_token(48);
/* 1634 */           jjtn003.opp = ">";
/* 1635 */           break;
/*      */         case 52:
/* 1637 */           jj_consume_token(52);
/* 1638 */           jjtn003.opp = ">=";
/* 1639 */           break;
/*      */         case 49:
/* 1641 */           jj_consume_token(49);
/* 1642 */           jjtn003.opp = "<";
/* 1643 */           break;
/*      */         case 51:
/* 1645 */           jj_consume_token(51);
/* 1646 */           jjtn003.opp = "<=";
/* 1647 */           break;
/*      */         case 53:
/* 1649 */           jj_consume_token(53);
/* 1650 */           jjtn003.opp = "<>";
/* 1651 */           break;
/*      */         default:
/* 1653 */           this.jj_la1[46] = this.jj_gen;
/* 1654 */           jj_consume_token(-1);
/* 1655 */           throw new ParseException();
/*      */         }
/* 1657 */         DatetimeExpression();
/*      */       } catch (Throwable jjte003) {
/* 1659 */         if (jjtc003) {
/* 1660 */           this.jjtree.clearNodeScope(jjtn003);
/* 1661 */           jjtc003 = false;
/*      */         } else {
/* 1663 */           this.jjtree.popNode();
/*      */         }
/* 1665 */         if ((jjte003 instanceof RuntimeException)) {
/* 1666 */           throw ((RuntimeException)jjte003);
/*      */         }
/* 1668 */         if ((jjte003 instanceof ParseException)) {
/* 1669 */           throw ((ParseException)jjte003);
/*      */         }
/* 1671 */         throw ((Error)jjte003);
/*      */       } finally {
/* 1673 */         if (jjtc003)
/* 1674 */           this.jjtree.closeNodeScope(jjtn003, true);
/*      */       }
/*      */     }
/* 1677 */     else if (jj_2_8(2147483647)) {
/* 1678 */       ASTValueClassComparison jjtn004 = new ASTValueClassComparison(24);
/* 1679 */       boolean jjtc004 = true;
/* 1680 */       this.jjtree.openNodeScope(jjtn004);
/*      */       try {
/* 1682 */         ValueClassValue();
/* 1683 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 50:
/* 1685 */           jj_consume_token(50);
/* 1686 */           jjtn004.opp = "=";
/* 1687 */           break;
/*      */         case 48:
/* 1689 */           jj_consume_token(48);
/* 1690 */           jjtn004.opp = ">";
/* 1691 */           break;
/*      */         case 52:
/* 1693 */           jj_consume_token(52);
/* 1694 */           jjtn004.opp = ">=";
/* 1695 */           break;
/*      */         case 49:
/* 1697 */           jj_consume_token(49);
/* 1698 */           jjtn004.opp = "<";
/* 1699 */           break;
/*      */         case 51:
/* 1701 */           jj_consume_token(51);
/* 1702 */           jjtn004.opp = "<=";
/* 1703 */           break;
/*      */         case 53:
/* 1705 */           jj_consume_token(53);
/* 1706 */           jjtn004.opp = "<>";
/* 1707 */           break;
/*      */         default:
/* 1709 */           this.jj_la1[47] = this.jj_gen;
/* 1710 */           jj_consume_token(-1);
/* 1711 */           throw new ParseException();
/*      */         }
/* 1713 */         ValueClassExpression();
/*      */       } catch (Throwable jjte004) {
/* 1715 */         if (jjtc004) {
/* 1716 */           this.jjtree.clearNodeScope(jjtn004);
/* 1717 */           jjtc004 = false;
/*      */         } else {
/* 1719 */           this.jjtree.popNode();
/*      */         }
/* 1721 */         if ((jjte004 instanceof RuntimeException)) {
/* 1722 */           throw ((RuntimeException)jjte004);
/*      */         }
/* 1724 */         if ((jjte004 instanceof ParseException)) {
/* 1725 */           throw ((ParseException)jjte004);
/*      */         }
/* 1727 */         throw ((Error)jjte004);
/*      */       } finally {
/* 1729 */         if (jjtc004)
/* 1730 */           this.jjtree.closeNodeScope(jjtn004, true);
/*      */       }
/*      */     }
/* 1733 */     else if (jj_2_9(2147483647)) {
/* 1734 */       ASTEntityComparison jjtn005 = new ASTEntityComparison(25);
/* 1735 */       boolean jjtc005 = true;
/* 1736 */       this.jjtree.openNodeScope(jjtn005);
/*      */       try {
/* 1738 */         EntityBeanValue();
/* 1739 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 50:
/* 1741 */           jj_consume_token(50);
/* 1742 */           jjtn005.opp = "=";
/* 1743 */           break;
/*      */         case 53:
/* 1745 */           jj_consume_token(53);
/* 1746 */           jjtn005.opp = "<>";
/* 1747 */           break;
/*      */         default:
/* 1749 */           this.jj_la1[48] = this.jj_gen;
/* 1750 */           jj_consume_token(-1);
/* 1751 */           throw new ParseException();
/*      */         }
/* 1753 */         EntityBeanExpression();
/*      */       } catch (Throwable jjte005) {
/* 1755 */         if (jjtc005) {
/* 1756 */           this.jjtree.clearNodeScope(jjtn005);
/* 1757 */           jjtc005 = false;
/*      */         } else {
/* 1759 */           this.jjtree.popNode();
/*      */         }
/* 1761 */         if ((jjte005 instanceof RuntimeException)) {
/* 1762 */           throw ((RuntimeException)jjte005);
/*      */         }
/* 1764 */         if ((jjte005 instanceof ParseException)) {
/* 1765 */           throw ((ParseException)jjte005);
/*      */         }
/* 1767 */         throw ((Error)jjte005);
/*      */       } finally {
/* 1769 */         if (jjtc005)
/* 1770 */           this.jjtree.closeNodeScope(jjtn005, true);
/*      */       }
/*      */     }
/* 1773 */     else if (jj_2_10(2147483647)) {
/* 1774 */       ASTArithmeticComparison jjtn006 = new ASTArithmeticComparison(26);
/* 1775 */       boolean jjtc006 = true;
/* 1776 */       this.jjtree.openNodeScope(jjtn006);
/*      */       try {
/* 1778 */         ArithmeticValue();
/* 1779 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 50:
/* 1781 */           jj_consume_token(50);
/* 1782 */           jjtn006.opp = "=";
/* 1783 */           break;
/*      */         case 48:
/* 1785 */           jj_consume_token(48);
/* 1786 */           jjtn006.opp = ">";
/* 1787 */           break;
/*      */         case 52:
/* 1789 */           jj_consume_token(52);
/* 1790 */           jjtn006.opp = ">=";
/* 1791 */           break;
/*      */         case 49:
/* 1793 */           jj_consume_token(49);
/* 1794 */           jjtn006.opp = "<";
/* 1795 */           break;
/*      */         case 51:
/* 1797 */           jj_consume_token(51);
/* 1798 */           jjtn006.opp = "<=";
/* 1799 */           break;
/*      */         case 53:
/* 1801 */           jj_consume_token(53);
/* 1802 */           jjtn006.opp = "<>";
/* 1803 */           break;
/*      */         default:
/* 1805 */           this.jj_la1[49] = this.jj_gen;
/* 1806 */           jj_consume_token(-1);
/* 1807 */           throw new ParseException();
/*      */         }
/* 1809 */         SingleValueDesignator();
/*      */       } catch (Throwable jjte006) {
/* 1811 */         if (jjtc006) {
/* 1812 */           this.jjtree.clearNodeScope(jjtn006);
/* 1813 */           jjtc006 = false;
/*      */         } else {
/* 1815 */           this.jjtree.popNode();
/*      */         }
/* 1817 */         if ((jjte006 instanceof RuntimeException)) {
/* 1818 */           throw ((RuntimeException)jjte006);
/*      */         }
/* 1820 */         if ((jjte006 instanceof ParseException)) {
/* 1821 */           throw ((ParseException)jjte006);
/*      */         }
/* 1823 */         throw ((Error)jjte006);
/*      */       } finally {
/* 1825 */         if (jjtc006)
/* 1826 */           this.jjtree.closeNodeScope(jjtn006, true);
/*      */       }
/*      */     }
/*      */     else {
/* 1830 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 5:
/*      */       case 9:
/*      */       case 10:
/*      */       case 11:
/*      */       case 12:
/*      */       case 13:
/*      */       case 14:
/*      */       case 21:
/*      */       case 23:
/*      */       case 30:
/*      */       case 31:
/*      */       case 37:
/*      */       case 42:
/*      */       case 43:
/*      */       case 44:
/*      */       case 54:
/*      */       case 55:
/*      */       case 58:
/*      */       case 59:
/*      */       case 63:
/*      */       case 74:
/*      */       case 75:
/*      */       case 76:
/*      */       case 83:
/*      */       case 84:
/*      */       case 85:
/* 1857 */         BetweenExpression();
/* 1858 */         break;
/*      */       case 6:
/*      */       case 7:
/*      */       case 8:
/*      */       case 15:
/*      */       case 16:
/*      */       case 17:
/*      */       case 18:
/*      */       case 19:
/*      */       case 20:
/*      */       case 22:
/*      */       case 24:
/*      */       case 25:
/*      */       case 26:
/*      */       case 27:
/*      */       case 28:
/*      */       case 29:
/*      */       case 32:
/*      */       case 33:
/*      */       case 34:
/*      */       case 35:
/*      */       case 36:
/*      */       case 38:
/*      */       case 39:
/*      */       case 40:
/*      */       case 41:
/*      */       case 45:
/*      */       case 46:
/*      */       case 47:
/*      */       case 48:
/*      */       case 49:
/*      */       case 50:
/*      */       case 51:
/*      */       case 52:
/*      */       case 53:
/*      */       case 56:
/*      */       case 57:
/*      */       case 60:
/*      */       case 61:
/*      */       case 62:
/*      */       case 64:
/*      */       case 65:
/*      */       case 66:
/*      */       case 67:
/*      */       case 68:
/*      */       case 69:
/*      */       case 70:
/*      */       case 71:
/*      */       case 72:
/*      */       case 73:
/*      */       case 77:
/*      */       case 78:
/*      */       case 79:
/*      */       case 80:
/*      */       case 81:
/*      */       case 82:
/*      */       default:
/* 1860 */         this.jj_la1[50] = this.jj_gen;
/* 1861 */         jj_consume_token(-1);
/* 1862 */         throw new ParseException();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void ArithmeticValue() throws ParseException
/*      */   {
/* 1869 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 83:
/* 1871 */       NumericValuedPath();
/* 1872 */       break;
/*      */     case 5:
/*      */     case 10:
/*      */     case 11:
/*      */     case 12:
/*      */     case 13:
/*      */     case 14:
/*      */     case 21:
/*      */     case 23:
/*      */     case 31:
/*      */     case 43:
/* 1883 */       FunctionsReturningNumerics();
/* 1884 */       break;
/*      */     case 59:
/*      */     case 63:
/* 1887 */       NumericLiteral();
/* 1888 */       break;
/*      */     case 74:
/* 1890 */       NumericValuedParameter();
/* 1891 */       break;
/*      */     default:
/* 1893 */       this.jj_la1[51] = this.jj_gen;
/* 1894 */       jj_consume_token(-1);
/* 1895 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void SingleValueDesignator() throws ParseException
/*      */   {
/* 1901 */     ScalarExpression();
/*      */   }
/*      */ 
/*      */   public final void ScalarExpression() throws ParseException {
/* 1905 */     ArithmeticExpression();
/*      */   }
/*      */ 
/*      */   public final void ArithmeticExpression() throws ParseException {
/* 1909 */     ASTPlusMinus jjtn001 = new ASTPlusMinus(27);
/* 1910 */     boolean jjtc001 = true;
/* 1911 */     this.jjtree.openNodeScope(jjtn001);
/*      */     try {
/* 1913 */       ArithmeticTerm();
/*      */       while (true)
/*      */       {
/* 1916 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */         {
/*      */         case 54:
/*      */         case 55:
/* 1920 */           break;
/*      */         default:
/* 1922 */           this.jj_la1[52] = this.jj_gen;
/* 1923 */           break;
/*      */         }
/* 1925 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 54:
/* 1927 */           jj_consume_token(54);
/* 1928 */           jjtn001.addOpp("+");
/* 1929 */           break;
/*      */         case 55:
/* 1931 */           jj_consume_token(55);
/* 1932 */           jjtn001.addOpp("-");
/* 1933 */           break;
/*      */         default:
/* 1935 */           this.jj_la1[53] = this.jj_gen;
/* 1936 */           jj_consume_token(-1);
/* 1937 */           throw new ParseException();
/*      */         }
/* 1939 */         ArithmeticTerm();
/*      */       }
/*      */     } catch (Throwable jjte001) {
/* 1942 */       if (jjtc001) {
/* 1943 */         this.jjtree.clearNodeScope(jjtn001);
/* 1944 */         jjtc001 = false;
/*      */       } else {
/* 1946 */         this.jjtree.popNode();
/*      */       }
/* 1948 */       if ((jjte001 instanceof RuntimeException)) {
/* 1949 */         throw ((RuntimeException)jjte001);
/*      */       }
/* 1951 */       if ((jjte001 instanceof ParseException)) {
/* 1952 */         throw ((ParseException)jjte001);
/*      */       }
/* 1954 */       throw ((Error)jjte001);
/*      */     } finally {
/* 1956 */       if (jjtc001)
/* 1957 */         this.jjtree.closeNodeScope(jjtn001, this.jjtree.nodeArity() > 1);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void ArithmeticTerm() throws ParseException
/*      */   {
/* 1963 */     ASTMultDiv jjtn001 = new ASTMultDiv(28);
/* 1964 */     boolean jjtc001 = true;
/* 1965 */     this.jjtree.openNodeScope(jjtn001);
/*      */     try {
/* 1967 */       ArithmeticFactor();
/*      */       while (true)
/*      */       {
/* 1970 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */         {
/*      */         case 56:
/*      */         case 57:
/* 1974 */           break;
/*      */         default:
/* 1976 */           this.jj_la1[54] = this.jj_gen;
/* 1977 */           break;
/*      */         }
/* 1979 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 56:
/* 1981 */           jj_consume_token(56);
/* 1982 */           jjtn001.addOpp("*");
/* 1983 */           break;
/*      */         case 57:
/* 1985 */           jj_consume_token(57);
/* 1986 */           jjtn001.addOpp("/");
/* 1987 */           break;
/*      */         default:
/* 1989 */           this.jj_la1[55] = this.jj_gen;
/* 1990 */           jj_consume_token(-1);
/* 1991 */           throw new ParseException();
/*      */         }
/* 1993 */         ArithmeticFactor();
/*      */       }
/*      */     } catch (Throwable jjte001) {
/* 1996 */       if (jjtc001) {
/* 1997 */         this.jjtree.clearNodeScope(jjtn001);
/* 1998 */         jjtc001 = false;
/*      */       } else {
/* 2000 */         this.jjtree.popNode();
/*      */       }
/* 2002 */       if ((jjte001 instanceof RuntimeException)) {
/* 2003 */         throw ((RuntimeException)jjte001);
/*      */       }
/* 2005 */       if ((jjte001 instanceof ParseException)) {
/* 2006 */         throw ((ParseException)jjte001);
/*      */       }
/* 2008 */       throw ((Error)jjte001);
/*      */     } finally {
/* 2010 */       if (jjtc001)
/* 2011 */         this.jjtree.closeNodeScope(jjtn001, this.jjtree.nodeArity() > 1);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void ArithmeticFactor() throws ParseException
/*      */   {
/* 2017 */     boolean negation = false;
/* 2018 */     ASTNegation jjtn001 = new ASTNegation(29);
/* 2019 */     boolean jjtc001 = true;
/* 2020 */     this.jjtree.openNodeScope(jjtn001);
/*      */     try {
/* 2022 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 54:
/*      */       case 55:
/* 2025 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 54:
/* 2027 */           jj_consume_token(54);
/* 2028 */           break;
/*      */         case 55:
/* 2030 */           jj_consume_token(55);
/* 2031 */           negation = true;
/* 2032 */           break;
/*      */         default:
/* 2034 */           this.jj_la1[56] = this.jj_gen;
/* 2035 */           jj_consume_token(-1);
/* 2036 */           throw new ParseException();
/*      */         }
/*      */ 
/*      */       default:
/* 2040 */         this.jj_la1[57] = this.jj_gen;
/*      */       }
/*      */ 
/* 2043 */       ArithmeticPrimary();
/*      */     } catch (Throwable jjte001) {
/* 2045 */       if (jjtc001) {
/* 2046 */         this.jjtree.clearNodeScope(jjtn001);
/* 2047 */         jjtc001 = false;
/*      */       } else {
/* 2049 */         this.jjtree.popNode();
/*      */       }
/* 2051 */       if ((jjte001 instanceof RuntimeException)) {
/* 2052 */         throw ((RuntimeException)jjte001);
/*      */       }
/* 2054 */       if ((jjte001 instanceof ParseException)) {
/* 2055 */         throw ((ParseException)jjte001);
/*      */       }
/* 2057 */       throw ((Error)jjte001);
/*      */     } finally {
/* 2059 */       if (jjtc001)
/* 2060 */         this.jjtree.closeNodeScope(jjtn001, negation);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void ArithmeticPrimary() throws ParseException
/*      */   {
/* 2066 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 83:
/* 2068 */       NumericValuedPath();
/* 2069 */       break;
/*      */     case 59:
/*      */     case 63:
/* 2072 */       NumericLiteral();
/* 2073 */       break;
/*      */     case 44:
/* 2075 */       ASTArithmeticParenthetical jjtn001 = new ASTArithmeticParenthetical(30);
/* 2076 */       boolean jjtc001 = true;
/* 2077 */       this.jjtree.openNodeScope(jjtn001);
/*      */       try {
/* 2079 */         jj_consume_token(44);
/* 2080 */         ArithmeticExpression();
/* 2081 */         jj_consume_token(45);
/*      */       } catch (Throwable jjte001) {
/* 2083 */         if (jjtc001) {
/* 2084 */           this.jjtree.clearNodeScope(jjtn001);
/* 2085 */           jjtc001 = false;
/*      */         } else {
/* 2087 */           this.jjtree.popNode();
/*      */         }
/* 2089 */         if ((jjte001 instanceof RuntimeException)) {
/* 2090 */           throw ((RuntimeException)jjte001);
/*      */         }
/* 2092 */         if ((jjte001 instanceof ParseException)) {
/* 2093 */           throw ((ParseException)jjte001);
/*      */         }
/* 2095 */         throw ((Error)jjte001);
/*      */       } finally {
/* 2097 */         if (jjtc001) {
/* 2098 */           this.jjtree.closeNodeScope(jjtn001, true);
/*      */         }
/*      */       }
/* 2101 */       break;
/*      */     case 74:
/* 2103 */       NumericValuedParameter();
/* 2104 */       break;
/*      */     case 5:
/*      */     case 10:
/*      */     case 11:
/*      */     case 12:
/*      */     case 13:
/*      */     case 14:
/*      */     case 21:
/*      */     case 23:
/*      */     case 31:
/*      */     case 43:
/* 2115 */       FunctionsReturningNumerics();
/* 2116 */       break;
/*      */     default:
/* 2118 */       this.jj_la1[58] = this.jj_gen;
/* 2119 */       jj_consume_token(-1);
/* 2120 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void StringValue() throws ParseException
/*      */   {
/* 2126 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 84:
/* 2128 */       StringValuedPath();
/* 2129 */       break;
/*      */     case 9:
/*      */     case 30:
/*      */     case 37:
/*      */     case 42:
/* 2134 */       FunctionsReturningStrings();
/* 2135 */       break;
/*      */     case 58:
/* 2137 */       StringLiteral();
/* 2138 */       break;
/*      */     case 75:
/* 2140 */       StringValuedParameter();
/* 2141 */       break;
/*      */     default:
/* 2143 */       this.jj_la1[59] = this.jj_gen;
/* 2144 */       jj_consume_token(-1);
/* 2145 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void StringExpression() throws ParseException
/*      */   {
/* 2151 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 9:
/*      */     case 30:
/*      */     case 37:
/*      */     case 42:
/*      */     case 44:
/*      */     case 58:
/*      */     case 84:
/* 2159 */       StringPrimary();
/* 2160 */       break;
/*      */     case 75:
/* 2162 */       StringValuedParameter();
/* 2163 */       break;
/*      */     default:
/* 2165 */       this.jj_la1[60] = this.jj_gen;
/* 2166 */       jj_consume_token(-1);
/* 2167 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void StringPrimary() throws ParseException {
/* 2172 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 84:
/* 2174 */       StringValuedPath();
/* 2175 */       break;
/*      */     case 58:
/* 2177 */       StringLiteral();
/* 2178 */       break;
/*      */     case 44:
/* 2180 */       ASTStringParenthetical jjtn001 = new ASTStringParenthetical(31);
/* 2181 */       boolean jjtc001 = true;
/* 2182 */       this.jjtree.openNodeScope(jjtn001);
/*      */       try {
/* 2184 */         jj_consume_token(44);
/* 2185 */         StringExpression();
/* 2186 */         jj_consume_token(45);
/*      */       } catch (Throwable jjte001) {
/* 2188 */         if (jjtc001) {
/* 2189 */           this.jjtree.clearNodeScope(jjtn001);
/* 2190 */           jjtc001 = false;
/*      */         } else {
/* 2192 */           this.jjtree.popNode();
/*      */         }
/* 2194 */         if ((jjte001 instanceof RuntimeException)) {
/* 2195 */           throw ((RuntimeException)jjte001);
/*      */         }
/* 2197 */         if ((jjte001 instanceof ParseException)) {
/* 2198 */           throw ((ParseException)jjte001);
/*      */         }
/* 2200 */         throw ((Error)jjte001);
/*      */       } finally {
/* 2202 */         if (jjtc001) {
/* 2203 */           this.jjtree.closeNodeScope(jjtn001, true);
/*      */         }
/*      */       }
/* 2206 */       break;
/*      */     case 9:
/*      */     case 30:
/*      */     case 37:
/*      */     case 42:
/* 2211 */       FunctionsReturningStrings();
/* 2212 */       break;
/*      */     default:
/* 2214 */       this.jj_la1[61] = this.jj_gen;
/* 2215 */       jj_consume_token(-1);
/* 2216 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void DatetimeValue() throws ParseException
/*      */   {
/* 2222 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 85:
/* 2224 */       DatetimeValuedPath();
/* 2225 */       break;
/*      */     case 76:
/* 2227 */       DatetimeValuedParameter();
/* 2228 */       break;
/*      */     default:
/* 2230 */       this.jj_la1[62] = this.jj_gen;
/* 2231 */       jj_consume_token(-1);
/* 2232 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void DatetimeExpression() throws ParseException {
/* 2237 */     DatetimeValue();
/*      */   }
/*      */ 
/*      */   public final void BooleanValue() throws ParseException {
/* 2241 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 86:
/* 2243 */       BooleanValuedPath();
/* 2244 */       break;
/*      */     case 77:
/* 2246 */       BooleanValuedParameter();
/* 2247 */       break;
/*      */     case 65:
/*      */     case 66:
/* 2250 */       BooleanLiteral();
/* 2251 */       break;
/*      */     default:
/* 2253 */       this.jj_la1[63] = this.jj_gen;
/* 2254 */       jj_consume_token(-1);
/* 2255 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void BooleanExpression() throws ParseException {
/* 2260 */     BooleanValue();
/*      */   }
/*      */ 
/*      */   public final void ValueClassValue() throws ParseException {
/* 2264 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 88:
/* 2266 */       ValueClassValuedPath();
/* 2267 */       break;
/*      */     case 79:
/* 2269 */       ValueClassValuedParameter();
/* 2270 */       break;
/*      */     default:
/* 2272 */       this.jj_la1[64] = this.jj_gen;
/* 2273 */       jj_consume_token(-1);
/* 2274 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void ValueClassExpression() throws ParseException {
/* 2279 */     ValueClassValue();
/*      */   }
/*      */ 
/*      */   public final void EntityBeanValue() throws ParseException {
/* 2283 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 87:
/* 2285 */       EntityValuedPath();
/* 2286 */       break;
/*      */     case 69:
/* 2288 */       IdentificationVariable();
/* 2289 */       break;
/*      */     case 78:
/* 2291 */       EntityValuedParameter();
/* 2292 */       break;
/*      */     default:
/* 2294 */       this.jj_la1[65] = this.jj_gen;
/* 2295 */       jj_consume_token(-1);
/* 2296 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void EntityBeanExpression() throws ParseException {
/* 2301 */     EntityBeanValue();
/*      */   }
/*      */ 
/*      */   public final void FunctionsReturningStrings() throws ParseException
/*      */   {
/* 2306 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 9:
/* 2308 */       ASTConcat jjtn001 = new ASTConcat(32);
/* 2309 */       boolean jjtc001 = true;
/* 2310 */       this.jjtree.openNodeScope(jjtn001);
/*      */       try {
/* 2312 */         jj_consume_token(9);
/* 2313 */         jj_consume_token(44);
/* 2314 */         StringExpression();
/* 2315 */         jj_consume_token(46);
/* 2316 */         StringExpression();
/* 2317 */         jj_consume_token(45);
/*      */       } catch (Throwable jjte001) {
/* 2319 */         if (jjtc001) {
/* 2320 */           this.jjtree.clearNodeScope(jjtn001);
/* 2321 */           jjtc001 = false;
/*      */         } else {
/* 2323 */           this.jjtree.popNode();
/*      */         }
/* 2325 */         if ((jjte001 instanceof RuntimeException)) {
/* 2326 */           throw ((RuntimeException)jjte001);
/*      */         }
/* 2328 */         if ((jjte001 instanceof ParseException)) {
/* 2329 */           throw ((ParseException)jjte001);
/*      */         }
/* 2331 */         throw ((Error)jjte001);
/*      */       } finally {
/* 2333 */         if (jjtc001) {
/* 2334 */           this.jjtree.closeNodeScope(jjtn001, true);
/*      */         }
/*      */       }
/* 2337 */       break;
/*      */     case 30:
/* 2339 */       ASTSubstring jjtn002 = new ASTSubstring(33);
/* 2340 */       boolean jjtc002 = true;
/* 2341 */       this.jjtree.openNodeScope(jjtn002);
/*      */       try {
/* 2343 */         jj_consume_token(30);
/* 2344 */         jj_consume_token(44);
/* 2345 */         StringExpression();
/* 2346 */         jj_consume_token(46);
/* 2347 */         ArithmeticExpression();
/* 2348 */         jj_consume_token(46);
/* 2349 */         ArithmeticExpression();
/* 2350 */         jj_consume_token(45);
/*      */       } catch (Throwable jjte002) {
/* 2352 */         if (jjtc002) {
/* 2353 */           this.jjtree.clearNodeScope(jjtn002);
/* 2354 */           jjtc002 = false;
/*      */         } else {
/* 2356 */           this.jjtree.popNode();
/*      */         }
/* 2358 */         if ((jjte002 instanceof RuntimeException)) {
/* 2359 */           throw ((RuntimeException)jjte002);
/*      */         }
/* 2361 */         if ((jjte002 instanceof ParseException)) {
/* 2362 */           throw ((ParseException)jjte002);
/*      */         }
/* 2364 */         throw ((Error)jjte002);
/*      */       } finally {
/* 2366 */         if (jjtc002) {
/* 2367 */           this.jjtree.closeNodeScope(jjtn002, true);
/*      */         }
/*      */       }
/* 2370 */       break;
/*      */     case 42:
/* 2372 */       ASTUCase jjtn003 = new ASTUCase(34);
/* 2373 */       boolean jjtc003 = true;
/* 2374 */       this.jjtree.openNodeScope(jjtn003);
/*      */       try {
/* 2376 */         jj_consume_token(42);
/* 2377 */         jj_consume_token(44);
/* 2378 */         StringExpression();
/* 2379 */         jj_consume_token(45);
/*      */       } catch (Throwable jjte003) {
/* 2381 */         if (jjtc003) {
/* 2382 */           this.jjtree.clearNodeScope(jjtn003);
/* 2383 */           jjtc003 = false;
/*      */         } else {
/* 2385 */           this.jjtree.popNode();
/*      */         }
/* 2387 */         if ((jjte003 instanceof RuntimeException)) {
/* 2388 */           throw ((RuntimeException)jjte003);
/*      */         }
/* 2390 */         if ((jjte003 instanceof ParseException)) {
/* 2391 */           throw ((ParseException)jjte003);
/*      */         }
/* 2393 */         throw ((Error)jjte003);
/*      */       } finally {
/* 2395 */         if (jjtc003) {
/* 2396 */           this.jjtree.closeNodeScope(jjtn003, true);
/*      */         }
/*      */       }
/* 2399 */       break;
/*      */     case 37:
/* 2401 */       ASTLCase jjtn004 = new ASTLCase(35);
/* 2402 */       boolean jjtc004 = true;
/* 2403 */       this.jjtree.openNodeScope(jjtn004);
/*      */       try {
/* 2405 */         jj_consume_token(37);
/* 2406 */         jj_consume_token(44);
/* 2407 */         StringExpression();
/* 2408 */         jj_consume_token(45);
/*      */       } catch (Throwable jjte004) {
/* 2410 */         if (jjtc004) {
/* 2411 */           this.jjtree.clearNodeScope(jjtn004);
/* 2412 */           jjtc004 = false;
/*      */         } else {
/* 2414 */           this.jjtree.popNode();
/*      */         }
/* 2416 */         if ((jjte004 instanceof RuntimeException)) {
/* 2417 */           throw ((RuntimeException)jjte004);
/*      */         }
/* 2419 */         if ((jjte004 instanceof ParseException)) {
/* 2420 */           throw ((ParseException)jjte004);
/*      */         }
/* 2422 */         throw ((Error)jjte004);
/*      */       } finally {
/* 2424 */         if (jjtc004) {
/* 2425 */           this.jjtree.closeNodeScope(jjtn004, true);
/*      */         }
/*      */       }
/* 2428 */       break;
/*      */     default:
/* 2430 */       this.jj_la1[66] = this.jj_gen;
/* 2431 */       jj_consume_token(-1);
/* 2432 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void FunctionsReturningNumerics() throws ParseException {
/* 2437 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 21:
/* 2439 */       ASTLength jjtn001 = new ASTLength(36);
/* 2440 */       boolean jjtc001 = true;
/* 2441 */       this.jjtree.openNodeScope(jjtn001);
/*      */       try {
/* 2443 */         jj_consume_token(21);
/* 2444 */         jj_consume_token(44);
/* 2445 */         StringExpression();
/* 2446 */         jj_consume_token(45);
/*      */       } catch (Throwable jjte001) {
/* 2448 */         if (jjtc001) {
/* 2449 */           this.jjtree.clearNodeScope(jjtn001);
/* 2450 */           jjtc001 = false;
/*      */         } else {
/* 2452 */           this.jjtree.popNode();
/*      */         }
/* 2454 */         if ((jjte001 instanceof RuntimeException)) {
/* 2455 */           throw ((RuntimeException)jjte001);
/*      */         }
/* 2457 */         if ((jjte001 instanceof ParseException)) {
/* 2458 */           throw ((ParseException)jjte001);
/*      */         }
/* 2460 */         throw ((Error)jjte001);
/*      */       } finally {
/* 2462 */         if (jjtc001) {
/* 2463 */           this.jjtree.closeNodeScope(jjtn001, true);
/*      */         }
/*      */       }
/* 2466 */       break;
/*      */     case 23:
/* 2468 */       ASTLocate jjtn002 = new ASTLocate(37);
/* 2469 */       boolean jjtc002 = true;
/* 2470 */       this.jjtree.openNodeScope(jjtn002);
/*      */       try {
/* 2472 */         jj_consume_token(23);
/* 2473 */         jj_consume_token(44);
/* 2474 */         StringExpression();
/* 2475 */         jj_consume_token(46);
/* 2476 */         StringExpression();
/* 2477 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 46:
/* 2479 */           jj_consume_token(46);
/* 2480 */           ArithmeticExpression();
/* 2481 */           break;
/*      */         default:
/* 2483 */           this.jj_la1[67] = this.jj_gen;
/*      */         }
/*      */ 
/* 2486 */         jj_consume_token(45);
/*      */       } catch (Throwable jjte002) {
/* 2488 */         if (jjtc002) {
/* 2489 */           this.jjtree.clearNodeScope(jjtn002);
/* 2490 */           jjtc002 = false;
/*      */         } else {
/* 2492 */           this.jjtree.popNode();
/*      */         }
/* 2494 */         if ((jjte002 instanceof RuntimeException)) {
/* 2495 */           throw ((RuntimeException)jjte002);
/*      */         }
/* 2497 */         if ((jjte002 instanceof ParseException)) {
/* 2498 */           throw ((ParseException)jjte002);
/*      */         }
/* 2500 */         throw ((Error)jjte002);
/*      */       } finally {
/* 2502 */         if (jjtc002) {
/* 2503 */           this.jjtree.closeNodeScope(jjtn002, true);
/*      */         }
/*      */       }
/* 2506 */       break;
/*      */     case 5:
/* 2508 */       ASTAbs jjtn003 = new ASTAbs(38);
/* 2509 */       boolean jjtc003 = true;
/* 2510 */       this.jjtree.openNodeScope(jjtn003);
/*      */       try {
/* 2512 */         jj_consume_token(5);
/* 2513 */         jj_consume_token(44);
/* 2514 */         ArithmeticExpression();
/* 2515 */         jj_consume_token(45);
/*      */       } catch (Throwable jjte003) {
/* 2517 */         if (jjtc003) {
/* 2518 */           this.jjtree.clearNodeScope(jjtn003);
/* 2519 */           jjtc003 = false;
/*      */         } else {
/* 2521 */           this.jjtree.popNode();
/*      */         }
/* 2523 */         if ((jjte003 instanceof RuntimeException)) {
/* 2524 */           throw ((RuntimeException)jjte003);
/*      */         }
/* 2526 */         if ((jjte003 instanceof ParseException)) {
/* 2527 */           throw ((ParseException)jjte003);
/*      */         }
/* 2529 */         throw ((Error)jjte003);
/*      */       } finally {
/* 2531 */         if (jjtc003) {
/* 2532 */           this.jjtree.closeNodeScope(jjtn003, true);
/*      */         }
/*      */       }
/* 2535 */       break;
/*      */     case 31:
/* 2537 */       ASTSqrt jjtn004 = new ASTSqrt(39);
/* 2538 */       boolean jjtc004 = true;
/* 2539 */       this.jjtree.openNodeScope(jjtn004);
/*      */       try {
/* 2541 */         jj_consume_token(31);
/* 2542 */         jj_consume_token(44);
/* 2543 */         ArithmeticExpression();
/* 2544 */         jj_consume_token(45);
/*      */       } catch (Throwable jjte004) {
/* 2546 */         if (jjtc004) {
/* 2547 */           this.jjtree.clearNodeScope(jjtn004);
/* 2548 */           jjtc004 = false;
/*      */         } else {
/* 2550 */           this.jjtree.popNode();
/*      */         }
/* 2552 */         if ((jjte004 instanceof RuntimeException)) {
/* 2553 */           throw ((RuntimeException)jjte004);
/*      */         }
/* 2555 */         if ((jjte004 instanceof ParseException)) {
/* 2556 */           throw ((ParseException)jjte004);
/*      */         }
/* 2558 */         throw ((Error)jjte004);
/*      */       } finally {
/* 2560 */         if (jjtc004) {
/* 2561 */           this.jjtree.closeNodeScope(jjtn004, true);
/*      */         }
/*      */       }
/* 2564 */       break;
/*      */     case 43:
/* 2566 */       ASTMod jjtn005 = new ASTMod(40);
/* 2567 */       boolean jjtc005 = true;
/* 2568 */       this.jjtree.openNodeScope(jjtn005);
/*      */       try {
/* 2570 */         jj_consume_token(43);
/* 2571 */         jj_consume_token(44);
/* 2572 */         ArithmeticExpression();
/* 2573 */         jj_consume_token(46);
/* 2574 */         ArithmeticExpression();
/* 2575 */         jj_consume_token(45);
/*      */       } catch (Throwable jjte005) {
/* 2577 */         if (jjtc005) {
/* 2578 */           this.jjtree.clearNodeScope(jjtn005);
/* 2579 */           jjtc005 = false;
/*      */         } else {
/* 2581 */           this.jjtree.popNode();
/*      */         }
/* 2583 */         if ((jjte005 instanceof RuntimeException)) {
/* 2584 */           throw ((RuntimeException)jjte005);
/*      */         }
/* 2586 */         if ((jjte005 instanceof ParseException)) {
/* 2587 */           throw ((ParseException)jjte005);
/*      */         }
/* 2589 */         throw ((Error)jjte005);
/*      */       } finally {
/* 2591 */         if (jjtc005) {
/* 2592 */           this.jjtree.closeNodeScope(jjtn005, true);
/*      */         }
/*      */       }
/* 2595 */       break;
/*      */     case 10:
/*      */     case 11:
/*      */     case 12:
/*      */     case 13:
/*      */     case 14:
/* 2601 */       AggregateFunctions();
/* 2602 */       break;
/*      */     case 6:
/*      */     case 7:
/*      */     case 8:
/*      */     case 9:
/*      */     case 15:
/*      */     case 16:
/*      */     case 17:
/*      */     case 18:
/*      */     case 19:
/*      */     case 20:
/*      */     case 22:
/*      */     case 24:
/*      */     case 25:
/*      */     case 26:
/*      */     case 27:
/*      */     case 28:
/*      */     case 29:
/*      */     case 30:
/*      */     case 32:
/*      */     case 33:
/*      */     case 34:
/*      */     case 35:
/*      */     case 36:
/*      */     case 37:
/*      */     case 38:
/*      */     case 39:
/*      */     case 40:
/*      */     case 41:
/*      */     case 42:
/*      */     default:
/* 2604 */       this.jj_la1[68] = this.jj_gen;
/* 2605 */       jj_consume_token(-1);
/* 2606 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void AggregateFunctions() throws ParseException {
/* 2611 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 13:
/* 2613 */       ASTAvg jjtn001 = new ASTAvg(41);
/* 2614 */       boolean jjtc001 = true;
/* 2615 */       this.jjtree.openNodeScope(jjtn001);
/*      */       try {
/* 2617 */         jj_consume_token(13);
/* 2618 */         jj_consume_token(44);
/* 2619 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 15:
/* 2621 */           jj_consume_token(15);
/* 2622 */           jjtn001.distinct = "DISTINCT";
/* 2623 */           break;
/*      */         default:
/* 2625 */           this.jj_la1[69] = this.jj_gen;
/*      */         }
/*      */ 
/* 2628 */         SingleValuedPath();
/* 2629 */         jj_consume_token(45);
/*      */       } catch (Throwable jjte001) {
/* 2631 */         if (jjtc001) {
/* 2632 */           this.jjtree.clearNodeScope(jjtn001);
/* 2633 */           jjtc001 = false;
/*      */         } else {
/* 2635 */           this.jjtree.popNode();
/*      */         }
/* 2637 */         if ((jjte001 instanceof RuntimeException)) {
/* 2638 */           throw ((RuntimeException)jjte001);
/*      */         }
/* 2640 */         if ((jjte001 instanceof ParseException)) {
/* 2641 */           throw ((ParseException)jjte001);
/*      */         }
/* 2643 */         throw ((Error)jjte001);
/*      */       } finally {
/* 2645 */         if (jjtc001) {
/* 2646 */           this.jjtree.closeNodeScope(jjtn001, true);
/*      */         }
/*      */       }
/* 2649 */       break;
/*      */     case 11:
/* 2651 */       ASTMax jjtn002 = new ASTMax(42);
/* 2652 */       boolean jjtc002 = true;
/* 2653 */       this.jjtree.openNodeScope(jjtn002);
/*      */       try {
/* 2655 */         jj_consume_token(11);
/* 2656 */         jj_consume_token(44);
/* 2657 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 15:
/* 2659 */           jj_consume_token(15);
/* 2660 */           jjtn002.distinct = "DISTINCT";
/* 2661 */           break;
/*      */         default:
/* 2663 */           this.jj_la1[70] = this.jj_gen;
/*      */         }
/*      */ 
/* 2666 */         SingleValuedPath();
/* 2667 */         jj_consume_token(45);
/*      */       } catch (Throwable jjte002) {
/* 2669 */         if (jjtc002) {
/* 2670 */           this.jjtree.clearNodeScope(jjtn002);
/* 2671 */           jjtc002 = false;
/*      */         } else {
/* 2673 */           this.jjtree.popNode();
/*      */         }
/* 2675 */         if ((jjte002 instanceof RuntimeException)) {
/* 2676 */           throw ((RuntimeException)jjte002);
/*      */         }
/* 2678 */         if ((jjte002 instanceof ParseException)) {
/* 2679 */           throw ((ParseException)jjte002);
/*      */         }
/* 2681 */         throw ((Error)jjte002);
/*      */       } finally {
/* 2683 */         if (jjtc002) {
/* 2684 */           this.jjtree.closeNodeScope(jjtn002, true);
/*      */         }
/*      */       }
/* 2687 */       break;
/*      */     case 12:
/* 2689 */       ASTMin jjtn003 = new ASTMin(43);
/* 2690 */       boolean jjtc003 = true;
/* 2691 */       this.jjtree.openNodeScope(jjtn003);
/*      */       try {
/* 2693 */         jj_consume_token(12);
/* 2694 */         jj_consume_token(44);
/* 2695 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 15:
/* 2697 */           jj_consume_token(15);
/* 2698 */           jjtn003.distinct = "DISTINCT";
/* 2699 */           break;
/*      */         default:
/* 2701 */           this.jj_la1[71] = this.jj_gen;
/*      */         }
/*      */ 
/* 2704 */         SingleValuedPath();
/* 2705 */         jj_consume_token(45);
/*      */       } catch (Throwable jjte003) {
/* 2707 */         if (jjtc003) {
/* 2708 */           this.jjtree.clearNodeScope(jjtn003);
/* 2709 */           jjtc003 = false;
/*      */         } else {
/* 2711 */           this.jjtree.popNode();
/*      */         }
/* 2713 */         if ((jjte003 instanceof RuntimeException)) {
/* 2714 */           throw ((RuntimeException)jjte003);
/*      */         }
/* 2716 */         if ((jjte003 instanceof ParseException)) {
/* 2717 */           throw ((ParseException)jjte003);
/*      */         }
/* 2719 */         throw ((Error)jjte003);
/*      */       } finally {
/* 2721 */         if (jjtc003) {
/* 2722 */           this.jjtree.closeNodeScope(jjtn003, true);
/*      */         }
/*      */       }
/* 2725 */       break;
/*      */     case 14:
/* 2727 */       ASTSum jjtn004 = new ASTSum(44);
/* 2728 */       boolean jjtc004 = true;
/* 2729 */       this.jjtree.openNodeScope(jjtn004);
/*      */       try {
/* 2731 */         jj_consume_token(14);
/* 2732 */         jj_consume_token(44);
/* 2733 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 15:
/* 2735 */           jj_consume_token(15);
/* 2736 */           jjtn004.distinct = "DISTINCT";
/* 2737 */           break;
/*      */         default:
/* 2739 */           this.jj_la1[72] = this.jj_gen;
/*      */         }
/*      */ 
/* 2742 */         SingleValuedPath();
/* 2743 */         jj_consume_token(45);
/*      */       } catch (Throwable jjte004) {
/* 2745 */         if (jjtc004) {
/* 2746 */           this.jjtree.clearNodeScope(jjtn004);
/* 2747 */           jjtc004 = false;
/*      */         } else {
/* 2749 */           this.jjtree.popNode();
/*      */         }
/* 2751 */         if ((jjte004 instanceof RuntimeException)) {
/* 2752 */           throw ((RuntimeException)jjte004);
/*      */         }
/* 2754 */         if ((jjte004 instanceof ParseException)) {
/* 2755 */           throw ((ParseException)jjte004);
/*      */         }
/* 2757 */         throw ((Error)jjte004);
/*      */       } finally {
/* 2759 */         if (jjtc004) {
/* 2760 */           this.jjtree.closeNodeScope(jjtn004, true);
/*      */         }
/*      */       }
/* 2763 */       break;
/*      */     case 10:
/* 2765 */       ASTCount jjtn005 = new ASTCount(45);
/* 2766 */       boolean jjtc005 = true;
/* 2767 */       this.jjtree.openNodeScope(jjtn005);
/*      */       try {
/* 2769 */         jj_consume_token(10);
/* 2770 */         jj_consume_token(44);
/* 2771 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 15:
/* 2773 */           jj_consume_token(15);
/* 2774 */           jjtn005.distinct = "DISTINCT";
/* 2775 */           break;
/*      */         default:
/* 2777 */           this.jj_la1[73] = this.jj_gen;
/*      */         }
/*      */ 
/* 2780 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 83:
/*      */         case 84:
/*      */         case 85:
/*      */         case 86:
/*      */         case 87:
/*      */         case 88:
/* 2787 */           SingleValuedPath();
/* 2788 */           break;
/*      */         case 69:
/*      */         case 78:
/* 2791 */           EntityBeanValue();
/* 2792 */           break;
/*      */         case 70:
/*      */         case 71:
/*      */         case 72:
/*      */         case 73:
/*      */         case 74:
/*      */         case 75:
/*      */         case 76:
/*      */         case 77:
/*      */         case 79:
/*      */         case 80:
/*      */         case 81:
/*      */         case 82:
/*      */         default:
/* 2794 */           this.jj_la1[74] = this.jj_gen;
/* 2795 */           jj_consume_token(-1);
/* 2796 */           throw new ParseException();
/*      */         }
/* 2798 */         jj_consume_token(45);
/*      */       } catch (Throwable jjte005) {
/* 2800 */         if (jjtc005) {
/* 2801 */           this.jjtree.clearNodeScope(jjtn005);
/* 2802 */           jjtc005 = false;
/*      */         } else {
/* 2804 */           this.jjtree.popNode();
/*      */         }
/* 2806 */         if ((jjte005 instanceof RuntimeException)) {
/* 2807 */           throw ((RuntimeException)jjte005);
/*      */         }
/* 2809 */         if ((jjte005 instanceof ParseException)) {
/* 2810 */           throw ((ParseException)jjte005);
/*      */         }
/* 2812 */         throw ((Error)jjte005);
/*      */       } finally {
/* 2814 */         if (jjtc005) {
/* 2815 */           this.jjtree.closeNodeScope(jjtn005, true);
/*      */         }
/*      */       }
/* 2818 */       break;
/*      */     default:
/* 2820 */       this.jj_la1[75] = this.jj_gen;
/* 2821 */       jj_consume_token(-1);
/* 2822 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final Token CollectionValuedPath() throws ParseException
/*      */   {
/* 2828 */     ASTPath jjtn000 = new ASTPath(46);
/* 2829 */     boolean jjtc000 = true;
/* 2830 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 2832 */       Token t = jj_consume_token(90);
/* 2833 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 2834 */       jjtc000 = false;
/* 2835 */       initPathNode(jjtn000, t.image, 5);
/* 2836 */       localToken1 = t;
/*      */     }
/*      */     finally
/*      */     {
/*      */       Token localToken1;
/* 2838 */       if (jjtc000)
/* 2839 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final Token IdentificationVariable()
/*      */     throws ParseException
/*      */   {
/* 2847 */     ASTPath jjtn000 = new ASTPath(46);
/* 2848 */     boolean jjtc000 = true;
/* 2849 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 2851 */       Token t = jj_consume_token(69);
/* 2852 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 2853 */       jjtc000 = false;
/* 2854 */       t.image = t.image.toLowerCase();
/* 2855 */       initPathNode(jjtn000, t.image, 5);
/* 2856 */       localToken1 = t;
/*      */     }
/*      */     finally
/*      */     {
/*      */       Token localToken1;
/* 2858 */       if (jjtc000)
/* 2859 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final Token AbstractSchema()
/*      */     throws ParseException
/*      */   {
/* 2867 */     ASTAbstractSchema jjtn000 = new ASTAbstractSchema(47);
/* 2868 */     boolean jjtc000 = true;
/* 2869 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try
/*      */     {
/*      */       Token t;
/*      */       Token localToken1;
/* 2871 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 68:
/* 2873 */         t = jj_consume_token(68);
/* 2874 */         this.jjtree.closeNodeScope(jjtn000, true);
/* 2875 */         jjtc000 = false;
/* 2876 */         jjtn000.abstractSchemaName = t.image;
/* 2877 */         jjtn000.entity = this.catalog.getEntityByAbstractSchemaName(t.image);
/* 2878 */         localToken1 = t; jsr 89;
/*      */       case 40:
/* 2881 */         t = jj_consume_token(40);
/* 2882 */         this.jjtree.closeNodeScope(jjtn000, true);
/* 2883 */         jjtc000 = false;
/* 2884 */         jjtn000.abstractSchemaName = t.image;
/* 2885 */         jjtn000.entity = this.catalog.getEntityByAbstractSchemaName(t.image);
/* 2886 */         localToken1 = t; jsr 39;
/*      */       }
/*      */ 
/* 2889 */       this.jj_la1[76] = this.jj_gen;
/* 2890 */       jj_consume_token(-1);
/* 2891 */       throw new ParseException();
/*      */     }
/*      */     finally {
/* 2894 */       jsr 6; throw localObject1; localObject2 = returnAddress; if (jjtc000)
/* 2895 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final Token Identifier()
/*      */     throws ParseException
/*      */   {
/* 2903 */     ASTIdentifier jjtn000 = new ASTIdentifier(48);
/* 2904 */     boolean jjtc000 = true;
/* 2905 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 2907 */       Token t = jj_consume_token(67);
/* 2908 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 2909 */       jjtc000 = false;
/* 2910 */       t.image = t.image.toLowerCase();
/* 2911 */       jjtn000.identifier = t.image;
/* 2912 */       localToken1 = t;
/*      */     }
/*      */     finally
/*      */     {
/*      */       Token localToken1;
/* 2914 */       if (jjtc000)
/* 2915 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void SingleValuedPath()
/*      */     throws ParseException
/*      */   {
/* 2922 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 83:
/* 2924 */       NumericValuedPath();
/* 2925 */       break;
/*      */     case 84:
/* 2927 */       StringValuedPath();
/* 2928 */       break;
/*      */     case 85:
/* 2930 */       DatetimeValuedPath();
/* 2931 */       break;
/*      */     case 86:
/* 2933 */       BooleanValuedPath();
/* 2934 */       break;
/*      */     case 87:
/* 2936 */       EntityValuedPath();
/* 2937 */       break;
/*      */     case 88:
/* 2939 */       ValueClassValuedPath();
/* 2940 */       break;
/*      */     default:
/* 2942 */       this.jj_la1[77] = this.jj_gen;
/* 2943 */       jj_consume_token(-1);
/* 2944 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void NumericValuedPath() throws ParseException
/*      */   {
/* 2950 */     ASTPath jjtn000 = new ASTPath(46);
/* 2951 */     boolean jjtc000 = true;
/* 2952 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 2954 */       Token t = jj_consume_token(83);
/* 2955 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 2956 */       jjtc000 = false;
/* 2957 */       initPathNode(jjtn000, t.image, 1);
/*      */     } finally {
/* 2959 */       if (jjtc000)
/* 2960 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void StringValuedPath()
/*      */     throws ParseException
/*      */   {
/* 2967 */     ASTPath jjtn000 = new ASTPath(46);
/* 2968 */     boolean jjtc000 = true;
/* 2969 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 2971 */       Token t = jj_consume_token(84);
/* 2972 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 2973 */       jjtc000 = false;
/* 2974 */       initPathNode(jjtn000, t.image, 2);
/*      */     } finally {
/* 2976 */       if (jjtc000)
/* 2977 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void DatetimeValuedPath()
/*      */     throws ParseException
/*      */   {
/* 2984 */     ASTPath jjtn000 = new ASTPath(46);
/* 2985 */     boolean jjtc000 = true;
/* 2986 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 2988 */       Token t = jj_consume_token(85);
/* 2989 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 2990 */       jjtc000 = false;
/* 2991 */       initPathNode(jjtn000, t.image, 3);
/*      */     } finally {
/* 2993 */       if (jjtc000)
/* 2994 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void BooleanValuedPath()
/*      */     throws ParseException
/*      */   {
/* 3001 */     ASTPath jjtn000 = new ASTPath(46);
/* 3002 */     boolean jjtc000 = true;
/* 3003 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 3005 */       Token t = jj_consume_token(86);
/* 3006 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 3007 */       jjtc000 = false;
/* 3008 */       initPathNode(jjtn000, t.image, 4);
/*      */     } finally {
/* 3010 */       if (jjtc000)
/* 3011 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void EntityValuedPath()
/*      */     throws ParseException
/*      */   {
/* 3018 */     ASTPath jjtn000 = new ASTPath(46);
/* 3019 */     boolean jjtc000 = true;
/* 3020 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 3022 */       Token t = jj_consume_token(87);
/* 3023 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 3024 */       jjtc000 = false;
/* 3025 */       initPathNode(jjtn000, t.image, 5);
/*      */     } finally {
/* 3027 */       if (jjtc000)
/* 3028 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void ValueClassValuedPath()
/*      */     throws ParseException
/*      */   {
/* 3035 */     ASTPath jjtn000 = new ASTPath(46);
/* 3036 */     boolean jjtc000 = true;
/* 3037 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 3039 */       Token t = jj_consume_token(88);
/* 3040 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 3041 */       jjtc000 = false;
/* 3042 */       initPathNode(jjtn000, t.image, 6);
/*      */     } finally {
/* 3044 */       if (jjtc000)
/* 3045 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void NumericValuedParameter()
/*      */     throws ParseException
/*      */   {
/* 3052 */     ASTParameter jjtn000 = new ASTParameter(49);
/* 3053 */     boolean jjtc000 = true;
/* 3054 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 3056 */       Token t = jj_consume_token(74);
/* 3057 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 3058 */       jjtc000 = false;
/* 3059 */       initParameterNode(jjtn000, t.image, 1);
/*      */     } finally {
/* 3061 */       if (jjtc000)
/* 3062 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void StringValuedParameter()
/*      */     throws ParseException
/*      */   {
/* 3069 */     ASTParameter jjtn000 = new ASTParameter(49);
/* 3070 */     boolean jjtc000 = true;
/* 3071 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 3073 */       Token t = jj_consume_token(75);
/* 3074 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 3075 */       jjtc000 = false;
/* 3076 */       initParameterNode(jjtn000, t.image, 2);
/*      */     } finally {
/* 3078 */       if (jjtc000)
/* 3079 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void DatetimeValuedParameter()
/*      */     throws ParseException
/*      */   {
/* 3086 */     ASTParameter jjtn000 = new ASTParameter(49);
/* 3087 */     boolean jjtc000 = true;
/* 3088 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 3090 */       Token t = jj_consume_token(76);
/* 3091 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 3092 */       jjtc000 = false;
/* 3093 */       initParameterNode(jjtn000, t.image, 3);
/*      */     } finally {
/* 3095 */       if (jjtc000)
/* 3096 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void BooleanValuedParameter()
/*      */     throws ParseException
/*      */   {
/* 3103 */     ASTParameter jjtn000 = new ASTParameter(49);
/* 3104 */     boolean jjtc000 = true;
/* 3105 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 3107 */       Token t = jj_consume_token(77);
/* 3108 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 3109 */       jjtc000 = false;
/* 3110 */       initParameterNode(jjtn000, t.image, 4);
/*      */     } finally {
/* 3112 */       if (jjtc000)
/* 3113 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void EntityValuedParameter()
/*      */     throws ParseException
/*      */   {
/* 3120 */     ASTParameter jjtn000 = new ASTParameter(49);
/* 3121 */     boolean jjtc000 = true;
/* 3122 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 3124 */       Token t = jj_consume_token(78);
/* 3125 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 3126 */       jjtc000 = false;
/* 3127 */       initParameterNode(jjtn000, t.image, 5);
/*      */     } finally {
/* 3129 */       if (jjtc000)
/* 3130 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void ValueClassValuedParameter()
/*      */     throws ParseException
/*      */   {
/* 3137 */     ASTParameter jjtn000 = new ASTParameter(49);
/* 3138 */     boolean jjtc000 = true;
/* 3139 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 3141 */       Token t = jj_consume_token(79);
/* 3142 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 3143 */       jjtc000 = false;
/* 3144 */       initParameterNode(jjtn000, t.image, 6);
/*      */     } finally {
/* 3146 */       if (jjtc000)
/* 3147 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void NumericLiteral()
/*      */     throws ParseException
/*      */   {
/*      */     Token t;
/* 3154 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 59:
/* 3156 */       ASTExactNumericLiteral jjtn001 = new ASTExactNumericLiteral(50);
/* 3157 */       boolean jjtc001 = true;
/* 3158 */       this.jjtree.openNodeScope(jjtn001);
/*      */       try {
/* 3160 */         t = jj_consume_token(59);
/* 3161 */         this.jjtree.closeNodeScope(jjtn001, true);
/* 3162 */         jjtc001 = false;
/* 3163 */         jjtn001.setValue(t.image);
/*      */       } finally {
/* 3165 */         if (jjtc001) {
/* 3166 */           this.jjtree.closeNodeScope(jjtn001, true);
/*      */         }
/*      */       }
/* 3169 */       break;
/*      */     case 63:
/* 3171 */       ASTApproximateNumericLiteral jjtn002 = new ASTApproximateNumericLiteral(51);
/* 3172 */       boolean jjtc002 = true;
/* 3173 */       this.jjtree.openNodeScope(jjtn002);
/*      */       try {
/* 3175 */         t = jj_consume_token(63);
/* 3176 */         this.jjtree.closeNodeScope(jjtn002, true);
/* 3177 */         jjtc002 = false;
/* 3178 */         jjtn002.setValue(t.image);
/*      */       } finally {
/* 3180 */         if (jjtc002) {
/* 3181 */           this.jjtree.closeNodeScope(jjtn002, true);
/*      */         }
/*      */       }
/* 3184 */       break;
/*      */     default:
/* 3186 */       this.jj_la1[78] = this.jj_gen;
/* 3187 */       jj_consume_token(-1);
/* 3188 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void StringLiteral() throws ParseException
/*      */   {
/* 3194 */     ASTStringLiteral jjtn000 = new ASTStringLiteral(52);
/* 3195 */     boolean jjtc000 = true;
/* 3196 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 3198 */       Token t = jj_consume_token(58);
/* 3199 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 3200 */       jjtc000 = false;
/* 3201 */       jjtn000.value = t.image;
/*      */     } finally {
/* 3203 */       if (jjtc000)
/* 3204 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void BooleanLiteral()
/*      */     throws ParseException
/*      */   {
/* 3211 */     ASTBooleanLiteral jjtn000 = new ASTBooleanLiteral(53);
/* 3212 */     boolean jjtc000 = true;
/* 3213 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 3215 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 66:
/* 3217 */         jj_consume_token(66);
/* 3218 */         this.jjtree.closeNodeScope(jjtn000, true);
/* 3219 */         jjtc000 = false;
/* 3220 */         jjtn000.value = true;
/* 3221 */         break;
/*      */       case 65:
/* 3223 */         jj_consume_token(65);
/* 3224 */         this.jjtree.closeNodeScope(jjtn000, true);
/* 3225 */         jjtc000 = false;
/* 3226 */         jjtn000.value = false;
/* 3227 */         break;
/*      */       default:
/* 3229 */         this.jj_la1[79] = this.jj_gen;
/* 3230 */         jj_consume_token(-1);
/* 3231 */         throw new ParseException();
/*      */       }
/*      */     } finally {
/* 3234 */       if (jjtc000)
/* 3235 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   private final boolean jj_2_1(int xla)
/*      */   {
/* 3241 */     this.jj_la = xla; this.jj_lastpos = (this.jj_scanpos = this.token);
/*      */     try { i = !jj_3_1() ? 1 : 0;
/*      */     }
/*      */     catch (LookaheadSuccess ls)
/*      */     {
/*      */       int i;
/* 3243 */       return 1; } finally {
/* 3244 */       jj_save(0, xla);
/*      */     }
/*      */   }
/*      */ 
/*      */   private final boolean jj_2_2(int xla) {
/* 3248 */     this.jj_la = xla; this.jj_lastpos = (this.jj_scanpos = this.token);
/*      */     try { i = !jj_3_2() ? 1 : 0;
/*      */     }
/*      */     catch (LookaheadSuccess ls)
/*      */     {
/*      */       int i;
/* 3250 */       return 1; } finally {
/* 3251 */       jj_save(1, xla);
/*      */     }
/*      */   }
/*      */ 
/*      */   private final boolean jj_2_3(int xla) {
/* 3255 */     this.jj_la = xla; this.jj_lastpos = (this.jj_scanpos = this.token);
/*      */     try { i = !jj_3_3() ? 1 : 0;
/*      */     }
/*      */     catch (LookaheadSuccess ls)
/*      */     {
/*      */       int i;
/* 3257 */       return 1; } finally {
/* 3258 */       jj_save(2, xla);
/*      */     }
/*      */   }
/*      */ 
/*      */   private final boolean jj_2_4(int xla) {
/* 3262 */     this.jj_la = xla; this.jj_lastpos = (this.jj_scanpos = this.token);
/*      */     try { i = !jj_3_4() ? 1 : 0;
/*      */     }
/*      */     catch (LookaheadSuccess ls)
/*      */     {
/*      */       int i;
/* 3264 */       return 1; } finally {
/* 3265 */       jj_save(3, xla);
/*      */     }
/*      */   }
/*      */ 
/*      */   private final boolean jj_2_5(int xla) {
/* 3269 */     this.jj_la = xla; this.jj_lastpos = (this.jj_scanpos = this.token);
/*      */     try { i = !jj_3_5() ? 1 : 0;
/*      */     }
/*      */     catch (LookaheadSuccess ls)
/*      */     {
/*      */       int i;
/* 3271 */       return 1; } finally {
/* 3272 */       jj_save(4, xla);
/*      */     }
/*      */   }
/*      */ 
/*      */   private final boolean jj_2_6(int xla) {
/* 3276 */     this.jj_la = xla; this.jj_lastpos = (this.jj_scanpos = this.token);
/*      */     try { i = !jj_3_6() ? 1 : 0;
/*      */     }
/*      */     catch (LookaheadSuccess ls)
/*      */     {
/*      */       int i;
/* 3278 */       return 1; } finally {
/* 3279 */       jj_save(5, xla);
/*      */     }
/*      */   }
/*      */ 
/*      */   private final boolean jj_2_7(int xla) {
/* 3283 */     this.jj_la = xla; this.jj_lastpos = (this.jj_scanpos = this.token);
/*      */     try { i = !jj_3_7() ? 1 : 0;
/*      */     }
/*      */     catch (LookaheadSuccess ls)
/*      */     {
/*      */       int i;
/* 3285 */       return 1; } finally {
/* 3286 */       jj_save(6, xla);
/*      */     }
/*      */   }
/*      */ 
/*      */   private final boolean jj_2_8(int xla) {
/* 3290 */     this.jj_la = xla; this.jj_lastpos = (this.jj_scanpos = this.token);
/*      */     try { i = !jj_3_8() ? 1 : 0;
/*      */     }
/*      */     catch (LookaheadSuccess ls)
/*      */     {
/*      */       int i;
/* 3292 */       return 1; } finally {
/* 3293 */       jj_save(7, xla);
/*      */     }
/*      */   }
/*      */ 
/*      */   private final boolean jj_2_9(int xla) {
/* 3297 */     this.jj_la = xla; this.jj_lastpos = (this.jj_scanpos = this.token);
/*      */     try { i = !jj_3_9() ? 1 : 0;
/*      */     }
/*      */     catch (LookaheadSuccess ls)
/*      */     {
/*      */       int i;
/* 3299 */       return 1; } finally {
/* 3300 */       jj_save(8, xla);
/*      */     }
/*      */   }
/*      */ 
/*      */   private final boolean jj_2_10(int xla) {
/* 3304 */     this.jj_la = xla; this.jj_lastpos = (this.jj_scanpos = this.token);
/*      */     try { i = !jj_3_10() ? 1 : 0;
/*      */     }
/*      */     catch (LookaheadSuccess ls)
/*      */     {
/*      */       int i;
/* 3306 */       return 1; } finally {
/* 3307 */       jj_save(9, xla);
/*      */     }
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_111() {
/* 3312 */     Token xsp = this.jj_scanpos;
/* 3313 */     if (jj_3R_119()) {
/* 3314 */       this.jj_scanpos = xsp;
/* 3315 */       if (jj_3_2()) return true;
/*      */     }
/* 3317 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_119() {
/* 3321 */     if (jj_scan_token(44)) return true;
/* 3322 */     if (jj_3R_12()) return true;
/* 3323 */     return jj_scan_token(45);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_108()
/*      */   {
/* 3328 */     return jj_3R_118();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_24()
/*      */   {
/* 3333 */     if (jj_scan_token(28)) return true;
/* 3334 */     return jj_3R_23();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_76()
/*      */   {
/* 3339 */     return jj_3R_111();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_107()
/*      */   {
/* 3344 */     if (jj_scan_token(43)) return true;
/* 3345 */     if (jj_scan_token(44)) return true;
/* 3346 */     if (jj_3R_116()) return true;
/* 3347 */     if (jj_scan_token(46)) return true;
/* 3348 */     if (jj_3R_116()) return true;
/* 3349 */     return jj_scan_token(45);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_117()
/*      */   {
/* 3354 */     if (jj_scan_token(46)) return true;
/* 3355 */     return jj_3R_116();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_75()
/*      */   {
/* 3360 */     return jj_scan_token(24);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_106()
/*      */   {
/* 3365 */     if (jj_scan_token(31)) return true;
/* 3366 */     if (jj_scan_token(44)) return true;
/* 3367 */     if (jj_3R_116()) return true;
/* 3368 */     return jj_scan_token(45);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_49()
/*      */   {
/* 3374 */     Token xsp = this.jj_scanpos;
/* 3375 */     if (jj_3R_75()) this.jj_scanpos = xsp;
/* 3376 */     return jj_3R_76();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_105()
/*      */   {
/* 3381 */     if (jj_scan_token(5)) return true;
/* 3382 */     if (jj_scan_token(44)) return true;
/* 3383 */     if (jj_3R_116()) return true;
/* 3384 */     return jj_scan_token(45);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_44()
/*      */   {
/* 3389 */     return jj_3R_70();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_104()
/*      */   {
/* 3394 */     if (jj_scan_token(23)) return true;
/* 3395 */     if (jj_scan_token(44)) return true;
/* 3396 */     if (jj_3R_113()) return true;
/* 3397 */     if (jj_scan_token(46)) return true;
/* 3398 */     if (jj_3R_113()) return true;
/*      */ 
/* 3400 */     Token xsp = this.jj_scanpos;
/* 3401 */     if (jj_3R_117()) this.jj_scanpos = xsp;
/* 3402 */     return jj_scan_token(45);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_23()
/*      */   {
/* 3407 */     if (jj_3R_49()) return true; Token xsp;
/*      */     do
/* 3410 */       xsp = this.jj_scanpos;
/* 3411 */     while (!jj_3R_50()); this.jj_scanpos = xsp;
/*      */ 
/* 3413 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_72()
/*      */   {
/* 3418 */     Token xsp = this.jj_scanpos;
/* 3419 */     if (jj_3R_103()) {
/* 3420 */       this.jj_scanpos = xsp;
/* 3421 */       if (jj_3R_104()) {
/* 3422 */         this.jj_scanpos = xsp;
/* 3423 */         if (jj_3R_105()) {
/* 3424 */           this.jj_scanpos = xsp;
/* 3425 */           if (jj_3R_106()) {
/* 3426 */             this.jj_scanpos = xsp;
/* 3427 */             if (jj_3R_107()) {
/* 3428 */               this.jj_scanpos = xsp;
/* 3429 */               if (jj_3R_108()) return true;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 3435 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_103() {
/* 3439 */     if (jj_scan_token(21)) return true;
/* 3440 */     if (jj_scan_token(44)) return true;
/* 3441 */     if (jj_3R_113()) return true;
/* 3442 */     return jj_scan_token(45);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_12()
/*      */   {
/* 3447 */     if (jj_3R_23()) return true; Token xsp;
/*      */     do
/* 3450 */       xsp = this.jj_scanpos;
/* 3451 */     while (!jj_3R_24()); this.jj_scanpos = xsp;
/*      */ 
/* 3453 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_100() {
/* 3457 */     if (jj_scan_token(37)) return true;
/* 3458 */     if (jj_scan_token(44)) return true;
/* 3459 */     if (jj_3R_113()) return true;
/* 3460 */     return jj_scan_token(45);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_99()
/*      */   {
/* 3465 */     if (jj_scan_token(42)) return true;
/* 3466 */     if (jj_scan_token(44)) return true;
/* 3467 */     if (jj_3R_113()) return true;
/* 3468 */     return jj_scan_token(45);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_37()
/*      */   {
/* 3473 */     return jj_3R_63();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_43()
/*      */   {
/* 3478 */     return jj_3R_69();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_98()
/*      */   {
/* 3483 */     if (jj_scan_token(30)) return true;
/* 3484 */     if (jj_scan_token(44)) return true;
/* 3485 */     if (jj_3R_113()) return true;
/* 3486 */     if (jj_scan_token(46)) return true;
/* 3487 */     if (jj_3R_116()) return true;
/* 3488 */     if (jj_scan_token(46)) return true;
/* 3489 */     if (jj_3R_116()) return true;
/* 3490 */     return jj_scan_token(45);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_58()
/*      */   {
/* 3496 */     Token xsp = this.jj_scanpos;
/* 3497 */     if (jj_3R_97()) {
/* 3498 */       this.jj_scanpos = xsp;
/* 3499 */       if (jj_3R_98()) {
/* 3500 */         this.jj_scanpos = xsp;
/* 3501 */         if (jj_3R_99()) {
/* 3502 */           this.jj_scanpos = xsp;
/* 3503 */           if (jj_3R_100()) return true;
/*      */         }
/*      */       }
/*      */     }
/* 3507 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_97() {
/* 3511 */     if (jj_scan_token(9)) return true;
/* 3512 */     if (jj_scan_token(44)) return true;
/* 3513 */     if (jj_3R_113()) return true;
/* 3514 */     if (jj_scan_token(46)) return true;
/* 3515 */     if (jj_3R_113()) return true;
/* 3516 */     return jj_scan_token(45);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_41()
/*      */   {
/* 3521 */     return jj_3R_67();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_199()
/*      */   {
/* 3526 */     return jj_3R_21();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_42()
/*      */   {
/* 3531 */     return jj_3R_68();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_21()
/*      */   {
/* 3537 */     Token xsp = this.jj_scanpos;
/* 3538 */     if (jj_3R_42()) {
/* 3539 */       this.jj_scanpos = xsp;
/* 3540 */       if (jj_3R_43()) {
/* 3541 */         this.jj_scanpos = xsp;
/* 3542 */         if (jj_3R_44()) return true;
/*      */       }
/*      */     }
/* 3545 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_36() {
/* 3549 */     return jj_3R_62();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_196()
/*      */   {
/* 3554 */     return jj_3R_20();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_40()
/*      */   {
/* 3559 */     return jj_3R_66();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_20()
/*      */   {
/* 3565 */     Token xsp = this.jj_scanpos;
/* 3566 */     if (jj_3R_40()) {
/* 3567 */       this.jj_scanpos = xsp;
/* 3568 */       if (jj_3R_41()) return true;
/*      */     }
/* 3570 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_39() {
/* 3574 */     return jj_3R_65();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_209()
/*      */   {
/* 3579 */     return jj_3R_18();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_18()
/*      */   {
/* 3585 */     Token xsp = this.jj_scanpos;
/* 3586 */     if (jj_3R_35()) {
/* 3587 */       this.jj_scanpos = xsp;
/* 3588 */       if (jj_3R_36()) {
/* 3589 */         this.jj_scanpos = xsp;
/* 3590 */         if (jj_3R_37()) return true;
/*      */       }
/*      */     }
/* 3593 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_35() {
/* 3597 */     return jj_3R_61();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_189()
/*      */   {
/* 3602 */     return jj_3R_19();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_127()
/*      */   {
/* 3607 */     return jj_3R_60();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_38()
/*      */   {
/* 3612 */     return jj_3R_64();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_19()
/*      */   {
/* 3618 */     Token xsp = this.jj_scanpos;
/* 3619 */     if (jj_3R_38()) {
/* 3620 */       this.jj_scanpos = xsp;
/* 3621 */       if (jj_3R_39()) return true;
/*      */     }
/* 3623 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_32() {
/* 3627 */     return jj_3R_58();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_34()
/*      */   {
/* 3632 */     return jj_3R_60();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_158()
/*      */   {
/* 3637 */     return jj_3R_58();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_157()
/*      */   {
/* 3642 */     if (jj_scan_token(44)) return true;
/* 3643 */     if (jj_3R_113()) return true;
/* 3644 */     return jj_scan_token(45);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_156()
/*      */   {
/* 3649 */     return jj_3R_59();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_155()
/*      */   {
/* 3654 */     return jj_3R_57();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_143()
/*      */   {
/* 3660 */     Token xsp = this.jj_scanpos;
/* 3661 */     if (jj_3R_155()) {
/* 3662 */       this.jj_scanpos = xsp;
/* 3663 */       if (jj_3R_156()) {
/* 3664 */         this.jj_scanpos = xsp;
/* 3665 */         if (jj_3R_157()) {
/* 3666 */           this.jj_scanpos = xsp;
/* 3667 */           if (jj_3R_158()) return true;
/*      */         }
/*      */       }
/*      */     }
/* 3671 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_113()
/*      */   {
/* 3676 */     Token xsp = this.jj_scanpos;
/* 3677 */     if (jj_3R_126()) {
/* 3678 */       this.jj_scanpos = xsp;
/* 3679 */       if (jj_3R_127()) return true;
/*      */     }
/* 3681 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_126() {
/* 3685 */     return jj_3R_143();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_33()
/*      */   {
/* 3690 */     return jj_3R_59();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_14()
/*      */   {
/* 3696 */     Token xsp = this.jj_scanpos;
/* 3697 */     if (jj_3R_31()) {
/* 3698 */       this.jj_scanpos = xsp;
/* 3699 */       if (jj_3R_32()) {
/* 3700 */         this.jj_scanpos = xsp;
/* 3701 */         if (jj_3R_33()) {
/* 3702 */           this.jj_scanpos = xsp;
/* 3703 */           if (jj_3R_34()) return true;
/*      */         }
/*      */       }
/*      */     }
/* 3707 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_31() {
/* 3711 */     return jj_3R_57();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_162()
/*      */   {
/* 3716 */     return jj_scan_token(55);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_132()
/*      */   {
/* 3721 */     return jj_3R_72();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_131()
/*      */   {
/* 3726 */     return jj_3R_74();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_130()
/*      */   {
/* 3731 */     if (jj_scan_token(44)) return true;
/* 3732 */     if (jj_3R_116()) return true;
/* 3733 */     return jj_scan_token(45);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_129()
/*      */   {
/* 3738 */     return jj_3R_73();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_114()
/*      */   {
/* 3744 */     Token xsp = this.jj_scanpos;
/* 3745 */     if (jj_3R_128()) {
/* 3746 */       this.jj_scanpos = xsp;
/* 3747 */       if (jj_3R_129()) {
/* 3748 */         this.jj_scanpos = xsp;
/* 3749 */         if (jj_3R_130()) {
/* 3750 */           this.jj_scanpos = xsp;
/* 3751 */           if (jj_3R_131()) {
/* 3752 */             this.jj_scanpos = xsp;
/* 3753 */             if (jj_3R_132()) return true;
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 3758 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_128() {
/* 3762 */     return jj_3R_71();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_159()
/*      */   {
/* 3768 */     Token xsp = this.jj_scanpos;
/* 3769 */     if (jj_scan_token(54)) {
/* 3770 */       this.jj_scanpos = xsp;
/* 3771 */       if (jj_3R_162()) return true;
/*      */     }
/* 3773 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_161() {
/* 3777 */     return jj_scan_token(57);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_144()
/*      */   {
/* 3783 */     Token xsp = this.jj_scanpos;
/* 3784 */     if (jj_3R_159()) this.jj_scanpos = xsp;
/* 3785 */     return jj_3R_114();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_160()
/*      */   {
/* 3790 */     return jj_scan_token(56);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_145()
/*      */   {
/* 3796 */     Token xsp = this.jj_scanpos;
/* 3797 */     if (jj_3R_160()) {
/* 3798 */       this.jj_scanpos = xsp;
/* 3799 */       if (jj_3R_161()) return true;
/*      */     }
/* 3801 */     return jj_3R_144();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_102()
/*      */   {
/* 3806 */     return jj_scan_token(65);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_147()
/*      */   {
/* 3811 */     return jj_scan_token(55);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_136()
/*      */   {
/* 3816 */     if (jj_3R_144()) return true; Token xsp;
/*      */     do
/* 3819 */       xsp = this.jj_scanpos;
/* 3820 */     while (!jj_3R_145()); this.jj_scanpos = xsp;
/*      */ 
/* 3822 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_146() {
/* 3826 */     return jj_scan_token(54);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_137()
/*      */   {
/* 3832 */     Token xsp = this.jj_scanpos;
/* 3833 */     if (jj_3R_146()) {
/* 3834 */       this.jj_scanpos = xsp;
/* 3835 */       if (jj_3R_147()) return true;
/*      */     }
/* 3837 */     return jj_3R_136();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_46()
/*      */   {
/* 3842 */     return jj_3R_72();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_48()
/*      */   {
/* 3847 */     return jj_3R_74();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_116()
/*      */   {
/* 3852 */     if (jj_3R_136()) return true; Token xsp;
/*      */     do
/* 3855 */       xsp = this.jj_scanpos;
/* 3856 */     while (!jj_3R_137()); this.jj_scanpos = xsp;
/*      */ 
/* 3858 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_210() {
/* 3862 */     return jj_3R_116();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_206()
/*      */   {
/* 3867 */     return jj_3R_210();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_63()
/*      */   {
/* 3873 */     Token xsp = this.jj_scanpos;
/* 3874 */     if (jj_3R_101()) {
/* 3875 */       this.jj_scanpos = xsp;
/* 3876 */       if (jj_3R_102()) return true;
/*      */     }
/* 3878 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_101() {
/* 3882 */     return jj_scan_token(66);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_47()
/*      */   {
/* 3887 */     return jj_3R_73();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_59()
/*      */   {
/* 3892 */     return jj_scan_token(58);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_45()
/*      */   {
/* 3897 */     return jj_3R_71();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_22()
/*      */   {
/* 3903 */     Token xsp = this.jj_scanpos;
/* 3904 */     if (jj_3R_45()) {
/* 3905 */       this.jj_scanpos = xsp;
/* 3906 */       if (jj_3R_46()) {
/* 3907 */         this.jj_scanpos = xsp;
/* 3908 */         if (jj_3R_47()) {
/* 3909 */           this.jj_scanpos = xsp;
/* 3910 */           if (jj_3R_48()) return true;
/*      */         }
/*      */       }
/*      */     }
/* 3914 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_205() {
/* 3918 */     return jj_scan_token(53);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_204()
/*      */   {
/* 3923 */     return jj_scan_token(51);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_96()
/*      */   {
/* 3928 */     return jj_3R_115();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_110()
/*      */   {
/* 3933 */     return jj_scan_token(63);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_203()
/*      */   {
/* 3938 */     return jj_scan_token(49);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_202()
/*      */   {
/* 3943 */     return jj_scan_token(52);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_201()
/*      */   {
/* 3948 */     return jj_scan_token(48);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_200()
/*      */   {
/* 3953 */     return jj_scan_token(50);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3_10()
/*      */   {
/* 3958 */     if (jj_3R_22()) return true;
/*      */ 
/* 3960 */     Token xsp = this.jj_scanpos;
/* 3961 */     if (jj_scan_token(50)) {
/* 3962 */       this.jj_scanpos = xsp;
/* 3963 */       if (jj_scan_token(48)) {
/* 3964 */         this.jj_scanpos = xsp;
/* 3965 */         if (jj_scan_token(52)) {
/* 3966 */           this.jj_scanpos = xsp;
/* 3967 */           if (jj_scan_token(49)) {
/* 3968 */             this.jj_scanpos = xsp;
/* 3969 */             if (jj_scan_token(51)) {
/* 3970 */               this.jj_scanpos = xsp;
/* 3971 */               if (jj_scan_token(53)) return true;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 3977 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_73()
/*      */   {
/* 3982 */     Token xsp = this.jj_scanpos;
/* 3983 */     if (jj_3R_109()) {
/* 3984 */       this.jj_scanpos = xsp;
/* 3985 */       if (jj_3R_110()) return true;
/*      */     }
/* 3987 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_109() {
/* 3991 */     return jj_scan_token(59);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_67()
/*      */   {
/* 3996 */     return jj_scan_token(79);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_198()
/*      */   {
/* 4001 */     return jj_scan_token(53);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_197()
/*      */   {
/* 4006 */     return jj_scan_token(50);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3_9()
/*      */   {
/* 4011 */     if (jj_3R_21()) return true;
/*      */ 
/* 4013 */     Token xsp = this.jj_scanpos;
/* 4014 */     if (jj_scan_token(50)) {
/* 4015 */       this.jj_scanpos = xsp;
/* 4016 */       if (jj_scan_token(53)) return true;
/*      */     }
/* 4018 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_95() {
/* 4022 */     if (jj_3R_22()) return true;
/*      */ 
/* 4024 */     Token xsp = this.jj_scanpos;
/* 4025 */     if (jj_3R_200()) {
/* 4026 */       this.jj_scanpos = xsp;
/* 4027 */       if (jj_3R_201()) {
/* 4028 */         this.jj_scanpos = xsp;
/* 4029 */         if (jj_3R_202()) {
/* 4030 */           this.jj_scanpos = xsp;
/* 4031 */           if (jj_3R_203()) {
/* 4032 */             this.jj_scanpos = xsp;
/* 4033 */             if (jj_3R_204()) {
/* 4034 */               this.jj_scanpos = xsp;
/* 4035 */               if (jj_3R_205()) return true;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 4041 */     return jj_3R_206();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_70()
/*      */   {
/* 4046 */     return jj_scan_token(78);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_195()
/*      */   {
/* 4051 */     return jj_scan_token(53);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_94()
/*      */   {
/* 4056 */     if (jj_3R_21()) return true;
/*      */ 
/* 4058 */     Token xsp = this.jj_scanpos;
/* 4059 */     if (jj_3R_197()) {
/* 4060 */       this.jj_scanpos = xsp;
/* 4061 */       if (jj_3R_198()) return true;
/*      */     }
/* 4063 */     return jj_3R_199();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_194()
/*      */   {
/* 4068 */     return jj_scan_token(51);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_62()
/*      */   {
/* 4073 */     return jj_scan_token(77);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_193()
/*      */   {
/* 4078 */     return jj_scan_token(49);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_192()
/*      */   {
/* 4083 */     return jj_scan_token(52);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_191()
/*      */   {
/* 4088 */     return jj_scan_token(48);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_190()
/*      */   {
/* 4093 */     return jj_scan_token(50);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3_8()
/*      */   {
/* 4098 */     if (jj_3R_20()) return true;
/*      */ 
/* 4100 */     Token xsp = this.jj_scanpos;
/* 4101 */     if (jj_scan_token(50)) {
/* 4102 */       this.jj_scanpos = xsp;
/* 4103 */       if (jj_scan_token(48)) {
/* 4104 */         this.jj_scanpos = xsp;
/* 4105 */         if (jj_scan_token(52)) {
/* 4106 */           this.jj_scanpos = xsp;
/* 4107 */           if (jj_scan_token(49)) {
/* 4108 */             this.jj_scanpos = xsp;
/* 4109 */             if (jj_scan_token(51)) {
/* 4110 */               this.jj_scanpos = xsp;
/* 4111 */               if (jj_scan_token(53)) return true;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 4117 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_65() {
/* 4121 */     return jj_scan_token(76);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_188()
/*      */   {
/* 4126 */     return jj_scan_token(53);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_187()
/*      */   {
/* 4131 */     return jj_scan_token(51);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_93()
/*      */   {
/* 4136 */     if (jj_3R_20()) return true;
/*      */ 
/* 4138 */     Token xsp = this.jj_scanpos;
/* 4139 */     if (jj_3R_190()) {
/* 4140 */       this.jj_scanpos = xsp;
/* 4141 */       if (jj_3R_191()) {
/* 4142 */         this.jj_scanpos = xsp;
/* 4143 */         if (jj_3R_192()) {
/* 4144 */           this.jj_scanpos = xsp;
/* 4145 */           if (jj_3R_193()) {
/* 4146 */             this.jj_scanpos = xsp;
/* 4147 */             if (jj_3R_194()) {
/* 4148 */               this.jj_scanpos = xsp;
/* 4149 */               if (jj_3R_195()) return true;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 4155 */     return jj_3R_196();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_60()
/*      */   {
/* 4160 */     return jj_scan_token(75);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_186()
/*      */   {
/* 4165 */     return jj_scan_token(49);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_185()
/*      */   {
/* 4170 */     return jj_scan_token(52);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_184()
/*      */   {
/* 4175 */     return jj_scan_token(48);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_183()
/*      */   {
/* 4180 */     return jj_scan_token(50);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3_7()
/*      */   {
/* 4185 */     if (jj_3R_19()) return true;
/*      */ 
/* 4187 */     Token xsp = this.jj_scanpos;
/* 4188 */     if (jj_scan_token(50)) {
/* 4189 */       this.jj_scanpos = xsp;
/* 4190 */       if (jj_scan_token(48)) {
/* 4191 */         this.jj_scanpos = xsp;
/* 4192 */         if (jj_scan_token(52)) {
/* 4193 */           this.jj_scanpos = xsp;
/* 4194 */           if (jj_scan_token(49)) {
/* 4195 */             this.jj_scanpos = xsp;
/* 4196 */             if (jj_scan_token(51)) {
/* 4197 */               this.jj_scanpos = xsp;
/* 4198 */               if (jj_scan_token(53)) return true;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 4204 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_74() {
/* 4208 */     return jj_scan_token(74);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_208()
/*      */   {
/* 4213 */     return jj_scan_token(53);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_207()
/*      */   {
/* 4218 */     return jj_scan_token(50);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_92()
/*      */   {
/* 4223 */     if (jj_3R_19()) return true;
/*      */ 
/* 4225 */     Token xsp = this.jj_scanpos;
/* 4226 */     if (jj_3R_183()) {
/* 4227 */       this.jj_scanpos = xsp;
/* 4228 */       if (jj_3R_184()) {
/* 4229 */         this.jj_scanpos = xsp;
/* 4230 */         if (jj_3R_185()) {
/* 4231 */           this.jj_scanpos = xsp;
/* 4232 */           if (jj_3R_186()) {
/* 4233 */             this.jj_scanpos = xsp;
/* 4234 */             if (jj_3R_187()) {
/* 4235 */               this.jj_scanpos = xsp;
/* 4236 */               if (jj_3R_188()) return true;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 4242 */     return jj_3R_189();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_66()
/*      */   {
/* 4247 */     return jj_scan_token(88);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_182()
/*      */   {
/* 4253 */     Token xsp = this.jj_scanpos;
/* 4254 */     if (jj_3R_207()) {
/* 4255 */       this.jj_scanpos = xsp;
/* 4256 */       if (jj_3R_208()) return true;
/*      */     }
/* 4258 */     return jj_3R_209();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3_6()
/*      */   {
/* 4263 */     if (jj_3R_18()) return true;
/*      */ 
/* 4265 */     Token xsp = this.jj_scanpos;
/* 4266 */     if (jj_scan_token(50)) {
/* 4267 */       this.jj_scanpos = xsp;
/* 4268 */       if (jj_scan_token(53)) return true;
/*      */     }
/* 4270 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_68() {
/* 4274 */     return jj_scan_token(87);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_181()
/*      */   {
/* 4279 */     return jj_scan_token(53);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_91()
/*      */   {
/* 4284 */     if (jj_3R_18()) return true;
/*      */ 
/* 4286 */     Token xsp = this.jj_scanpos;
/* 4287 */     if (jj_3R_182()) this.jj_scanpos = xsp;
/* 4288 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_180() {
/* 4292 */     return jj_scan_token(51);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_179()
/*      */   {
/* 4297 */     return jj_scan_token(49);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_61()
/*      */   {
/* 4302 */     return jj_scan_token(86);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_178()
/*      */   {
/* 4307 */     return jj_scan_token(52);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_169()
/*      */   {
/* 4312 */     return jj_3R_74();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_163()
/*      */   {
/* 4317 */     return jj_scan_token(24);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_177()
/*      */   {
/* 4322 */     return jj_scan_token(48);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_176()
/*      */   {
/* 4327 */     return jj_scan_token(50);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3_5()
/*      */   {
/* 4332 */     if (jj_3R_14()) return true;
/*      */ 
/* 4334 */     Token xsp = this.jj_scanpos;
/* 4335 */     if (jj_scan_token(50)) {
/* 4336 */       this.jj_scanpos = xsp;
/* 4337 */       if (jj_scan_token(48)) {
/* 4338 */         this.jj_scanpos = xsp;
/* 4339 */         if (jj_scan_token(52)) {
/* 4340 */           this.jj_scanpos = xsp;
/* 4341 */           if (jj_scan_token(49)) {
/* 4342 */             this.jj_scanpos = xsp;
/* 4343 */             if (jj_scan_token(51)) {
/* 4344 */               this.jj_scanpos = xsp;
/* 4345 */               if (jj_scan_token(53)) return true;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 4351 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_64() {
/* 4355 */     return jj_scan_token(85);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_56()
/*      */   {
/* 4361 */     Token xsp = this.jj_scanpos;
/* 4362 */     if (jj_3R_90()) {
/* 4363 */       this.jj_scanpos = xsp;
/* 4364 */       if (jj_3R_91()) {
/* 4365 */         this.jj_scanpos = xsp;
/* 4366 */         if (jj_3R_92()) {
/* 4367 */           this.jj_scanpos = xsp;
/* 4368 */           if (jj_3R_93()) {
/* 4369 */             this.jj_scanpos = xsp;
/* 4370 */             if (jj_3R_94()) {
/* 4371 */               this.jj_scanpos = xsp;
/* 4372 */               if (jj_3R_95()) {
/* 4373 */                 this.jj_scanpos = xsp;
/* 4374 */                 if (jj_3R_96()) return true;
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 4381 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_90() {
/* 4385 */     if (jj_3R_14()) return true;
/*      */ 
/* 4387 */     Token xsp = this.jj_scanpos;
/* 4388 */     if (jj_3R_176()) {
/* 4389 */       this.jj_scanpos = xsp;
/* 4390 */       if (jj_3R_177()) {
/* 4391 */         this.jj_scanpos = xsp;
/* 4392 */         if (jj_3R_178()) {
/* 4393 */           this.jj_scanpos = xsp;
/* 4394 */           if (jj_3R_179()) {
/* 4395 */             this.jj_scanpos = xsp;
/* 4396 */             if (jj_3R_180()) {
/* 4397 */               this.jj_scanpos = xsp;
/* 4398 */               if (jj_3R_181()) return true;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 4404 */     return jj_3R_113();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_57()
/*      */   {
/* 4409 */     return jj_scan_token(84);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_86()
/*      */   {
/* 4414 */     return jj_3R_70();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_165()
/*      */   {
/* 4419 */     return jj_scan_token(24);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_85()
/*      */   {
/* 4424 */     return jj_3R_69();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_168()
/*      */   {
/* 4429 */     return jj_3R_59();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_71()
/*      */   {
/* 4434 */     return jj_scan_token(83);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_84()
/*      */   {
/* 4439 */     return jj_3R_68();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_53()
/*      */   {
/* 4445 */     Token xsp = this.jj_scanpos;
/* 4446 */     if (jj_3R_84()) {
/* 4447 */       this.jj_scanpos = xsp;
/* 4448 */       if (jj_3R_85()) {
/* 4449 */         this.jj_scanpos = xsp;
/* 4450 */         if (jj_3R_86()) return true;
/*      */       }
/*      */     }
/* 4453 */     xsp = this.jj_scanpos;
/* 4454 */     if (jj_3R_165()) this.jj_scanpos = xsp;
/* 4455 */     if (jj_scan_token(34)) return true;
/* 4456 */     xsp = this.jj_scanpos;
/* 4457 */     if (jj_scan_token(27)) this.jj_scanpos = xsp;
/* 4458 */     return jj_3R_77();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_173()
/*      */   {
/* 4463 */     if (jj_scan_token(46)) return true;
/* 4464 */     return jj_3R_114();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_125()
/*      */   {
/* 4469 */     return jj_3R_66();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_124()
/*      */   {
/* 4474 */     return jj_3R_68();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_175()
/*      */   {
/* 4479 */     if (jj_scan_token(46)) return true;
/* 4480 */     return jj_3R_19();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_167()
/*      */   {
/* 4485 */     if (jj_scan_token(17)) return true;
/*      */ 
/* 4487 */     Token xsp = this.jj_scanpos;
/* 4488 */     if (jj_3R_168()) {
/* 4489 */       this.jj_scanpos = xsp;
/* 4490 */       if (jj_3R_169()) return true;
/*      */     }
/* 4492 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_123() {
/* 4496 */     return jj_3R_61();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_164()
/*      */   {
/* 4501 */     return jj_scan_token(24);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_51()
/*      */   {
/* 4506 */     if (jj_3R_77()) return true;
/* 4507 */     if (jj_scan_token(20)) return true;
/*      */ 
/* 4509 */     Token xsp = this.jj_scanpos;
/* 4510 */     if (jj_3R_163()) this.jj_scanpos = xsp;
/* 4511 */     return jj_scan_token(16);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_122()
/*      */   {
/* 4516 */     return jj_3R_64();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_121()
/*      */   {
/* 4521 */     return jj_3R_57();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_171()
/*      */   {
/* 4526 */     if (jj_scan_token(46)) return true;
/* 4527 */     return jj_3R_113();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_112()
/*      */   {
/* 4533 */     Token xsp = this.jj_scanpos;
/* 4534 */     if (jj_3R_120()) {
/* 4535 */       this.jj_scanpos = xsp;
/* 4536 */       if (jj_3R_121()) {
/* 4537 */         this.jj_scanpos = xsp;
/* 4538 */         if (jj_3R_122()) {
/* 4539 */           this.jj_scanpos = xsp;
/* 4540 */           if (jj_3R_123()) {
/* 4541 */             this.jj_scanpos = xsp;
/* 4542 */             if (jj_3R_124()) {
/* 4543 */               this.jj_scanpos = xsp;
/* 4544 */               if (jj_3R_125()) return true;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 4550 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_120() {
/* 4554 */     return jj_3R_71();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_83()
/*      */   {
/* 4559 */     return jj_3R_62();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_82()
/*      */   {
/* 4564 */     return jj_3R_65();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_81()
/*      */   {
/* 4569 */     return jj_3R_60();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_166()
/*      */   {
/* 4574 */     return jj_scan_token(24);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_80()
/*      */   {
/* 4579 */     return jj_3R_70();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_79()
/*      */   {
/* 4584 */     return jj_3R_74();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_78()
/*      */   {
/* 4589 */     return jj_3R_112();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_172()
/*      */   {
/* 4594 */     return jj_scan_token(24);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_17()
/*      */   {
/* 4599 */     return jj_3R_19();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_174()
/*      */   {
/* 4604 */     return jj_scan_token(24);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_52()
/*      */   {
/* 4610 */     Token xsp = this.jj_scanpos;
/* 4611 */     if (jj_3R_78()) {
/* 4612 */       this.jj_scanpos = xsp;
/* 4613 */       if (jj_3R_79()) {
/* 4614 */         this.jj_scanpos = xsp;
/* 4615 */         if (jj_3R_80()) {
/* 4616 */           this.jj_scanpos = xsp;
/* 4617 */           if (jj_3R_81()) {
/* 4618 */             this.jj_scanpos = xsp;
/* 4619 */             if (jj_3R_82()) {
/* 4620 */               this.jj_scanpos = xsp;
/* 4621 */               if (jj_3R_83()) return true;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 4627 */     if (jj_scan_token(20)) return true;
/* 4628 */     xsp = this.jj_scanpos;
/* 4629 */     if (jj_3R_164()) this.jj_scanpos = xsp;
/* 4630 */     return jj_scan_token(25);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_170()
/*      */   {
/* 4635 */     return jj_scan_token(24);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_54()
/*      */   {
/* 4640 */     if (jj_3R_14()) return true;
/*      */ 
/* 4642 */     Token xsp = this.jj_scanpos;
/* 4643 */     if (jj_3R_166()) this.jj_scanpos = xsp;
/* 4644 */     if (jj_scan_token(22)) return true;
/* 4645 */     if (jj_3R_113()) return true;
/* 4646 */     xsp = this.jj_scanpos;
/* 4647 */     if (jj_3R_167()) this.jj_scanpos = xsp;
/* 4648 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_211() {
/* 4652 */     return jj_scan_token(24);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_213()
/*      */   {
/* 4657 */     return jj_scan_token(24);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_212()
/*      */   {
/* 4662 */     return jj_scan_token(24);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_89()
/*      */   {
/* 4667 */     if (jj_3R_19()) return true;
/*      */ 
/* 4669 */     Token xsp = this.jj_scanpos;
/* 4670 */     if (jj_3R_174()) this.jj_scanpos = xsp;
/* 4671 */     if (jj_scan_token(19)) return true;
/* 4672 */     if (jj_scan_token(44)) return true;
/* 4673 */     if (jj_3R_19()) return true;
/*      */     do
/* 4675 */       xsp = this.jj_scanpos;
/* 4676 */     while (!jj_3R_175()); this.jj_scanpos = xsp;
/*      */ 
/* 4678 */     return jj_scan_token(45);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_16()
/*      */   {
/* 4683 */     return jj_3R_22();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_88()
/*      */   {
/* 4688 */     if (jj_3R_114()) return true;
/*      */ 
/* 4690 */     Token xsp = this.jj_scanpos;
/* 4691 */     if (jj_3R_172()) this.jj_scanpos = xsp;
/* 4692 */     if (jj_scan_token(19)) return true;
/* 4693 */     if (jj_scan_token(44)) return true;
/* 4694 */     if (jj_3R_114()) return true;
/*      */     do
/* 4696 */       xsp = this.jj_scanpos;
/* 4697 */     while (!jj_3R_173()); this.jj_scanpos = xsp;
/*      */ 
/* 4699 */     return jj_scan_token(45);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_154()
/*      */   {
/* 4704 */     return jj_3R_21();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_55()
/*      */   {
/* 4710 */     Token xsp = this.jj_scanpos;
/* 4711 */     if (jj_3R_87()) {
/* 4712 */       this.jj_scanpos = xsp;
/* 4713 */       if (jj_3R_88()) {
/* 4714 */         this.jj_scanpos = xsp;
/* 4715 */         if (jj_3R_89()) return true;
/*      */       }
/*      */     }
/* 4718 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_87() {
/* 4722 */     if (jj_3R_113()) return true;
/*      */ 
/* 4724 */     Token xsp = this.jj_scanpos;
/* 4725 */     if (jj_3R_170()) this.jj_scanpos = xsp;
/* 4726 */     if (jj_scan_token(19)) return true;
/* 4727 */     if (jj_scan_token(44)) return true;
/* 4728 */     if (jj_3R_113()) return true;
/*      */     do
/* 4730 */       xsp = this.jj_scanpos;
/* 4731 */     while (!jj_3R_171()); this.jj_scanpos = xsp;
/*      */ 
/* 4733 */     return jj_scan_token(45);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_152()
/*      */   {
/* 4738 */     return jj_scan_token(15);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_69()
/*      */   {
/* 4743 */     return jj_scan_token(69);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_135()
/*      */   {
/* 4748 */     if (jj_3R_14()) return true;
/*      */ 
/* 4750 */     Token xsp = this.jj_scanpos;
/* 4751 */     if (jj_3R_213()) this.jj_scanpos = xsp;
/* 4752 */     if (jj_scan_token(8)) return true;
/* 4753 */     if (jj_3R_14()) return true;
/* 4754 */     if (jj_scan_token(6)) return true;
/* 4755 */     return jj_3R_14();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_134()
/*      */   {
/* 4760 */     if (jj_3R_19()) return true;
/*      */ 
/* 4762 */     Token xsp = this.jj_scanpos;
/* 4763 */     if (jj_3R_212()) this.jj_scanpos = xsp;
/* 4764 */     if (jj_scan_token(8)) return true;
/* 4765 */     if (jj_3R_19()) return true;
/* 4766 */     if (jj_scan_token(6)) return true;
/* 4767 */     return jj_3R_19();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_15()
/*      */   {
/* 4772 */     return jj_3R_14();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_151()
/*      */   {
/* 4777 */     return jj_scan_token(15);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3_4()
/*      */   {
/* 4783 */     Token xsp = this.jj_scanpos;
/* 4784 */     if (jj_3R_15()) {
/* 4785 */       this.jj_scanpos = xsp;
/* 4786 */       if (jj_3R_16()) {
/* 4787 */         this.jj_scanpos = xsp;
/* 4788 */         if (jj_3R_17()) return true;
/*      */       }
/*      */     }
/* 4791 */     xsp = this.jj_scanpos;
/* 4792 */     if (jj_scan_token(24)) this.jj_scanpos = xsp;
/* 4793 */     return jj_scan_token(19);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_115()
/*      */   {
/* 4799 */     Token xsp = this.jj_scanpos;
/* 4800 */     if (jj_3R_133()) {
/* 4801 */       this.jj_scanpos = xsp;
/* 4802 */       if (jj_3R_134()) {
/* 4803 */         this.jj_scanpos = xsp;
/* 4804 */         if (jj_3R_135()) return true;
/*      */       }
/*      */     }
/* 4807 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_133() {
/* 4811 */     if (jj_3R_116()) return true;
/*      */ 
/* 4813 */     Token xsp = this.jj_scanpos;
/* 4814 */     if (jj_3R_211()) this.jj_scanpos = xsp;
/* 4815 */     if (jj_scan_token(8)) return true;
/* 4816 */     if (jj_3R_116()) return true;
/* 4817 */     if (jj_scan_token(6)) return true;
/* 4818 */     return jj_3R_116();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3_3()
/*      */   {
/* 4823 */     if (jj_3R_14()) return true;
/*      */ 
/* 4825 */     Token xsp = this.jj_scanpos;
/* 4826 */     if (jj_scan_token(24)) this.jj_scanpos = xsp;
/* 4827 */     return jj_scan_token(22);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_150()
/*      */   {
/* 4832 */     return jj_scan_token(15);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_77()
/*      */   {
/* 4837 */     return jj_scan_token(90);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_153()
/*      */   {
/* 4842 */     return jj_3R_112();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_30()
/*      */   {
/* 4847 */     return jj_3R_56();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_149()
/*      */   {
/* 4852 */     return jj_scan_token(15);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_29()
/*      */   {
/* 4857 */     return jj_3R_55();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_148()
/*      */   {
/* 4862 */     return jj_scan_token(15);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_28()
/*      */   {
/* 4867 */     return jj_3R_54();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_27()
/*      */   {
/* 4872 */     return jj_3R_53();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_142()
/*      */   {
/* 4877 */     if (jj_scan_token(10)) return true;
/* 4878 */     if (jj_scan_token(44)) return true;
/*      */ 
/* 4880 */     Token xsp = this.jj_scanpos;
/* 4881 */     if (jj_3R_152()) this.jj_scanpos = xsp;
/* 4882 */     xsp = this.jj_scanpos;
/* 4883 */     if (jj_3R_153()) {
/* 4884 */       this.jj_scanpos = xsp;
/* 4885 */       if (jj_3R_154()) return true;
/*      */     }
/* 4887 */     return jj_scan_token(45);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_26()
/*      */   {
/* 4892 */     return jj_3R_52();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_141()
/*      */   {
/* 4897 */     if (jj_scan_token(14)) return true;
/* 4898 */     if (jj_scan_token(44)) return true;
/*      */ 
/* 4900 */     Token xsp = this.jj_scanpos;
/* 4901 */     if (jj_3R_151()) this.jj_scanpos = xsp;
/* 4902 */     if (jj_3R_112()) return true;
/* 4903 */     return jj_scan_token(45);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_13()
/*      */   {
/* 4909 */     Token xsp = this.jj_scanpos;
/* 4910 */     if (jj_3R_25()) {
/* 4911 */       this.jj_scanpos = xsp;
/* 4912 */       this.lookingAhead = true;
/* 4913 */       this.jj_semLA = (getToken(2).kind == 20);
/* 4914 */       this.lookingAhead = false;
/* 4915 */       if ((!this.jj_semLA) || (jj_3R_26())) {
/* 4916 */         this.jj_scanpos = xsp;
/* 4917 */         this.lookingAhead = true;
/* 4918 */         this.jj_semLA = ((getToken(2).kind == 34) || (getToken(3).kind == 34));
/* 4919 */         this.lookingAhead = false;
/* 4920 */         if ((!this.jj_semLA) || (jj_3R_27())) {
/* 4921 */           this.jj_scanpos = xsp;
/* 4922 */           if (jj_3R_28()) {
/* 4923 */             this.jj_scanpos = xsp;
/* 4924 */             if (jj_3R_29()) {
/* 4925 */               this.jj_scanpos = xsp;
/* 4926 */               if (jj_3R_30()) return true;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 4932 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_25() {
/* 4936 */     return jj_3R_51();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_140()
/*      */   {
/* 4941 */     if (jj_scan_token(12)) return true;
/* 4942 */     if (jj_scan_token(44)) return true;
/*      */ 
/* 4944 */     Token xsp = this.jj_scanpos;
/* 4945 */     if (jj_3R_150()) this.jj_scanpos = xsp;
/* 4946 */     if (jj_3R_112()) return true;
/* 4947 */     return jj_scan_token(45);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_139()
/*      */   {
/* 4952 */     if (jj_scan_token(11)) return true;
/* 4953 */     if (jj_scan_token(44)) return true;
/*      */ 
/* 4955 */     Token xsp = this.jj_scanpos;
/* 4956 */     if (jj_3R_149()) this.jj_scanpos = xsp;
/* 4957 */     if (jj_3R_112()) return true;
/* 4958 */     return jj_scan_token(45);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3_1()
/*      */   {
/* 4963 */     if (jj_scan_token(44)) return true;
/* 4964 */     if (jj_3R_12()) return true;
/* 4965 */     return jj_scan_token(45);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_118()
/*      */   {
/* 4971 */     Token xsp = this.jj_scanpos;
/* 4972 */     if (jj_3R_138()) {
/* 4973 */       this.jj_scanpos = xsp;
/* 4974 */       if (jj_3R_139()) {
/* 4975 */         this.jj_scanpos = xsp;
/* 4976 */         if (jj_3R_140()) {
/* 4977 */           this.jj_scanpos = xsp;
/* 4978 */           if (jj_3R_141()) {
/* 4979 */             this.jj_scanpos = xsp;
/* 4980 */             if (jj_3R_142()) return true;
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 4985 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_138() {
/* 4989 */     if (jj_scan_token(13)) return true;
/* 4990 */     if (jj_scan_token(44)) return true;
/*      */ 
/* 4992 */     Token xsp = this.jj_scanpos;
/* 4993 */     if (jj_3R_148()) this.jj_scanpos = xsp;
/* 4994 */     if (jj_3R_112()) return true;
/* 4995 */     return jj_scan_token(45);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_50()
/*      */   {
/* 5000 */     if (jj_scan_token(6)) return true;
/* 5001 */     return jj_3R_49();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3_2()
/*      */   {
/* 5006 */     return jj_3R_13();
/*      */   }
/*      */ 
/*      */   private static void jj_la1_0()
/*      */   {
/* 5029 */     jj_la1_0 = new int[] { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 524288, 128, 128, 32768, -996114912, 268435456, 64, 268435456, 64, 16777216, -1063223776, 0, -1063223776, 16777216, 16777216, 16777216, -1063223776, 16777216, 0, 16777216, 0, 16777216, 0, -1063223776, 16777216, 0, 131072, 0, 16777216, 16777216, 0, 16777216, 134217728, 0, 0, 0, 0, 0, 0, 0, -1063223776, -2136966112, 0, 0, 0, 0, 0, 0, -2136966112, 1073742336, 1073742336, 1073742336, 0, 0, 0, 0, 1073742336, 0, -2136966112, 32768, 32768, 32768, 32768, 32768, 0, 31744, 0, 0, 0, 0 };
/*      */   }
/*      */   private static void jj_la1_1() {
/* 5032 */     jj_la1_1 = new int[] { 2, 256, 192, 16384, 0, 24, 24, 64, 192, 16384, 256, 0, 0, 0, 3104, 0, 0, 0, 0, 0, 3104, 0, -1933566944, 0, 0, 0, -1933566944, 0, 16384, 0, 16384, 0, 16384, -1946149856, 0, 67108864, 0, 0, 0, 0, 0, 0, 0, 4128768, 2359296, 2359296, 4128768, 4128768, 2359296, 4128768, -1933566944, -2013263872, 12582912, 12582912, 50331648, 50331648, 12582912, 12582912, -2013259776, 67109920, 67114016, 67114016, 0, 0, 0, 0, 1056, 16384, 2048, 0, 0, 0, 0, 0, 0, 0, 256, 0, -2013265920, 0 };
/*      */   }
/*      */   private static void jj_la1_2() {
/* 5035 */     jj_la1_2 = new int[] { 0, 0, 0, 0, 20480000, 0, 0, 0, 0, 0, 16, 0, 0, 0, 33030144, 0, 0, 0, 0, 0, 0, 67108864, 33094694, 0, 0, 0, 3677184, 0, 0, 0, 0, 0, 0, 3677184, 0, 1024, 0, 33061888, 0, 0, 8405024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3677184, 525312, 0, 0, 0, 0, 0, 0, 525312, 1050624, 1050624, 1048576, 2101248, 4202502, 16809984, 8405024, 0, 0, 0, 0, 0, 0, 0, 0, 33046560, 0, 16, 33030144, 0, 6 };
/*      */   }
/*      */ 
/*      */   public JBossQLParser(InputStream stream)
/*      */   {
/* 5042 */     this.jj_input_stream = new JavaCharStream(stream, 1, 1);
/* 5043 */     this.token_source = new JBossQLParserTokenManager(this.jj_input_stream);
/* 5044 */     this.token = new Token();
/* 5045 */     this.jj_ntk = -1;
/* 5046 */     this.jj_gen = 0;
/* 5047 */     for (int i = 0; i < 80; i++) this.jj_la1[i] = -1;
/* 5048 */     for (int i = 0; i < this.jj_2_rtns.length; i++) this.jj_2_rtns[i] = new JJCalls(); 
/*      */   }
/*      */ 
/*      */   public void ReInit(InputStream stream)
/*      */   {
/* 5052 */     this.jj_input_stream.ReInit(stream, 1, 1);
/* 5053 */     this.token_source.ReInit(this.jj_input_stream);
/* 5054 */     this.token = new Token();
/* 5055 */     this.jj_ntk = -1;
/* 5056 */     this.jjtree.reset();
/* 5057 */     this.jj_gen = 0;
/* 5058 */     for (int i = 0; i < 80; i++) this.jj_la1[i] = -1;
/* 5059 */     for (int i = 0; i < this.jj_2_rtns.length; i++) this.jj_2_rtns[i] = new JJCalls(); 
/*      */   }
/*      */ 
/*      */   public JBossQLParser(Reader stream)
/*      */   {
/* 5063 */     this.jj_input_stream = new JavaCharStream(stream, 1, 1);
/* 5064 */     this.token_source = new JBossQLParserTokenManager(this.jj_input_stream);
/* 5065 */     this.token = new Token();
/* 5066 */     this.jj_ntk = -1;
/* 5067 */     this.jj_gen = 0;
/* 5068 */     for (int i = 0; i < 80; i++) this.jj_la1[i] = -1;
/* 5069 */     for (int i = 0; i < this.jj_2_rtns.length; i++) this.jj_2_rtns[i] = new JJCalls(); 
/*      */   }
/*      */ 
/*      */   public void ReInit(Reader stream)
/*      */   {
/* 5073 */     this.jj_input_stream.ReInit(stream, 1, 1);
/* 5074 */     this.token_source.ReInit(this.jj_input_stream);
/* 5075 */     this.token = new Token();
/* 5076 */     this.jj_ntk = -1;
/* 5077 */     this.jjtree.reset();
/* 5078 */     this.jj_gen = 0;
/* 5079 */     for (int i = 0; i < 80; i++) this.jj_la1[i] = -1;
/* 5080 */     for (int i = 0; i < this.jj_2_rtns.length; i++) this.jj_2_rtns[i] = new JJCalls(); 
/*      */   }
/*      */ 
/*      */   public JBossQLParser(JBossQLParserTokenManager tm)
/*      */   {
/* 5084 */     this.token_source = tm;
/* 5085 */     this.token = new Token();
/* 5086 */     this.jj_ntk = -1;
/* 5087 */     this.jj_gen = 0;
/* 5088 */     for (int i = 0; i < 80; i++) this.jj_la1[i] = -1;
/* 5089 */     for (int i = 0; i < this.jj_2_rtns.length; i++) this.jj_2_rtns[i] = new JJCalls(); 
/*      */   }
/*      */ 
/*      */   public void ReInit(JBossQLParserTokenManager tm)
/*      */   {
/* 5093 */     this.token_source = tm;
/* 5094 */     this.token = new Token();
/* 5095 */     this.jj_ntk = -1;
/* 5096 */     this.jjtree.reset();
/* 5097 */     this.jj_gen = 0;
/* 5098 */     for (int i = 0; i < 80; i++) this.jj_la1[i] = -1;
/* 5099 */     for (int i = 0; i < this.jj_2_rtns.length; i++) this.jj_2_rtns[i] = new JJCalls();
/*      */   }
/*      */ 
/*      */   private final Token jj_consume_token(int kind)
/*      */     throws ParseException
/*      */   {
/* 5104 */     Token oldToken;
/* 5104 */     if ((oldToken = this.token).next != null) this.token = this.token.next; else
/* 5105 */       this.token = (this.token.next = this.token_source.getNextToken());
/* 5106 */     this.jj_ntk = -1;
/* 5107 */     if (this.token.kind == kind) {
/* 5108 */       this.jj_gen += 1;
/* 5109 */       if (++this.jj_gc > 100) {
/* 5110 */         this.jj_gc = 0;
/* 5111 */         for (int i = 0; i < this.jj_2_rtns.length; i++) {
/* 5112 */           JJCalls c = this.jj_2_rtns[i];
/* 5113 */           while (c != null) {
/* 5114 */             if (c.gen < this.jj_gen) c.first = null;
/* 5115 */             c = c.next;
/*      */           }
/*      */         }
/*      */       }
/* 5119 */       return this.token;
/*      */     }
/* 5121 */     this.token = oldToken;
/* 5122 */     this.jj_kind = kind;
/* 5123 */     throw generateParseException();
/*      */   }
/*      */ 
/*      */   private final boolean jj_scan_token(int kind)
/*      */   {
/* 5129 */     if (this.jj_scanpos == this.jj_lastpos) {
/* 5130 */       this.jj_la -= 1;
/* 5131 */       if (this.jj_scanpos.next == null)
/* 5132 */         this.jj_lastpos = (this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken());
/*      */       else
/* 5134 */         this.jj_lastpos = (this.jj_scanpos = this.jj_scanpos.next);
/*      */     }
/*      */     else {
/* 5137 */       this.jj_scanpos = this.jj_scanpos.next;
/*      */     }
/* 5139 */     if (this.jj_rescan) {
/* 5140 */       int i = 0; Token tok = this.token;
/* 5141 */       for (; (tok != null) && (tok != this.jj_scanpos); tok = tok.next) i++;
/* 5142 */       if (tok != null) jj_add_error_token(kind, i);
/*      */     }
/* 5144 */     if (this.jj_scanpos.kind != kind) return true;
/* 5145 */     if ((this.jj_la == 0) && (this.jj_scanpos == this.jj_lastpos)) throw this.jj_ls;
/* 5146 */     return false;
/*      */   }
/*      */ 
/*      */   public final Token getNextToken() {
/* 5150 */     if (this.token.next != null) this.token = this.token.next; else
/* 5151 */       this.token = (this.token.next = this.token_source.getNextToken());
/* 5152 */     this.jj_ntk = -1;
/* 5153 */     this.jj_gen += 1;
/* 5154 */     return this.token;
/*      */   }
/*      */ 
/*      */   public final Token getToken(int index) {
/* 5158 */     Token t = this.lookingAhead ? this.jj_scanpos : this.token;
/* 5159 */     for (int i = 0; i < index; i++) {
/* 5160 */       if (t.next != null) t = t.next; else
/* 5161 */         t = t.next = this.token_source.getNextToken();
/*      */     }
/* 5163 */     return t;
/*      */   }
/*      */ 
/*      */   private final int jj_ntk() {
/* 5167 */     if ((this.jj_nt = this.token.next) == null) {
/* 5168 */       return this.jj_ntk = (this.token.next = this.token_source.getNextToken()).kind;
/*      */     }
/* 5170 */     return this.jj_ntk = this.jj_nt.kind;
/*      */   }
/*      */ 
/*      */   private void jj_add_error_token(int kind, int pos)
/*      */   {
/* 5180 */     if (pos >= 100) return;
/* 5181 */     if (pos == this.jj_endpos + 1) {
/* 5182 */       this.jj_lasttokens[(this.jj_endpos++)] = kind;
/* 5183 */     } else if (this.jj_endpos != 0) {
/* 5184 */       this.jj_expentry = new int[this.jj_endpos];
/* 5185 */       for (int i = 0; i < this.jj_endpos; i++) {
/* 5186 */         this.jj_expentry[i] = this.jj_lasttokens[i];
/*      */       }
/* 5188 */       boolean exists = false;
/* 5189 */       for (Enumeration e = this.jj_expentries.elements(); e.hasMoreElements(); ) {
/* 5190 */         int[] oldentry = (int[])(int[])e.nextElement();
/* 5191 */         if (oldentry.length == this.jj_expentry.length) {
/* 5192 */           exists = true;
/* 5193 */           for (int i = 0; i < this.jj_expentry.length; i++) {
/* 5194 */             if (oldentry[i] != this.jj_expentry[i]) {
/* 5195 */               exists = false;
/* 5196 */               break;
/*      */             }
/*      */           }
/* 5199 */           if (exists) break;
/*      */         }
/*      */       }
/* 5202 */       if (!exists) this.jj_expentries.addElement(this.jj_expentry);
/* 5203 */       if (pos != 0)
/*      */       {
/*      */         int tmp205_204 = pos; this.jj_endpos = tmp205_204; this.jj_lasttokens[(tmp205_204 - 1)] = kind;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public ParseException generateParseException() {
/* 5208 */     this.jj_expentries.removeAllElements();
/* 5209 */     boolean[] la1tokens = new boolean[91];
/* 5210 */     for (int i = 0; i < 91; i++) {
/* 5211 */       la1tokens[i] = false;
/*      */     }
/* 5213 */     if (this.jj_kind >= 0) {
/* 5214 */       la1tokens[this.jj_kind] = true;
/* 5215 */       this.jj_kind = -1;
/*      */     }
/* 5217 */     for (int i = 0; i < 80; i++) {
/* 5218 */       if (this.jj_la1[i] == this.jj_gen) {
/* 5219 */         for (int j = 0; j < 32; j++) {
/* 5220 */           if ((jj_la1_0[i] & 1 << j) != 0) {
/* 5221 */             la1tokens[j] = true;
/*      */           }
/* 5223 */           if ((jj_la1_1[i] & 1 << j) != 0) {
/* 5224 */             la1tokens[(32 + j)] = true;
/*      */           }
/* 5226 */           if ((jj_la1_2[i] & 1 << j) != 0) {
/* 5227 */             la1tokens[(64 + j)] = true;
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 5232 */     for (int i = 0; i < 91; i++) {
/* 5233 */       if (la1tokens[i] != 0) {
/* 5234 */         this.jj_expentry = new int[1];
/* 5235 */         this.jj_expentry[0] = i;
/* 5236 */         this.jj_expentries.addElement(this.jj_expentry);
/*      */       }
/*      */     }
/* 5239 */     this.jj_endpos = 0;
/* 5240 */     jj_rescan_token();
/* 5241 */     jj_add_error_token(0, 0);
/* 5242 */     int[][] exptokseq = new int[this.jj_expentries.size()][];
/* 5243 */     for (int i = 0; i < this.jj_expentries.size(); i++) {
/* 5244 */       exptokseq[i] = ((int[])(int[])this.jj_expentries.elementAt(i));
/*      */     }
/* 5246 */     return new ParseException(this.token, exptokseq, tokenImage);
/*      */   }
/*      */ 
/*      */   public final void enable_tracing() {
/*      */   }
/*      */ 
/*      */   public final void disable_tracing() {
/*      */   }
/*      */ 
/*      */   private final void jj_rescan_token() {
/* 5256 */     this.jj_rescan = true;
/* 5257 */     for (int i = 0; i < 10; i++) {
/* 5258 */       JJCalls p = this.jj_2_rtns[i];
/*      */       do {
/* 5260 */         if (p.gen > this.jj_gen) {
/* 5261 */           this.jj_la = p.arg; this.jj_lastpos = (this.jj_scanpos = p.first);
/* 5262 */           switch (i) { case 0:
/* 5263 */             jj_3_1(); break;
/*      */           case 1:
/* 5264 */             jj_3_2(); break;
/*      */           case 2:
/* 5265 */             jj_3_3(); break;
/*      */           case 3:
/* 5266 */             jj_3_4(); break;
/*      */           case 4:
/* 5267 */             jj_3_5(); break;
/*      */           case 5:
/* 5268 */             jj_3_6(); break;
/*      */           case 6:
/* 5269 */             jj_3_7(); break;
/*      */           case 7:
/* 5270 */             jj_3_8(); break;
/*      */           case 8:
/* 5271 */             jj_3_9(); break;
/*      */           case 9:
/* 5272 */             jj_3_10();
/*      */           }
/*      */         }
/* 5275 */         p = p.next;
/* 5276 */       }while (p != null);
/*      */     }
/* 5278 */     this.jj_rescan = false;
/*      */   }
/*      */ 
/*      */   private final void jj_save(int index, int xla) {
/* 5282 */     JJCalls p = this.jj_2_rtns[index];
/* 5283 */     while (p.gen > this.jj_gen) {
/* 5284 */       if (p.next == null) { p = p.next = new JJCalls(); break; }
/* 5285 */       p = p.next;
/*      */     }
/* 5287 */     p.gen = (this.jj_gen + xla - this.jj_la); p.first = this.token; p.arg = xla;
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/* 5024 */     jj_la1_0();
/* 5025 */     jj_la1_1();
/* 5026 */     jj_la1_2();
/*      */   }
/*      */ 
/*      */   static final class JJCalls
/*      */   {
/*      */     int gen;
/*      */     Token first;
/*      */     int arg;
/*      */     JJCalls next;
/*      */   }
/*      */ 
/*      */   private static final class LookaheadSuccess extends Error
/*      */   {
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.ejbql.JBossQLParser
 * JD-Core Version:    0.6.0
 */