/*      */ package org.jboss.ejb.plugins.cmp.ejbql;
/*      */ 
/*      */ import java.io.CharArrayReader;
/*      */ import java.io.InputStream;
/*      */ import java.io.Reader;
/*      */ import java.util.Enumeration;
/*      */ import java.util.Vector;
/*      */ 
/*      */ public class EJBQLParser
/*      */   implements EJBQLParserTreeConstants, EJBQLParserConstants
/*      */ {
/*   20 */   protected JJTEJBQLParserState jjtree = new JJTEJBQLParserState();
/*      */   private Catalog catalog;
/*      */   private Class[] argumentTypes;
/*      */   private IdentifierManager idManager;
/*      */   private boolean selectDistinct;
/*      */   private String selectPath;
/*      */   public EJBQLParserTokenManager token_source;
/*      */   JavaCharStream jj_input_stream;
/*      */   public Token token;
/*      */   public Token jj_nt;
/*      */   private int jj_ntk;
/*      */   private Token jj_scanpos;
/*      */   private Token jj_lastpos;
/*      */   private int jj_la;
/* 4130 */   public boolean lookingAhead = false;
/*      */   private boolean jj_semLA;
/*      */   private int jj_gen;
/* 4133 */   private final int[] jj_la1 = new int[72];
/*      */   private static int[] jj_la1_0;
/*      */   private static int[] jj_la1_1;
/*      */   private static int[] jj_la1_2;
/* 4151 */   private final JJCalls[] jj_2_rtns = new JJCalls[3];
/* 4152 */   private boolean jj_rescan = false;
/* 4153 */   private int jj_gc = 0;
/*      */ 
/* 4241 */   private final LookaheadSuccess jj_ls = new LookaheadSuccess(null);
/*      */ 
/* 4287 */   private Vector jj_expentries = new Vector();
/*      */   private int[] jj_expentry;
/* 4289 */   private int jj_kind = -1;
/* 4290 */   private int[] jj_lasttokens = new int[100];
/*      */   private int jj_endpos;
/*      */ 
/*      */   public ASTEJBQL parse(Catalog catalog, Class[] argumentTypes, String ejbql)
/*      */     throws ParseException
/*      */   {
/*   29 */     this.catalog = catalog;
/*   30 */     this.token_source.catalog = catalog;
/*   31 */     this.argumentTypes = argumentTypes;
/*   32 */     this.token_source.argumentTypes = argumentTypes;
/*   33 */     this.idManager = new IdentifierManager(catalog);
/*   34 */     this.token_source.idManager = this.idManager;
/*      */ 
/*   36 */     String lowerCase = ejbql.toLowerCase();
/*   37 */     int fromBeginIndex = indexOf(lowerCase, "from");
/*   38 */     if (fromBeginIndex < 0) {
/*   39 */       throw new ParseException("FROM not found");
/*      */     }
/*      */ 
/*   42 */     int fromEndIndex = indexOf(lowerCase, "where");
/*   43 */     if (fromEndIndex < 0) {
/*   44 */       fromEndIndex = indexOfOrderBy(lowerCase);
/*      */     }
/*   46 */     if (fromEndIndex < 0) {
/*   47 */       fromEndIndex = ejbql.length();
/*      */     }
/*      */ 
/*   51 */     char[] from = ejbql.toCharArray();
/*   52 */     clear(from, 0, fromBeginIndex);
/*   53 */     clear(from, fromEndIndex, from.length);
/*      */ 
/*   56 */     char[] sansFrom = ejbql.toCharArray();
/*   57 */     clear(sansFrom, fromBeginIndex + 4, fromEndIndex);
/*      */ 
/*   60 */     ReInit(new CharArrayReader(from));
/*   61 */     ASTFrom fromNode = ParseFromClause();
/*      */ 
/*   64 */     ReInit(new CharArrayReader(sansFrom));
/*   65 */     ASTEJBQL ejbqlNode = EJBQL();
/*      */ 
/*   69 */     ejbqlNode.jjtAddChild(fromNode, 1);
/*      */ 
/*   71 */     return ejbqlNode;
/*      */   }
/*      */ 
/*      */   private static final int indexOf(String ql, String word)
/*      */   {
/*   80 */     return indexOf(ql, word, 0);
/*      */   }
/*      */ 
/*      */   private static final int indexOf(String ql, String word, int startInd)
/*      */   {
/*   89 */     int i = ql.indexOf(word, startInd);
/*   90 */     if (i < 0)
/*      */     {
/*   92 */       return -1;
/*      */     }
/*      */ 
/*   95 */     int qlLength = ql.length();
/*   96 */     int wordLength = word.length();
/*   97 */     while (i >= 0)
/*      */     {
/*   99 */       int endInd = i + wordLength;
/*  100 */       if (((i == 0) || (Character.isWhitespace(ql.charAt(i - 1)))) && ((endInd == qlLength) || ((endInd < qlLength) && (Character.isWhitespace(ql.charAt(endInd))))))
/*      */       {
/*      */         break;
/*      */       }
/*      */ 
/*  106 */       i = ql.indexOf(word, i + 1);
/*      */     }
/*  108 */     return i;
/*      */   }
/*      */ 
/*      */   private static final int indexOfOrderBy(String ql)
/*      */   {
/*  113 */     int orderInd = indexOf(ql, "order", 0);
/*  114 */     int byInd = -1;
/*  115 */     while (orderInd > 0)
/*      */     {
/*  117 */       if (byInd < orderInd)
/*      */       {
/*  119 */         byInd = indexOf(ql, "by", orderInd + 5);
/*      */       }
/*      */ 
/*  122 */       if (byInd > 0)
/*      */       {
/*  124 */         int i = byInd - 1;
/*  125 */         while ((i >= orderInd + 5) && (Character.isWhitespace(ql.charAt(i--))));
/*  126 */         if (i == orderInd + 4)
/*      */         {
/*      */           break;
/*      */         }
/*      */ 
/*  132 */         orderInd = indexOf(ql, "order", orderInd + 5);
/*      */ 
/*  134 */         continue;
/*      */       }
/*      */ 
/*  137 */       orderInd = -1;
/*      */     }
/*      */ 
/*  140 */     return orderInd;
/*      */   }
/*      */ 
/*      */   private final void clear(char[] c, int beginIndex, int endIndex) {
/*  144 */     for (int i = beginIndex; i < endIndex; i++)
/*  145 */       if ((c[i] != '\r') && (c[i] != '\n') && (c[i] != '\t'))
/*  146 */         c[i] = ' ';
/*      */   }
/*      */ 
/*      */   private final void initPathNode(ASTPath pathNode, String path, int type)
/*      */   {
/*  152 */     pathNode.pathList = this.idManager.getPathList(path);
/*  153 */     pathNode.fieldList = this.idManager.getFieldList(path);
/*  154 */     pathNode.type = type;
/*      */   }
/*      */ 
/*      */   private final void initParameterNode(ASTParameter parameterNode, String number, int type)
/*      */   {
/*  162 */     parameterNode.number = Integer.parseInt(number);
/*  163 */     parameterNode.type = type;
/*      */   }
/*      */ 
/*      */   public final ASTEJBQL EJBQL() throws ParseException
/*      */   {
/*  168 */     ASTEJBQL jjtn000 = new ASTEJBQL(0);
/*  169 */     boolean jjtc000 = true;
/*  170 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/*  172 */       SelectClause();
/*  173 */       FromKeyword();
/*  174 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 28:
/*  176 */         WhereClause();
/*  177 */         break;
/*      */       default:
/*  179 */         this.jj_la1[0] = this.jj_gen;
/*      */       }
/*      */ 
/*  182 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 30:
/*  184 */         OrderByClause();
/*  185 */         break;
/*      */       default:
/*  187 */         this.jj_la1[1] = this.jj_gen;
/*      */       }
/*      */ 
/*  190 */       jj_consume_token(0);
/*  191 */       this.jjtree.closeNodeScope(jjtn000, true);
/*  192 */       jjtc000 = false;
/*  193 */       localASTEJBQL1 = jjtn000;
/*      */     }
/*      */     catch (Throwable jjte000)
/*      */     {
/*      */       ASTEJBQL localASTEJBQL1;
/*  195 */       if (jjtc000) {
/*  196 */         this.jjtree.clearNodeScope(jjtn000);
/*  197 */         jjtc000 = false;
/*      */       } else {
/*  199 */         this.jjtree.popNode();
/*      */       }
/*  201 */       if ((jjte000 instanceof RuntimeException)) {
/*  202 */         throw ((RuntimeException)jjte000);
/*      */       }
/*  204 */       if ((jjte000 instanceof ParseException)) {
/*  205 */         throw ((ParseException)jjte000);
/*      */       }
/*  207 */       throw ((Error)jjte000);
/*      */     } finally {
/*  209 */       if (jjtc000)
/*  210 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final ASTOrderBy OrderByClause()
/*      */     throws ParseException
/*      */   {
/*  218 */     ASTOrderBy jjtn000 = new ASTOrderBy(1);
/*  219 */     boolean jjtc000 = true;
/*  220 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/*  222 */       jj_consume_token(30);
/*  223 */       jj_consume_token(31);
/*  224 */       OrderByPathExpression();
/*      */       while (true)
/*      */       {
/*  227 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */         {
/*      */         case 42:
/*  230 */           break;
/*      */         default:
/*  232 */           this.jj_la1[2] = this.jj_gen;
/*  233 */           break;
/*      */         }
/*  235 */         jj_consume_token(42);
/*  236 */         OrderByPathExpression();
/*      */       }
/*  238 */       this.jjtree.closeNodeScope(jjtn000, true);
/*  239 */       jjtc000 = false;
/*  240 */       localASTOrderBy1 = jjtn000;
/*      */     }
/*      */     catch (Throwable jjte000)
/*      */     {
/*      */       ASTOrderBy localASTOrderBy1;
/*  242 */       if (jjtc000) {
/*  243 */         this.jjtree.clearNodeScope(jjtn000);
/*  244 */         jjtc000 = false;
/*      */       } else {
/*  246 */         this.jjtree.popNode();
/*      */       }
/*  248 */       if ((jjte000 instanceof RuntimeException)) {
/*  249 */         throw ((RuntimeException)jjte000);
/*      */       }
/*  251 */       if ((jjte000 instanceof ParseException)) {
/*  252 */         throw ((ParseException)jjte000);
/*      */       }
/*  254 */       throw ((Error)jjte000);
/*      */     } finally {
/*  256 */       if (jjtc000)
/*  257 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void OrderByPathExpression()
/*      */     throws ParseException
/*      */   {
/*  265 */     ASTOrderByPath jjtn000 = new ASTOrderByPath(2);
/*  266 */     boolean jjtc000 = true;
/*  267 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/*  269 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 79:
/*  271 */         NumericValuedPath();
/*  272 */         break;
/*      */       case 80:
/*  274 */         StringValuedPath();
/*  275 */         break;
/*      */       case 81:
/*  277 */         DatetimeValuedPath();
/*  278 */         break;
/*      */       default:
/*  280 */         this.jj_la1[3] = this.jj_gen;
/*  281 */         jj_consume_token(-1);
/*  282 */         throw new ParseException();
/*      */       }
/*  284 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 32:
/*      */       case 33:
/*  287 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 32:
/*  289 */           jj_consume_token(32);
/*  290 */           break;
/*      */         case 33:
/*  292 */           jj_consume_token(33);
/*  293 */           jjtn000.ascending = false;
/*  294 */           break;
/*      */         default:
/*  296 */           this.jj_la1[4] = this.jj_gen;
/*  297 */           jj_consume_token(-1);
/*  298 */           throw new ParseException();
/*      */         }
/*      */ 
/*      */       default:
/*  302 */         this.jj_la1[5] = this.jj_gen;
/*      */       }
/*      */     }
/*      */     catch (Throwable jjte000) {
/*  306 */       if (jjtc000) {
/*  307 */         this.jjtree.clearNodeScope(jjtn000);
/*  308 */         jjtc000 = false;
/*      */       } else {
/*  310 */         this.jjtree.popNode();
/*      */       }
/*  312 */       if ((jjte000 instanceof RuntimeException)) {
/*  313 */         throw ((RuntimeException)jjte000);
/*      */       }
/*  315 */       if ((jjte000 instanceof ParseException)) {
/*  316 */         throw ((ParseException)jjte000);
/*      */       }
/*  318 */       throw ((Error)jjte000);
/*      */     } finally {
/*  320 */       if (jjtc000)
/*  321 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void FromKeyword()
/*      */     throws ParseException
/*      */   {
/*  328 */     ASTFrom jjtn000 = new ASTFrom(3);
/*  329 */     boolean jjtc000 = true;
/*  330 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/*  332 */       jj_consume_token(13);
/*      */     } finally {
/*  334 */       if (jjtc000)
/*  335 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final ASTFrom ParseFromClause()
/*      */     throws ParseException
/*      */   {
/*  342 */     ASTFrom node = FromClause();
/*  343 */     jj_consume_token(0);
/*  344 */     return node;
/*      */   }
/*      */ 
/*      */   public final ASTFrom FromClause()
/*      */     throws ParseException
/*      */   {
/*  350 */     ASTFrom jjtn000 = new ASTFrom(3);
/*  351 */     boolean jjtc000 = true;
/*  352 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/*  354 */       jj_consume_token(13);
/*  355 */       IdentificationVariableDeclaration();
/*      */       while (true)
/*      */       {
/*  358 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */         {
/*      */         case 42:
/*  361 */           break;
/*      */         default:
/*  363 */           this.jj_la1[6] = this.jj_gen;
/*  364 */           break;
/*      */         }
/*  366 */         jj_consume_token(42);
/*  367 */         IdentificationVariableDeclaration();
/*      */       }
/*  369 */       this.jjtree.closeNodeScope(jjtn000, true);
/*  370 */       jjtc000 = false;
/*  371 */       localASTFrom1 = jjtn000;
/*      */     }
/*      */     catch (Throwable jjte000)
/*      */     {
/*      */       ASTFrom localASTFrom1;
/*  373 */       if (jjtc000) {
/*  374 */         this.jjtree.clearNodeScope(jjtn000);
/*  375 */         jjtc000 = false;
/*      */       } else {
/*  377 */         this.jjtree.popNode();
/*      */       }
/*  379 */       if ((jjte000 instanceof RuntimeException)) {
/*  380 */         throw ((RuntimeException)jjte000);
/*      */       }
/*  382 */       if ((jjte000 instanceof ParseException)) {
/*  383 */         throw ((ParseException)jjte000);
/*      */       }
/*  385 */       throw ((Error)jjte000);
/*      */     } finally {
/*  387 */       if (jjtc000)
/*  388 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void IdentificationVariableDeclaration()
/*      */     throws ParseException
/*      */   {
/*  395 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 14:
/*  397 */       CollectionMemberDeclaration();
/*  398 */       break;
/*      */     case 30:
/*      */     case 64:
/*  401 */       RangeVariableDeclaration();
/*  402 */       break;
/*      */     default:
/*  404 */       this.jj_la1[7] = this.jj_gen;
/*  405 */       jj_consume_token(-1);
/*  406 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void CollectionMemberDeclaration() throws ParseException
/*      */   {
/*  412 */     ASTCollectionMemberDeclaration jjtn000 = new ASTCollectionMemberDeclaration(5);
/*  413 */     boolean jjtc000 = true;
/*  414 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try
/*      */     {
/*  417 */       jj_consume_token(14);
/*  418 */       jj_consume_token(40);
/*  419 */       Token path = CollectionValuedPath();
/*  420 */       jj_consume_token(41);
/*  421 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 7:
/*  423 */         jj_consume_token(7);
/*  424 */         break;
/*      */       default:
/*  426 */         this.jj_la1[8] = this.jj_gen;
/*      */       }
/*      */ 
/*  429 */       Token id = Identifier();
/*  430 */       this.jjtree.closeNodeScope(jjtn000, true);
/*  431 */       jjtc000 = false;
/*  432 */       this.idManager.declareCollectionMember(id.image, path.image);
/*      */     } catch (Throwable jjte000) {
/*  434 */       if (jjtc000) {
/*  435 */         this.jjtree.clearNodeScope(jjtn000);
/*  436 */         jjtc000 = false;
/*      */       } else {
/*  438 */         this.jjtree.popNode();
/*      */       }
/*  440 */       if ((jjte000 instanceof RuntimeException)) {
/*  441 */         throw ((RuntimeException)jjte000);
/*      */       }
/*  443 */       if ((jjte000 instanceof ParseException)) {
/*  444 */         throw ((ParseException)jjte000);
/*      */       }
/*  446 */       throw ((Error)jjte000);
/*      */     } finally {
/*  448 */       if (jjtc000)
/*  449 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void RangeVariableDeclaration()
/*      */     throws ParseException
/*      */   {
/*  456 */     ASTRangeVariableDeclaration jjtn000 = new ASTRangeVariableDeclaration(6);
/*  457 */     boolean jjtc000 = true;
/*  458 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try
/*      */     {
/*  461 */       Token schema = AbstractSchema();
/*  462 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 7:
/*  464 */         jj_consume_token(7);
/*  465 */         break;
/*      */       default:
/*  467 */         this.jj_la1[9] = this.jj_gen;
/*      */       }
/*      */ 
/*  470 */       Token id = Identifier();
/*  471 */       this.jjtree.closeNodeScope(jjtn000, true);
/*  472 */       jjtc000 = false;
/*  473 */       this.idManager.declareRangeVariable(id.image, schema.image);
/*      */     } catch (Throwable jjte000) {
/*  475 */       if (jjtc000) {
/*  476 */         this.jjtree.clearNodeScope(jjtn000);
/*  477 */         jjtc000 = false;
/*      */       } else {
/*  479 */         this.jjtree.popNode();
/*      */       }
/*  481 */       if ((jjte000 instanceof RuntimeException)) {
/*  482 */         throw ((RuntimeException)jjte000);
/*      */       }
/*  484 */       if ((jjte000 instanceof ParseException)) {
/*  485 */         throw ((ParseException)jjte000);
/*      */       }
/*  487 */       throw ((Error)jjte000);
/*      */     } finally {
/*  489 */       if (jjtc000)
/*  490 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final ASTSelect SelectClause()
/*      */     throws ParseException
/*      */   {
/*  497 */     ASTSelect jjtn000 = new ASTSelect(7);
/*  498 */     boolean jjtc000 = true;
/*  499 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/*  501 */       jj_consume_token(24);
/*  502 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 10:
/*  504 */         jj_consume_token(10);
/*  505 */         jjtn000.distinct = true;
/*  506 */         break;
/*      */       default:
/*  508 */         this.jj_la1[10] = this.jj_gen;
/*      */       }
/*      */ 
/*  511 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 21:
/*  513 */         jj_consume_token(21);
/*  514 */         jj_consume_token(40);
/*  515 */         IdentificationVariable();
/*  516 */         jj_consume_token(41);
/*  517 */         break;
/*      */       case 34:
/*      */       case 35:
/*      */       case 36:
/*      */       case 37:
/*      */       case 38:
/*      */       case 79:
/*      */       case 80:
/*      */       case 81:
/*      */       case 82:
/*      */       case 83:
/*      */       case 84:
/*  529 */         SelectExpression();
/*  530 */         break;
/*      */       default:
/*  532 */         this.jj_la1[11] = this.jj_gen;
/*  533 */         jj_consume_token(-1);
/*  534 */         throw new ParseException();
/*      */       }
/*  536 */       this.jjtree.closeNodeScope(jjtn000, true);
/*  537 */       jjtc000 = false;
/*  538 */       localASTSelect1 = jjtn000;
/*      */     }
/*      */     catch (Throwable jjte000)
/*      */     {
/*      */       ASTSelect localASTSelect1;
/*  540 */       if (jjtc000) {
/*  541 */         this.jjtree.clearNodeScope(jjtn000);
/*  542 */         jjtc000 = false;
/*      */       } else {
/*  544 */         this.jjtree.popNode();
/*      */       }
/*  546 */       if ((jjte000 instanceof RuntimeException)) {
/*  547 */         throw ((RuntimeException)jjte000);
/*      */       }
/*  549 */       if ((jjte000 instanceof ParseException)) {
/*  550 */         throw ((ParseException)jjte000);
/*      */       }
/*  552 */       throw ((Error)jjte000);
/*      */     } finally {
/*  554 */       if (jjtc000)
/*  555 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void SelectExpression()
/*      */     throws ParseException
/*      */   {
/*  562 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 79:
/*      */     case 80:
/*      */     case 81:
/*      */     case 82:
/*      */     case 83:
/*      */     case 84:
/*  569 */       SingleValuedPath();
/*  570 */       break;
/*      */     case 34:
/*      */     case 35:
/*      */     case 36:
/*      */     case 37:
/*      */     case 38:
/*  576 */       AggregateSelectExpression();
/*  577 */       break;
/*      */     default:
/*  579 */       this.jj_la1[12] = this.jj_gen;
/*  580 */       jj_consume_token(-1);
/*  581 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final ASTWhere WhereClause() throws ParseException
/*      */   {
/*  587 */     ASTWhere jjtn000 = new ASTWhere(8);
/*  588 */     boolean jjtc000 = true;
/*  589 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/*  591 */       jj_consume_token(28);
/*  592 */       WhereExpression();
/*  593 */       this.jjtree.closeNodeScope(jjtn000, true);
/*  594 */       jjtc000 = false;
/*  595 */       localASTWhere1 = jjtn000;
/*      */     }
/*      */     catch (Throwable jjte000)
/*      */     {
/*      */       ASTWhere localASTWhere1;
/*  597 */       if (jjtc000) {
/*  598 */         this.jjtree.clearNodeScope(jjtn000);
/*  599 */         jjtc000 = false;
/*      */       } else {
/*  601 */         this.jjtree.popNode();
/*      */       }
/*  603 */       if ((jjte000 instanceof RuntimeException)) {
/*  604 */         throw ((RuntimeException)jjte000);
/*      */       }
/*  606 */       if ((jjte000 instanceof ParseException)) {
/*  607 */         throw ((ParseException)jjte000);
/*      */       }
/*  609 */       throw ((Error)jjte000);
/*      */     } finally {
/*  611 */       if (jjtc000)
/*  612 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void WhereExpression()
/*      */     throws ParseException
/*      */   {
/*  624 */     ASTOr jjtn001 = new ASTOr(9);
/*  625 */     boolean jjtc001 = true;
/*  626 */     this.jjtree.openNodeScope(jjtn001);
/*      */     try {
/*  628 */       WhereConditionalTerm();
/*      */       while (true)
/*      */       {
/*  631 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */         {
/*      */         case 23:
/*  634 */           break;
/*      */         default:
/*  636 */           this.jj_la1[13] = this.jj_gen;
/*  637 */           break;
/*      */         }
/*  639 */         jj_consume_token(23);
/*  640 */         WhereConditionalTerm();
/*      */       }
/*      */     } catch (Throwable jjte001) {
/*  643 */       if (jjtc001) {
/*  644 */         this.jjtree.clearNodeScope(jjtn001);
/*  645 */         jjtc001 = false;
/*      */       } else {
/*  647 */         this.jjtree.popNode();
/*      */       }
/*  649 */       if ((jjte001 instanceof RuntimeException)) {
/*  650 */         throw ((RuntimeException)jjte001);
/*      */       }
/*  652 */       if ((jjte001 instanceof ParseException)) {
/*  653 */         throw ((ParseException)jjte001);
/*      */       }
/*  655 */       throw ((Error)jjte001);
/*      */     } finally {
/*  657 */       if (jjtc001)
/*  658 */         this.jjtree.closeNodeScope(jjtn001, this.jjtree.nodeArity() > 1);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final ASTWhereConditionalTerm WhereConditionalTerm()
/*      */     throws ParseException
/*      */   {
/*  665 */     ASTWhereConditionalTerm jjtn000 = new ASTWhereConditionalTerm(10);
/*  666 */     boolean jjtc000 = true;
/*  667 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/*  669 */       ASTAnd jjtn001 = new ASTAnd(11);
/*  670 */       boolean jjtc001 = true;
/*  671 */       this.jjtree.openNodeScope(jjtn001);
/*      */       try {
/*  673 */         ConditionalFactor();
/*      */         while (true)
/*      */         {
/*  676 */           switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */           {
/*      */           case 6:
/*  679 */             break;
/*      */           default:
/*  681 */             this.jj_la1[14] = this.jj_gen;
/*  682 */             break;
/*      */           }
/*  684 */           jj_consume_token(6);
/*  685 */           ConditionalFactor();
/*      */         }
/*      */       } catch (Throwable jjte001) {
/*  688 */         if (jjtc001) {
/*  689 */           this.jjtree.clearNodeScope(jjtn001);
/*  690 */           jjtc001 = false;
/*      */         } else {
/*  692 */           this.jjtree.popNode();
/*      */         }
/*  694 */         if ((jjte001 instanceof RuntimeException)) {
/*  695 */           throw ((RuntimeException)jjte001);
/*      */         }
/*  697 */         if ((jjte001 instanceof ParseException)) {
/*  698 */           throw ((ParseException)jjte001);
/*      */         }
/*  700 */         throw ((Error)jjte001);
/*      */       } finally {
/*  702 */         if (jjtc001) {
/*  703 */           this.jjtree.closeNodeScope(jjtn001, this.jjtree.nodeArity() > 1);
/*      */         }
/*      */       }
/*  706 */       this.jjtree.closeNodeScope(jjtn000, true);
/*  707 */       jjtc000 = false;
/*  708 */       jjte001 = jjtn000;
/*      */     } catch (Throwable jjte000) {
/*  710 */       if (jjtc000) {
/*  711 */         this.jjtree.clearNodeScope(jjtn000);
/*  712 */         jjtc000 = false;
/*      */       } else {
/*  714 */         this.jjtree.popNode();
/*      */       }
/*  716 */       if ((jjte000 instanceof RuntimeException)) {
/*  717 */         throw ((RuntimeException)jjte000);
/*      */       }
/*  719 */       if ((jjte000 instanceof ParseException)) {
/*  720 */         throw ((ParseException)jjte000);
/*      */       }
/*  722 */       throw ((Error)jjte000);
/*      */     } finally {
/*  724 */       if (jjtc000)
/*  725 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void ConditionalExpression()
/*      */     throws ParseException
/*      */   {
/*  732 */     ASTOr jjtn001 = new ASTOr(9);
/*  733 */     boolean jjtc001 = true;
/*  734 */     this.jjtree.openNodeScope(jjtn001);
/*      */     try {
/*  736 */       ConditionalTerm();
/*      */       while (true)
/*      */       {
/*  739 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */         {
/*      */         case 23:
/*  742 */           break;
/*      */         default:
/*  744 */           this.jj_la1[15] = this.jj_gen;
/*  745 */           break;
/*      */         }
/*  747 */         jj_consume_token(23);
/*  748 */         ConditionalTerm();
/*      */       }
/*      */     } catch (Throwable jjte001) {
/*  751 */       if (jjtc001) {
/*  752 */         this.jjtree.clearNodeScope(jjtn001);
/*  753 */         jjtc001 = false;
/*      */       } else {
/*  755 */         this.jjtree.popNode();
/*      */       }
/*  757 */       if ((jjte001 instanceof RuntimeException)) {
/*  758 */         throw ((RuntimeException)jjte001);
/*      */       }
/*  760 */       if ((jjte001 instanceof ParseException)) {
/*  761 */         throw ((ParseException)jjte001);
/*      */       }
/*  763 */       throw ((Error)jjte001);
/*      */     } finally {
/*  765 */       if (jjtc001)
/*  766 */         this.jjtree.closeNodeScope(jjtn001, this.jjtree.nodeArity() > 1);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void ConditionalTerm() throws ParseException
/*      */   {
/*  772 */     ASTAnd jjtn001 = new ASTAnd(11);
/*  773 */     boolean jjtc001 = true;
/*  774 */     this.jjtree.openNodeScope(jjtn001);
/*      */     try {
/*  776 */       ConditionalFactor();
/*      */       while (true)
/*      */       {
/*  779 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */         {
/*      */         case 6:
/*  782 */           break;
/*      */         default:
/*  784 */           this.jj_la1[16] = this.jj_gen;
/*  785 */           break;
/*      */         }
/*  787 */         jj_consume_token(6);
/*  788 */         ConditionalFactor();
/*      */       }
/*      */     } catch (Throwable jjte001) {
/*  791 */       if (jjtc001) {
/*  792 */         this.jjtree.clearNodeScope(jjtn001);
/*  793 */         jjtc001 = false;
/*      */       } else {
/*  795 */         this.jjtree.popNode();
/*      */       }
/*  797 */       if ((jjte001 instanceof RuntimeException)) {
/*  798 */         throw ((RuntimeException)jjte001);
/*      */       }
/*  800 */       if ((jjte001 instanceof ParseException)) {
/*  801 */         throw ((ParseException)jjte001);
/*      */       }
/*  803 */       throw ((Error)jjte001);
/*      */     } finally {
/*  805 */       if (jjtc001)
/*  806 */         this.jjtree.closeNodeScope(jjtn001, this.jjtree.nodeArity() > 1);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void ConditionalFactor() throws ParseException
/*      */   {
/*  812 */     boolean not = false;
/*  813 */     ASTNot jjtn001 = new ASTNot(12);
/*  814 */     boolean jjtc001 = true;
/*  815 */     this.jjtree.openNodeScope(jjtn001);
/*      */     try {
/*  817 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 19:
/*  819 */         jj_consume_token(19);
/*  820 */         not = true;
/*  821 */         break;
/*      */       default:
/*  823 */         this.jj_la1[17] = this.jj_gen;
/*      */       }
/*      */ 
/*  826 */       ConditionalTest();
/*      */     } catch (Throwable jjte001) {
/*  828 */       if (jjtc001) {
/*  829 */         this.jjtree.clearNodeScope(jjtn001);
/*  830 */         jjtc001 = false;
/*      */       } else {
/*  832 */         this.jjtree.popNode();
/*      */       }
/*  834 */       if ((jjte001 instanceof RuntimeException)) {
/*  835 */         throw ((RuntimeException)jjte001);
/*      */       }
/*  837 */       if ((jjte001 instanceof ParseException)) {
/*  838 */         throw ((ParseException)jjte001);
/*      */       }
/*  840 */       throw ((Error)jjte001);
/*      */     } finally {
/*  842 */       if (jjtc001)
/*  843 */         this.jjtree.closeNodeScope(jjtn001, not);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void ConditionalTest() throws ParseException
/*      */   {
/*  849 */     ConditionalPrimary();
/*      */   }
/*      */ 
/*      */   public final void ConditionalPrimary() throws ParseException {
/*  853 */     if (jj_2_1(2147483647)) {
/*  854 */       ASTConditionalParenthetical jjtn001 = new ASTConditionalParenthetical(13);
/*  855 */       boolean jjtc001 = true;
/*  856 */       this.jjtree.openNodeScope(jjtn001);
/*      */       try {
/*  858 */         jj_consume_token(40);
/*  859 */         ConditionalExpression();
/*  860 */         jj_consume_token(41);
/*      */       } catch (Throwable jjte001) {
/*  862 */         if (jjtc001) {
/*  863 */           this.jjtree.clearNodeScope(jjtn001);
/*  864 */           jjtc001 = false;
/*      */         } else {
/*  866 */           this.jjtree.popNode();
/*      */         }
/*  868 */         if ((jjte001 instanceof RuntimeException)) {
/*  869 */           throw ((RuntimeException)jjte001);
/*      */         }
/*  871 */         if ((jjte001 instanceof ParseException)) {
/*  872 */           throw ((ParseException)jjte001);
/*      */         }
/*  874 */         throw ((Error)jjte001);
/*      */       } finally {
/*  876 */         if (jjtc001)
/*  877 */           this.jjtree.closeNodeScope(jjtn001, true);
/*      */       }
/*      */     }
/*  880 */     else if (jj_2_2(1)) {
/*  881 */       SimpleCondExpression();
/*      */     } else {
/*  883 */       jj_consume_token(-1);
/*  884 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void SimpleCondExpression() throws ParseException {
/*  889 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 86:
/*  891 */       EmptyCollectionComparisonExpression();
/*  892 */       break;
/*      */     default:
/*  894 */       this.jj_la1[18] = this.jj_gen;
/*  895 */       if (getToken(2).kind == 15)
/*  896 */         NullComparisonExpression();
/*  897 */       else if ((getToken(2).kind == 29) || (getToken(3).kind == 29))
/*  898 */         CollectionMemberExpression();
/*  899 */       else if ((getToken(2).kind == 17) || (getToken(3).kind == 17))
/*  900 */         LikeExpression();
/*  901 */       else if ((getToken(2).kind == 14) || (getToken(3).kind == 14))
/*  902 */         InExpression();
/*      */       else
/*  904 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 5:
/*      */         case 9:
/*      */         case 16:
/*      */         case 18:
/*      */         case 25:
/*      */         case 26:
/*      */         case 39:
/*      */         case 40:
/*      */         case 50:
/*      */         case 51:
/*      */         case 55:
/*      */         case 59:
/*      */         case 65:
/*      */         case 70:
/*      */         case 79:
/*      */         case 80:
/*      */         case 81:
/*      */         case 82:
/*      */         case 83:
/*  924 */           ComparisonExpression();
/*  925 */           break;
/*      */         case 6:
/*      */         case 7:
/*      */         case 8:
/*      */         case 10:
/*      */         case 11:
/*      */         case 12:
/*      */         case 13:
/*      */         case 14:
/*      */         case 15:
/*      */         case 17:
/*      */         case 19:
/*      */         case 20:
/*      */         case 21:
/*      */         case 22:
/*      */         case 23:
/*      */         case 24:
/*      */         case 27:
/*      */         case 28:
/*      */         case 29:
/*      */         case 30:
/*      */         case 31:
/*      */         case 32:
/*      */         case 33:
/*      */         case 34:
/*      */         case 35:
/*      */         case 36:
/*      */         case 37:
/*      */         case 38:
/*      */         case 41:
/*      */         case 42:
/*      */         case 43:
/*      */         case 44:
/*      */         case 45:
/*      */         case 46:
/*      */         case 47:
/*      */         case 48:
/*      */         case 49:
/*      */         case 52:
/*      */         case 53:
/*      */         case 54:
/*      */         case 56:
/*      */         case 57:
/*      */         case 58:
/*      */         case 60:
/*      */         case 61:
/*      */         case 62:
/*      */         case 63:
/*      */         case 64:
/*      */         case 66:
/*      */         case 67:
/*      */         case 68:
/*      */         case 69:
/*      */         case 71:
/*      */         case 72:
/*      */         case 73:
/*      */         case 74:
/*      */         case 75:
/*      */         case 76:
/*      */         case 77:
/*      */         case 78:
/*      */         default:
/*  927 */           this.jj_la1[19] = this.jj_gen;
/*  928 */           jj_consume_token(-1);
/*  929 */           throw new ParseException();
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void BetweenExpression()
/*      */     throws ParseException
/*      */   {
/*  937 */     ASTBetween jjtn000 = new ASTBetween(14);
/*  938 */     boolean jjtc000 = true;
/*  939 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/*  941 */       ArithmeticExpression();
/*  942 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 19:
/*  944 */         jj_consume_token(19);
/*  945 */         jjtn000.not = true;
/*  946 */         break;
/*      */       default:
/*  948 */         this.jj_la1[20] = this.jj_gen;
/*      */       }
/*      */ 
/*  951 */       jj_consume_token(8);
/*  952 */       ArithmeticExpression();
/*  953 */       jj_consume_token(6);
/*  954 */       ArithmeticExpression();
/*      */     } catch (Throwable jjte000) {
/*  956 */       if (jjtc000) {
/*  957 */         this.jjtree.clearNodeScope(jjtn000);
/*  958 */         jjtc000 = false;
/*      */       } else {
/*  960 */         this.jjtree.popNode();
/*      */       }
/*  962 */       if ((jjte000 instanceof RuntimeException)) {
/*  963 */         throw ((RuntimeException)jjte000);
/*      */       }
/*  965 */       if ((jjte000 instanceof ParseException)) {
/*  966 */         throw ((ParseException)jjte000);
/*      */       }
/*  968 */       throw ((Error)jjte000);
/*      */     } finally {
/*  970 */       if (jjtc000)
/*  971 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void InExpression()
/*      */     throws ParseException
/*      */   {
/*  978 */     ASTIn jjtn000 = new ASTIn(15);
/*  979 */     boolean jjtc000 = true;
/*  980 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/*  982 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 9:
/*      */       case 25:
/*      */       case 40:
/*      */       case 54:
/*      */       case 71:
/*      */       case 80:
/*  989 */         StringExpression();
/*  990 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 19:
/*  992 */           jj_consume_token(19);
/*  993 */           jjtn000.not = true;
/*  994 */           break;
/*      */         default:
/*  996 */           this.jj_la1[21] = this.jj_gen;
/*      */         }
/*      */ 
/*  999 */         jj_consume_token(14);
/* 1000 */         jj_consume_token(40);
/* 1001 */         StringExpression();
/*      */         while (true)
/*      */         {
/* 1004 */           switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */           {
/*      */           case 42:
/* 1007 */             break;
/*      */           default:
/* 1009 */             this.jj_la1[22] = this.jj_gen;
/* 1010 */             break;
/*      */           }
/* 1012 */           jj_consume_token(42);
/* 1013 */           StringExpression();
/*      */         }
/* 1015 */         jj_consume_token(41);
/* 1016 */         break;
/*      */       case 5:
/*      */       case 16:
/*      */       case 18:
/*      */       case 26:
/*      */       case 39:
/*      */       case 55:
/*      */       case 59:
/*      */       case 70:
/*      */       case 79:
/* 1026 */         ArithmeticPrimary();
/* 1027 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 19:
/* 1029 */           jj_consume_token(19);
/* 1030 */           jjtn000.not = true;
/* 1031 */           break;
/*      */         default:
/* 1033 */           this.jj_la1[23] = this.jj_gen;
/*      */         }
/*      */ 
/* 1036 */         jj_consume_token(14);
/* 1037 */         jj_consume_token(40);
/* 1038 */         ArithmeticPrimary();
/*      */         while (true)
/*      */         {
/* 1041 */           switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */           {
/*      */           case 42:
/* 1044 */             break;
/*      */           default:
/* 1046 */             this.jj_la1[24] = this.jj_gen;
/* 1047 */             break;
/*      */           }
/* 1049 */           jj_consume_token(42);
/* 1050 */           ArithmeticPrimary();
/*      */         }
/* 1052 */         jj_consume_token(41);
/* 1053 */         break;
/*      */       default:
/* 1055 */         this.jj_la1[25] = this.jj_gen;
/* 1056 */         jj_consume_token(-1);
/* 1057 */         throw new ParseException();
/*      */       }
/*      */     } catch (Throwable jjte000) {
/* 1060 */       if (jjtc000) {
/* 1061 */         this.jjtree.clearNodeScope(jjtn000);
/* 1062 */         jjtc000 = false;
/*      */       } else {
/* 1064 */         this.jjtree.popNode();
/*      */       }
/* 1066 */       if ((jjte000 instanceof RuntimeException)) {
/* 1067 */         throw ((RuntimeException)jjte000);
/*      */       }
/* 1069 */       if ((jjte000 instanceof ParseException)) {
/* 1070 */         throw ((ParseException)jjte000);
/*      */       }
/* 1072 */       throw ((Error)jjte000);
/*      */     } finally {
/* 1074 */       if (jjtc000)
/* 1075 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void LikeExpression()
/*      */     throws ParseException
/*      */   {
/* 1082 */     ASTLike jjtn000 = new ASTLike(16);
/* 1083 */     boolean jjtc000 = true;
/* 1084 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 1086 */       StringValuedPath();
/* 1087 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 19:
/* 1089 */         jj_consume_token(19);
/* 1090 */         jjtn000.not = true;
/* 1091 */         break;
/*      */       default:
/* 1093 */         this.jj_la1[26] = this.jj_gen;
/*      */       }
/*      */ 
/* 1096 */       jj_consume_token(17);
/* 1097 */       StringExpression();
/* 1098 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 12:
/* 1100 */         jj_consume_token(12);
/* 1101 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 54:
/* 1103 */           StringLiteral();
/* 1104 */           break;
/*      */         case 70:
/* 1106 */           NumericValuedParameter();
/* 1107 */           break;
/*      */         default:
/* 1109 */           this.jj_la1[27] = this.jj_gen;
/* 1110 */           jj_consume_token(-1);
/* 1111 */           throw new ParseException();
/*      */         }
/*      */ 
/*      */       default:
/* 1115 */         this.jj_la1[28] = this.jj_gen;
/*      */       }
/*      */     }
/*      */     catch (Throwable jjte000) {
/* 1119 */       if (jjtc000) {
/* 1120 */         this.jjtree.clearNodeScope(jjtn000);
/* 1121 */         jjtc000 = false;
/*      */       } else {
/* 1123 */         this.jjtree.popNode();
/*      */       }
/* 1125 */       if ((jjte000 instanceof RuntimeException)) {
/* 1126 */         throw ((RuntimeException)jjte000);
/*      */       }
/* 1128 */       if ((jjte000 instanceof ParseException)) {
/* 1129 */         throw ((ParseException)jjte000);
/*      */       }
/* 1131 */       throw ((Error)jjte000);
/*      */     } finally {
/* 1133 */       if (jjtc000)
/* 1134 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void NullComparisonExpression()
/*      */     throws ParseException
/*      */   {
/* 1141 */     ASTNullComparison jjtn000 = new ASTNullComparison(17);
/* 1142 */     boolean jjtc000 = true;
/* 1143 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 1145 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 79:
/*      */       case 80:
/*      */       case 81:
/*      */       case 82:
/*      */       case 83:
/*      */       case 84:
/* 1152 */         SingleValuedPath();
/* 1153 */         break;
/*      */       case 70:
/* 1155 */         NumericValuedParameter();
/* 1156 */         break;
/*      */       case 74:
/* 1158 */         EntityValuedParameter();
/* 1159 */         break;
/*      */       case 71:
/* 1161 */         StringValuedParameter();
/* 1162 */         break;
/*      */       case 72:
/* 1164 */         DatetimeValuedParameter();
/* 1165 */         break;
/*      */       case 73:
/* 1167 */         BooleanValuedParameter();
/* 1168 */         break;
/*      */       case 75:
/*      */       case 76:
/*      */       case 77:
/*      */       case 78:
/*      */       default:
/* 1170 */         this.jj_la1[29] = this.jj_gen;
/* 1171 */         jj_consume_token(-1);
/* 1172 */         throw new ParseException();
/*      */       }
/* 1174 */       jj_consume_token(15);
/* 1175 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 19:
/* 1177 */         jj_consume_token(19);
/* 1178 */         jjtn000.not = true;
/* 1179 */         break;
/*      */       default:
/* 1181 */         this.jj_la1[30] = this.jj_gen;
/*      */       }
/*      */ 
/* 1184 */       jj_consume_token(20);
/*      */     } catch (Throwable jjte000) {
/* 1186 */       if (jjtc000) {
/* 1187 */         this.jjtree.clearNodeScope(jjtn000);
/* 1188 */         jjtc000 = false;
/*      */       } else {
/* 1190 */         this.jjtree.popNode();
/*      */       }
/* 1192 */       if ((jjte000 instanceof RuntimeException)) {
/* 1193 */         throw ((RuntimeException)jjte000);
/*      */       }
/* 1195 */       if ((jjte000 instanceof ParseException)) {
/* 1196 */         throw ((ParseException)jjte000);
/*      */       }
/* 1198 */       throw ((Error)jjte000);
/*      */     } finally {
/* 1200 */       if (jjtc000)
/* 1201 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void EmptyCollectionComparisonExpression()
/*      */     throws ParseException
/*      */   {
/* 1208 */     ASTIsEmpty jjtn000 = new ASTIsEmpty(18);
/* 1209 */     boolean jjtc000 = true;
/* 1210 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 1212 */       CollectionValuedPath();
/* 1213 */       jj_consume_token(15);
/* 1214 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 19:
/* 1216 */         jj_consume_token(19);
/* 1217 */         jjtn000.not = true;
/* 1218 */         break;
/*      */       default:
/* 1220 */         this.jj_la1[31] = this.jj_gen;
/*      */       }
/*      */ 
/* 1223 */       jj_consume_token(11);
/*      */     } catch (Throwable jjte000) {
/* 1225 */       if (jjtc000) {
/* 1226 */         this.jjtree.clearNodeScope(jjtn000);
/* 1227 */         jjtc000 = false;
/*      */       } else {
/* 1229 */         this.jjtree.popNode();
/*      */       }
/* 1231 */       if ((jjte000 instanceof RuntimeException)) {
/* 1232 */         throw ((RuntimeException)jjte000);
/*      */       }
/* 1234 */       if ((jjte000 instanceof ParseException)) {
/* 1235 */         throw ((ParseException)jjte000);
/*      */       }
/* 1237 */       throw ((Error)jjte000);
/*      */     } finally {
/* 1239 */       if (jjtc000)
/* 1240 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void CollectionMemberExpression()
/*      */     throws ParseException
/*      */   {
/* 1247 */     ASTMemberOf jjtn000 = new ASTMemberOf(19);
/* 1248 */     boolean jjtc000 = true;
/* 1249 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 1251 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 83:
/* 1253 */         EntityValuedPath();
/* 1254 */         break;
/*      */       case 65:
/* 1256 */         IdentificationVariable();
/* 1257 */         break;
/*      */       case 74:
/* 1259 */         EntityValuedParameter();
/* 1260 */         break;
/*      */       default:
/* 1262 */         this.jj_la1[32] = this.jj_gen;
/* 1263 */         jj_consume_token(-1);
/* 1264 */         throw new ParseException();
/*      */       }
/* 1266 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 19:
/* 1268 */         jj_consume_token(19);
/* 1269 */         jjtn000.not = true;
/* 1270 */         break;
/*      */       default:
/* 1272 */         this.jj_la1[33] = this.jj_gen;
/*      */       }
/*      */ 
/* 1275 */       jj_consume_token(29);
/* 1276 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 22:
/* 1278 */         jj_consume_token(22);
/* 1279 */         break;
/*      */       default:
/* 1281 */         this.jj_la1[34] = this.jj_gen;
/*      */       }
/*      */ 
/* 1284 */       CollectionValuedPath();
/*      */     } catch (Throwable jjte000) {
/* 1286 */       if (jjtc000) {
/* 1287 */         this.jjtree.clearNodeScope(jjtn000);
/* 1288 */         jjtc000 = false;
/*      */       } else {
/* 1290 */         this.jjtree.popNode();
/*      */       }
/* 1292 */       if ((jjte000 instanceof RuntimeException)) {
/* 1293 */         throw ((RuntimeException)jjte000);
/*      */       }
/* 1295 */       if ((jjte000 instanceof ParseException)) {
/* 1296 */         throw ((ParseException)jjte000);
/*      */       }
/* 1298 */       throw ((Error)jjte000);
/*      */     } finally {
/* 1300 */       if (jjtc000)
/* 1301 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void ComparisonExpression() throws ParseException
/*      */   {
/* 1307 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 9:
/*      */     case 25:
/*      */     case 80:
/* 1311 */       ASTStringComparison jjtn001 = new ASTStringComparison(20);
/* 1312 */       boolean jjtc001 = true;
/* 1313 */       this.jjtree.openNodeScope(jjtn001);
/*      */       try {
/* 1315 */         StringValue();
/* 1316 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 46:
/* 1318 */           jj_consume_token(46);
/* 1319 */           jjtn001.opp = "=";
/* 1320 */           break;
/*      */         case 44:
/* 1322 */           jj_consume_token(44);
/* 1323 */           jjtn001.opp = ">";
/* 1324 */           break;
/*      */         case 48:
/* 1326 */           jj_consume_token(48);
/* 1327 */           jjtn001.opp = ">=";
/* 1328 */           break;
/*      */         case 45:
/* 1330 */           jj_consume_token(45);
/* 1331 */           jjtn001.opp = "<";
/* 1332 */           break;
/*      */         case 47:
/* 1334 */           jj_consume_token(47);
/* 1335 */           jjtn001.opp = "<=";
/* 1336 */           break;
/*      */         case 49:
/* 1338 */           jj_consume_token(49);
/* 1339 */           jjtn001.opp = "<>";
/* 1340 */           break;
/*      */         default:
/* 1342 */           this.jj_la1[35] = this.jj_gen;
/* 1343 */           jj_consume_token(-1);
/* 1344 */           throw new ParseException();
/*      */         }
/* 1346 */         StringExpression();
/*      */       } catch (Throwable jjte001) {
/* 1348 */         if (jjtc001) {
/* 1349 */           this.jjtree.clearNodeScope(jjtn001);
/* 1350 */           jjtc001 = false;
/*      */         } else {
/* 1352 */           this.jjtree.popNode();
/*      */         }
/* 1354 */         if ((jjte001 instanceof RuntimeException)) {
/* 1355 */           throw ((RuntimeException)jjte001);
/*      */         }
/* 1357 */         if ((jjte001 instanceof ParseException)) {
/* 1358 */           throw ((ParseException)jjte001);
/*      */         }
/* 1360 */         throw ((Error)jjte001);
/*      */       } finally {
/* 1362 */         if (jjtc001) {
/* 1363 */           this.jjtree.closeNodeScope(jjtn001, true);
/*      */         }
/*      */       }
/* 1366 */       break;
/*      */     case 82:
/* 1368 */       ASTBooleanComparison jjtn002 = new ASTBooleanComparison(21);
/* 1369 */       boolean jjtc002 = true;
/* 1370 */       this.jjtree.openNodeScope(jjtn002);
/*      */       try {
/* 1372 */         BooleanValue();
/* 1373 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 46:
/*      */         case 49:
/* 1376 */           switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */           case 46:
/* 1378 */             jj_consume_token(46);
/* 1379 */             jjtn002.opp = "=";
/* 1380 */             break;
/*      */           case 49:
/* 1382 */             jj_consume_token(49);
/* 1383 */             jjtn002.opp = "<>";
/* 1384 */             break;
/*      */           default:
/* 1386 */             this.jj_la1[36] = this.jj_gen;
/* 1387 */             jj_consume_token(-1);
/* 1388 */             throw new ParseException();
/*      */           }
/* 1390 */           BooleanExpression();
/* 1391 */           break;
/*      */         default:
/* 1393 */           this.jj_la1[37] = this.jj_gen;
/*      */         }
/*      */       }
/*      */       catch (Throwable jjte002) {
/* 1397 */         if (jjtc002) {
/* 1398 */           this.jjtree.clearNodeScope(jjtn002);
/* 1399 */           jjtc002 = false;
/*      */         } else {
/* 1401 */           this.jjtree.popNode();
/*      */         }
/* 1403 */         if ((jjte002 instanceof RuntimeException)) {
/* 1404 */           throw ((RuntimeException)jjte002);
/*      */         }
/* 1406 */         if ((jjte002 instanceof ParseException)) {
/* 1407 */           throw ((ParseException)jjte002);
/*      */         }
/* 1409 */         throw ((Error)jjte002);
/*      */       } finally {
/* 1411 */         if (jjtc002) {
/* 1412 */           this.jjtree.closeNodeScope(jjtn002, true);
/*      */         }
/*      */       }
/* 1415 */       break;
/*      */     case 81:
/* 1417 */       ASTDatetimeComparison jjtn003 = new ASTDatetimeComparison(22);
/* 1418 */       boolean jjtc003 = true;
/* 1419 */       this.jjtree.openNodeScope(jjtn003);
/*      */       try {
/* 1421 */         DatetimeValue();
/* 1422 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 46:
/* 1424 */           jj_consume_token(46);
/* 1425 */           jjtn003.opp = "=";
/* 1426 */           break;
/*      */         case 44:
/* 1428 */           jj_consume_token(44);
/* 1429 */           jjtn003.opp = ">";
/* 1430 */           break;
/*      */         case 45:
/* 1432 */           jj_consume_token(45);
/* 1433 */           jjtn003.opp = "<";
/* 1434 */           break;
/*      */         case 49:
/* 1436 */           jj_consume_token(49);
/* 1437 */           jjtn003.opp = "<>";
/* 1438 */           break;
/*      */         case 48:
/* 1440 */           jj_consume_token(48);
/* 1441 */           jjtn003.opp = ">=";
/* 1442 */           break;
/*      */         case 47:
/* 1444 */           jj_consume_token(47);
/* 1445 */           jjtn003.opp = "<=";
/* 1446 */           break;
/*      */         default:
/* 1448 */           this.jj_la1[38] = this.jj_gen;
/* 1449 */           jj_consume_token(-1);
/* 1450 */           throw new ParseException();
/*      */         }
/* 1452 */         DatetimeExpression();
/*      */       } catch (Throwable jjte003) {
/* 1454 */         if (jjtc003) {
/* 1455 */           this.jjtree.clearNodeScope(jjtn003);
/* 1456 */           jjtc003 = false;
/*      */         } else {
/* 1458 */           this.jjtree.popNode();
/*      */         }
/* 1460 */         if ((jjte003 instanceof RuntimeException)) {
/* 1461 */           throw ((RuntimeException)jjte003);
/*      */         }
/* 1463 */         if ((jjte003 instanceof ParseException)) {
/* 1464 */           throw ((ParseException)jjte003);
/*      */         }
/* 1466 */         throw ((Error)jjte003);
/*      */       } finally {
/* 1468 */         if (jjtc003) {
/* 1469 */           this.jjtree.closeNodeScope(jjtn003, true);
/*      */         }
/*      */       }
/* 1472 */       break;
/*      */     case 65:
/*      */     case 83:
/* 1475 */       ASTEntityComparison jjtn004 = new ASTEntityComparison(23);
/* 1476 */       boolean jjtc004 = true;
/* 1477 */       this.jjtree.openNodeScope(jjtn004);
/*      */       try {
/* 1479 */         EntityBeanValue();
/* 1480 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 46:
/* 1482 */           jj_consume_token(46);
/* 1483 */           jjtn004.opp = "=";
/* 1484 */           break;
/*      */         case 49:
/* 1486 */           jj_consume_token(49);
/* 1487 */           jjtn004.opp = "<>";
/* 1488 */           break;
/*      */         default:
/* 1490 */           this.jj_la1[39] = this.jj_gen;
/* 1491 */           jj_consume_token(-1);
/* 1492 */           throw new ParseException();
/*      */         }
/* 1494 */         EntityBeanExpression();
/*      */       } catch (Throwable jjte004) {
/* 1496 */         if (jjtc004) {
/* 1497 */           this.jjtree.clearNodeScope(jjtn004);
/* 1498 */           jjtc004 = false;
/*      */         } else {
/* 1500 */           this.jjtree.popNode();
/*      */         }
/* 1502 */         if ((jjte004 instanceof RuntimeException)) {
/* 1503 */           throw ((RuntimeException)jjte004);
/*      */         }
/* 1505 */         if ((jjte004 instanceof ParseException)) {
/* 1506 */           throw ((ParseException)jjte004);
/*      */         }
/* 1508 */         throw ((Error)jjte004);
/*      */       } finally {
/* 1510 */         if (jjtc004) {
/* 1511 */           this.jjtree.closeNodeScope(jjtn004, true);
/*      */         }
/*      */       }
/* 1514 */       break;
/*      */     default:
/* 1516 */       this.jj_la1[41] = this.jj_gen;
/* 1517 */       if (jj_2_3(2147483647)) {
/* 1518 */         ASTArithmeticComparison jjtn005 = new ASTArithmeticComparison(24);
/* 1519 */         boolean jjtc005 = true;
/* 1520 */         this.jjtree.openNodeScope(jjtn005);
/*      */         try {
/* 1522 */           ArithmeticValue();
/* 1523 */           switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */           case 46:
/* 1525 */             jj_consume_token(46);
/* 1526 */             jjtn005.opp = "=";
/* 1527 */             break;
/*      */           case 44:
/* 1529 */             jj_consume_token(44);
/* 1530 */             jjtn005.opp = ">";
/* 1531 */             break;
/*      */           case 48:
/* 1533 */             jj_consume_token(48);
/* 1534 */             jjtn005.opp = ">=";
/* 1535 */             break;
/*      */           case 45:
/* 1537 */             jj_consume_token(45);
/* 1538 */             jjtn005.opp = "<";
/* 1539 */             break;
/*      */           case 47:
/* 1541 */             jj_consume_token(47);
/* 1542 */             jjtn005.opp = "<=";
/* 1543 */             break;
/*      */           case 49:
/* 1545 */             jj_consume_token(49);
/* 1546 */             jjtn005.opp = "<>";
/* 1547 */             break;
/*      */           default:
/* 1549 */             this.jj_la1[40] = this.jj_gen;
/* 1550 */             jj_consume_token(-1);
/* 1551 */             throw new ParseException();
/*      */           }
/* 1553 */           SingleValueDesignator();
/*      */         } catch (Throwable jjte005) {
/* 1555 */           if (jjtc005) {
/* 1556 */             this.jjtree.clearNodeScope(jjtn005);
/* 1557 */             jjtc005 = false;
/*      */           } else {
/* 1559 */             this.jjtree.popNode();
/*      */           }
/* 1561 */           if ((jjte005 instanceof RuntimeException)) {
/* 1562 */             throw ((RuntimeException)jjte005);
/*      */           }
/* 1564 */           if ((jjte005 instanceof ParseException)) {
/* 1565 */             throw ((ParseException)jjte005);
/*      */           }
/* 1567 */           throw ((Error)jjte005);
/*      */         } finally {
/* 1569 */           if (jjtc005)
/* 1570 */             this.jjtree.closeNodeScope(jjtn005, true);
/*      */         }
/*      */       }
/*      */       else {
/* 1574 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 5:
/*      */         case 16:
/*      */         case 18:
/*      */         case 26:
/*      */         case 39:
/*      */         case 40:
/*      */         case 50:
/*      */         case 51:
/*      */         case 55:
/*      */         case 59:
/*      */         case 70:
/*      */         case 79:
/* 1587 */           BetweenExpression();
/* 1588 */           break;
/*      */         default:
/* 1590 */           this.jj_la1[42] = this.jj_gen;
/* 1591 */           jj_consume_token(-1);
/* 1592 */           throw new ParseException();
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void ArithmeticValue() throws ParseException {
/* 1599 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 79:
/* 1601 */       NumericValuedPath();
/* 1602 */       break;
/*      */     case 5:
/*      */     case 16:
/*      */     case 18:
/*      */     case 26:
/*      */     case 39:
/* 1608 */       FunctionsReturningNumerics();
/* 1609 */       break;
/*      */     default:
/* 1611 */       this.jj_la1[43] = this.jj_gen;
/* 1612 */       jj_consume_token(-1);
/* 1613 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void SingleValueDesignator() throws ParseException {
/* 1618 */     ScalarExpression();
/*      */   }
/*      */ 
/*      */   public final void ScalarExpression() throws ParseException {
/* 1622 */     ArithmeticExpression();
/*      */   }
/*      */ 
/*      */   public final void ArithmeticExpression() throws ParseException {
/* 1626 */     ASTPlusMinus jjtn001 = new ASTPlusMinus(25);
/* 1627 */     boolean jjtc001 = true;
/* 1628 */     this.jjtree.openNodeScope(jjtn001);
/*      */     try {
/* 1630 */       ArithmeticTerm();
/*      */       while (true)
/*      */       {
/* 1633 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */         {
/*      */         case 50:
/*      */         case 51:
/* 1637 */           break;
/*      */         default:
/* 1639 */           this.jj_la1[44] = this.jj_gen;
/* 1640 */           break;
/*      */         }
/* 1642 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 50:
/* 1644 */           jj_consume_token(50);
/* 1645 */           jjtn001.addOpp("+");
/* 1646 */           break;
/*      */         case 51:
/* 1648 */           jj_consume_token(51);
/* 1649 */           jjtn001.addOpp("-");
/* 1650 */           break;
/*      */         default:
/* 1652 */           this.jj_la1[45] = this.jj_gen;
/* 1653 */           jj_consume_token(-1);
/* 1654 */           throw new ParseException();
/*      */         }
/* 1656 */         ArithmeticTerm();
/*      */       }
/*      */     } catch (Throwable jjte001) {
/* 1659 */       if (jjtc001) {
/* 1660 */         this.jjtree.clearNodeScope(jjtn001);
/* 1661 */         jjtc001 = false;
/*      */       } else {
/* 1663 */         this.jjtree.popNode();
/*      */       }
/* 1665 */       if ((jjte001 instanceof RuntimeException)) {
/* 1666 */         throw ((RuntimeException)jjte001);
/*      */       }
/* 1668 */       if ((jjte001 instanceof ParseException)) {
/* 1669 */         throw ((ParseException)jjte001);
/*      */       }
/* 1671 */       throw ((Error)jjte001);
/*      */     } finally {
/* 1673 */       if (jjtc001)
/* 1674 */         this.jjtree.closeNodeScope(jjtn001, this.jjtree.nodeArity() > 1);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void ArithmeticTerm() throws ParseException
/*      */   {
/* 1680 */     ASTMultDiv jjtn001 = new ASTMultDiv(26);
/* 1681 */     boolean jjtc001 = true;
/* 1682 */     this.jjtree.openNodeScope(jjtn001);
/*      */     try {
/* 1684 */       ArithmeticFactor();
/*      */       while (true)
/*      */       {
/* 1687 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*      */         {
/*      */         case 52:
/*      */         case 53:
/* 1691 */           break;
/*      */         default:
/* 1693 */           this.jj_la1[46] = this.jj_gen;
/* 1694 */           break;
/*      */         }
/* 1696 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 52:
/* 1698 */           jj_consume_token(52);
/* 1699 */           jjtn001.addOpp("*");
/* 1700 */           break;
/*      */         case 53:
/* 1702 */           jj_consume_token(53);
/* 1703 */           jjtn001.addOpp("/");
/* 1704 */           break;
/*      */         default:
/* 1706 */           this.jj_la1[47] = this.jj_gen;
/* 1707 */           jj_consume_token(-1);
/* 1708 */           throw new ParseException();
/*      */         }
/* 1710 */         ArithmeticFactor();
/*      */       }
/*      */     } catch (Throwable jjte001) {
/* 1713 */       if (jjtc001) {
/* 1714 */         this.jjtree.clearNodeScope(jjtn001);
/* 1715 */         jjtc001 = false;
/*      */       } else {
/* 1717 */         this.jjtree.popNode();
/*      */       }
/* 1719 */       if ((jjte001 instanceof RuntimeException)) {
/* 1720 */         throw ((RuntimeException)jjte001);
/*      */       }
/* 1722 */       if ((jjte001 instanceof ParseException)) {
/* 1723 */         throw ((ParseException)jjte001);
/*      */       }
/* 1725 */       throw ((Error)jjte001);
/*      */     } finally {
/* 1727 */       if (jjtc001)
/* 1728 */         this.jjtree.closeNodeScope(jjtn001, this.jjtree.nodeArity() > 1);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void ArithmeticFactor() throws ParseException
/*      */   {
/* 1734 */     boolean negation = false;
/* 1735 */     ASTNegation jjtn001 = new ASTNegation(27);
/* 1736 */     boolean jjtc001 = true;
/* 1737 */     this.jjtree.openNodeScope(jjtn001);
/*      */     try {
/* 1739 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 50:
/*      */       case 51:
/* 1742 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 50:
/* 1744 */           jj_consume_token(50);
/* 1745 */           break;
/*      */         case 51:
/* 1747 */           jj_consume_token(51);
/* 1748 */           negation = true;
/* 1749 */           break;
/*      */         default:
/* 1751 */           this.jj_la1[48] = this.jj_gen;
/* 1752 */           jj_consume_token(-1);
/* 1753 */           throw new ParseException();
/*      */         }
/*      */ 
/*      */       default:
/* 1757 */         this.jj_la1[49] = this.jj_gen;
/*      */       }
/*      */ 
/* 1760 */       ArithmeticPrimary();
/*      */     } catch (Throwable jjte001) {
/* 1762 */       if (jjtc001) {
/* 1763 */         this.jjtree.clearNodeScope(jjtn001);
/* 1764 */         jjtc001 = false;
/*      */       } else {
/* 1766 */         this.jjtree.popNode();
/*      */       }
/* 1768 */       if ((jjte001 instanceof RuntimeException)) {
/* 1769 */         throw ((RuntimeException)jjte001);
/*      */       }
/* 1771 */       if ((jjte001 instanceof ParseException)) {
/* 1772 */         throw ((ParseException)jjte001);
/*      */       }
/* 1774 */       throw ((Error)jjte001);
/*      */     } finally {
/* 1776 */       if (jjtc001)
/* 1777 */         this.jjtree.closeNodeScope(jjtn001, negation);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void ArithmeticPrimary() throws ParseException
/*      */   {
/* 1783 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 79:
/* 1785 */       NumericValuedPath();
/* 1786 */       break;
/*      */     case 55:
/*      */     case 59:
/* 1789 */       NumericLiteral();
/* 1790 */       break;
/*      */     case 40:
/* 1792 */       ASTArithmeticParenthetical jjtn001 = new ASTArithmeticParenthetical(28);
/* 1793 */       boolean jjtc001 = true;
/* 1794 */       this.jjtree.openNodeScope(jjtn001);
/*      */       try {
/* 1796 */         jj_consume_token(40);
/* 1797 */         ArithmeticExpression();
/* 1798 */         jj_consume_token(41);
/*      */       } catch (Throwable jjte001) {
/* 1800 */         if (jjtc001) {
/* 1801 */           this.jjtree.clearNodeScope(jjtn001);
/* 1802 */           jjtc001 = false;
/*      */         } else {
/* 1804 */           this.jjtree.popNode();
/*      */         }
/* 1806 */         if ((jjte001 instanceof RuntimeException)) {
/* 1807 */           throw ((RuntimeException)jjte001);
/*      */         }
/* 1809 */         if ((jjte001 instanceof ParseException)) {
/* 1810 */           throw ((ParseException)jjte001);
/*      */         }
/* 1812 */         throw ((Error)jjte001);
/*      */       } finally {
/* 1814 */         if (jjtc001) {
/* 1815 */           this.jjtree.closeNodeScope(jjtn001, true);
/*      */         }
/*      */       }
/* 1818 */       break;
/*      */     case 70:
/* 1820 */       NumericValuedParameter();
/* 1821 */       break;
/*      */     case 5:
/*      */     case 16:
/*      */     case 18:
/*      */     case 26:
/*      */     case 39:
/* 1827 */       FunctionsReturningNumerics();
/* 1828 */       break;
/*      */     default:
/* 1830 */       this.jj_la1[50] = this.jj_gen;
/* 1831 */       jj_consume_token(-1);
/* 1832 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void StringValue() throws ParseException {
/* 1837 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 80:
/* 1839 */       StringValuedPath();
/* 1840 */       break;
/*      */     case 9:
/*      */     case 25:
/* 1843 */       FunctionsReturningStrings();
/* 1844 */       break;
/*      */     default:
/* 1846 */       this.jj_la1[51] = this.jj_gen;
/* 1847 */       jj_consume_token(-1);
/* 1848 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void StringExpression() throws ParseException {
/* 1853 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 9:
/*      */     case 25:
/*      */     case 40:
/*      */     case 54:
/*      */     case 80:
/* 1859 */       StringPrimary();
/* 1860 */       break;
/*      */     case 71:
/* 1862 */       StringValuedParameter();
/* 1863 */       break;
/*      */     default:
/* 1865 */       this.jj_la1[52] = this.jj_gen;
/* 1866 */       jj_consume_token(-1);
/* 1867 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void StringPrimary() throws ParseException {
/* 1872 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 80:
/* 1874 */       StringValuedPath();
/* 1875 */       break;
/*      */     case 54:
/* 1877 */       StringLiteral();
/* 1878 */       break;
/*      */     case 40:
/* 1880 */       ASTStringParenthetical jjtn001 = new ASTStringParenthetical(29);
/* 1881 */       boolean jjtc001 = true;
/* 1882 */       this.jjtree.openNodeScope(jjtn001);
/*      */       try {
/* 1884 */         jj_consume_token(40);
/* 1885 */         StringExpression();
/* 1886 */         jj_consume_token(41);
/*      */       } catch (Throwable jjte001) {
/* 1888 */         if (jjtc001) {
/* 1889 */           this.jjtree.clearNodeScope(jjtn001);
/* 1890 */           jjtc001 = false;
/*      */         } else {
/* 1892 */           this.jjtree.popNode();
/*      */         }
/* 1894 */         if ((jjte001 instanceof RuntimeException)) {
/* 1895 */           throw ((RuntimeException)jjte001);
/*      */         }
/* 1897 */         if ((jjte001 instanceof ParseException)) {
/* 1898 */           throw ((ParseException)jjte001);
/*      */         }
/* 1900 */         throw ((Error)jjte001);
/*      */       } finally {
/* 1902 */         if (jjtc001) {
/* 1903 */           this.jjtree.closeNodeScope(jjtn001, true);
/*      */         }
/*      */       }
/* 1906 */       break;
/*      */     case 9:
/*      */     case 25:
/* 1909 */       FunctionsReturningStrings();
/* 1910 */       break;
/*      */     default:
/* 1912 */       this.jj_la1[53] = this.jj_gen;
/* 1913 */       jj_consume_token(-1);
/* 1914 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void DatetimeValue() throws ParseException {
/* 1919 */     DatetimeValuedPath();
/*      */   }
/*      */ 
/*      */   public final void DatetimeExpression() throws ParseException {
/* 1923 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 81:
/* 1925 */       DatetimeValue();
/* 1926 */       break;
/*      */     case 72:
/* 1928 */       DatetimeValuedParameter();
/* 1929 */       break;
/*      */     default:
/* 1931 */       this.jj_la1[54] = this.jj_gen;
/* 1932 */       jj_consume_token(-1);
/* 1933 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void BooleanValue() throws ParseException {
/* 1938 */     BooleanValuedPath();
/*      */   }
/*      */ 
/*      */   public final void BooleanExpression() throws ParseException {
/* 1942 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 82:
/* 1944 */       BooleanValue();
/* 1945 */       break;
/*      */     case 73:
/* 1947 */       BooleanValuedParameter();
/* 1948 */       break;
/*      */     case 61:
/*      */     case 62:
/* 1951 */       BooleanLiteral();
/* 1952 */       break;
/*      */     default:
/* 1954 */       this.jj_la1[55] = this.jj_gen;
/* 1955 */       jj_consume_token(-1);
/* 1956 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void EntityBeanValue() throws ParseException {
/* 1961 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 83:
/* 1963 */       EntityValuedPath();
/* 1964 */       break;
/*      */     case 65:
/* 1966 */       IdentificationVariable();
/* 1967 */       break;
/*      */     default:
/* 1969 */       this.jj_la1[56] = this.jj_gen;
/* 1970 */       jj_consume_token(-1);
/* 1971 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void EntityBeanExpression() throws ParseException {
/* 1976 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 65:
/*      */     case 83:
/* 1979 */       EntityBeanValue();
/* 1980 */       break;
/*      */     case 74:
/* 1982 */       EntityValuedParameter();
/* 1983 */       break;
/*      */     default:
/* 1985 */       this.jj_la1[57] = this.jj_gen;
/* 1986 */       jj_consume_token(-1);
/* 1987 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void FunctionsReturningStrings() throws ParseException {
/* 1992 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 9:
/* 1994 */       ASTConcat jjtn001 = new ASTConcat(30);
/* 1995 */       boolean jjtc001 = true;
/* 1996 */       this.jjtree.openNodeScope(jjtn001);
/*      */       try {
/* 1998 */         jj_consume_token(9);
/* 1999 */         jj_consume_token(40);
/* 2000 */         StringExpression();
/* 2001 */         jj_consume_token(42);
/* 2002 */         StringExpression();
/* 2003 */         jj_consume_token(41);
/*      */       } catch (Throwable jjte001) {
/* 2005 */         if (jjtc001) {
/* 2006 */           this.jjtree.clearNodeScope(jjtn001);
/* 2007 */           jjtc001 = false;
/*      */         } else {
/* 2009 */           this.jjtree.popNode();
/*      */         }
/* 2011 */         if ((jjte001 instanceof RuntimeException)) {
/* 2012 */           throw ((RuntimeException)jjte001);
/*      */         }
/* 2014 */         if ((jjte001 instanceof ParseException)) {
/* 2015 */           throw ((ParseException)jjte001);
/*      */         }
/* 2017 */         throw ((Error)jjte001);
/*      */       } finally {
/* 2019 */         if (jjtc001) {
/* 2020 */           this.jjtree.closeNodeScope(jjtn001, true);
/*      */         }
/*      */       }
/* 2023 */       break;
/*      */     case 25:
/* 2025 */       ASTSubstring jjtn002 = new ASTSubstring(31);
/* 2026 */       boolean jjtc002 = true;
/* 2027 */       this.jjtree.openNodeScope(jjtn002);
/*      */       try {
/* 2029 */         jj_consume_token(25);
/* 2030 */         jj_consume_token(40);
/* 2031 */         StringExpression();
/* 2032 */         jj_consume_token(42);
/* 2033 */         ArithmeticExpression();
/* 2034 */         jj_consume_token(42);
/* 2035 */         ArithmeticExpression();
/* 2036 */         jj_consume_token(41);
/*      */       } catch (Throwable jjte002) {
/* 2038 */         if (jjtc002) {
/* 2039 */           this.jjtree.clearNodeScope(jjtn002);
/* 2040 */           jjtc002 = false;
/*      */         } else {
/* 2042 */           this.jjtree.popNode();
/*      */         }
/* 2044 */         if ((jjte002 instanceof RuntimeException)) {
/* 2045 */           throw ((RuntimeException)jjte002);
/*      */         }
/* 2047 */         if ((jjte002 instanceof ParseException)) {
/* 2048 */           throw ((ParseException)jjte002);
/*      */         }
/* 2050 */         throw ((Error)jjte002);
/*      */       } finally {
/* 2052 */         if (jjtc002) {
/* 2053 */           this.jjtree.closeNodeScope(jjtn002, true);
/*      */         }
/*      */       }
/* 2056 */       break;
/*      */     default:
/* 2058 */       this.jj_la1[58] = this.jj_gen;
/* 2059 */       jj_consume_token(-1);
/* 2060 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void FunctionsReturningNumerics() throws ParseException {
/* 2065 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 16:
/* 2067 */       ASTLength jjtn001 = new ASTLength(32);
/* 2068 */       boolean jjtc001 = true;
/* 2069 */       this.jjtree.openNodeScope(jjtn001);
/*      */       try {
/* 2071 */         jj_consume_token(16);
/* 2072 */         jj_consume_token(40);
/* 2073 */         StringExpression();
/* 2074 */         jj_consume_token(41);
/*      */       } catch (Throwable jjte001) {
/* 2076 */         if (jjtc001) {
/* 2077 */           this.jjtree.clearNodeScope(jjtn001);
/* 2078 */           jjtc001 = false;
/*      */         } else {
/* 2080 */           this.jjtree.popNode();
/*      */         }
/* 2082 */         if ((jjte001 instanceof RuntimeException)) {
/* 2083 */           throw ((RuntimeException)jjte001);
/*      */         }
/* 2085 */         if ((jjte001 instanceof ParseException)) {
/* 2086 */           throw ((ParseException)jjte001);
/*      */         }
/* 2088 */         throw ((Error)jjte001);
/*      */       } finally {
/* 2090 */         if (jjtc001) {
/* 2091 */           this.jjtree.closeNodeScope(jjtn001, true);
/*      */         }
/*      */       }
/* 2094 */       break;
/*      */     case 18:
/* 2096 */       ASTLocate jjtn002 = new ASTLocate(33);
/* 2097 */       boolean jjtc002 = true;
/* 2098 */       this.jjtree.openNodeScope(jjtn002);
/*      */       try {
/* 2100 */         jj_consume_token(18);
/* 2101 */         jj_consume_token(40);
/* 2102 */         StringExpression();
/* 2103 */         jj_consume_token(42);
/* 2104 */         StringExpression();
/* 2105 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 42:
/* 2107 */           jj_consume_token(42);
/* 2108 */           ArithmeticExpression();
/* 2109 */           break;
/*      */         default:
/* 2111 */           this.jj_la1[59] = this.jj_gen;
/*      */         }
/*      */ 
/* 2114 */         jj_consume_token(41);
/*      */       } catch (Throwable jjte002) {
/* 2116 */         if (jjtc002) {
/* 2117 */           this.jjtree.clearNodeScope(jjtn002);
/* 2118 */           jjtc002 = false;
/*      */         } else {
/* 2120 */           this.jjtree.popNode();
/*      */         }
/* 2122 */         if ((jjte002 instanceof RuntimeException)) {
/* 2123 */           throw ((RuntimeException)jjte002);
/*      */         }
/* 2125 */         if ((jjte002 instanceof ParseException)) {
/* 2126 */           throw ((ParseException)jjte002);
/*      */         }
/* 2128 */         throw ((Error)jjte002);
/*      */       } finally {
/* 2130 */         if (jjtc002) {
/* 2131 */           this.jjtree.closeNodeScope(jjtn002, true);
/*      */         }
/*      */       }
/* 2134 */       break;
/*      */     case 5:
/* 2136 */       ASTAbs jjtn003 = new ASTAbs(34);
/* 2137 */       boolean jjtc003 = true;
/* 2138 */       this.jjtree.openNodeScope(jjtn003);
/*      */       try {
/* 2140 */         jj_consume_token(5);
/* 2141 */         jj_consume_token(40);
/* 2142 */         ArithmeticExpression();
/* 2143 */         jj_consume_token(41);
/*      */       } catch (Throwable jjte003) {
/* 2145 */         if (jjtc003) {
/* 2146 */           this.jjtree.clearNodeScope(jjtn003);
/* 2147 */           jjtc003 = false;
/*      */         } else {
/* 2149 */           this.jjtree.popNode();
/*      */         }
/* 2151 */         if ((jjte003 instanceof RuntimeException)) {
/* 2152 */           throw ((RuntimeException)jjte003);
/*      */         }
/* 2154 */         if ((jjte003 instanceof ParseException)) {
/* 2155 */           throw ((ParseException)jjte003);
/*      */         }
/* 2157 */         throw ((Error)jjte003);
/*      */       } finally {
/* 2159 */         if (jjtc003) {
/* 2160 */           this.jjtree.closeNodeScope(jjtn003, true);
/*      */         }
/*      */       }
/* 2163 */       break;
/*      */     case 26:
/* 2165 */       ASTSqrt jjtn004 = new ASTSqrt(35);
/* 2166 */       boolean jjtc004 = true;
/* 2167 */       this.jjtree.openNodeScope(jjtn004);
/*      */       try {
/* 2169 */         jj_consume_token(26);
/* 2170 */         jj_consume_token(40);
/* 2171 */         ArithmeticExpression();
/* 2172 */         jj_consume_token(41);
/*      */       } catch (Throwable jjte004) {
/* 2174 */         if (jjtc004) {
/* 2175 */           this.jjtree.clearNodeScope(jjtn004);
/* 2176 */           jjtc004 = false;
/*      */         } else {
/* 2178 */           this.jjtree.popNode();
/*      */         }
/* 2180 */         if ((jjte004 instanceof RuntimeException)) {
/* 2181 */           throw ((RuntimeException)jjte004);
/*      */         }
/* 2183 */         if ((jjte004 instanceof ParseException)) {
/* 2184 */           throw ((ParseException)jjte004);
/*      */         }
/* 2186 */         throw ((Error)jjte004);
/*      */       } finally {
/* 2188 */         if (jjtc004) {
/* 2189 */           this.jjtree.closeNodeScope(jjtn004, true);
/*      */         }
/*      */       }
/* 2192 */       break;
/*      */     case 39:
/* 2194 */       ASTMod jjtn005 = new ASTMod(36);
/* 2195 */       boolean jjtc005 = true;
/* 2196 */       this.jjtree.openNodeScope(jjtn005);
/*      */       try {
/* 2198 */         jj_consume_token(39);
/* 2199 */         jj_consume_token(40);
/* 2200 */         ArithmeticExpression();
/* 2201 */         jj_consume_token(42);
/* 2202 */         ArithmeticExpression();
/* 2203 */         jj_consume_token(41);
/*      */       } catch (Throwable jjte005) {
/* 2205 */         if (jjtc005) {
/* 2206 */           this.jjtree.clearNodeScope(jjtn005);
/* 2207 */           jjtc005 = false;
/*      */         } else {
/* 2209 */           this.jjtree.popNode();
/*      */         }
/* 2211 */         if ((jjte005 instanceof RuntimeException)) {
/* 2212 */           throw ((RuntimeException)jjte005);
/*      */         }
/* 2214 */         if ((jjte005 instanceof ParseException)) {
/* 2215 */           throw ((ParseException)jjte005);
/*      */         }
/* 2217 */         throw ((Error)jjte005);
/*      */       } finally {
/* 2219 */         if (jjtc005) {
/* 2220 */           this.jjtree.closeNodeScope(jjtn005, true);
/*      */         }
/*      */       }
/* 2223 */       break;
/*      */     default:
/* 2225 */       this.jj_la1[60] = this.jj_gen;
/* 2226 */       jj_consume_token(-1);
/* 2227 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final Token CollectionValuedPath() throws ParseException
/*      */   {
/* 2233 */     ASTPath jjtn000 = new ASTPath(37);
/* 2234 */     boolean jjtc000 = true;
/* 2235 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 2237 */       Token t = jj_consume_token(86);
/* 2238 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 2239 */       jjtc000 = false;
/* 2240 */       initPathNode(jjtn000, t.image, 5);
/* 2241 */       localToken1 = t;
/*      */     }
/*      */     finally
/*      */     {
/*      */       Token localToken1;
/* 2243 */       if (jjtc000)
/* 2244 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final Token IdentificationVariable()
/*      */     throws ParseException
/*      */   {
/* 2252 */     ASTPath jjtn000 = new ASTPath(37);
/* 2253 */     boolean jjtc000 = true;
/* 2254 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 2256 */       Token t = jj_consume_token(65);
/* 2257 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 2258 */       jjtc000 = false;
/* 2259 */       t.image = t.image.toLowerCase();
/* 2260 */       initPathNode(jjtn000, t.image, 5);
/* 2261 */       localToken1 = t;
/*      */     }
/*      */     finally
/*      */     {
/*      */       Token localToken1;
/* 2263 */       if (jjtc000)
/* 2264 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final Token AbstractSchema()
/*      */     throws ParseException
/*      */   {
/* 2272 */     ASTAbstractSchema jjtn000 = new ASTAbstractSchema(38);
/* 2273 */     boolean jjtc000 = true;
/* 2274 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try
/*      */     {
/*      */       Token t;
/*      */       Token localToken1;
/* 2276 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 64:
/* 2278 */         t = jj_consume_token(64);
/* 2279 */         this.jjtree.closeNodeScope(jjtn000, true);
/* 2280 */         jjtc000 = false;
/* 2281 */         jjtn000.abstractSchemaName = t.image;
/* 2282 */         jjtn000.entity = this.catalog.getEntityByAbstractSchemaName(t.image);
/* 2283 */         localToken1 = t; jsr 89;
/*      */       case 30:
/* 2286 */         t = jj_consume_token(30);
/* 2287 */         this.jjtree.closeNodeScope(jjtn000, true);
/* 2288 */         jjtc000 = false;
/* 2289 */         jjtn000.abstractSchemaName = t.image;
/* 2290 */         jjtn000.entity = this.catalog.getEntityByAbstractSchemaName(t.image);
/* 2291 */         localToken1 = t; jsr 39;
/*      */       }
/*      */ 
/* 2294 */       this.jj_la1[61] = this.jj_gen;
/* 2295 */       jj_consume_token(-1);
/* 2296 */       throw new ParseException();
/*      */     }
/*      */     finally {
/* 2299 */       jsr 6; throw localObject1; localObject2 = returnAddress; if (jjtc000)
/* 2300 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final Token Identifier()
/*      */     throws ParseException
/*      */   {
/* 2308 */     ASTIdentifier jjtn000 = new ASTIdentifier(39);
/* 2309 */     boolean jjtc000 = true;
/* 2310 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 2312 */       Token t = jj_consume_token(63);
/* 2313 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 2314 */       jjtc000 = false;
/* 2315 */       t.image = t.image.toLowerCase();
/* 2316 */       jjtn000.identifier = t.image;
/* 2317 */       localToken1 = t;
/*      */     }
/*      */     finally
/*      */     {
/*      */       Token localToken1;
/* 2319 */       if (jjtc000)
/* 2320 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void SingleValuedPath()
/*      */     throws ParseException
/*      */   {
/* 2327 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 79:
/* 2329 */       NumericValuedPath();
/* 2330 */       break;
/*      */     case 80:
/* 2332 */       StringValuedPath();
/* 2333 */       break;
/*      */     case 81:
/* 2335 */       DatetimeValuedPath();
/* 2336 */       break;
/*      */     case 82:
/* 2338 */       BooleanValuedPath();
/* 2339 */       break;
/*      */     case 83:
/* 2341 */       EntityValuedPath();
/* 2342 */       break;
/*      */     case 84:
/* 2344 */       ValueClassValuedPath();
/* 2345 */       break;
/*      */     default:
/* 2347 */       this.jj_la1[62] = this.jj_gen;
/* 2348 */       jj_consume_token(-1);
/* 2349 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void NumericValuedPath() throws ParseException
/*      */   {
/* 2355 */     ASTPath jjtn000 = new ASTPath(37);
/* 2356 */     boolean jjtc000 = true;
/* 2357 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 2359 */       Token t = jj_consume_token(79);
/* 2360 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 2361 */       jjtc000 = false;
/* 2362 */       initPathNode(jjtn000, t.image, 1);
/*      */     } finally {
/* 2364 */       if (jjtc000)
/* 2365 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void StringValuedPath()
/*      */     throws ParseException
/*      */   {
/* 2372 */     ASTPath jjtn000 = new ASTPath(37);
/* 2373 */     boolean jjtc000 = true;
/* 2374 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 2376 */       Token t = jj_consume_token(80);
/* 2377 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 2378 */       jjtc000 = false;
/* 2379 */       initPathNode(jjtn000, t.image, 2);
/*      */     } finally {
/* 2381 */       if (jjtc000)
/* 2382 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void DatetimeValuedPath()
/*      */     throws ParseException
/*      */   {
/* 2389 */     ASTPath jjtn000 = new ASTPath(37);
/* 2390 */     boolean jjtc000 = true;
/* 2391 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 2393 */       Token t = jj_consume_token(81);
/* 2394 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 2395 */       jjtc000 = false;
/* 2396 */       initPathNode(jjtn000, t.image, 3);
/*      */     } finally {
/* 2398 */       if (jjtc000)
/* 2399 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void BooleanValuedPath()
/*      */     throws ParseException
/*      */   {
/* 2406 */     ASTPath jjtn000 = new ASTPath(37);
/* 2407 */     boolean jjtc000 = true;
/* 2408 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 2410 */       Token t = jj_consume_token(82);
/* 2411 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 2412 */       jjtc000 = false;
/* 2413 */       initPathNode(jjtn000, t.image, 4);
/*      */     } finally {
/* 2415 */       if (jjtc000)
/* 2416 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void EntityValuedPath()
/*      */     throws ParseException
/*      */   {
/* 2423 */     ASTPath jjtn000 = new ASTPath(37);
/* 2424 */     boolean jjtc000 = true;
/* 2425 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 2427 */       Token t = jj_consume_token(83);
/* 2428 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 2429 */       jjtc000 = false;
/* 2430 */       initPathNode(jjtn000, t.image, 5);
/*      */     } finally {
/* 2432 */       if (jjtc000)
/* 2433 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void ValueClassValuedPath()
/*      */     throws ParseException
/*      */   {
/* 2440 */     ASTPath jjtn000 = new ASTPath(37);
/* 2441 */     boolean jjtc000 = true;
/* 2442 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 2444 */       Token t = jj_consume_token(84);
/* 2445 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 2446 */       jjtc000 = false;
/* 2447 */       initPathNode(jjtn000, t.image, 6);
/*      */     } finally {
/* 2449 */       if (jjtc000)
/* 2450 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void NumericValuedParameter()
/*      */     throws ParseException
/*      */   {
/* 2457 */     ASTParameter jjtn000 = new ASTParameter(40);
/* 2458 */     boolean jjtc000 = true;
/* 2459 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 2461 */       Token t = jj_consume_token(70);
/* 2462 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 2463 */       jjtc000 = false;
/* 2464 */       initParameterNode(jjtn000, t.image, 1);
/*      */     } finally {
/* 2466 */       if (jjtc000)
/* 2467 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void StringValuedParameter()
/*      */     throws ParseException
/*      */   {
/* 2474 */     ASTParameter jjtn000 = new ASTParameter(40);
/* 2475 */     boolean jjtc000 = true;
/* 2476 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 2478 */       Token t = jj_consume_token(71);
/* 2479 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 2480 */       jjtc000 = false;
/* 2481 */       initParameterNode(jjtn000, t.image, 2);
/*      */     } finally {
/* 2483 */       if (jjtc000)
/* 2484 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void DatetimeValuedParameter()
/*      */     throws ParseException
/*      */   {
/* 2491 */     ASTParameter jjtn000 = new ASTParameter(40);
/* 2492 */     boolean jjtc000 = true;
/* 2493 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 2495 */       Token t = jj_consume_token(72);
/* 2496 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 2497 */       jjtc000 = false;
/* 2498 */       initParameterNode(jjtn000, t.image, 3);
/*      */     } finally {
/* 2500 */       if (jjtc000)
/* 2501 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void BooleanValuedParameter()
/*      */     throws ParseException
/*      */   {
/* 2508 */     ASTParameter jjtn000 = new ASTParameter(40);
/* 2509 */     boolean jjtc000 = true;
/* 2510 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 2512 */       Token t = jj_consume_token(73);
/* 2513 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 2514 */       jjtc000 = false;
/* 2515 */       initParameterNode(jjtn000, t.image, 4);
/*      */     } finally {
/* 2517 */       if (jjtc000)
/* 2518 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void EntityValuedParameter()
/*      */     throws ParseException
/*      */   {
/* 2525 */     ASTParameter jjtn000 = new ASTParameter(40);
/* 2526 */     boolean jjtc000 = true;
/* 2527 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 2529 */       Token t = jj_consume_token(74);
/* 2530 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 2531 */       jjtc000 = false;
/* 2532 */       initParameterNode(jjtn000, t.image, 5);
/*      */     } finally {
/* 2534 */       if (jjtc000)
/* 2535 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void ValueClassValuedParameter()
/*      */     throws ParseException
/*      */   {
/* 2542 */     ASTParameter jjtn000 = new ASTParameter(40);
/* 2543 */     boolean jjtc000 = true;
/* 2544 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 2546 */       Token t = jj_consume_token(75);
/* 2547 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 2548 */       jjtc000 = false;
/* 2549 */       initParameterNode(jjtn000, t.image, 6);
/*      */     } finally {
/* 2551 */       if (jjtc000)
/* 2552 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void NumericLiteral()
/*      */     throws ParseException
/*      */   {
/*      */     Token t;
/* 2559 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 55:
/* 2561 */       ASTExactNumericLiteral jjtn001 = new ASTExactNumericLiteral(41);
/* 2562 */       boolean jjtc001 = true;
/* 2563 */       this.jjtree.openNodeScope(jjtn001);
/*      */       try {
/* 2565 */         t = jj_consume_token(55);
/* 2566 */         this.jjtree.closeNodeScope(jjtn001, true);
/* 2567 */         jjtc001 = false;
/* 2568 */         jjtn001.setValue(t.image);
/*      */       } finally {
/* 2570 */         if (jjtc001) {
/* 2571 */           this.jjtree.closeNodeScope(jjtn001, true);
/*      */         }
/*      */       }
/* 2574 */       break;
/*      */     case 59:
/* 2576 */       ASTApproximateNumericLiteral jjtn002 = new ASTApproximateNumericLiteral(42);
/* 2577 */       boolean jjtc002 = true;
/* 2578 */       this.jjtree.openNodeScope(jjtn002);
/*      */       try {
/* 2580 */         t = jj_consume_token(59);
/* 2581 */         this.jjtree.closeNodeScope(jjtn002, true);
/* 2582 */         jjtc002 = false;
/* 2583 */         jjtn002.setValue(t.image);
/*      */       } finally {
/* 2585 */         if (jjtc002) {
/* 2586 */           this.jjtree.closeNodeScope(jjtn002, true);
/*      */         }
/*      */       }
/* 2589 */       break;
/*      */     default:
/* 2591 */       this.jj_la1[63] = this.jj_gen;
/* 2592 */       jj_consume_token(-1);
/* 2593 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void StringLiteral() throws ParseException
/*      */   {
/* 2599 */     ASTStringLiteral jjtn000 = new ASTStringLiteral(43);
/* 2600 */     boolean jjtc000 = true;
/* 2601 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 2603 */       Token t = jj_consume_token(54);
/* 2604 */       this.jjtree.closeNodeScope(jjtn000, true);
/* 2605 */       jjtc000 = false;
/* 2606 */       jjtn000.value = t.image;
/*      */     } finally {
/* 2608 */       if (jjtc000)
/* 2609 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void BooleanLiteral()
/*      */     throws ParseException
/*      */   {
/* 2616 */     ASTBooleanLiteral jjtn000 = new ASTBooleanLiteral(44);
/* 2617 */     boolean jjtc000 = true;
/* 2618 */     this.jjtree.openNodeScope(jjtn000);
/*      */     try {
/* 2620 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */       case 62:
/* 2622 */         jj_consume_token(62);
/* 2623 */         this.jjtree.closeNodeScope(jjtn000, true);
/* 2624 */         jjtc000 = false;
/* 2625 */         jjtn000.value = true;
/* 2626 */         break;
/*      */       case 61:
/* 2628 */         jj_consume_token(61);
/* 2629 */         this.jjtree.closeNodeScope(jjtn000, true);
/* 2630 */         jjtc000 = false;
/* 2631 */         jjtn000.value = false;
/* 2632 */         break;
/*      */       default:
/* 2634 */         this.jj_la1[64] = this.jj_gen;
/* 2635 */         jj_consume_token(-1);
/* 2636 */         throw new ParseException();
/*      */       }
/*      */     } finally {
/* 2639 */       if (jjtc000)
/* 2640 */         this.jjtree.closeNodeScope(jjtn000, true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void AggregateSelectExpression() throws ParseException
/*      */   {
/* 2646 */     switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */     case 37:
/* 2648 */       ASTAvg jjtn001 = new ASTAvg(45);
/* 2649 */       boolean jjtc001 = true;
/* 2650 */       this.jjtree.openNodeScope(jjtn001);
/*      */       try {
/* 2652 */         jj_consume_token(37);
/* 2653 */         jj_consume_token(40);
/* 2654 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 10:
/* 2656 */           jj_consume_token(10);
/* 2657 */           jjtn001.distinct = "DISTINCT";
/* 2658 */           break;
/*      */         default:
/* 2660 */           this.jj_la1[65] = this.jj_gen;
/*      */         }
/*      */ 
/* 2663 */         SingleValuedPath();
/* 2664 */         jj_consume_token(41);
/*      */       } catch (Throwable jjte001) {
/* 2666 */         if (jjtc001) {
/* 2667 */           this.jjtree.clearNodeScope(jjtn001);
/* 2668 */           jjtc001 = false;
/*      */         } else {
/* 2670 */           this.jjtree.popNode();
/*      */         }
/* 2672 */         if ((jjte001 instanceof RuntimeException)) {
/* 2673 */           throw ((RuntimeException)jjte001);
/*      */         }
/* 2675 */         if ((jjte001 instanceof ParseException)) {
/* 2676 */           throw ((ParseException)jjte001);
/*      */         }
/* 2678 */         throw ((Error)jjte001);
/*      */       } finally {
/* 2680 */         if (jjtc001) {
/* 2681 */           this.jjtree.closeNodeScope(jjtn001, true);
/*      */         }
/*      */       }
/* 2684 */       break;
/*      */     case 35:
/* 2686 */       ASTMax jjtn002 = new ASTMax(46);
/* 2687 */       boolean jjtc002 = true;
/* 2688 */       this.jjtree.openNodeScope(jjtn002);
/*      */       try {
/* 2690 */         jj_consume_token(35);
/* 2691 */         jj_consume_token(40);
/* 2692 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 10:
/* 2694 */           jj_consume_token(10);
/* 2695 */           jjtn002.distinct = "DISTINCT";
/* 2696 */           break;
/*      */         default:
/* 2698 */           this.jj_la1[66] = this.jj_gen;
/*      */         }
/*      */ 
/* 2701 */         SingleValuedPath();
/* 2702 */         jj_consume_token(41);
/*      */       } catch (Throwable jjte002) {
/* 2704 */         if (jjtc002) {
/* 2705 */           this.jjtree.clearNodeScope(jjtn002);
/* 2706 */           jjtc002 = false;
/*      */         } else {
/* 2708 */           this.jjtree.popNode();
/*      */         }
/* 2710 */         if ((jjte002 instanceof RuntimeException)) {
/* 2711 */           throw ((RuntimeException)jjte002);
/*      */         }
/* 2713 */         if ((jjte002 instanceof ParseException)) {
/* 2714 */           throw ((ParseException)jjte002);
/*      */         }
/* 2716 */         throw ((Error)jjte002);
/*      */       } finally {
/* 2718 */         if (jjtc002) {
/* 2719 */           this.jjtree.closeNodeScope(jjtn002, true);
/*      */         }
/*      */       }
/* 2722 */       break;
/*      */     case 36:
/* 2724 */       ASTMin jjtn003 = new ASTMin(47);
/* 2725 */       boolean jjtc003 = true;
/* 2726 */       this.jjtree.openNodeScope(jjtn003);
/*      */       try {
/* 2728 */         jj_consume_token(36);
/* 2729 */         jj_consume_token(40);
/* 2730 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 10:
/* 2732 */           jj_consume_token(10);
/* 2733 */           jjtn003.distinct = "DISTINCT";
/* 2734 */           break;
/*      */         default:
/* 2736 */           this.jj_la1[67] = this.jj_gen;
/*      */         }
/*      */ 
/* 2739 */         SingleValuedPath();
/* 2740 */         jj_consume_token(41);
/*      */       } catch (Throwable jjte003) {
/* 2742 */         if (jjtc003) {
/* 2743 */           this.jjtree.clearNodeScope(jjtn003);
/* 2744 */           jjtc003 = false;
/*      */         } else {
/* 2746 */           this.jjtree.popNode();
/*      */         }
/* 2748 */         if ((jjte003 instanceof RuntimeException)) {
/* 2749 */           throw ((RuntimeException)jjte003);
/*      */         }
/* 2751 */         if ((jjte003 instanceof ParseException)) {
/* 2752 */           throw ((ParseException)jjte003);
/*      */         }
/* 2754 */         throw ((Error)jjte003);
/*      */       } finally {
/* 2756 */         if (jjtc003) {
/* 2757 */           this.jjtree.closeNodeScope(jjtn003, true);
/*      */         }
/*      */       }
/* 2760 */       break;
/*      */     case 38:
/* 2762 */       ASTSum jjtn004 = new ASTSum(48);
/* 2763 */       boolean jjtc004 = true;
/* 2764 */       this.jjtree.openNodeScope(jjtn004);
/*      */       try {
/* 2766 */         jj_consume_token(38);
/* 2767 */         jj_consume_token(40);
/* 2768 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 10:
/* 2770 */           jj_consume_token(10);
/* 2771 */           jjtn004.distinct = "DISTINCT";
/* 2772 */           break;
/*      */         default:
/* 2774 */           this.jj_la1[68] = this.jj_gen;
/*      */         }
/*      */ 
/* 2777 */         SingleValuedPath();
/* 2778 */         jj_consume_token(41);
/*      */       } catch (Throwable jjte004) {
/* 2780 */         if (jjtc004) {
/* 2781 */           this.jjtree.clearNodeScope(jjtn004);
/* 2782 */           jjtc004 = false;
/*      */         } else {
/* 2784 */           this.jjtree.popNode();
/*      */         }
/* 2786 */         if ((jjte004 instanceof RuntimeException)) {
/* 2787 */           throw ((RuntimeException)jjte004);
/*      */         }
/* 2789 */         if ((jjte004 instanceof ParseException)) {
/* 2790 */           throw ((ParseException)jjte004);
/*      */         }
/* 2792 */         throw ((Error)jjte004);
/*      */       } finally {
/* 2794 */         if (jjtc004) {
/* 2795 */           this.jjtree.closeNodeScope(jjtn004, true);
/*      */         }
/*      */       }
/* 2798 */       break;
/*      */     case 34:
/* 2800 */       ASTCount jjtn005 = new ASTCount(49);
/* 2801 */       boolean jjtc005 = true;
/* 2802 */       this.jjtree.openNodeScope(jjtn005);
/*      */       try {
/* 2804 */         jj_consume_token(34);
/* 2805 */         jj_consume_token(40);
/* 2806 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 10:
/* 2808 */           jj_consume_token(10);
/* 2809 */           jjtn005.distinct = "DISTINCT";
/* 2810 */           break;
/*      */         default:
/* 2812 */           this.jj_la1[69] = this.jj_gen;
/*      */         }
/*      */ 
/* 2815 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*      */         case 79:
/*      */         case 80:
/*      */         case 81:
/*      */         case 82:
/*      */         case 83:
/*      */         case 84:
/* 2822 */           SingleValuedPath();
/* 2823 */           break;
/*      */         case 65:
/* 2825 */           EntityBeanValue();
/* 2826 */           break;
/*      */         case 66:
/*      */         case 67:
/*      */         case 68:
/*      */         case 69:
/*      */         case 70:
/*      */         case 71:
/*      */         case 72:
/*      */         case 73:
/*      */         case 74:
/*      */         case 75:
/*      */         case 76:
/*      */         case 77:
/*      */         case 78:
/*      */         default:
/* 2828 */           this.jj_la1[70] = this.jj_gen;
/* 2829 */           jj_consume_token(-1);
/* 2830 */           throw new ParseException();
/*      */         }
/* 2832 */         jj_consume_token(41);
/*      */       } catch (Throwable jjte005) {
/* 2834 */         if (jjtc005) {
/* 2835 */           this.jjtree.clearNodeScope(jjtn005);
/* 2836 */           jjtc005 = false;
/*      */         } else {
/* 2838 */           this.jjtree.popNode();
/*      */         }
/* 2840 */         if ((jjte005 instanceof RuntimeException)) {
/* 2841 */           throw ((RuntimeException)jjte005);
/*      */         }
/* 2843 */         if ((jjte005 instanceof ParseException)) {
/* 2844 */           throw ((ParseException)jjte005);
/*      */         }
/* 2846 */         throw ((Error)jjte005);
/*      */       } finally {
/* 2848 */         if (jjtc005) {
/* 2849 */           this.jjtree.closeNodeScope(jjtn005, true);
/*      */         }
/*      */       }
/* 2852 */       break;
/*      */     default:
/* 2854 */       this.jj_la1[71] = this.jj_gen;
/* 2855 */       jj_consume_token(-1);
/* 2856 */       throw new ParseException();
/*      */     }
/*      */   }
/*      */ 
/*      */   private final boolean jj_2_1(int xla) {
/* 2861 */     this.jj_la = xla; this.jj_lastpos = (this.jj_scanpos = this.token);
/*      */     try { i = !jj_3_1() ? 1 : 0;
/*      */     }
/*      */     catch (LookaheadSuccess ls)
/*      */     {
/*      */       int i;
/* 2863 */       return 1; } finally {
/* 2864 */       jj_save(0, xla);
/*      */     }
/*      */   }
/*      */ 
/*      */   private final boolean jj_2_2(int xla) {
/* 2868 */     this.jj_la = xla; this.jj_lastpos = (this.jj_scanpos = this.token);
/*      */     try { i = !jj_3_2() ? 1 : 0;
/*      */     }
/*      */     catch (LookaheadSuccess ls)
/*      */     {
/*      */       int i;
/* 2870 */       return 1; } finally {
/* 2871 */       jj_save(1, xla);
/*      */     }
/*      */   }
/*      */ 
/*      */   private final boolean jj_2_3(int xla) {
/* 2875 */     this.jj_la = xla; this.jj_lastpos = (this.jj_scanpos = this.token);
/*      */     try { i = !jj_3_3() ? 1 : 0;
/*      */     }
/*      */     catch (LookaheadSuccess ls)
/*      */     {
/*      */       int i;
/* 2877 */       return 1; } finally {
/* 2878 */       jj_save(2, xla);
/*      */     }
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_18() {
/* 2882 */     return jj_3R_28();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_17()
/*      */   {
/* 2887 */     return jj_3R_27();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3_1()
/*      */   {
/* 2892 */     if (jj_scan_token(40)) return true;
/* 2893 */     if (jj_3R_11()) return true;
/* 2894 */     return jj_scan_token(41);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_16()
/*      */   {
/* 2899 */     return jj_3R_26();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_12()
/*      */   {
/* 2905 */     Token xsp = this.jj_scanpos;
/* 2906 */     if (jj_3R_16()) {
/* 2907 */       this.jj_scanpos = xsp;
/* 2908 */       this.lookingAhead = true;
/* 2909 */       this.jj_semLA = (getToken(2).kind == 15);
/* 2910 */       this.lookingAhead = false;
/* 2911 */       if ((!this.jj_semLA) || (jj_3R_17())) {
/* 2912 */         this.jj_scanpos = xsp;
/* 2913 */         this.lookingAhead = true;
/* 2914 */         this.jj_semLA = ((getToken(2).kind == 29) || (getToken(3).kind == 29));
/* 2915 */         this.lookingAhead = false;
/* 2916 */         if ((!this.jj_semLA) || (jj_3R_18())) {
/* 2917 */           this.jj_scanpos = xsp;
/* 2918 */           this.lookingAhead = true;
/* 2919 */           this.jj_semLA = ((getToken(2).kind == 17) || (getToken(3).kind == 17));
/* 2920 */           this.lookingAhead = false;
/* 2921 */           if ((!this.jj_semLA) || (jj_3R_19())) {
/* 2922 */             this.jj_scanpos = xsp;
/* 2923 */             this.lookingAhead = true;
/* 2924 */             this.jj_semLA = ((getToken(2).kind == 14) || (getToken(3).kind == 14));
/* 2925 */             this.lookingAhead = false;
/* 2926 */             if ((!this.jj_semLA) || (jj_3R_20())) {
/* 2927 */               this.jj_scanpos = xsp;
/* 2928 */               if (jj_3R_21()) return true;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 2934 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_94() {
/* 2938 */     return jj_scan_token(82);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_25()
/*      */   {
/* 2943 */     if (jj_scan_token(6)) return true;
/* 2944 */     return jj_3R_24();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3_2()
/*      */   {
/* 2949 */     return jj_3R_12();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_95()
/*      */   {
/* 2954 */     return jj_scan_token(81);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_78()
/*      */   {
/* 2959 */     if (jj_scan_token(40)) return true;
/* 2960 */     if (jj_3R_11()) return true;
/* 2961 */     return jj_scan_token(41);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_60()
/*      */   {
/* 2967 */     Token xsp = this.jj_scanpos;
/* 2968 */     if (jj_3R_78()) {
/* 2969 */       this.jj_scanpos = xsp;
/* 2970 */       if (jj_3_2()) return true;
/*      */     }
/* 2972 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_46() {
/* 2976 */     return jj_scan_token(80);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_15()
/*      */   {
/* 2981 */     if (jj_scan_token(23)) return true;
/* 2982 */     return jj_3R_14();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_35()
/*      */   {
/* 2987 */     return jj_3R_60();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_34()
/*      */   {
/* 2992 */     return jj_scan_token(19);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_32()
/*      */   {
/* 2997 */     return jj_scan_token(79);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_24()
/*      */   {
/* 3003 */     Token xsp = this.jj_scanpos;
/* 3004 */     if (jj_3R_34()) this.jj_scanpos = xsp;
/* 3005 */     return jj_3R_35();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_84()
/*      */   {
/* 3010 */     return jj_3R_100();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_83()
/*      */   {
/* 3015 */     return jj_3R_67();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_82()
/*      */   {
/* 3020 */     return jj_3R_94();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_81()
/*      */   {
/* 3025 */     return jj_3R_95();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_14()
/*      */   {
/* 3030 */     if (jj_3R_24()) return true; Token xsp;
/*      */     do
/* 3033 */       xsp = this.jj_scanpos;
/* 3034 */     while (!jj_3R_25()); this.jj_scanpos = xsp;
/*      */ 
/* 3036 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_80() {
/* 3040 */     return jj_3R_46();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_61()
/*      */   {
/* 3046 */     Token xsp = this.jj_scanpos;
/* 3047 */     if (jj_3R_79()) {
/* 3048 */       this.jj_scanpos = xsp;
/* 3049 */       if (jj_3R_80()) {
/* 3050 */         this.jj_scanpos = xsp;
/* 3051 */         if (jj_3R_81()) {
/* 3052 */           this.jj_scanpos = xsp;
/* 3053 */           if (jj_3R_82()) {
/* 3054 */             this.jj_scanpos = xsp;
/* 3055 */             if (jj_3R_83()) {
/* 3056 */               this.jj_scanpos = xsp;
/* 3057 */               if (jj_3R_84()) return true;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 3063 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_79() {
/* 3067 */     return jj_3R_32();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_11()
/*      */   {
/* 3072 */     if (jj_3R_14()) return true; Token xsp;
/*      */     do
/* 3075 */       xsp = this.jj_scanpos;
/* 3076 */     while (!jj_3R_15()); this.jj_scanpos = xsp;
/*      */ 
/* 3078 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_68() {
/* 3082 */     return jj_scan_token(65);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_36()
/*      */   {
/* 3087 */     return jj_scan_token(86);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_76()
/*      */   {
/* 3092 */     if (jj_scan_token(42)) return true;
/* 3093 */     return jj_3R_77();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_59()
/*      */   {
/* 3098 */     if (jj_scan_token(39)) return true;
/* 3099 */     if (jj_scan_token(40)) return true;
/* 3100 */     if (jj_3R_77()) return true;
/* 3101 */     if (jj_scan_token(42)) return true;
/* 3102 */     if (jj_3R_77()) return true;
/* 3103 */     return jj_scan_token(41);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_58()
/*      */   {
/* 3108 */     if (jj_scan_token(26)) return true;
/* 3109 */     if (jj_scan_token(40)) return true;
/* 3110 */     if (jj_3R_77()) return true;
/* 3111 */     return jj_scan_token(41);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_167()
/*      */   {
/* 3116 */     return jj_3R_168();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_57()
/*      */   {
/* 3121 */     if (jj_scan_token(5)) return true;
/* 3122 */     if (jj_scan_token(40)) return true;
/* 3123 */     if (jj_3R_77()) return true;
/* 3124 */     return jj_scan_token(41);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_56()
/*      */   {
/* 3129 */     if (jj_scan_token(18)) return true;
/* 3130 */     if (jj_scan_token(40)) return true;
/* 3131 */     if (jj_3R_69()) return true;
/* 3132 */     if (jj_scan_token(42)) return true;
/* 3133 */     if (jj_3R_69()) return true;
/*      */ 
/* 3135 */     Token xsp = this.jj_scanpos;
/* 3136 */     if (jj_3R_76()) this.jj_scanpos = xsp;
/* 3137 */     return jj_scan_token(41);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_55()
/*      */   {
/* 3142 */     if (jj_scan_token(16)) return true;
/* 3143 */     if (jj_scan_token(40)) return true;
/* 3144 */     if (jj_3R_69()) return true;
/* 3145 */     return jj_scan_token(41);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_33()
/*      */   {
/* 3151 */     Token xsp = this.jj_scanpos;
/* 3152 */     if (jj_3R_55()) {
/* 3153 */       this.jj_scanpos = xsp;
/* 3154 */       if (jj_3R_56()) {
/* 3155 */         this.jj_scanpos = xsp;
/* 3156 */         if (jj_3R_57()) {
/* 3157 */           this.jj_scanpos = xsp;
/* 3158 */           if (jj_3R_58()) {
/* 3159 */             this.jj_scanpos = xsp;
/* 3160 */             if (jj_3R_59()) return true;
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 3165 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_162() {
/* 3169 */     return jj_3R_63();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_97()
/*      */   {
/* 3174 */     return jj_3R_68();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_115()
/*      */   {
/* 3179 */     if (jj_scan_token(25)) return true;
/* 3180 */     if (jj_scan_token(40)) return true;
/* 3181 */     if (jj_3R_69()) return true;
/* 3182 */     if (jj_scan_token(42)) return true;
/* 3183 */     if (jj_3R_77()) return true;
/* 3184 */     if (jj_scan_token(42)) return true;
/* 3185 */     if (jj_3R_77()) return true;
/* 3186 */     return jj_scan_token(41);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_103()
/*      */   {
/* 3192 */     Token xsp = this.jj_scanpos;
/* 3193 */     if (jj_3R_114()) {
/* 3194 */       this.jj_scanpos = xsp;
/* 3195 */       if (jj_3R_115()) return true;
/*      */     }
/* 3197 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_114() {
/* 3201 */     if (jj_scan_token(9)) return true;
/* 3202 */     if (jj_scan_token(40)) return true;
/* 3203 */     if (jj_3R_69()) return true;
/* 3204 */     if (jj_scan_token(42)) return true;
/* 3205 */     if (jj_3R_69()) return true;
/* 3206 */     return jj_scan_token(41);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_166()
/*      */   {
/* 3211 */     return jj_3R_66();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_161()
/*      */   {
/* 3216 */     return jj_3R_74();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_148()
/*      */   {
/* 3222 */     Token xsp = this.jj_scanpos;
/* 3223 */     if (jj_3R_161()) {
/* 3224 */       this.jj_scanpos = xsp;
/* 3225 */       if (jj_3R_162()) return true;
/*      */     }
/* 3227 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_160() {
/* 3231 */     return jj_3R_65();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_74()
/*      */   {
/* 3237 */     Token xsp = this.jj_scanpos;
/* 3238 */     if (jj_3R_96()) {
/* 3239 */       this.jj_scanpos = xsp;
/* 3240 */       if (jj_3R_97()) return true;
/*      */     }
/* 3242 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_96() {
/* 3246 */     return jj_3R_67();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_165()
/*      */   {
/* 3251 */     return jj_3R_72();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_158()
/*      */   {
/* 3257 */     Token xsp = this.jj_scanpos;
/* 3258 */     if (jj_3R_165()) {
/* 3259 */       this.jj_scanpos = xsp;
/* 3260 */       if (jj_3R_166()) {
/* 3261 */         this.jj_scanpos = xsp;
/* 3262 */         if (jj_3R_167()) return true;
/*      */       }
/*      */     }
/* 3265 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_72() {
/* 3269 */     return jj_3R_94();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_159()
/*      */   {
/* 3274 */     return jj_3R_73();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_145()
/*      */   {
/* 3280 */     Token xsp = this.jj_scanpos;
/* 3281 */     if (jj_3R_159()) {
/* 3282 */       this.jj_scanpos = xsp;
/* 3283 */       if (jj_3R_160()) return true;
/*      */     }
/* 3285 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_86() {
/* 3289 */     return jj_3R_64();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_73()
/*      */   {
/* 3294 */     return jj_3R_95();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_93()
/*      */   {
/* 3299 */     return jj_3R_103();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_111()
/*      */   {
/* 3304 */     return jj_3R_103();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_110()
/*      */   {
/* 3309 */     if (jj_scan_token(40)) return true;
/* 3310 */     if (jj_3R_69()) return true;
/* 3311 */     return jj_scan_token(41);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_109()
/*      */   {
/* 3316 */     return jj_3R_119();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_101()
/*      */   {
/* 3322 */     Token xsp = this.jj_scanpos;
/* 3323 */     if (jj_3R_108()) {
/* 3324 */       this.jj_scanpos = xsp;
/* 3325 */       if (jj_3R_109()) {
/* 3326 */         this.jj_scanpos = xsp;
/* 3327 */         if (jj_3R_110()) {
/* 3328 */           this.jj_scanpos = xsp;
/* 3329 */           if (jj_3R_111()) return true;
/*      */         }
/*      */       }
/*      */     }
/* 3333 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_108() {
/* 3337 */     return jj_3R_46();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_69()
/*      */   {
/* 3343 */     Token xsp = this.jj_scanpos;
/* 3344 */     if (jj_3R_85()) {
/* 3345 */       this.jj_scanpos = xsp;
/* 3346 */       if (jj_3R_86()) return true;
/*      */     }
/* 3348 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_85() {
/* 3352 */     return jj_3R_101();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_71()
/*      */   {
/* 3358 */     Token xsp = this.jj_scanpos;
/* 3359 */     if (jj_3R_92()) {
/* 3360 */       this.jj_scanpos = xsp;
/* 3361 */       if (jj_3R_93()) return true;
/*      */     }
/* 3363 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_92() {
/* 3367 */     return jj_3R_46();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_91()
/*      */   {
/* 3372 */     return jj_3R_33();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_120()
/*      */   {
/* 3377 */     return jj_scan_token(51);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_90()
/*      */   {
/* 3382 */     return jj_3R_62();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_89()
/*      */   {
/* 3387 */     if (jj_scan_token(40)) return true;
/* 3388 */     if (jj_3R_77()) return true;
/* 3389 */     return jj_scan_token(41);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_88()
/*      */   {
/* 3394 */     return jj_3R_102();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_70()
/*      */   {
/* 3400 */     Token xsp = this.jj_scanpos;
/* 3401 */     if (jj_3R_87()) {
/* 3402 */       this.jj_scanpos = xsp;
/* 3403 */       if (jj_3R_88()) {
/* 3404 */         this.jj_scanpos = xsp;
/* 3405 */         if (jj_3R_89()) {
/* 3406 */           this.jj_scanpos = xsp;
/* 3407 */           if (jj_3R_90()) {
/* 3408 */             this.jj_scanpos = xsp;
/* 3409 */             if (jj_3R_91()) return true;
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 3414 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_87() {
/* 3418 */     return jj_3R_32();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_116()
/*      */   {
/* 3424 */     Token xsp = this.jj_scanpos;
/* 3425 */     if (jj_scan_token(50)) {
/* 3426 */       this.jj_scanpos = xsp;
/* 3427 */       if (jj_3R_120()) return true;
/*      */     }
/* 3429 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_104()
/*      */   {
/* 3434 */     Token xsp = this.jj_scanpos;
/* 3435 */     if (jj_3R_116()) this.jj_scanpos = xsp;
/* 3436 */     return jj_3R_70();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_118()
/*      */   {
/* 3441 */     return jj_scan_token(53);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_117()
/*      */   {
/* 3446 */     return jj_scan_token(52);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_105()
/*      */   {
/* 3452 */     Token xsp = this.jj_scanpos;
/* 3453 */     if (jj_3R_117()) {
/* 3454 */       this.jj_scanpos = xsp;
/* 3455 */       if (jj_3R_118()) return true;
/*      */     }
/* 3457 */     return jj_3R_104();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_98()
/*      */   {
/* 3462 */     if (jj_3R_104()) return true; Token xsp;
/*      */     do
/* 3465 */       xsp = this.jj_scanpos;
/* 3466 */     while (!jj_3R_105()); this.jj_scanpos = xsp;
/*      */ 
/* 3468 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_107() {
/* 3472 */     return jj_scan_token(51);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_106()
/*      */   {
/* 3477 */     return jj_scan_token(50);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_99()
/*      */   {
/* 3483 */     Token xsp = this.jj_scanpos;
/* 3484 */     if (jj_3R_106()) {
/* 3485 */       this.jj_scanpos = xsp;
/* 3486 */       if (jj_3R_107()) return true;
/*      */     }
/* 3488 */     return jj_3R_98();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_23()
/*      */   {
/* 3493 */     return jj_3R_33();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_77()
/*      */   {
/* 3498 */     if (jj_3R_98()) return true; Token xsp;
/*      */     do
/* 3501 */       xsp = this.jj_scanpos;
/* 3502 */     while (!jj_3R_99()); this.jj_scanpos = xsp;
/*      */ 
/* 3504 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_163() {
/* 3508 */     return jj_3R_77();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_155()
/*      */   {
/* 3513 */     return jj_3R_163();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_22()
/*      */   {
/* 3518 */     return jj_3R_32();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_13()
/*      */   {
/* 3524 */     Token xsp = this.jj_scanpos;
/* 3525 */     if (jj_3R_22()) {
/* 3526 */       this.jj_scanpos = xsp;
/* 3527 */       if (jj_3R_23()) return true;
/*      */     }
/* 3529 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_154() {
/* 3533 */     return jj_scan_token(49);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_153()
/*      */   {
/* 3538 */     return jj_scan_token(47);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_54()
/*      */   {
/* 3543 */     return jj_3R_75();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_152()
/*      */   {
/* 3548 */     return jj_scan_token(45);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_151()
/*      */   {
/* 3553 */     return jj_scan_token(48);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_150()
/*      */   {
/* 3558 */     return jj_scan_token(44);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3_3()
/*      */   {
/* 3563 */     if (jj_3R_13()) return true;
/*      */ 
/* 3565 */     Token xsp = this.jj_scanpos;
/* 3566 */     if (jj_scan_token(46)) {
/* 3567 */       this.jj_scanpos = xsp;
/* 3568 */       if (jj_scan_token(44)) {
/* 3569 */         this.jj_scanpos = xsp;
/* 3570 */         if (jj_scan_token(48)) {
/* 3571 */           this.jj_scanpos = xsp;
/* 3572 */           if (jj_scan_token(45)) {
/* 3573 */             this.jj_scanpos = xsp;
/* 3574 */             if (jj_scan_token(47)) {
/* 3575 */               this.jj_scanpos = xsp;
/* 3576 */               if (jj_scan_token(49)) return true;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 3582 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_149() {
/* 3586 */     return jj_scan_token(46);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_147()
/*      */   {
/* 3591 */     return jj_scan_token(49);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_53()
/*      */   {
/* 3596 */     if (jj_3R_13()) return true;
/*      */ 
/* 3598 */     Token xsp = this.jj_scanpos;
/* 3599 */     if (jj_3R_149()) {
/* 3600 */       this.jj_scanpos = xsp;
/* 3601 */       if (jj_3R_150()) {
/* 3602 */         this.jj_scanpos = xsp;
/* 3603 */         if (jj_3R_151()) {
/* 3604 */           this.jj_scanpos = xsp;
/* 3605 */           if (jj_3R_152()) {
/* 3606 */             this.jj_scanpos = xsp;
/* 3607 */             if (jj_3R_153()) {
/* 3608 */               this.jj_scanpos = xsp;
/* 3609 */               if (jj_3R_154()) return true;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 3615 */     return jj_3R_155();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_146()
/*      */   {
/* 3620 */     return jj_scan_token(46);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_170()
/*      */   {
/* 3625 */     return jj_scan_token(61);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_144()
/*      */   {
/* 3630 */     return jj_scan_token(47);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_52()
/*      */   {
/* 3635 */     if (jj_3R_74()) return true;
/*      */ 
/* 3637 */     Token xsp = this.jj_scanpos;
/* 3638 */     if (jj_3R_146()) {
/* 3639 */       this.jj_scanpos = xsp;
/* 3640 */       if (jj_3R_147()) return true;
/*      */     }
/* 3642 */     return jj_3R_148();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_143()
/*      */   {
/* 3647 */     return jj_scan_token(48);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_142()
/*      */   {
/* 3652 */     return jj_scan_token(49);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_141()
/*      */   {
/* 3657 */     return jj_scan_token(45);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_140()
/*      */   {
/* 3662 */     return jj_scan_token(44);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_139()
/*      */   {
/* 3667 */     return jj_scan_token(46);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_157()
/*      */   {
/* 3672 */     return jj_scan_token(49);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_156()
/*      */   {
/* 3677 */     return jj_scan_token(46);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_51()
/*      */   {
/* 3682 */     if (jj_3R_73()) return true;
/*      */ 
/* 3684 */     Token xsp = this.jj_scanpos;
/* 3685 */     if (jj_3R_139()) {
/* 3686 */       this.jj_scanpos = xsp;
/* 3687 */       if (jj_3R_140()) {
/* 3688 */         this.jj_scanpos = xsp;
/* 3689 */         if (jj_3R_141()) {
/* 3690 */           this.jj_scanpos = xsp;
/* 3691 */           if (jj_3R_142()) {
/* 3692 */             this.jj_scanpos = xsp;
/* 3693 */             if (jj_3R_143()) {
/* 3694 */               this.jj_scanpos = xsp;
/* 3695 */               if (jj_3R_144()) return true;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 3701 */     return jj_3R_145();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_138()
/*      */   {
/* 3707 */     Token xsp = this.jj_scanpos;
/* 3708 */     if (jj_3R_156()) {
/* 3709 */       this.jj_scanpos = xsp;
/* 3710 */       if (jj_3R_157()) return true;
/*      */     }
/* 3712 */     return jj_3R_158();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_127()
/*      */   {
/* 3717 */     return jj_3R_62();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_137()
/*      */   {
/* 3722 */     return jj_scan_token(49);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_50()
/*      */   {
/* 3727 */     if (jj_3R_72()) return true;
/*      */ 
/* 3729 */     Token xsp = this.jj_scanpos;
/* 3730 */     if (jj_3R_138()) this.jj_scanpos = xsp;
/* 3731 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_121() {
/* 3735 */     return jj_scan_token(19);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_136()
/*      */   {
/* 3740 */     return jj_scan_token(47);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_135()
/*      */   {
/* 3745 */     return jj_scan_token(45);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_134()
/*      */   {
/* 3750 */     return jj_scan_token(48);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_133()
/*      */   {
/* 3755 */     return jj_scan_token(44);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_132()
/*      */   {
/* 3760 */     return jj_scan_token(46);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_169()
/*      */   {
/* 3765 */     return jj_scan_token(62);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_168()
/*      */   {
/* 3771 */     Token xsp = this.jj_scanpos;
/* 3772 */     if (jj_3R_169()) {
/* 3773 */       this.jj_scanpos = xsp;
/* 3774 */       if (jj_3R_170()) return true;
/*      */     }
/* 3776 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_119() {
/* 3780 */     return jj_scan_token(54);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_49()
/*      */   {
/* 3785 */     if (jj_3R_71()) return true;
/*      */ 
/* 3787 */     Token xsp = this.jj_scanpos;
/* 3788 */     if (jj_3R_132()) {
/* 3789 */       this.jj_scanpos = xsp;
/* 3790 */       if (jj_3R_133()) {
/* 3791 */         this.jj_scanpos = xsp;
/* 3792 */         if (jj_3R_134()) {
/* 3793 */           this.jj_scanpos = xsp;
/* 3794 */           if (jj_3R_135()) {
/* 3795 */             this.jj_scanpos = xsp;
/* 3796 */             if (jj_3R_136()) {
/* 3797 */               this.jj_scanpos = xsp;
/* 3798 */               if (jj_3R_137()) return true;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 3804 */     return jj_3R_69();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_31()
/*      */   {
/* 3810 */     Token xsp = this.jj_scanpos;
/* 3811 */     if (jj_3R_49()) {
/* 3812 */       this.jj_scanpos = xsp;
/* 3813 */       if (jj_3R_50()) {
/* 3814 */         this.jj_scanpos = xsp;
/* 3815 */         if (jj_3R_51()) {
/* 3816 */           this.jj_scanpos = xsp;
/* 3817 */           if (jj_3R_52()) {
/* 3818 */             this.jj_scanpos = xsp;
/* 3819 */             if (jj_3R_53()) {
/* 3820 */               this.jj_scanpos = xsp;
/* 3821 */               if (jj_3R_54()) return true;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 3827 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_45() {
/* 3831 */     return jj_3R_63();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_44()
/*      */   {
/* 3836 */     return jj_3R_68();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_123()
/*      */   {
/* 3841 */     return jj_scan_token(19);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_126()
/*      */   {
/* 3846 */     return jj_3R_119();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_113()
/*      */   {
/* 3851 */     return jj_scan_token(59);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_131()
/*      */   {
/* 3856 */     if (jj_scan_token(42)) return true;
/* 3857 */     return jj_3R_70();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_43()
/*      */   {
/* 3862 */     return jj_3R_67();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_28()
/*      */   {
/* 3868 */     Token xsp = this.jj_scanpos;
/* 3869 */     if (jj_3R_43()) {
/* 3870 */       this.jj_scanpos = xsp;
/* 3871 */       if (jj_3R_44()) {
/* 3872 */         this.jj_scanpos = xsp;
/* 3873 */         if (jj_3R_45()) return true;
/*      */       }
/*      */     }
/* 3876 */     xsp = this.jj_scanpos;
/* 3877 */     if (jj_3R_123()) this.jj_scanpos = xsp;
/* 3878 */     if (jj_scan_token(29)) return true;
/* 3879 */     xsp = this.jj_scanpos;
/* 3880 */     if (jj_scan_token(22)) this.jj_scanpos = xsp;
/* 3881 */     return jj_3R_36();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_102()
/*      */   {
/* 3887 */     Token xsp = this.jj_scanpos;
/* 3888 */     if (jj_3R_112()) {
/* 3889 */       this.jj_scanpos = xsp;
/* 3890 */       if (jj_3R_113()) return true;
/*      */     }
/* 3892 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_112() {
/* 3896 */     return jj_scan_token(55);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_125()
/*      */   {
/* 3901 */     if (jj_scan_token(12)) return true;
/*      */ 
/* 3903 */     Token xsp = this.jj_scanpos;
/* 3904 */     if (jj_3R_126()) {
/* 3905 */       this.jj_scanpos = xsp;
/* 3906 */       if (jj_3R_127()) return true;
/*      */     }
/* 3908 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_129() {
/* 3912 */     if (jj_scan_token(42)) return true;
/* 3913 */     return jj_3R_69();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_26()
/*      */   {
/* 3918 */     if (jj_3R_36()) return true;
/* 3919 */     if (jj_scan_token(15)) return true;
/*      */ 
/* 3921 */     Token xsp = this.jj_scanpos;
/* 3922 */     if (jj_3R_121()) this.jj_scanpos = xsp;
/* 3923 */     return jj_scan_token(11);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_122()
/*      */   {
/* 3928 */     return jj_scan_token(19);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_124()
/*      */   {
/* 3933 */     return jj_scan_token(19);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_42()
/*      */   {
/* 3938 */     return jj_3R_66();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_41()
/*      */   {
/* 3943 */     return jj_3R_65();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_130()
/*      */   {
/* 3948 */     return jj_scan_token(19);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_40()
/*      */   {
/* 3953 */     return jj_3R_64();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_39()
/*      */   {
/* 3958 */     return jj_3R_63();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_38()
/*      */   {
/* 3963 */     return jj_3R_62();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_63()
/*      */   {
/* 3968 */     return jj_scan_token(74);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_37()
/*      */   {
/* 3973 */     return jj_3R_61();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_128()
/*      */   {
/* 3978 */     return jj_scan_token(19);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_164()
/*      */   {
/* 3983 */     return jj_scan_token(19);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_27()
/*      */   {
/* 3989 */     Token xsp = this.jj_scanpos;
/* 3990 */     if (jj_3R_37()) {
/* 3991 */       this.jj_scanpos = xsp;
/* 3992 */       if (jj_3R_38()) {
/* 3993 */         this.jj_scanpos = xsp;
/* 3994 */         if (jj_3R_39()) {
/* 3995 */           this.jj_scanpos = xsp;
/* 3996 */           if (jj_3R_40()) {
/* 3997 */             this.jj_scanpos = xsp;
/* 3998 */             if (jj_3R_41()) {
/* 3999 */               this.jj_scanpos = xsp;
/* 4000 */               if (jj_3R_42()) return true;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 4006 */     if (jj_scan_token(15)) return true;
/* 4007 */     xsp = this.jj_scanpos;
/* 4008 */     if (jj_3R_122()) this.jj_scanpos = xsp;
/* 4009 */     return jj_scan_token(20);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_66()
/*      */   {
/* 4014 */     return jj_scan_token(73);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_29()
/*      */   {
/* 4019 */     if (jj_3R_46()) return true;
/*      */ 
/* 4021 */     Token xsp = this.jj_scanpos;
/* 4022 */     if (jj_3R_124()) this.jj_scanpos = xsp;
/* 4023 */     if (jj_scan_token(17)) return true;
/* 4024 */     if (jj_3R_69()) return true;
/* 4025 */     xsp = this.jj_scanpos;
/* 4026 */     if (jj_3R_125()) this.jj_scanpos = xsp;
/* 4027 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_65() {
/* 4031 */     return jj_scan_token(72);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_48()
/*      */   {
/* 4036 */     if (jj_3R_70()) return true;
/*      */ 
/* 4038 */     Token xsp = this.jj_scanpos;
/* 4039 */     if (jj_3R_130()) this.jj_scanpos = xsp;
/* 4040 */     if (jj_scan_token(14)) return true;
/* 4041 */     if (jj_scan_token(40)) return true;
/* 4042 */     if (jj_3R_70()) return true;
/*      */     do
/* 4044 */       xsp = this.jj_scanpos;
/* 4045 */     while (!jj_3R_131()); this.jj_scanpos = xsp;
/*      */ 
/* 4047 */     return jj_scan_token(41);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_64()
/*      */   {
/* 4052 */     return jj_scan_token(71);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_47()
/*      */   {
/* 4057 */     if (jj_3R_69()) return true;
/*      */ 
/* 4059 */     Token xsp = this.jj_scanpos;
/* 4060 */     if (jj_3R_128()) this.jj_scanpos = xsp;
/* 4061 */     if (jj_scan_token(14)) return true;
/* 4062 */     if (jj_scan_token(40)) return true;
/* 4063 */     if (jj_3R_69()) return true;
/*      */     do
/* 4065 */       xsp = this.jj_scanpos;
/* 4066 */     while (!jj_3R_129()); this.jj_scanpos = xsp;
/*      */ 
/* 4068 */     return jj_scan_token(41);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_30()
/*      */   {
/* 4074 */     Token xsp = this.jj_scanpos;
/* 4075 */     if (jj_3R_47()) {
/* 4076 */       this.jj_scanpos = xsp;
/* 4077 */       if (jj_3R_48()) return true;
/*      */     }
/* 4079 */     return false;
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_62() {
/* 4083 */     return jj_scan_token(70);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_75()
/*      */   {
/* 4088 */     if (jj_3R_77()) return true;
/*      */ 
/* 4090 */     Token xsp = this.jj_scanpos;
/* 4091 */     if (jj_3R_164()) this.jj_scanpos = xsp;
/* 4092 */     if (jj_scan_token(8)) return true;
/* 4093 */     if (jj_3R_77()) return true;
/* 4094 */     if (jj_scan_token(6)) return true;
/* 4095 */     return jj_3R_77();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_21()
/*      */   {
/* 4100 */     return jj_3R_31();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_100()
/*      */   {
/* 4105 */     return jj_scan_token(84);
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_20()
/*      */   {
/* 4110 */     return jj_3R_30();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_19()
/*      */   {
/* 4115 */     return jj_3R_29();
/*      */   }
/*      */ 
/*      */   private final boolean jj_3R_67()
/*      */   {
/* 4120 */     return jj_scan_token(83);
/*      */   }
/*      */ 
/*      */   private static void jj_la1_0()
/*      */   {
/* 4143 */     jj_la1_0 = new int[] { 268435456, 1073741824, 0, 0, 0, 0, 0, 1073758208, 128, 128, 1024, 2097152, 0, 8388608, 64, 8388608, 64, 524288, 0, 100991520, 524288, 524288, 0, 524288, 0, 100991520, 524288, 0, 4096, 0, 524288, 524288, 0, 524288, 4194304, 0, 0, 0, 0, 0, 0, 33554944, 67436576, 67436576, 0, 0, 0, 0, 0, 0, 67436576, 33554944, 33554944, 33554944, 0, 0, 0, 0, 33554944, 0, 67436576, 1073741824, 0, 0, 0, 1024, 1024, 1024, 1024, 1024, 0, 0 };
/*      */   }
/*      */   private static void jj_la1_1() {
/* 4146 */     jj_la1_1 = new int[] { 0, 0, 1024, 0, 3, 3, 1024, 0, 0, 0, 0, 124, 124, 0, 0, 0, 0, 0, 0, 143393152, 0, 0, 1024, 0, 1024, 146801024, 0, 4194304, 0, 0, 0, 0, 0, 0, 0, 258048, 147456, 147456, 258048, 147456, 258048, 0, 143393152, 128, 786432, 786432, 3145728, 3145728, 786432, 786432, 142606720, 0, 4194560, 4194560, 0, 1610612736, 0, 0, 0, 1024, 128, 0, 0, 142606336, 1610612736, 0, 0, 0, 0, 0, 0, 124 };
/*      */   }
/*      */   private static void jj_la1_2() {
/* 4149 */     jj_la1_2 = new int[] { 0, 0, 0, 229376, 0, 0, 0, 1, 0, 0, 0, 2064384, 2064384, 0, 0, 0, 0, 0, 4194304, 1015874, 0, 0, 0, 0, 0, 98496, 0, 64, 0, 2066368, 0, 0, 525314, 0, 0, 0, 0, 0, 0, 0, 0, 983042, 32832, 32768, 0, 0, 0, 0, 0, 0, 32832, 65536, 65664, 65536, 131328, 262656, 524290, 525314, 0, 0, 0, 1, 2064384, 0, 0, 0, 0, 0, 0, 0, 2064386, 0 };
/*      */   }
/*      */ 
/*      */   public EJBQLParser(InputStream stream)
/*      */   {
/* 4156 */     this.jj_input_stream = new JavaCharStream(stream, 1, 1);
/* 4157 */     this.token_source = new EJBQLParserTokenManager(this.jj_input_stream);
/* 4158 */     this.token = new Token();
/* 4159 */     this.jj_ntk = -1;
/* 4160 */     this.jj_gen = 0;
/* 4161 */     for (int i = 0; i < 72; i++) this.jj_la1[i] = -1;
/* 4162 */     for (int i = 0; i < this.jj_2_rtns.length; i++) this.jj_2_rtns[i] = new JJCalls(); 
/*      */   }
/*      */ 
/*      */   public void ReInit(InputStream stream)
/*      */   {
/* 4166 */     this.jj_input_stream.ReInit(stream, 1, 1);
/* 4167 */     this.token_source.ReInit(this.jj_input_stream);
/* 4168 */     this.token = new Token();
/* 4169 */     this.jj_ntk = -1;
/* 4170 */     this.jjtree.reset();
/* 4171 */     this.jj_gen = 0;
/* 4172 */     for (int i = 0; i < 72; i++) this.jj_la1[i] = -1;
/* 4173 */     for (int i = 0; i < this.jj_2_rtns.length; i++) this.jj_2_rtns[i] = new JJCalls(); 
/*      */   }
/*      */ 
/*      */   public EJBQLParser(Reader stream)
/*      */   {
/* 4177 */     this.jj_input_stream = new JavaCharStream(stream, 1, 1);
/* 4178 */     this.token_source = new EJBQLParserTokenManager(this.jj_input_stream);
/* 4179 */     this.token = new Token();
/* 4180 */     this.jj_ntk = -1;
/* 4181 */     this.jj_gen = 0;
/* 4182 */     for (int i = 0; i < 72; i++) this.jj_la1[i] = -1;
/* 4183 */     for (int i = 0; i < this.jj_2_rtns.length; i++) this.jj_2_rtns[i] = new JJCalls(); 
/*      */   }
/*      */ 
/*      */   public void ReInit(Reader stream)
/*      */   {
/* 4187 */     this.jj_input_stream.ReInit(stream, 1, 1);
/* 4188 */     this.token_source.ReInit(this.jj_input_stream);
/* 4189 */     this.token = new Token();
/* 4190 */     this.jj_ntk = -1;
/* 4191 */     this.jjtree.reset();
/* 4192 */     this.jj_gen = 0;
/* 4193 */     for (int i = 0; i < 72; i++) this.jj_la1[i] = -1;
/* 4194 */     for (int i = 0; i < this.jj_2_rtns.length; i++) this.jj_2_rtns[i] = new JJCalls(); 
/*      */   }
/*      */ 
/*      */   public EJBQLParser(EJBQLParserTokenManager tm)
/*      */   {
/* 4198 */     this.token_source = tm;
/* 4199 */     this.token = new Token();
/* 4200 */     this.jj_ntk = -1;
/* 4201 */     this.jj_gen = 0;
/* 4202 */     for (int i = 0; i < 72; i++) this.jj_la1[i] = -1;
/* 4203 */     for (int i = 0; i < this.jj_2_rtns.length; i++) this.jj_2_rtns[i] = new JJCalls(); 
/*      */   }
/*      */ 
/*      */   public void ReInit(EJBQLParserTokenManager tm)
/*      */   {
/* 4207 */     this.token_source = tm;
/* 4208 */     this.token = new Token();
/* 4209 */     this.jj_ntk = -1;
/* 4210 */     this.jjtree.reset();
/* 4211 */     this.jj_gen = 0;
/* 4212 */     for (int i = 0; i < 72; i++) this.jj_la1[i] = -1;
/* 4213 */     for (int i = 0; i < this.jj_2_rtns.length; i++) this.jj_2_rtns[i] = new JJCalls();
/*      */   }
/*      */ 
/*      */   private final Token jj_consume_token(int kind)
/*      */     throws ParseException
/*      */   {
/* 4218 */     Token oldToken;
/* 4218 */     if ((oldToken = this.token).next != null) this.token = this.token.next; else
/* 4219 */       this.token = (this.token.next = this.token_source.getNextToken());
/* 4220 */     this.jj_ntk = -1;
/* 4221 */     if (this.token.kind == kind) {
/* 4222 */       this.jj_gen += 1;
/* 4223 */       if (++this.jj_gc > 100) {
/* 4224 */         this.jj_gc = 0;
/* 4225 */         for (int i = 0; i < this.jj_2_rtns.length; i++) {
/* 4226 */           JJCalls c = this.jj_2_rtns[i];
/* 4227 */           while (c != null) {
/* 4228 */             if (c.gen < this.jj_gen) c.first = null;
/* 4229 */             c = c.next;
/*      */           }
/*      */         }
/*      */       }
/* 4233 */       return this.token;
/*      */     }
/* 4235 */     this.token = oldToken;
/* 4236 */     this.jj_kind = kind;
/* 4237 */     throw generateParseException();
/*      */   }
/*      */ 
/*      */   private final boolean jj_scan_token(int kind)
/*      */   {
/* 4243 */     if (this.jj_scanpos == this.jj_lastpos) {
/* 4244 */       this.jj_la -= 1;
/* 4245 */       if (this.jj_scanpos.next == null)
/* 4246 */         this.jj_lastpos = (this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken());
/*      */       else
/* 4248 */         this.jj_lastpos = (this.jj_scanpos = this.jj_scanpos.next);
/*      */     }
/*      */     else {
/* 4251 */       this.jj_scanpos = this.jj_scanpos.next;
/*      */     }
/* 4253 */     if (this.jj_rescan) {
/* 4254 */       int i = 0; Token tok = this.token;
/* 4255 */       for (; (tok != null) && (tok != this.jj_scanpos); tok = tok.next) i++;
/* 4256 */       if (tok != null) jj_add_error_token(kind, i);
/*      */     }
/* 4258 */     if (this.jj_scanpos.kind != kind) return true;
/* 4259 */     if ((this.jj_la == 0) && (this.jj_scanpos == this.jj_lastpos)) throw this.jj_ls;
/* 4260 */     return false;
/*      */   }
/*      */ 
/*      */   public final Token getNextToken() {
/* 4264 */     if (this.token.next != null) this.token = this.token.next; else
/* 4265 */       this.token = (this.token.next = this.token_source.getNextToken());
/* 4266 */     this.jj_ntk = -1;
/* 4267 */     this.jj_gen += 1;
/* 4268 */     return this.token;
/*      */   }
/*      */ 
/*      */   public final Token getToken(int index) {
/* 4272 */     Token t = this.lookingAhead ? this.jj_scanpos : this.token;
/* 4273 */     for (int i = 0; i < index; i++) {
/* 4274 */       if (t.next != null) t = t.next; else
/* 4275 */         t = t.next = this.token_source.getNextToken();
/*      */     }
/* 4277 */     return t;
/*      */   }
/*      */ 
/*      */   private final int jj_ntk() {
/* 4281 */     if ((this.jj_nt = this.token.next) == null) {
/* 4282 */       return this.jj_ntk = (this.token.next = this.token_source.getNextToken()).kind;
/*      */     }
/* 4284 */     return this.jj_ntk = this.jj_nt.kind;
/*      */   }
/*      */ 
/*      */   private void jj_add_error_token(int kind, int pos)
/*      */   {
/* 4294 */     if (pos >= 100) return;
/* 4295 */     if (pos == this.jj_endpos + 1) {
/* 4296 */       this.jj_lasttokens[(this.jj_endpos++)] = kind;
/* 4297 */     } else if (this.jj_endpos != 0) {
/* 4298 */       this.jj_expentry = new int[this.jj_endpos];
/* 4299 */       for (int i = 0; i < this.jj_endpos; i++) {
/* 4300 */         this.jj_expentry[i] = this.jj_lasttokens[i];
/*      */       }
/* 4302 */       boolean exists = false;
/* 4303 */       for (Enumeration e = this.jj_expentries.elements(); e.hasMoreElements(); ) {
/* 4304 */         int[] oldentry = (int[])(int[])e.nextElement();
/* 4305 */         if (oldentry.length == this.jj_expentry.length) {
/* 4306 */           exists = true;
/* 4307 */           for (int i = 0; i < this.jj_expentry.length; i++) {
/* 4308 */             if (oldentry[i] != this.jj_expentry[i]) {
/* 4309 */               exists = false;
/* 4310 */               break;
/*      */             }
/*      */           }
/* 4313 */           if (exists) break;
/*      */         }
/*      */       }
/* 4316 */       if (!exists) this.jj_expentries.addElement(this.jj_expentry);
/* 4317 */       if (pos != 0)
/*      */       {
/*      */         int tmp205_204 = pos; this.jj_endpos = tmp205_204; this.jj_lasttokens[(tmp205_204 - 1)] = kind;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public ParseException generateParseException() {
/* 4322 */     this.jj_expentries.removeAllElements();
/* 4323 */     boolean[] la1tokens = new boolean[87];
/* 4324 */     for (int i = 0; i < 87; i++) {
/* 4325 */       la1tokens[i] = false;
/*      */     }
/* 4327 */     if (this.jj_kind >= 0) {
/* 4328 */       la1tokens[this.jj_kind] = true;
/* 4329 */       this.jj_kind = -1;
/*      */     }
/* 4331 */     for (int i = 0; i < 72; i++) {
/* 4332 */       if (this.jj_la1[i] == this.jj_gen) {
/* 4333 */         for (int j = 0; j < 32; j++) {
/* 4334 */           if ((jj_la1_0[i] & 1 << j) != 0) {
/* 4335 */             la1tokens[j] = true;
/*      */           }
/* 4337 */           if ((jj_la1_1[i] & 1 << j) != 0) {
/* 4338 */             la1tokens[(32 + j)] = true;
/*      */           }
/* 4340 */           if ((jj_la1_2[i] & 1 << j) != 0) {
/* 4341 */             la1tokens[(64 + j)] = true;
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 4346 */     for (int i = 0; i < 87; i++) {
/* 4347 */       if (la1tokens[i] != 0) {
/* 4348 */         this.jj_expentry = new int[1];
/* 4349 */         this.jj_expentry[0] = i;
/* 4350 */         this.jj_expentries.addElement(this.jj_expentry);
/*      */       }
/*      */     }
/* 4353 */     this.jj_endpos = 0;
/* 4354 */     jj_rescan_token();
/* 4355 */     jj_add_error_token(0, 0);
/* 4356 */     int[][] exptokseq = new int[this.jj_expentries.size()][];
/* 4357 */     for (int i = 0; i < this.jj_expentries.size(); i++) {
/* 4358 */       exptokseq[i] = ((int[])(int[])this.jj_expentries.elementAt(i));
/*      */     }
/* 4360 */     return new ParseException(this.token, exptokseq, tokenImage);
/*      */   }
/*      */ 
/*      */   public final void enable_tracing() {
/*      */   }
/*      */ 
/*      */   public final void disable_tracing() {
/*      */   }
/*      */ 
/*      */   private final void jj_rescan_token() {
/* 4370 */     this.jj_rescan = true;
/* 4371 */     for (int i = 0; i < 3; i++) {
/* 4372 */       JJCalls p = this.jj_2_rtns[i];
/*      */       do {
/* 4374 */         if (p.gen > this.jj_gen) {
/* 4375 */           this.jj_la = p.arg; this.jj_lastpos = (this.jj_scanpos = p.first);
/* 4376 */           switch (i) { case 0:
/* 4377 */             jj_3_1(); break;
/*      */           case 1:
/* 4378 */             jj_3_2(); break;
/*      */           case 2:
/* 4379 */             jj_3_3();
/*      */           }
/*      */         }
/* 4382 */         p = p.next;
/* 4383 */       }while (p != null);
/*      */     }
/* 4385 */     this.jj_rescan = false;
/*      */   }
/*      */ 
/*      */   private final void jj_save(int index, int xla) {
/* 4389 */     JJCalls p = this.jj_2_rtns[index];
/* 4390 */     while (p.gen > this.jj_gen) {
/* 4391 */       if (p.next == null) { p = p.next = new JJCalls(); break; }
/* 4392 */       p = p.next;
/*      */     }
/* 4394 */     p.gen = (this.jj_gen + xla - this.jj_la); p.first = this.token; p.arg = xla;
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/* 4138 */     jj_la1_0();
/* 4139 */     jj_la1_1();
/* 4140 */     jj_la1_2();
/*      */   }
/*      */ 
/*      */   static final class JJCalls
/*      */   {
/*      */     int gen;
/*      */     Token first;
/*      */     int arg;
/*      */     JJCalls next;
/*      */   }
/*      */ 
/*      */   private static final class LookaheadSuccess extends Error
/*      */   {
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.ejbql.EJBQLParser
 * JD-Core Version:    0.6.0
 */