/*    */ package org.jboss.ejb.plugins.cmp.ejbql;
/*    */ 
/*    */ import java.util.Collections;
/*    */ import java.util.HashMap;
/*    */ import java.util.Map;
/*    */ import java.util.Set;
/*    */ import org.jboss.ejb.plugins.cmp.bridge.EntityBridge;
/*    */ 
/*    */ public final class Catalog
/*    */ {
/* 38 */   private final Map entityByAbstractSchemaName = new HashMap();
/* 39 */   private final Map entityByEJBName = new HashMap();
/* 40 */   private final Map entityByInterface = new HashMap();
/*    */ 
/*    */   public void addEntity(EntityBridge entityBridge) {
/* 43 */     this.entityByAbstractSchemaName.put(entityBridge.getAbstractSchemaName(), entityBridge);
/*    */ 
/* 46 */     this.entityByEJBName.put(entityBridge.getEntityName(), entityBridge);
/*    */ 
/* 50 */     Class remote = entityBridge.getRemoteInterface();
/* 51 */     if (remote != null) {
/* 52 */       this.entityByInterface.put(remote, entityBridge);
/*    */     }
/* 54 */     Class local = entityBridge.getLocalInterface();
/* 55 */     if (local != null)
/* 56 */       this.entityByInterface.put(local, entityBridge);
/*    */   }
/*    */ 
/*    */   public EntityBridge getEntityByAbstractSchemaName(String abstractSchemaName)
/*    */   {
/* 63 */     return (EntityBridge)this.entityByAbstractSchemaName.get(abstractSchemaName);
/*    */   }
/*    */ 
/*    */   public EntityBridge getEntityByInterface(Class intf) {
/* 67 */     return (EntityBridge)this.entityByInterface.get(intf);
/*    */   }
/*    */ 
/*    */   public EntityBridge getEntityByEJBName(String ejbName) {
/* 71 */     return (EntityBridge)this.entityByEJBName.get(ejbName);
/*    */   }
/*    */ 
/*    */   public int getEntityCount() {
/* 75 */     return this.entityByEJBName.size();
/*    */   }
/*    */ 
/*    */   public Set getEJBNames() {
/* 79 */     return Collections.unmodifiableSet(this.entityByEJBName.keySet());
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.ejbql.Catalog
 * JD-Core Version:    0.6.0
 */