/*     */ package org.jboss.ejb.plugins.cmp.ejbql;
/*     */ 
/*     */ import java.util.List;
/*     */ 
/*     */ public class BasicVisitor
/*     */   implements JBossQLParserVisitor
/*     */ {
/*     */   public Object visit(SimpleNode node, Object data)
/*     */   {
/*  38 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTEJBQL node, Object data)
/*     */   {
/*  43 */     StringBuffer buf = (StringBuffer)data;
/*  44 */     for (int i = 0; i < node.jjtGetNumChildren(); i++)
/*     */     {
/*  46 */       if (i > 0)
/*     */       {
/*  48 */         buf.append(' ');
/*     */       }
/*  50 */       node.jjtGetChild(i).jjtAccept(this, data);
/*     */     }
/*  52 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTFrom node, Object data)
/*     */   {
/*  57 */     StringBuffer buf = (StringBuffer)data;
/*  58 */     buf.append(" FROM ");
/*  59 */     for (int i = 0; i < node.jjtGetNumChildren(); i++)
/*     */     {
/*  61 */       if (i > 0)
/*     */       {
/*  63 */         buf.append(", ");
/*     */       }
/*  65 */       node.jjtGetChild(i).jjtAccept(this, data);
/*     */     }
/*  67 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCollectionMemberDeclaration node, Object data)
/*     */   {
/*  72 */     StringBuffer buf = (StringBuffer)data;
/*  73 */     buf.append(" IN ").append('(');
/*  74 */     node.jjtGetChild(0).jjtAccept(this, data);
/*  75 */     buf.append(')').append(' ');
/*  76 */     node.jjtGetChild(1).jjtAccept(this, data);
/*  77 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTRangeVariableDeclaration node, Object data)
/*     */   {
/*  82 */     StringBuffer buf = (StringBuffer)data;
/*  83 */     node.jjtGetChild(0).jjtAccept(this, data);
/*  84 */     buf.append(' ');
/*  85 */     node.jjtGetChild(1).jjtAccept(this, data);
/*  86 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTSelect node, Object data)
/*     */   {
/*  91 */     StringBuffer buf = (StringBuffer)data;
/*  92 */     buf.append("SELECT ");
/*  93 */     node.jjtGetChild(0).jjtAccept(this, data);
/*  94 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTWhere node, Object data)
/*     */   {
/*  99 */     StringBuffer buf = (StringBuffer)data;
/* 100 */     buf.append(" WHERE ");
/* 101 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 102 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTOr node, Object data)
/*     */   {
/* 107 */     StringBuffer buf = (StringBuffer)data;
/* 108 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 109 */     for (int i = 1; i < node.jjtGetNumChildren(); i++)
/*     */     {
/* 111 */       buf.append(" OR ");
/* 112 */       node.jjtGetChild(i).jjtAccept(this, data);
/*     */     }
/* 114 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTWhereConditionalTerm node, Object data)
/*     */   {
/* 119 */     for (int i = 0; i < node.jjtGetNumChildren(); i++)
/*     */     {
/* 121 */       node.jjtGetChild(i).jjtAccept(this, data);
/*     */     }
/* 123 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAnd node, Object data)
/*     */   {
/* 128 */     StringBuffer buf = (StringBuffer)data;
/* 129 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 130 */     for (int i = 1; i < node.jjtGetNumChildren(); i++)
/*     */     {
/* 132 */       buf.append(" AND ");
/* 133 */       node.jjtGetChild(i).jjtAccept(this, data);
/*     */     }
/* 135 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTNot node, Object data)
/*     */   {
/* 140 */     StringBuffer buf = (StringBuffer)data;
/* 141 */     buf.append(" NOT ");
/* 142 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 143 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTConditionalParenthetical node, Object data)
/*     */   {
/* 148 */     StringBuffer buf = (StringBuffer)data;
/* 149 */     buf.append('(');
/* 150 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 151 */     buf.append(')');
/* 152 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTBetween node, Object data)
/*     */   {
/* 157 */     StringBuffer buf = (StringBuffer)data;
/* 158 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 159 */     if (node.not)
/*     */     {
/* 161 */       buf.append(" NOT ");
/*     */     }
/* 163 */     buf.append(" BETWEEN ");
/* 164 */     node.jjtGetChild(1).jjtAccept(this, data);
/* 165 */     buf.append(" AND ");
/* 166 */     node.jjtGetChild(2).jjtAccept(this, data);
/* 167 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTIn node, Object data)
/*     */   {
/* 172 */     StringBuffer buf = (StringBuffer)data;
/* 173 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 174 */     if (node.not)
/*     */     {
/* 176 */       buf.append(" NOT ");
/*     */     }
/* 178 */     buf.append(" IN ").append('(');
/* 179 */     node.jjtGetChild(1).jjtAccept(this, data);
/* 180 */     for (int i = 2; i < node.jjtGetNumChildren(); i++)
/*     */     {
/* 182 */       buf.append(", ");
/* 183 */       node.jjtGetChild(i).jjtAccept(this, data);
/*     */     }
/* 185 */     buf.append(')');
/* 186 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTLike node, Object data)
/*     */   {
/* 191 */     StringBuffer buf = (StringBuffer)data;
/* 192 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 193 */     if (node.not)
/*     */     {
/* 195 */       buf.append(" NOT ");
/*     */     }
/* 197 */     buf.append(" LIKE ");
/* 198 */     node.jjtGetChild(1).jjtAccept(this, data);
/* 199 */     if (node.jjtGetNumChildren() == 3)
/*     */     {
/* 201 */       buf.append(" {ESCAPE ");
/* 202 */       node.jjtGetChild(2).jjtAccept(this, data);
/* 203 */       buf.append('}');
/*     */     }
/* 205 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTNullComparison node, Object data)
/*     */   {
/* 211 */     StringBuffer buf = (StringBuffer)data;
/* 212 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 213 */     buf.append(" IS ");
/* 214 */     if (node.not)
/*     */     {
/* 216 */       buf.append(" NOT ");
/*     */     }
/* 218 */     buf.append("NULL");
/* 219 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTIsEmpty node, Object data)
/*     */   {
/* 224 */     StringBuffer buf = (StringBuffer)data;
/* 225 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 226 */     buf.append(" IS ");
/* 227 */     if (node.not)
/*     */     {
/* 229 */       buf.append(" NOT ");
/*     */     }
/* 231 */     buf.append("EMPTY");
/* 232 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTMemberOf node, Object data)
/*     */   {
/* 237 */     StringBuffer buf = (StringBuffer)data;
/* 238 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 239 */     if (node.not)
/*     */     {
/* 241 */       buf.append(" NOT ");
/*     */     }
/* 243 */     buf.append(" MEMBER OF ");
/* 244 */     node.jjtGetChild(1).jjtAccept(this, data);
/* 245 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTStringComparison node, Object data)
/*     */   {
/* 250 */     StringBuffer buf = (StringBuffer)data;
/* 251 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 252 */     buf.append(' ').append(node.opp).append(' ');
/* 253 */     node.jjtGetChild(1).jjtAccept(this, data);
/* 254 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTBooleanComparison node, Object data)
/*     */   {
/* 259 */     StringBuffer buf = (StringBuffer)data;
/* 260 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 261 */     if (node.jjtGetNumChildren() == 2)
/*     */     {
/* 263 */       buf.append(' ').append(node.opp).append(' ');
/* 264 */       node.jjtGetChild(1).jjtAccept(this, data);
/*     */     }
/* 266 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTDatetimeComparison node, Object data)
/*     */   {
/* 271 */     StringBuffer buf = (StringBuffer)data;
/* 272 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 273 */     buf.append(' ').append(node.opp).append(' ');
/* 274 */     node.jjtGetChild(1).jjtAccept(this, data);
/* 275 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTEntityComparison node, Object data)
/*     */   {
/* 280 */     StringBuffer buf = (StringBuffer)data;
/* 281 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 282 */     buf.append(' ').append(node.opp).append(' ');
/* 283 */     node.jjtGetChild(1).jjtAccept(this, data);
/* 284 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTValueClassComparison node, Object data)
/*     */   {
/* 289 */     StringBuffer buf = (StringBuffer)data;
/* 290 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 291 */     buf.append(' ').append(node.opp).append(' ');
/* 292 */     node.jjtGetChild(1).jjtAccept(this, data);
/* 293 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTArithmeticComparison node, Object data)
/*     */   {
/* 298 */     StringBuffer buf = (StringBuffer)data;
/* 299 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 300 */     buf.append(' ').append(node.opp).append(' ');
/* 301 */     node.jjtGetChild(1).jjtAccept(this, data);
/* 302 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTPlusMinus node, Object data)
/*     */   {
/* 307 */     StringBuffer buf = (StringBuffer)data;
/* 308 */     for (int i = 0; i < node.jjtGetNumChildren(); i++)
/*     */     {
/* 310 */       if (i > 0)
/*     */       {
/* 312 */         buf.append(' ').append(node.opps.get(i - 1)).append(' ');
/*     */       }
/* 314 */       node.jjtGetChild(i).jjtAccept(this, data);
/*     */     }
/* 316 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTMultDiv node, Object data)
/*     */   {
/* 321 */     StringBuffer buf = (StringBuffer)data;
/* 322 */     for (int i = 0; i < node.jjtGetNumChildren(); i++)
/*     */     {
/* 324 */       if (i > 0)
/*     */       {
/* 326 */         buf.append(' ').append(node.opps.get(i - 1)).append(' ');
/*     */       }
/* 328 */       node.jjtGetChild(i).jjtAccept(this, data);
/*     */     }
/* 330 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTNegation node, Object data)
/*     */   {
/* 335 */     StringBuffer buf = (StringBuffer)data;
/* 336 */     buf.append('-');
/* 337 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 338 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTArithmeticParenthetical node, Object data)
/*     */   {
/* 343 */     StringBuffer buf = (StringBuffer)data;
/* 344 */     buf.append('(');
/* 345 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 346 */     buf.append(')');
/* 347 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTStringParenthetical node, Object data)
/*     */   {
/* 352 */     StringBuffer buf = (StringBuffer)data;
/* 353 */     buf.append('(');
/* 354 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 355 */     buf.append(')');
/* 356 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTConcat node, Object data)
/*     */   {
/* 361 */     StringBuffer buf = (StringBuffer)data;
/* 362 */     buf.append("CONCAT").append('(');
/* 363 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 364 */     buf.append(", ");
/* 365 */     node.jjtGetChild(1).jjtAccept(this, data);
/* 366 */     buf.append(')');
/* 367 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTSubstring node, Object data)
/*     */   {
/* 372 */     StringBuffer buf = (StringBuffer)data;
/* 373 */     buf.append("SUBSTRING").append('(');
/* 374 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 375 */     buf.append(", ");
/* 376 */     node.jjtGetChild(1).jjtAccept(this, data);
/* 377 */     buf.append(", ");
/* 378 */     node.jjtGetChild(2).jjtAccept(this, data);
/* 379 */     buf.append(')');
/* 380 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTLCase node, Object data)
/*     */   {
/* 385 */     StringBuffer buf = (StringBuffer)data;
/* 386 */     buf.append("LCASE").append('(');
/* 387 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 388 */     buf.append(')');
/* 389 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTUCase node, Object data)
/*     */   {
/* 394 */     StringBuffer buf = (StringBuffer)data;
/* 395 */     buf.append("UCASE").append('(');
/* 396 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 397 */     buf.append(')');
/* 398 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTLength node, Object data)
/*     */   {
/* 403 */     StringBuffer buf = (StringBuffer)data;
/* 404 */     buf.append("LENGTH").append('(');
/* 405 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 406 */     buf.append(')');
/* 407 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTLocate node, Object data)
/*     */   {
/* 412 */     StringBuffer buf = (StringBuffer)data;
/* 413 */     buf.append("LOCATE").append('(');
/* 414 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 415 */     buf.append(", ");
/* 416 */     node.jjtGetChild(1).jjtAccept(this, data);
/* 417 */     if (node.jjtGetNumChildren() == 3)
/*     */     {
/* 419 */       buf.append(", ");
/* 420 */       node.jjtGetChild(2).jjtAccept(this, data);
/*     */     }
/* 422 */     buf.append(')');
/* 423 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAbs node, Object data)
/*     */   {
/* 428 */     StringBuffer buf = (StringBuffer)data;
/* 429 */     buf.append("ABS").append('(');
/* 430 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 431 */     buf.append(')');
/* 432 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTSqrt node, Object data)
/*     */   {
/* 437 */     StringBuffer buf = (StringBuffer)data;
/* 438 */     buf.append("SQRT").append('(');
/* 439 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 440 */     buf.append(')');
/* 441 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCount node, Object data)
/*     */   {
/* 446 */     StringBuffer buf = (StringBuffer)data;
/* 447 */     buf.append("COUNT").append('(');
/* 448 */     ASTPath path = (ASTPath)node.jjtGetChild(0);
/* 449 */     path.children[0].jjtAccept(this, data);
/* 450 */     buf.append(')');
/* 451 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTMax node, Object data)
/*     */   {
/* 456 */     StringBuffer buf = (StringBuffer)data;
/* 457 */     buf.append("MAX").append('(');
/* 458 */     ASTPath path = (ASTPath)node.jjtGetChild(0);
/* 459 */     path.children[0].jjtAccept(this, data);
/* 460 */     buf.append(')');
/* 461 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTMin node, Object data)
/*     */   {
/* 466 */     StringBuffer buf = (StringBuffer)data;
/* 467 */     buf.append("MIN").append('(');
/* 468 */     ASTPath path = (ASTPath)node.jjtGetChild(0);
/* 469 */     path.children[0].jjtAccept(this, data);
/* 470 */     buf.append(')');
/* 471 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAvg node, Object data)
/*     */   {
/* 476 */     StringBuffer buf = (StringBuffer)data;
/* 477 */     buf.append("AVG").append('(');
/* 478 */     ASTPath path = (ASTPath)node.jjtGetChild(0);
/* 479 */     path.children[0].jjtAccept(this, data);
/* 480 */     buf.append(')');
/* 481 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTSum node, Object data)
/*     */   {
/* 486 */     StringBuffer buf = (StringBuffer)data;
/* 487 */     buf.append("SUM").append('(');
/* 488 */     ASTPath path = (ASTPath)node.jjtGetChild(0);
/* 489 */     path.children[0].jjtAccept(this, data);
/* 490 */     buf.append(')');
/* 491 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTOrderBy node, Object data)
/*     */   {
/* 496 */     StringBuffer buf = (StringBuffer)data;
/* 497 */     for (int i = 0; i < node.jjtGetNumChildren(); i++)
/*     */     {
/* 499 */       if (i > 0)
/*     */       {
/* 501 */         buf.append(", ");
/*     */       }
/* 503 */       node.jjtGetChild(i).jjtAccept(this, data);
/*     */     }
/* 505 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTOrderByPath node, Object data)
/*     */   {
/* 510 */     StringBuffer buf = (StringBuffer)data;
/*     */ 
/* 512 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 513 */     if (node.ascending)
/*     */     {
/* 515 */       buf.append(" ASC");
/*     */     }
/*     */     else
/*     */     {
/* 519 */       buf.append(" DESC");
/*     */     }
/* 521 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTPath node, Object data)
/*     */   {
/* 526 */     StringBuffer buf = (StringBuffer)data;
/* 527 */     buf.append(node.getPath());
/* 528 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTIdentifier node, Object data)
/*     */   {
/* 533 */     StringBuffer buf = (StringBuffer)data;
/* 534 */     buf.append(node.identifier);
/* 535 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAbstractSchema node, Object data)
/*     */   {
/* 540 */     StringBuffer buf = (StringBuffer)data;
/* 541 */     buf.append(node.abstractSchemaName);
/* 542 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTParameter node, Object data)
/*     */   {
/* 547 */     StringBuffer buf = (StringBuffer)data;
/* 548 */     buf.append("?").append(node.number);
/* 549 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTExactNumericLiteral node, Object data)
/*     */   {
/* 554 */     StringBuffer buf = (StringBuffer)data;
/* 555 */     buf.append(node.literal);
/* 556 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTApproximateNumericLiteral node, Object data)
/*     */   {
/* 561 */     StringBuffer buf = (StringBuffer)data;
/* 562 */     buf.append(node.literal);
/* 563 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTStringLiteral node, Object data)
/*     */   {
/* 568 */     StringBuffer buf = (StringBuffer)data;
/* 569 */     buf.append(node.value);
/* 570 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTBooleanLiteral node, Object data)
/*     */   {
/* 575 */     StringBuffer buf = (StringBuffer)data;
/* 576 */     buf.append(node.value);
/* 577 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTLimitOffset node, Object data)
/*     */   {
/* 582 */     StringBuffer buf = (StringBuffer)data;
/* 583 */     int child = 0;
/* 584 */     if (node.hasOffset)
/*     */     {
/* 586 */       buf.append(" OFFSET ");
/* 587 */       node.jjtGetChild(child++).jjtAccept(this, data);
/*     */     }
/* 589 */     if (node.hasLimit)
/*     */     {
/* 591 */       buf.append(" LIMIT ");
/* 592 */       node.jjtGetChild(child).jjtAccept(this, data);
/*     */     }
/* 594 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTMod node, Object data)
/*     */   {
/* 599 */     StringBuffer buf = (StringBuffer)data;
/* 600 */     buf.append("MOD").append('(');
/* 601 */     node.jjtGetChild(0).jjtAccept(this, data);
/* 602 */     buf.append(", ");
/* 603 */     node.jjtGetChild(1).jjtAccept(this, data);
/* 604 */     buf.append(')');
/* 605 */     return data;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.ejbql.BasicVisitor
 * JD-Core Version:    0.6.0
 */