/*    */ package org.jboss.ejb.plugins.cmp.ejbql;
/*    */ 
/*    */ import java.sql.ResultSet;
/*    */ import java.sql.SQLException;
/*    */ import java.util.Collection;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCResultSetReader;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public abstract class AggregateFunction extends SimpleNode
/*    */   implements SelectFunction
/*    */ {
/*    */   private final Logger log;
/*    */   private JDBCResultSetReader resultReader;
/*    */   private Class resultType;
/* 44 */   public String distinct = "";
/*    */ 
/*    */   public AggregateFunction(int i)
/*    */   {
/* 48 */     super(i);
/* 49 */     this.log = Logger.getLogger(getClass());
/*    */   }
/*    */ 
/*    */   public void setResultType(Class type)
/*    */   {
/* 54 */     if (Collection.class.isAssignableFrom(type))
/*    */     {
/* 56 */       this.resultType = getDefaultResultType();
/*    */     }
/*    */     else
/*    */     {
/* 60 */       this.resultType = type;
/*    */     }
/* 62 */     this.resultReader = JDBCUtil.getResultReaderByType(this.resultType);
/*    */   }
/*    */ 
/*    */   protected Class getDefaultResultType()
/*    */   {
/* 67 */     return Double.class;
/*    */   }
/*    */ 
/*    */   public Object readResult(ResultSet rs)
/*    */     throws SQLException
/*    */   {
/* 74 */     return this.resultReader.get(rs, 1, this.resultType, this.log);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.ejbql.AggregateFunction
 * JD-Core Version:    0.6.0
 */