/*    */ package org.jboss.ejb.plugins.cmp.ejbql;
/*    */ 
/*    */ public final class ASTExactNumericLiteral extends SimpleNode
/*    */ {
/*    */   public long value;
/*    */   public String literal;
/*    */   private static final String LOFFER_L = "l";
/*    */   private static final String UPPER_L = "L";
/*    */   private static final String OX = "0X";
/*    */   private static final String Ox = "0x";
/*    */   private static final String ZERRO = "0";
/*    */ 
/*    */   public ASTExactNumericLiteral(int id)
/*    */   {
/* 40 */     super(id);
/*    */   }
/*    */ 
/*    */   public void setValue(String number) {
/* 44 */     this.literal = number;
/*    */ 
/* 47 */     if ((number.endsWith("l")) || (number.endsWith("L")))
/*    */     {
/* 49 */       number = number.substring(0, number.length() - 1);
/*    */     }
/*    */ 
/* 53 */     if ((number.startsWith("0X")) || (number.startsWith("0x")))
/*    */     {
/* 57 */       if (number.length() == 18) {
/* 58 */         byte first = Byte.decode(number.substring(0, 3)).byteValue();
/* 59 */         if (first >= 8) {
/* 60 */           number = "0x" + (first - 8) + number.substring(3);
/* 61 */           this.value = (Long.decode(number).longValue() - 9223372036854775807L - 1L);
/* 62 */           return;
/*    */         }
/*    */       }
/* 65 */     } else if (number.startsWith("0"))
/*    */     {
/* 70 */       if ((number.length() == 23) && 
/* 71 */         (number.charAt(1) == '1')) {
/* 72 */         number = "0" + number.substring(2);
/* 73 */         this.value = (Long.decode(number).longValue() - 9223372036854775807L - 1L);
/* 74 */         return;
/*    */       }
/*    */     }
/*    */ 
/* 78 */     this.value = Long.decode(number).longValue();
/*    */   }
/*    */ 
/*    */   public String toString() {
/* 82 */     return this.literal;
/*    */   }
/*    */ 
/*    */   public Object jjtAccept(JBossQLParserVisitor visitor, Object data)
/*    */   {
/* 87 */     return visitor.visit(this, data);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.ejbql.ASTExactNumericLiteral
 * JD-Core Version:    0.6.0
 */